/*
 * Arox - filer/thumbnail viewer for Absolute Linux
 * based upon ROX-Filer by Thomas Leonard
 */

#ifndef __VIEW_COLLECTION_H__
#define __VIEW_COLLECTION_H__

#include <gtk/gtk.h>

typedef struct _ViewCollectionClass ViewCollectionClass;

#define VIEW_COLLECTION(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST((obj), view_collection_get_type(), ViewCollection))

GtkWidget *view_collection_new(FilerWindow *filer_window);
GType view_collection_get_type(void);

struct _ViewCollection {
	GtkViewport viewport;

	Collection *collection;
	FilerWindow *filer_window;	/* Used for styles, etc */

	int	cursor_base;		/* Cursor when minibuffer opened */

	GQueue		*thumbs_queue;
	guint		thumb_func;
};

#endif /* __VIEW_COLLECTION_H__ */
