#include "SystrayIcon.h"
#include "PrefsDialog.h"
#include "SettingsInfo.h"

#include <QtGui>
#include <QCloseEvent>
#include <QSystemTrayIcon>
#include <QProcess>
#include <QDir>
#include <QFile>
#include <QTextEdit>
#include <QMap>
#include <QTimer>
#include <QDateTime>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSettings>

SystrayIcon::SystrayIcon(QObject * parent) : QSystemTrayIcon (parent)
{
    #ifdef Q_WS_WIN
    QSettings::setDefaultFormat ( QSettings::IniFormat );
    #endif
    //settingsPath = QString("%1/%2").arg(QDir::homePath()).arg(".imapquickcheck");
    //settingsFile = QString("%1/%2").arg(settingsPath).arg("imapquickcheckrc");
    settingsPath = SettingsInfo::configDir();
    settingsFile = SettingsInfo::fileName();
    pythonFile = QString("%1/%2").arg(settingsPath).arg("imap_check_sql_final.py");
    soundFile = QString("%1/%2").arg(settingsPath).arg("KDE_Window_Iconify.wav");
    dbFile = QString("%1/%2").arg(settingsPath).arg("accounts.db");

	/*
    db = QSqlDatabase::addDatabase("QSQLITE");
    db.setDatabaseName(dbFile);
	if (!db.isOpen())
	{
	  if (!db.open())
	  {
		qDebug() << "error SQL : could not open";
	  }
	} */

    tooltipContent = "";
    tooltipSummaryContent = "";
    messageContent = "";
    currSender = "";
    currDate = "";
    currAccount = "";
    currSubject = "";
    currUnread = "";
    iconAnimatorIdx = 0;
    iconAnimatorRefreshTime=250;


    imapProcess = new QProcess();
    imapTimer = new QTimer();
    iconAnimatorTimer = new QTimer();
    imapTimeoutTimer = new QTimer();

    QDir dir (settingsPath); //createConfigDir(dir);    
	if( !  createConfigDir( dir ) )
    {
	  qDebug() << "FATAL error : could not create Config Dir";
	  QProcess::startDetached("kdialog --error 'ImapQuickCheck : could not create config dir. Exiting.'");
	  exit( -1 );
    }
    initActions();
    initTrayIcon();
    restoreSettings();

    connect( this, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
         this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));
    connect( imapProcess, SIGNAL( finished(int , QProcess::ExitStatus ) ), this,
          SLOT( imapProcessFinished(int , QProcess::ExitStatus ) ) );
    connect( imapProcess, SIGNAL(readyReadStandardOutput()),
        this, SLOT(imapProcessOutput()));
    connect( imapTimer, SIGNAL(timeout()), this, SLOT(imapProcessStart()));
    connect( iconAnimatorTimer, SIGNAL(timeout()), this, SLOT(iconAnimator()));
    connect( imapTimeoutTimer, SIGNAL(timeout()), this, SLOT(imapProcessTimeOut()));

    /* initiate imap process */
    if (imapFirstCheckTime>0)
        QTimer::singleShot(imapFirstCheckTime*1000, this, SLOT(imapProcessStart()));
    else
    {
        setToolTip(tr("Please, start mail checking manually"));
    }
}

bool SystrayIcon::createConfigDir(QDir dir)
{
    QFile pyFileSrc (":python/imap_check_sql_final.py");
    QFile pyFileDest (pythonFile);

    if (!dir.exists(settingsPath))
     {
         if (!dir.mkdir(settingsPath))
        {
             qDebug() << "could not create conf dir" << settingsPath;
             //return;
        }
     }

     if (dir.exists(settingsPath))
     {
         if (!QFile::exists(pythonFile))
         {
             if (QFile::copy(":python/imap_check_sql_final.py", pythonFile))
                 QFile::setPermissions( pythonFile, QFile::ReadOwner|QFile::ExeOwner|QFile::ReadGroup|QFile::ExeGroup|QFile::ReadOther|QFile::ExeOther|QFile::WriteOwner );
             else
                 qDebug() << "[createConfigDir] Warning : pythonFile copy error" ;
         }
         else if (pyFileSrc.size() != pyFileDest.size()) // check file integrity (ie: newer or altered version of program)
         {
             QFile::remove(pythonFile);
             if (QFile::copy(":python/imap_check_sql_final.py", pythonFile))
                 QFile::setPermissions( pythonFile, QFile::ReadOwner|QFile::ExeOwner|QFile::ReadGroup|QFile::ExeGroup|QFile::ReadOther|QFile::ExeOther|QFile::WriteOwner );
             else
                 qDebug() << "[createConfigDir] Warning : pythonFile copy error" ;
         }
         else
         {
             QFileInfo pyInfo(pythonFile);
             if (!pyInfo.isExecutable())
                 QFile::setPermissions( pythonFile, QFile::ReadOwner|QFile::ExeOwner|QFile::ReadGroup|QFile::ExeGroup|QFile::ReadOther|QFile::ExeOther|QFile::WriteOwner );
         }

         if (!QFile::exists(soundFile))
         {
             if (!QFile::copy(":sounds/KDE_Window_Iconify.wav", soundFile))
                 qDebug() << "[createConfigDir] Warning : could not copy sound file";
         }

		  /*
         if (!QFile::exists(dbFile))
         {
             //db.setDatabaseName(dbFile);
             if (!db.isOpen())
                 qDebug() << "error SQL";
             else
             {
                 QSqlQuery query;
                 //query.exec("create table accounts (id INTEGER primary key, type int, name varchar(60), host varchar(40), port int, user varchar(40), pwd varchar(20), check_time DATE)");
                 query.exec("create table accounts (id INTEGER primary key, type int, name varchar(60), host varchar(40), port int, user varchar(40), pwd varchar(20), check_time DATE, inbox varchar(20))");
                 //db.close();
             }
         }
		 */
		  
		  // create database object (locally)
		  QSqlDatabase db = QSqlDatabase::addDatabase( "QSQLITE" );
		  db.setDatabaseName( dbFile );
		  
		  // create database file if not exists
		  // else open it
		  if( ! QFile::exists( dbFile ) )
		  {
			  if( ! db.open() )
			  {
				  qDebug() << "error: SQL open new database";
				  return( false );
			  }
			  QSqlQuery query( "create table accounts ( "
					  "id         INTEGER primary key, "
					  "type       int, "
					  "name       varchar(60), "
					  "host       varchar(40), "
					  "port       int, "
					  "user       varchar(40), "
					  "pwd        varchar(20), "
					  "check_time DATE, "
					  "inbox      varchar(20) )");
		  }
		  else
		  {
			//qDebug() << "SQL should be open";
			if( ! db.open() )
			{
			  qDebug() << "error: SQL open database";
			  return( false );
			}
			else
			{
			  qDebug() << "SQL database opened successfully";
			}
		  }  
     }
	 
	 // all is ok
	 return( true );
}

void SystrayIcon::initActions()
{
 restoreAction = new QAction( QIcon(":images/configure.png"), tr("&Preferences"), this);
 connect(restoreAction, SIGNAL(triggered()), this, SLOT(showPrefs()));

 showAccountsAction = new QAction( QIcon(":images/bookmark-new-list.png"), tr("&Accounts"), this);
 connect(showAccountsAction, SIGNAL(triggered()), this, SLOT(showAccounts()));

 quitAction = new QAction( QIcon(":images/exit.png"), tr("&Quit"), this);
 connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));

 markAllReadAction = new QAction( QIcon(":images/mail-mark-read.png"), tr("Mark all read"), this);
 connect(markAllReadAction, SIGNAL(triggered()), this, SLOT(imapProcessMarkReadStart()));
 
 deleteAllReadAction = new QAction( QIcon(":images/fileclose.png"), tr("Delete unread mail"), this);
 connect(deleteAllReadAction, SIGNAL(triggered()), this, SLOT(imapProcessDeleteReadStart()));

 checkNowAction = new QAction( QIcon(":images/reload.png"), tr("Check now"), this);
 connect(checkNowAction, SIGNAL(triggered()), this, SLOT(imapProcessStart()));

 aboutAction = new QAction( QIcon(":images/info.png"), tr("About"), this);
 connect(aboutAction, SIGNAL(triggered()), this, SLOT(showAbout()));

 launchClientAction = new QAction( QIcon(":images/internet-mail.png"), tr("E-mail reader"), this);
 connect(launchClientAction, SIGNAL(triggered()), this, SLOT(launchEmailClient()));

 launchComposerAction = new QAction( QIcon(":images/mail-send.png"), tr("E-mail composer"), this);
 connect(launchComposerAction, SIGNAL(triggered()), this, SLOT(launchEmailComposer()));
}

void SystrayIcon::initTrayIcon()
{
  QMenu * unreadMailMenu = new QMenu();
  unreadMailMenu->setTitle(tr("Unread Mail"));
  unreadMailMenu->setIcon( QIcon(":images/internet-mail.png") );
  unreadMailMenu->addAction(markAllReadAction);
  unreadMailMenu->addAction(deleteAllReadAction);
  
  trayIconMenu = new QMenu(/*this*/);
  trayIconMenu->addAction(launchClientAction);
  trayIconMenu->addAction(launchComposerAction);
  trayIconMenu->addSeparator();
  trayIconMenu->addAction(checkNowAction);  
  trayIconMenu->addMenu(unreadMailMenu);//trayIconMenu->addAction(markAllReadAction);
  trayIconMenu->addSeparator();
  trayIconMenu->addAction(restoreAction);
  trayIconMenu->addAction(showAccountsAction);
  trayIconMenu->addAction(aboutAction);
  trayIconMenu->addSeparator();
  trayIconMenu->addAction(quitAction);

  setIcon(QIcon(":images/mail-normal.png"));
  setContextMenu(trayIconMenu);
}

void SystrayIcon::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
     switch (reason) {
     case QSystemTrayIcon::Trigger:
         //if ( this->isHidden() )
         //    show();
         break;
     case QSystemTrayIcon::DoubleClick:
         launchEmailClient();
         break;
     case QSystemTrayIcon::MiddleClick:
         //showMessage();
         launchEmailComposer();
         break;
     default:
         ;
     }
}

QPixmap SystrayIcon::buildSystrayIcon(int nbMess, QString bckImg)
{
    /* Build Systray icon with message number information */

 QPixmap pixmap1(bckImg);//QPixmap pixmap1(":/images/mail-normal.png");

 if (nbMess == 0)
     return pixmap1;

 QPixmap resultat(22,22);
 resultat.fill(Qt::transparent);
 QPainter painter(&resultat);
 painter.setFont(QFont("Times", 9, QFont::DemiBold));
 painter.setPen(Qt::black);
 painter.drawPixmap(resultat.rect(),pixmap1,pixmap1.rect());

 QString numMess( QString::number( nbMess ) );
 if (numMess.size() == 1)
     numMess.prepend("  ");
 else if (numMess.size() == 2)
     numMess.prepend(" ");

 painter.drawText( 5, 15, numMess );

 return resultat;
}

QString SystrayIcon::convertFromHtml(QString htmlRaw)
{
  //qDebug() << "cleanSenderArddress" << qPrintable(QString::number(emailRaw.lastIndexOf("&gt;")));
  //return emailRaw.mid( emailRaw.lastIndexOf("&lt;")+4, emailRaw.lastIndexOf("&gt;")-4 );
  /*

  QString clean ( emailRaw.mid( emailRaw.lastIndexOf("&lt;")+4 ) );
  clean.chop(4);

  return clean;
  */
  QTextEdit *te = new QTextEdit();
  te->setHtml(htmlRaw);
  QString str_utf = te->toPlainText();
  delete te;

  return str_utf;
}

void SystrayIcon::restoreSettings()
{
    // Get Settings from config file
    QSettings settings; //QSettings settings(settingsFile, QSettings::IniFormat);

    settings.beginGroup("MAIN");
     imapCheckIntervaltTime = settings.value("check_interval", 4).toInt();//imapCheckIntervaltTime = 15;
     imapFirstCheckTime = settings.value("first_check", 1).toInt();
     messageDisplayTime = settings.value("popup_duration", 30).toInt() * 1000;
     imapTimeoutTime = settings.value("timeout_duration", 90).toInt() * 1000;
     playSoundOk = settings.value("sound",  1).toInt();
     popupsOk = settings.value("popups",  0).toInt();
     soundFileOther = settings.value("sound_file", "").toString();
     emailClient = settings.value("email_client", "kmail").toString();
     emailComposer = settings.value("email_composer", "kmail --composer").toString();
    settings.endGroup();

    settings.beginGroup("MAIL");
     dateLastCheck = QDateTime::fromString( settings.value("last_check", QDateTime::currentDateTime().toString("d M yyyy hh':'mm':'ss")).toString(), "d M yyyy hh':'mm':'ss" );
    settings.endGroup();

    /* load timer */
    imapTimer->setInterval(imapCheckIntervaltTime*60000);//imapTimer->setInterval(imapCheckIntervaltTime*1000);
    imapTimeoutTimer->setInterval(imapTimeoutTime);
}


bool SystrayIcon::accountsListIsEmpty()
{
    bool empty_state = true;
    int count = 0;
	/*
	if (!db.isOpen())
	{
	  if (!db.open())
	  {
		qDebug() << "[accountsListIsEmpty] error SQL : can't open db";
		return empty_state;
	  }
	}
	*/

	QSqlQuery query("SELECT id, name FROM accounts");
	while (query.next())
		count++;
	
	query.finish(); //db.close();
	 
	if (count > 0)
	  empty_state = false;

    return empty_state;
}

void SystrayIcon::imapProcessTimeOut()
{
	qDebug() << "imapProcessTimeOut()";
	imapTimeoutTimer->stop();

	if (imapProcess->state() == QProcess::Running)
	{
		tooltipContent = QString("<P style='font-weight: bold;'>%1</P><P style='font-style: italic;'>&nbsp;&nbsp;%2</P>")
                                         .arg(tr("Caution !"))
                                         .arg(tr("Mail check process timed out."));
		imapProcess->terminate();		
	}
}

void SystrayIcon::imapProcessStart()
{
    if (imapTimer->isActive()) // manual check request from context menu
         imapTimer->stop();

	if ( accountsListIsEmpty() )
    {
        setIcon( QIcon(":images/mail-normal.png") );
        setToolTip( tr("No accounts set.") );
        imapTimer->start();//imapTimer->start(imapCheckIntervaltTime*1000);
        return;
    }

     QStringList arguments;
     arguments << dbFile;
     imapProcess->start(pythonFile, arguments);
     iconAnimatorTimer->start(iconAnimatorRefreshTime);
     imapTimeoutTimer->start();
     checkNowAction->setDisabled(true);
     markAllReadAction->setDisabled(true);
	 deleteAllReadAction->setDisabled(true);
}

void SystrayIcon::imapProcessMarkReadStart()
{
    if (imapTimer->isActive()) // manual check request from context menu
         imapTimer->stop();

    if ( accountsListIsEmpty() )
    {
        setIcon( QIcon(":images/mail-normal.png") );
        setToolTip( tr("No accounts set.") );
        imapTimer->start();//imapTimer->start(imapCheckIntervaltTime*1000);
        return;
    }

     QStringList arguments;
     arguments << dbFile << "-markread";
     imapProcess->start(pythonFile, arguments);
     iconAnimatorTimer->start(iconAnimatorRefreshTime);
     imapTimeoutTimer->start();
     checkNowAction->setDisabled(true);
     markAllReadAction->setDisabled(true);
	 deleteAllReadAction->setDisabled(true);
}

void SystrayIcon::imapProcessDeleteReadStart()
{
    if (imapTimer->isActive()) // manual check request from context menu
         imapTimer->stop();

    if ( accountsListIsEmpty() )
    {
        setIcon( QIcon(":images/mail-normal.png") );
        setToolTip( tr("No accounts set.") );
        imapTimer->start();//imapTimer->start(imapCheckIntervaltTime*1000);
        return;
    }

     QStringList arguments;
     arguments << dbFile << "-deleteread";
     imapProcess->start(pythonFile, arguments);
     iconAnimatorTimer->start(iconAnimatorRefreshTime);
     imapTimeoutTimer->start();
     checkNowAction->setDisabled(true);
     markAllReadAction->setDisabled(true);
	 deleteAllReadAction->setDisabled(true);
}

void SystrayIcon::imapProcessOutput()
{
    while(imapProcess->canReadLine())
    {
        QByteArray buffer(imapProcess->readLine());
        //log->append(QString(buffer));
        //qDebug() << qPrintable(QString(buffer));

        if ( buffer.startsWith("__ERROR_LOGIN:") )
        {
            buffer.remove(0, QString("__ERROR_LOGIN:").size()+1);
            currAccount = QString(buffer).trimmed();
            tooltipSummaryContent.append( QString("<div><img src=':images/gaim.png'> %1 : <span style='color: red;'>%2</span></div>").arg(currAccount).arg(tr("communication problem <b>[login]</b>")) );
        }

        if ( buffer.startsWith("__ERROR_FETCH:") )
        {
            buffer.remove(0, QString("__ERROR_FETCH:").size()+1);
            currAccount = QString(buffer).trimmed();
            tooltipSummaryContent.append( QString("<div><img src=':images/gaim.png'> %1 : <span style='color: red;'>%2</span></div>").arg(currAccount).arg(tr("communication problem <b>[fetch]</b>")) );
        }

        if ( buffer.startsWith("__ACCOUNT:") )
        {
            buffer.remove(0, QString("__ACCOUNT:").size()+1);
            currAccount = QString(buffer).trimmed();
        }

        if ( buffer.startsWith("__UNREAD:") )
        {
            buffer.remove(0, QString("__UNREAD:").size()+1);
            currUnread = QString(buffer).trimmed();
            tooltipSummaryContent.append( QString("<div><img src=':images/gaim.png'> %1 (%2)</div>").arg(currAccount).arg(currUnread) );
            messageContent.append( QString(" > %1 (%2)\n").arg(currAccount).arg(currUnread) );
        }

        if ( buffer.startsWith("__SENDER:") )
        {
            buffer.remove(0, QString("__SENDER:").size()+1);
            currSender = QString(buffer).trimmed();
        }

        if ( buffer.startsWith("__DATE:") )
        {
            buffer.remove(0, QString("__DATE:").size()+1);
            currDate = QString(buffer).trimmed();
        }

        if ( buffer.startsWith("__SUBJECT:") )
        {
            buffer.remove(0, QString("__SUBJECT:").size()+1);
            currSubject = QString(buffer).trimmed();
        }

        if ( buffer.startsWith("____________") ) //  message change
        {
            QDateTime datetmp = QDateTime::fromString( currDate, "d M yyyy hh':'mm':'ss" );
            if ( datetmp.isValid() )
            {
                /* looking for overlapping dates */
                for (int i=1; i<=10 ; i++) // 10 is arbitrary, should be enough ?!
                {
                    if ( messages_map.contains(datetmp) )
                    {
                        //qDebug() << "message-map SAME KEY FOUNd" << qPrintable(datetmp.toString());
                        datetmp = datetmp.addMSecs(i*100);
                        //qDebug() << "->" << qPrintable(datetmp.toString());
                     }
                    else
                        break;
                }

                QStringList components;
                components << currAccount << currSender << currSubject;//<< currDate
                messages_map[ datetmp ] = components;
            }
            else
                qDebug() << "DATE NON VALIDE" << qPrintable(currDate) << qPrintable(currSubject);

        }

    }
}

void SystrayIcon::imapProcessFinished (int exitCode, QProcess::ExitStatus exitStatus)
{
    imapTimeoutTimer->stop();

    QSettings settings;//QSettings settings(settingsFile, QSettings::IniFormat);

    QDateTime dateMostRecent;

    QMapIterator<QDateTime, QStringList> z(messages_map);
    z.toBack();

    QString tooltipBottom = "";
    QString senderMostRecent;
    QString subjectMostRecent;
    QString txtFrom = tr("From");
    QString txtDate = tr("Date");
    QString txtSubject = tr("Subject");
    QString txtAccount = tr("Account");
    QString txtMostRecent = tr("Most recent");
    QString txtUnreadMailFound = tr("Unread mail found in the following accounts");
    QString txtMailPreview = tr("Mail preview");

    int map_count = 0;
    int map_count_max = QApplication::desktop()->height()/110;//int map_count_max = 9;

    //-------------------------

    switch (exitStatus)
     {
         case QProcess::NormalExit:
            while ( z.hasPrevious() )
            {
                z.previous();
                if (map_count == 0)
                {
                    dateMostRecent = z.key();
                    senderMostRecent = z.value()[1];
                    subjectMostRecent = z.value()[2];
                }

                map_count ++;

                if ( map_count > map_count_max )
                    break;
				
				//tooltipContent.append(QString("\t%5  %1\n\t%6  %2\n\t%3  %7\n\t%4  %8\n")
               tooltipContent.append(  QString("<table><tr><td>&nbsp;<b>%5</b>&nbsp;</td><td><span style='color: blue;'>%1</span></td></tr><tr><td>&nbsp;<b>%6</b></td><td><span style='color: green;'>%2</span></td></tr><tr><td>&nbsp;<b>%7</b></td><td>%3</td></tr><tr><td>&nbsp;<b>%8</b></td><td><em>%4</em></td></tr></table><br>")
                                       .arg( z.value()[0] ).arg( z.value()[1] )
                                       .arg( z.value()[2] ).arg( z.key().toString(Qt::SystemLocaleLongDate) ) //ddd d MMM yyyy hh:mm:ss
                                       .arg(txtAccount).arg(txtFrom)
                                       .arg(txtSubject).arg(txtDate)
                                       );
            }

            if ( messages_map.size() > map_count_max )
                tooltipBottom = tr("&nbsp;&nbsp;<em>%1 non-displayed messages ...</em>").arg(QString::number(messages_map.size()-map_count_max));

            
			setToolTip(
                    QString("<table><tr><td>&nbsp;</td><td><P style='white-space:pre; margin: 4px; align='center'><div style='white-space:pre; padding: 4px; margin: 4px; font-weight: normal;' align='left' valign='top'><div style='margin-bottom: 3px;'><B>%1 :</B></div>%2<hr><B>&nbsp;%3</B><div style='white-space:pre; padding: 4px; margin: 4px;' valign='top'>%4</div></P><br>%5</td><td>&nbsp;</td></tr></table>")
                    .arg(txtUnreadMailFound)
                    .arg(tooltipSummaryContent)
                    .arg(txtMailPreview)
                    .arg(tooltipContent)
                    .arg(tooltipBottom)
                    );

            if (dateMostRecent > dateLastCheck) //if ( !messageContent.isEmpty() )
            {
                qDebug() << "New Mail FOUND";
                if ( playSoundOk > 0 )
                {
                    launchSoundFile();
                }

                if ( popupsOk == 0 )
                {
                    showMessage(
                            tr("Incoming Mail"),
                            messageContent.append( QString("____________________________________________________________\n\n - %4 -\n      %1\n\n - %5 -\n      %2\n\n - %6 -\n      %3")
                                                  .arg( dateMostRecent.toString(Qt::SystemLocaleLongDate) ) //.arg( dateMostRecent.toString("ddd d MMM yyyy hh:mm:ss") )
                                                  .arg( convertFromHtml(senderMostRecent) )
                                                  .arg( convertFromHtml(subjectMostRecent) )
                                                  .arg( txtMostRecent )
                                                  .arg( txtFrom )
                                                  .arg( txtSubject ) ) ,
                            QSystemTrayIcon::Information, messageDisplayTime
                            );
                }

                dateLastCheck = QDateTime::currentDateTime();

                settings.beginGroup("MAIL");
                    settings.setValue("last_check", dateLastCheck.toString("d M yyyy hh':'mm':'ss"));
                settings.endGroup(); //qDebug() << "Write Settings";
            }
            break;
         case QProcess::CrashExit:
             qDebug() << "IMAP process = CrashExit";
             setToolTip(tooltipContent);
             break;
         default:
             ;
     }

    // -----------------------------

    iconAnimatorTimer->stop();

    setIcon(QIcon( buildSystrayIcon( messages_map.size(), ":/images/mail-normal.png" ) ) );

    /* Reset values */
	
	//delete z;
    iconAnimatorIdx=0;
    messageContent = "";
    tooltipContent = "";
    tooltipSummaryContent = "";
    messages_map.clear();
    checkNowAction->setDisabled(false);
    markAllReadAction->setDisabled(false);
	deleteAllReadAction->setDisabled(false);
    imapTimer->start();//imapTimer->start(imapCheckIntervaltTime*1000);
}

 void SystrayIcon::iconAnimator()
 {
     if (iconAnimatorIdx==8)
       iconAnimatorIdx=0;

     QPixmap iconAnimatorPng(":images/process-working.png");
     QPixmap pixmap1 (this->icon().pixmap(22,22,QIcon::Normal,QIcon::Off));//QPixmap pixmap1(":/images/mail-notification.png");
     QPixmap pixTmp = iconAnimatorPng.copy(0,iconAnimatorIdx*22,22,22);

     QPixmap resultat(22,22);
     resultat.fill(Qt::transparent);

     QPainter painter(&resultat);
     painter.drawPixmap(resultat.rect(),pixmap1,pixmap1.rect());
     painter.drawPixmap(resultat.rect(),pixTmp,pixTmp.rect());

     setIcon( QIcon(resultat) );
	 
	 /*
	 delete resultat;	 
	 delete painter;
	 delete pixTmp;
	 delete pixmap1;
	 delete iconAnimatorPng;
	 */

     iconAnimatorIdx++;
}

void SystrayIcon::launchSoundFile()
{
    //QProcess *soundProcess=new QProcess();
    QStringList args;
    if (playSoundOk == 3) //if (cbSound->currentIndex() == 3)
      args << soundFileOther;
    else
      args << soundFile;
    QProcess::startDetached("aplay", args);//soundProcess->startDetached("aplay", args);
}
void SystrayIcon::launchEmailClient()
{
    showMessage( tr("ImapQuickCheck"),
                 tr("Launching e-mail client ..."),
                 QSystemTrayIcon::Information,
                 5000);

    //QProcess *emailClientProcess=new QProcess();
    QProcess::startDetached(emailClient);// emailClientProcess->startDetached(emailClient);
}

void SystrayIcon::launchEmailComposer()
{
    showMessage( tr("ImapQuickCheck"),
             tr("Launching e-mail composer ..."),
             QSystemTrayIcon::Information,
             5000);

    //QProcess *emailComposerProcess=new QProcess();
    QProcess::startDetached(emailComposer);//emailComposerProcess->startDetached(emailComposer);
}

void SystrayIcon::showPrefs()
{
    PrefsDialog *dlg = new PrefsDialog();
    /*
    if (dlg->exec() == QDialog::Accepted)
    {
        qDebug() << "DIALOG ACCEPTEd";
        restoreSettings();
    }*/
    prefsApplied( dlg->exec() );

    delete dlg;
}

void SystrayIcon::showAccounts()
{
    PrefsDialog *dlg = new PrefsDialog(0,0,1);
    /*
    if (dlg->exec() == QDialog::Accepted)
    {
        qDebug() << "DIALOG ACCEPTEd";
        restoreSettings();
    }
    */
    prefsApplied( dlg->exec() );

    delete dlg;
}

void SystrayIcon::showAbout()
{
    PrefsDialog *dlg = new PrefsDialog(0,0,2);
    /*
    if (dlg->exec() == QDialog::Accepted)
    {
        qDebug() << "DIALOG ACCEPTEd";
        restoreSettings();
    }
    */
    prefsApplied( dlg->exec() );

    delete dlg;
}


void SystrayIcon::prefsApplied(int answer)
{
    if (answer == QDialog::Accepted)
    {        
        restoreSettings();//qDebug() << "DIALOG Applied";
    }
    /*
    if (!accountsListIsEmpty())
    {
        if (!imapProcess->isOpen())
            imapProcessStart();
    }
    */
}

SystrayIcon::~SystrayIcon()
{
  //if (db.isOpen())
	//db.close();
  //db.close();
  QSqlDatabase::database( dbFile ).close();
  QSqlDatabase::removeDatabase ( dbFile );
  //qDebug() << "Bye";
}
