#ifndef SYSTRAYICON_H
#define SYSTRAYICON_H

//#include<QtGui>
#include <QSystemTrayIcon>
#include <QProcess>
#include <QMap>
#include <QTimer>
#include <QDateTime>
#include <QSqlDatabase>

//class QSignalMapper;
//class QMenu;
//class QTextEdit;
class QAction;
class QSystemTrayIcon;
class QProcess;
class QDir;
class QDateTime;


class SystrayIcon : public QSystemTrayIcon
{
Q_OBJECT

public:
        SystrayIcon( QObject * parent = 0 );//SystrayIcon( QWidget * parent = 0 , QString args = 0 );
		~SystrayIcon();

private slots:
        void iconActivated(QSystemTrayIcon::ActivationReason reason);
        void iconAnimator();
        void imapProcessFinished(int, QProcess::ExitStatus);
        void imapProcessOutput();
        void imapProcessStart();
        void imapProcessMarkReadStart();
        void imapProcessDeleteReadStart();
        void imapProcessTimeOut();  
        void launchEmailClient();
        void launchEmailComposer();
        void showPrefs();
        void showAccounts();
        void showAbout();
        //void showMessage();
        //void messageClicked();


private:
        bool createConfigDir(QDir); //void createConfigDir(QDir);
        void initActions();
        void initTrayIcon();
        void restoreSettings();
        void launchSoundFile();
        void prefsApplied(int);
        bool accountsListIsEmpty();
        QString convertFromHtml(QString);

        QPixmap buildSystrayIcon(int, QString);

        QProcess *imapProcess;

        QTimer *imapTimer;
        QTimer *imapTimeoutTimer;
        QTimer *iconAnimatorTimer;

        QAction *restoreAction;
        QAction *showAccountsAction;
        QAction *quitAction;
        QAction *aboutAction;
        QAction *launchClientAction;
        QAction *launchComposerAction;
        QAction *checkNowAction;
        QAction *markAllReadAction;
	QAction *deleteAllReadAction;
        QMenu *trayIconMenu;

        //QSqlDatabase db;

        QDateTime dateLastCheck;

        QMap <QDateTime, QStringList> messages_map;

        QString tooltipContent;
        QString tooltipSummaryContent;
        QString messageContent;
        QString currSender;
        QString currDate;
        QString currAccount;
        QString currUnread;
        QString currSubject;

        QString soundFile;
        QString soundFileOther;
        QString pythonFile;
        QString emailClient;
        QString emailComposer;
        QString settingsFile;
        QString dbFile;
        QString settingsPath;

        int messageDisplayTime;
        int imapCheckIntervaltTime;
        int imapFirstCheckTime;
        int iconAnimatorIdx;
        int iconAnimatorRefreshTime;
        int popupsOk;
        int playSoundOk;
        int imapTimeoutTime;

//protected:
//	bool eventFilter(QObject *obj, QEvent *ev);
};

#endif // SYSTRAYICON_H



