#include <QApplication>
#include <QDir>
//#include <QDebug>
#include <QTranslator>
#include <QLocale>
#include "SystrayIcon.h"
#include "SettingsInfo.h"

int main(int argc, char ** argv)
{
    QApplication a(argc, argv);
    /* following setXXX direcly impact QSettings */
    a.setApplicationName("imapquickcheck");
    a.setApplicationVersion("1.3");
    a.setOrganizationDomain("imapquickcheck.org");
    a.setOrganizationName("ImapQuickCheck");

	QString transfilename = a.applicationName() + "_" +  QLocale::system().name();
	QStringList translocations;
	translocations.append( "/usr/share/" + a.applicationName() + "/translations/" + transfilename );
	translocations.append( "/usr/local/share/" + a.applicationName() + "/translations/" + transfilename );
	translocations.append( SettingsInfo::configDir() + "/" + transfilename );
	translocations.append( a.applicationDirPath() + "/" + transfilename );
	QTranslator translator;

	foreach (QString transfile, translocations)
	{
	  if (translator.load(transfile))
	  {
		a.installTranslator(&translator);
		break;
	  }
	}
/*
    QTranslator translator;
    bool translation_found = false;    

    if ( translator.load( SettingsInfo::configDir() + "/" + app.applicationName() + "_" +  QLocale::system().name()) )
    {       
        translation_found = true;
    }
    else if ( translator.load( "/usr/share/" + app.applicationName() + "/translations/" + app.applicationName() + "_" + QLocale::system().name() ) )
        translation_found = true;

    if (translation_found)
        app.installTranslator(&translator);
*/
    SystrayIcon systray(0);
    systray.show();
    a.setQuitOnLastWindowClosed(false);//a.connect( &app, SIGNAL( lastWindowClosed() ), &app, SLOT( quit() ) );
    return a.exec();
}
