#! /usr/bin/env python
# -*- coding: utf-8 -*-

# TODO: sys.exit & args + SSL

import os, sys, imaplib #, ConfigParser string,time, codecs
from email.header import decode_header
from htmlentitydefs import codepoint2name
import sqlite3 as sqlite#from pysqlite2 import dbapi2 as sqlite

_db_file = os.path.join(os.path.expanduser("~"), ".config/ImapQuickCheck/accounts.db")
markAllReadRequested = False
deleteAllReadRequested = False
readonly_state=1

if len(sys.argv) > 1:
  _db_file = sys.argv[1]
  if "-markread" in sys.argv:
	markAllReadRequested = True
	readonly_state=0
  if "-deleteread" in sys.argv:
	deleteAllReadRequested = True
	readonly_state=0

if not os.path.exists(_db_file):
  print "ERROR : Could not find .db accounts file. BYE"
  sys.exit(1)

_keys_new = ["From:", "Subject:", "Date:"]
_months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

def htmlentities(u):
  #carrouf_chars = [34,39,60,62]
  result = []
  for c in u:
      if ord(c) < 128:
	  #if ord(c) in carrouf_chars:
	  #  result.append('*') #result.append('&%s;' % codepoint2name[ord(c)])
	  #else:
	  result.append(c)
      else:
	  result.append('&%s;' % codepoint2name[ord(c)])
  return ''.join(result)

def cleanDate(rawDate):
  rawSplit = rawDate.strip().split(' ')
  rawSplitted = []
  
  for raw in rawSplit:
	if raw != '':
	  rawSplitted.append(raw)

  if rawSplitted[0].isdigit() == False:
	rawSplitted.pop(0)

  if rawSplitted[0][:1] == "0":
	rawSplitted[0] = rawSplitted[0][1:]

  return (rawSplitted[0] + ' ' + convertMonthNameToNum( rawSplitted[1] ) + ' ' + rawSplitted[2] + ' ' + rawSplitted[3])

def convertMonthNameToNum(month_str):
  if month_str in _months:
	return str(_months.index(month_str)+1)
  else:
	return month_str  

"""
def extractData(_data, _currentKey):
  _currentKey, _currentLabel = _currentKey.split("//")
  _start = _data.find(_currentKey)
  _end =  _data.find("\r",_start)
  return htmlentities( _currentLabel + "" + filterHTML( _data[(_start+len(_currentKey)):_end].strip() ) )
"""

def extractDataNew(_data, _currentKey):
  _start = _data.find(_currentKey)
  _end =  _data.find("\r",_start)
  return htmlentities( filterHTML( _data[(_start+len(_currentKey)):_end].strip() ) )

def filterHTML(_str):
  _arr = ["':&#44;", "<:&lt;", ">:&gt;", '":&quot;'] #kdialog prend tous les <> pour des balises HTML
  for filt in _arr:
	_split = filt.split(":")
	_str = _str.replace( _split[0], _split[1] )

  _text = decode_header(_str)[0][0]
  _code = decode_header(_str)[0][1]
  #print  "HEY !!!, ", decode_header(_str)[0][0],decode_header(_str)[0][1]
  #print "TWO=", two
  try:
    if _code != None:
      #print '->', decode_header(_str)[0][0].decode(_code)
      #bob= decode_header(_str)[0][0].encode(two)
      _str = decode_header(_str)[0][0].decode(_code)
      #_str = -str.encode('latin-1')
  except:
    print 'filterHTML : Decode Error', sys.exc_info()[0]
    sys.exit(1)
  #print '->', decode_header(_str)[0][0].decode('iso-8859-1')
  #print _text, _code
  #return decode_header(_str)[0][0].encode(decode_header(_str)[0][1])
  return _str

def imapMailboxChecker():
  """
  CONNECT IMAP SERVER  
  """
  if _connect_mode == 1:
	conn = imaplib.IMAP4(host=_host, port=_port)
  elif _connect_mode == 2:
	conn = imaplib.IMAP4_SSL(host=_host, port=_port)
	
  try:
	(retcode, capabilities) = conn.login(_login, _pass)
  except:
	print sys.exc_info()[0] #sys.exit(1)	
	print "__ERROR_LOGIN:", _account_name #print "IMAP : login Error"
	return False #break

  """
  RETRIEVE UNSEEN MESSAGES DETAILS  
  """
  try:
	if len(_inbox)==0:
	  conn.select(readonly=readonly_state) # Select inbox or default namespace
	else:
	  conn.select(_inbox, readonly=readonly_state) # Select inbox or default namespace
	
	(retcode, messages) = conn.search(None, '(UNSEEN)')
	
	if retcode == 'OK':
	  if markAllReadRequested:
		for num in messages[0].split():
		  conn.store(num, '+FLAGS', '\\Seen')
	  elif deleteAllReadRequested:
		for num in messages[0].split():
		  conn.store(num, '+FLAGS', '\\Deleted')
		conn.expunge()
	  else:
		mailArray = []
		
		if len(messages[0]) > 0:
		  for message in messages[0].split(' '):
			(ret, mesginfo) = conn.fetch(message, '(BODY[HEADER.FIELDS (SUBJECT FROM DATE)])')  
			if ret == 'OK':
			  mailArray.append( [ extractDataNew(mesginfo[0][1], _keys_new[0]),
								  extractDataNew(mesginfo[0][1], _keys_new[1]),
								  extractDataNew(mesginfo[0][1], _keys_new[2])
								] ) 
			else:
			  print _host, "IMAP : request NOt Ok"	  
		  
		  mailArray.reverse()
		  print "__ACCOUNT:", _account_name
		  print "__UNREAD:",  str(len(mailArray))
		  
		  for j in range(0, len(mailArray)):
			print "__SENDER:", mailArray[j][0]
			print "__SUBJECT:", mailArray[j][1]
			print "__DATE:", cleanDate(mailArray[j][2])
			print "____________"

	conn.close()
	return True
  except:
	print "sys.exc_info()", sys.exc_info()[0]	
	print "__ERROR_FETCH:", _account_name #print "IMAP : Fetch Error"
	return False

"""
MAIN LOOP  
"""
con = sqlite.connect(_db_file)
cur = con.cursor()
cur.execute("SELECT type AS connect_type, name, host, port, user, pwd, inbox FROM accounts ORDER BY id")
for (connect_type, name, host, port, user, pwd, inbox) in cur:
	#print '%s is %d years old.' % (name, id)
	_connect_mode = connect_type
	_account_name = name
	_host = host
	_port = port
	_login = user
	_pass = pwd
	_inbox = inbox
	imapMailboxChecker()
