#!/bin/bash
#
# looks for an openoffice dir in /opt
# if it finds one it adds the /program subdir to the system path
# 2006 by Paul Sherman <pcbypaul.com>
#
for f in `ls -d /opt/?pen?ffice*`
do 
  oo_path=$f/program
done

if [ -x "$oo_path/swriter" ]; then 
	pret=`echo $PATH | grep $oo_path`
	if [ "$pret" == "" ]; then
		export PATH=$PATH:$oo_path
	fi
	swriter "$1"&
	exit 0
else
	DIALOG=Xdialog
	$DIALOG   --rc-file /usr/share/pixmaps/colorboxDOH.rc  --icon /usr/share/pixmaps/doh.xpm  --title "DOH!" \
		--msgbox "\nopenoffice does not seem to be installed\n\nVisit absolutelinux.org should have the package!\n" 0 0
	exit 0
fi

