# Handle the incoming configuration files:
config() {
  for infile in $1; do
    NEW="$infile"
    OLD="`dirname $NEW`/`basename $NEW .new`"
    # If there's no config file by that name, mv it over:
    if [ ! -r $OLD ]; then
      mv $NEW $OLD
    elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
      # toss the redundant copy
      rm $NEW
    fi
    # Otherwise, we leave the .new copy for the admin to consider...
  done
}

# An example of how you handle your '.new' config files:
#config etc/openbox.conf.new

( cd usr/lib ; rm -rf libobrender.so.32 )
( cd usr/lib ; ln -sf libobrender.so.32.0.0 libobrender.so.32 )
( cd usr/lib ; rm -rf libobt.so.2 )
( cd usr/lib ; ln -sf libobt.so.2.0.2 libobt.so.2 )
( cd usr/lib ; rm -rf libobt.so )
( cd usr/lib ; ln -sf libobt.so.2.0.2 libobt.so )
( cd usr/lib ; rm -rf libobrender.so )
( cd usr/lib ; ln -sf libobrender.so.32.0.0 libobrender.so )
( cd usr/share/apps/kdm/sessions ; rm -rf openbox-session.desktop )
( cd usr/share/apps/kdm/sessions ; ln -sf ../../../xsessions/openbox-session.desktop openbox-session.desktop )
