echo "**"
echo "** Downloading Web Core Fonts..."
echo "**"
TEMPOUT=$(mktemp -t -d alien.XXXXXX)
wget -nv -T 20 -O - "http://taper.alienbase.nl/fonts/webcore-fonts-3.0.tar.gz" | tar -C${TEMPOUT} -zxf -
if [ $? -ne 0 ]; then
  echo "** Downloading the Web Core fonts failed... aborting the install."
  exit 1
else
  echo "** Installing Web Core Fonts..."
  chown -R root:root ${TEMPOUT}/*
  chmod -R u+w,go+r-w,a+X-s ${TEMPOUT}/*
fi

# Move the fonts plus documentation into the system
# (yes, this causes pollution which remains after package uninstallation):
mkdir -p .//usr/share/fonts/TTF
cp ${TEMPOUT}/webcore-fonts/fonts/* .//usr/share/fonts/TTF
cp ${TEMPOUT}/webcore-fonts/vista/* .//usr/share/fonts/TTF
cp ${TEMPOUT}/webcore-fonts/doc/* ./usr/doc/webcore-fonts-installer-3.0

# Clean up:
rm -rf ${TEMPOUT}

# Update X font indexes and the font cache:
if [ -x usr/bin/mkfontdir ]; then
  chroot . /usr/bin/mkfontscale /usr/share/fonts/TTF
  chroot . /usr/bin/mkfontdir /usr/share/fonts/TTF
fi
if [ -x usr/bin/fc-cache ]; then
  chroot . /usr/bin/fc-cache /usr/share/fonts/TTF
fi
