include(GetPlatformInfo)

if(NOT OS_IS_WIN)
    return()
endif()

include(InstallRequiredSystemLibraries)

set(CPACK_PACKAGE_NAME ${MUSESCORE_NAME})
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "MuseScore is a full featured WYSIWYG score editor")
set(CPACK_PACKAGE_VENDOR "MuseScore BVBA and Others")
set(CPACK_PACKAGE_CONTACT "https://musescore.org")
set(CPACK_PACKAGE_HOMEPAGE_URL "https://musescore.org")

set(CPACK_PACKAGE_VERSION_MAJOR "${MUSESCORE_VERSION_MAJOR}")
set(CPACK_PACKAGE_VERSION_MINOR "${MUSESCORE_VERSION_MINOR}")
set(CPACK_PACKAGE_VERSION_PATCH "${MUSESCORE_VERSION_PATCH}")
set(CPACK_PACKAGE_VERSION_BUILD "${CMAKE_BUILD_NUMBER}")
set(CPACK_PACKAGE_VERSION "${MUSESCORE_VERSION_MAJOR}.${MUSESCORE_VERSION_MINOR}.${MUSESCORE_VERSION_PATCH}.${CPACK_PACKAGE_VERSION_BUILD}")
message("CPACK_PACKAGE_VERSION: ${CPACK_PACKAGE_VERSION}")

set(git_date_string "")

if(MUSESCORE_UNSTABLE)
    find_program(GIT_EXECUTABLE git PATHS ENV PATH)

    if(GIT_EXECUTABLE)
        execute_process(
            COMMAND "${GIT_EXECUTABLE}" log -1 --date=short --format=%cd
            WORKING_DIRECTORY "${PROJECT_SOURCE_DIR}"
            OUTPUT_VARIABLE git_date
            OUTPUT_STRIP_TRAILING_WHITESPACE)
    endif()

    if(git_date)
        string(REGEX REPLACE "-" "" git_date "${git_date}")
        set(git_date_string "~git${git_date}")
    endif()
endif(MUSESCORE_UNSTABLE)

set(CPACK_PACKAGE_FILE_NAME "${MUSESCORE_NAME}-${MUSESCORE_VERSION}${git_date_string}")
set(CPACK_PACKAGE_INSTALL_DIRECTORY ${MUSESCORE_NAME_VERSION})

set(MUSESCORE_EXECUTABLE_NAME ${MUSESCORE_NAME}${MUSESCORE_VERSION_MAJOR})
set(CPACK_PACKAGE_EXECUTABLES "${MUSESCORE_EXECUTABLE_NAME}" "${MUSESCORE_TITLE_VERSION}") # exe name, label
set(CPACK_CREATE_DESKTOP_LINKS "${MUSESCORE_EXECUTABLE_NAME}" "${MUSESCORE_TITLE_VERSION}") # exe name, label

# Wix-specific options
set(CPACK_GENERATOR "WIX")

file(TO_CMAKE_PATH $ENV{PROGRAMFILES} PROGRAMFILES)
set(CPACK_WIX_ROOT "${PROGRAMFILES}/WiX Toolset v3.11")

# Use custom version of WIX.template.in
set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_SOURCE_DIR}/build/packaging" ${CMAKE_MODULE_PATH})

if(NOT CPACK_WIX_PRODUCT_GUID)
    set(CPACK_WIX_PRODUCT_GUID "00000000-0000-0000-0000-000000000000")
endif()

message(STATUS "[SetupWindowsPackaging.cmake] CPACK_WIX_PRODUCT_GUID: ${CPACK_WIX_PRODUCT_GUID}")

if(NOT CPACK_WIX_UPGRADE_GUID)
    set(CPACK_WIX_UPGRADE_GUID "11111111-1111-1111-1111-111111111111")
endif()

message(STATUS "[SetupWindowsPackaging.cmake] CPACK_WIX_UPGRADE_GUID: ${CPACK_WIX_UPGRADE_GUID}")

set(CPACK_WIX_LICENSE_RTF "${PROJECT_SOURCE_DIR}/build/packaging/LICENSE.rtf")
set(CPACK_WIX_PRODUCT_ICON "${PROJECT_SOURCE_DIR}/share/icons/AppIcon/MS4_AppIcon.ico")
set(CPACK_WIX_UI_BANNER "${PROJECT_SOURCE_DIR}/build/packaging/installer_banner_wix.png")
set(CPACK_WIX_UI_DIALOG "${PROJECT_SOURCE_DIR}/build/packaging/installer_background_wix.png")
set(CPACK_WIX_PROGRAM_MENU_FOLDER "${MUSESCORE_TITLE_VERSION}")
set(CPACK_WIX_EXTENSIONS "WixUtilExtension")

# Extra CPack variables
list(APPEND CPACK_WIX_CANDLE_EXTRA_FLAGS
    "-dMUSESCORE_TITLE_VERSION=${MUSESCORE_TITLE_VERSION}"
    "-dMUSESCORE_TITLE=${MUSESCORE_TITLE}"
    "-dMUSESCORE_EXECUTABLE_NAME=${MUSESCORE_EXECUTABLE_NAME}"
    "-dMUSESCORE_RELEASE_CHANNEL=${MUSESCORE_RELEASE_CHANNEL}"
    "-dCPACK_PACKAGE_VERSION_MAJOR=${CPACK_PACKAGE_VERSION_MAJOR}"
)

if (MUSESCORE_IS_PRERELEASE)
    list(APPEND CPACK_WIX_CANDLE_EXTRA_FLAGS "-dMUSESCORE_IS_PRERELEASE=ON")
endif()

include(CPack)
