/*
 * SPDX-License-Identifier: GPL-3.0-only
 * MuseScore-CLA-applies
 *
 * MuseScore
 * Music Composition & Notation
 *
 * Copyright (C) 2022 MuseScore BVBA and others
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

// Templates
QT_TRANSLATE_NOOP("project/templatecategory", "General"),
QT_TRANSLATE_NOOP("project/template", "Treble Clef"),
QT_TRANSLATE_NOOP("project/template", "Bass Clef"),
QT_TRANSLATE_NOOP("project/template", "Grand Staff"),
QT_TRANSLATE_NOOP("project/templatecategory", "Choral"),
QT_TRANSLATE_NOOP("project/template", "SATB"),
QT_TRANSLATE_NOOP("project/template", "SATB + Organ"),
QT_TRANSLATE_NOOP("project/template", "SATB + Piano"),
QT_TRANSLATE_NOOP("project/template", "SATB Closed Score"),
QT_TRANSLATE_NOOP("project/template", "SATB Closed Score + Organ"),
QT_TRANSLATE_NOOP("project/template", "SATB Closed Score + Piano"),
QT_TRANSLATE_NOOP("project/template", "Voice + Piano"),
QT_TRANSLATE_NOOP("project/template", "Barbershop Quartet (Men)"),
QT_TRANSLATE_NOOP("project/template", "Barbershop Quartet (Women)"),
QT_TRANSLATE_NOOP("project/template", "Liturgical Unmetrical"),
QT_TRANSLATE_NOOP("project/template", "Liturgical Unmetrical + Organ"),
QT_TRANSLATE_NOOP("project/templatecategory", "Chamber Music"),
QT_TRANSLATE_NOOP("project/template", "String Quartet"),
QT_TRANSLATE_NOOP("project/template", "Wind Quartet"),
QT_TRANSLATE_NOOP("project/template", "Wind Quintet"),
QT_TRANSLATE_NOOP("project/template", "Saxophone Quartet"),
QT_TRANSLATE_NOOP("project/template", "Brass Quartet"),
QT_TRANSLATE_NOOP("project/template", "Brass Quintet"),
QT_TRANSLATE_NOOP("project/templatecategory", "Solo"),
QT_TRANSLATE_NOOP("project/template", "Guitar"),
QT_TRANSLATE_NOOP("project/template", "Guitar + Tablature"),
QT_TRANSLATE_NOOP("project/template", "Guitar Tablature"),
QT_TRANSLATE_NOOP("project/template", "Piano"),
QT_TRANSLATE_NOOP("project/templatecategory", "Jazz"),
QT_TRANSLATE_NOOP("project/template", "Jazz Lead Sheet"),
QT_TRANSLATE_NOOP("project/template", "Big Band"),
QT_TRANSLATE_NOOP("project/template", "Jazz Combo"),
QT_TRANSLATE_NOOP("project/templatecategory", "Popular"),
QT_TRANSLATE_NOOP("project/template", "Rock Band"),
QT_TRANSLATE_NOOP("project/template", "Bluegrass Band"),
QT_TRANSLATE_NOOP("project/templatecategory", "Band and Percussion"),
QT_TRANSLATE_NOOP("project/template", "Concert Band"),
QT_TRANSLATE_NOOP("project/template", "Small Concert Band"),
QT_TRANSLATE_NOOP("project/template", "Brass Band"),
QT_TRANSLATE_NOOP("project/template", "Marching Band"),
QT_TRANSLATE_NOOP("project/template", "Small Marching Band"),
QT_TRANSLATE_NOOP("project/template", "Battery Percussion"),
QT_TRANSLATE_NOOP("project/template", "Large Pit Percussion"),
QT_TRANSLATE_NOOP("project/template", "Small Pit Percussion"),
QT_TRANSLATE_NOOP("project/template", "European Concert Band"),
QT_TRANSLATE_NOOP("project/templatecategory", "Orchestral"),
QT_TRANSLATE_NOOP("project/template", "Classical Orchestra"),
QT_TRANSLATE_NOOP("project/template", "Symphony Orchestra"),
QT_TRANSLATE_NOOP("project/template", "String Orchestra"),

// Genres
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Common"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Pop/Rock"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Jazz"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Choral"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Orchestra"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Concert Band"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Marching Band"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Electronic Music"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "World Music"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Early Music"),
QT_TRANSLATE_NOOP("engraving/instruments/genre", "Classroom"),

// Families
QT_TRANSLATE_NOOP("engraving/instruments/family", "Winds"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Flutes"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Dizis"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Shakuhachis"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Fifes"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Whistles"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Flageolets"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Recorders"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Ocarinas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Gemshorns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Pan Flutes"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Quenas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Oboes"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Shawms"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Cromornes"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Crumhorns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Cornamuses"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Kelhorns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Rauschpfeifes"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Duduks"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Shenais"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Clarinets"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Chalumeaus"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Xaphoons"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Tarogatos"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Octavins"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Saxophones"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Bassoons"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Reed Contrabasses"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Dulcians"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Racketts"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Sarrusophones"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Bagpipes"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Accordions"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Harmonicas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Melodicas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Shengs"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Brass"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Horns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Wagner Tubas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Cornets"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Saxhorns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Alto Horns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Baritone Horns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Posthorns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Trumpets"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Baroque Trumpets"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Bugles"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Flugelhorns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Ophicleides"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Cornetts"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Serpents"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Trombones"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Cimbassos"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Sackbuts"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Euphoniums"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Tubas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Sousaphones"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Conches"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Alphorns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Rag Dungs"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Didgeridoos"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Shofars"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Vuvuzelas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Timpani"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Roto Toms"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Tubaphones"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Steel Drums"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Keyboard Percussion"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Pitched Metal Percussion"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Orff Percussion"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Flexatones"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Musical Saws"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Glass Percussion"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Klaxon Horns"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Kalimbas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Drums"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Unpitched Metal Percussion"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Unpitched Wooden Percussion"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Other Percussion"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Batterie"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Body Percussion"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Voices"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Voice Groups"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Kazoos"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Keyboards"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Organs"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Synths"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Harps"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Guitars"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Bass Guitars"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Banjos"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Ukuleles"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Mandolins"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Mtn. Dulcimers"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Lutes"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Balalaikas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Bouzoukis"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Kotos"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Ouds"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Shamisens"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Sitars"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Tamburicas"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Bandurrias"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Laúds"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Strings"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Orchestral Strings"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Viols"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Octobasses"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Erhus"),
QT_TRANSLATE_NOOP("engraving/instruments/family", "Nyckelharpas"),

// Groups & Instruments

// Woodwinds
QT_TRANSLATE_NOOP("engraving/instruments/group", "Woodwinds"),

//: description for Winds; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wind section notated on a grand staff.", "winds description"),
//: trackName for Winds; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Winds", "winds trackName"),
//: longName for Winds; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Winds", "winds longName"),
//: shortName for Winds; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wi.", "winds shortName"),

//: description for Piccolo; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo in E♭, sounding a minor third above the standard piccolo.", "eb-piccolo description"),
//: trackName for Piccolo; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo", "eb-piccolo trackName"),
//: longName for Piccolo; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo", "eb-piccolo longName"),
//: shortName for Piccolo; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Picc.", "eb-piccolo shortName"),
//: traitName for Piccolo; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "eb-piccolo traitName"),

//: description for Piccolo; transposition: D♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo in D♭, sounding a semitone above the standard piccolo.", "db-piccolo description"),
//: trackName for Piccolo; transposition: D♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo", "db-piccolo trackName"),
//: longName for Piccolo; transposition: D♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo", "db-piccolo longName"),
//: shortName for Piccolo; transposition: D♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Picc.", "db-piccolo shortName"),
//: traitName for Piccolo; transposition: D♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D♭", "db-piccolo traitName"),

//: description for Piccolo; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Standard concert piccolo in C.", "piccolo description"),
//: trackName for Piccolo; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo", "piccolo trackName"),
//: longName for Piccolo; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo", "piccolo longName"),
//: shortName for Piccolo; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Picc.", "piccolo shortName"),
//: traitName for Piccolo; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*(C)", "piccolo traitName"),

//: description for Treble Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in G, sounding a fifth higher than the standard flute.", "treble-flute description"),
//: trackName for Treble Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Treble Flute", "treble-flute trackName"),
//: longName for Treble Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Treble Flute", "treble-flute longName"),
//: shortName for Treble Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tr. Fl.", "treble-flute shortName"),

//: description for Danso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Notched, end-blown vertical bamboo flute used in Korean folk music.", "danso description"),
//: trackName for Danso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Danso", "danso trackName"),
//: longName for Danso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Danso", "danso longName"),
//: shortName for Danso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Da.", "danso shortName"),

//: description for Soprano Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in E♭, sounding a minor third above the standard flute.", "soprano-flute description"),
//: trackName for Soprano Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Flute", "soprano-flute trackName"),
//: longName for Soprano Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Flute", "soprano-flute longName"),
//: shortName for Soprano Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sop. Fl.", "soprano-flute shortName"),

//: description for Irish Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-hole simple-system wooden transverse flute.", "irish-flute description"),
//: trackName for Irish Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Irish Flute", "irish-flute trackName"),
//: longName for Irish Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Irish Flute", "irish-flute longName"),
//: shortName for Irish Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ir. Fl.", "irish-flute shortName"),

//: description for Traverso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque wooden transverse flute.", "traverso description"),
//: trackName for Traverso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Traverso", "traverso trackName"),
//: longName for Traverso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Traverso", "traverso longName"),
//: shortName for Traverso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trv.", "traverso shortName"),

//: description for Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Standard concert flute in C.", "flute description"),
//: trackName for Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute", "flute trackName"),
//: longName for Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute", "flute longName"),
//: shortName for Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fl.", "flute shortName"),

//: description for Alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in G, sounding a fourth lower than the standard flute.", "alto-flute description"),
//: trackName for Alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Flute", "alto-flute trackName"),
//: longName for Alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Flute", "alto-flute longName"),
//: shortName for Alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Fl.", "alto-flute shortName"),

//: description for Bass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in C, sounding an octave lower than the standard flute.", "bass-flute description"),
//: trackName for Bass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Flute", "bass-flute trackName"),
//: longName for Bass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Flute", "bass-flute longName"),
//: shortName for Bass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Fl.", "bass-flute shortName"),

//: description for Contra-alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in G, sounding an octave below the alto flute.", "contra-alto-flute description"),
//: trackName for Contra-alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contra-alto Flute", "contra-alto-flute trackName"),
//: longName for Contra-alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contra-alto Flute", "contra-alto-flute longName"),
//: shortName for Contra-alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C-a. Fl.", "contra-alto-flute shortName"),

//: description for Contrabass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in C, sounding two octaves lower than the standard flute.", "contrabass-flute description"),
//: trackName for Contrabass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Flute", "contrabass-flute trackName"),
//: longName for Contrabass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Flute", "contrabass-flute longName"),
//: shortName for Contrabass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Fl.", "contrabass-flute shortName"),

//: description for Sub Contra-alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in G, sounding two octaves below the alto flute.", "subcontra-alto-flute description"),
//: trackName for Sub Contra-alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sub Contra-alto Flute", "subcontra-alto-flute trackName"),
//: longName for Sub Contra-alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sub Contra-alto Flute", "subcontra-alto-flute longName"),
//: shortName for Sub Contra-alto Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sc-a. Fl.", "subcontra-alto-flute shortName"),

//: description for Double Contrabass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in C, sounding three octaves below the standard flute.", "double-contrabass-flute description"),
//: trackName for Double Contrabass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Double Contrabass Flute", "double-contrabass-flute trackName"),
//: longName for Double Contrabass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Double Contrabass Flute", "double-contrabass-flute longName"),
//: shortName for Double Contrabass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D. Cb. Fl.", "double-contrabass-flute shortName"),

//: description for Hyperbass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flute in C, sounding four octaves below the standard flute.", "hyperbass-flute description"),
//: trackName for Hyperbass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hyperbass Flute", "hyperbass-flute trackName"),
//: longName for Hyperbass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hyperbass Flute", "hyperbass-flute longName"),
//: shortName for Hyperbass Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hb. Fl.", "hyperbass-flute shortName"),

//: description for Dizi; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese bamboo transverse flute, pitched in A.", "a-dizi description"),
//: trackName for Dizi; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dizi", "a-dizi trackName"),
//: longName for Dizi; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A Dizi", "a-dizi longName"),
//: shortName for Dizi; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A Di.", "a-dizi shortName"),
//: traitName for Dizi; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "a-dizi traitName"),

//: description for Dizi; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese bamboo transverse flute, pitched in G. The most common variant.", "g-dizi description"),
//: trackName for Dizi; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dizi", "g-dizi trackName"),
//: longName for Dizi; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Dizi", "g-dizi longName"),
//: shortName for Dizi; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Di.", "g-dizi shortName"),
//: traitName for Dizi; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*G", "g-dizi traitName"),

//: description for Dizi; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese bamboo transverse flute, pitched in F.", "f-dizi description"),
//: trackName for Dizi; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dizi", "f-dizi trackName"),
//: longName for Dizi; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Dizi", "f-dizi longName"),
//: shortName for Dizi; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Di.", "f-dizi shortName"),
//: traitName for Dizi; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-dizi traitName"),

//: description for Dizi; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese bamboo transverse flute, pitched in E.", "e-dizi description"),
//: trackName for Dizi; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dizi", "e-dizi trackName"),
//: longName for Dizi; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E Dizi", "e-dizi longName"),
//: shortName for Dizi; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E Di.", "e-dizi shortName"),
//: traitName for Dizi; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E", "e-dizi traitName"),

//: description for Dizi; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese bamboo transverse flute, pitched in D.", "d-dizi description"),
//: trackName for Dizi; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dizi", "d-dizi trackName"),
//: longName for Dizi; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Dizi", "d-dizi longName"),
//: shortName for Dizi; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Di.", "d-dizi shortName"),
//: traitName for Dizi; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-dizi traitName"),

//: description for Dizi; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese bamboo transverse flute, pitched in C.", "c-dizi description"),
//: trackName for Dizi; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dizi", "c-dizi trackName"),
//: longName for Dizi; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Dizi", "c-dizi longName"),
//: shortName for Dizi; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Di.", "c-dizi shortName"),
//: traitName for Dizi; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-dizi traitName"),

//: description for Shakuhachi; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Japanese bamboo end-blown flute.", "shakuhachi description"),
//: trackName for Shakuhachi; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shakuhachi", "shakuhachi trackName"),
//: longName for Shakuhachi; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shakuhachi", "shakuhachi longName"),
//: shortName for Shakuhachi; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shak.", "shakuhachi shortName"),

//: description for Fife; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fife pitched in B♭ (when all 6 holes are covered), notated in A♭, sounding a minor sixth higher than written.", "fife description"),
//: trackName for Fife; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fife", "fife trackName"),
//: longName for Fife; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Fife", "fife longName"),
//: shortName for Fife; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Fife", "fife shortName"),
//: traitName for Fife; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "fife traitName"),

//: description for Tin Whistle; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Whistle pitched in D (notated at concert pitch).", "d-tin-whistle description"),
//: trackName for Tin Whistle; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tin Whistle", "d-tin-whistle trackName"),
//: longName for Tin Whistle; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Tin Whistle", "d-tin-whistle longName"),
//: shortName for Tin Whistle; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Tin Wh.", "d-tin-whistle shortName"),
//: traitName for Tin Whistle; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-tin-whistle traitName"),

//: description for Tin Whistle; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Whistle pitched in C.", "c-tin-whistle description"),
//: trackName for Tin Whistle; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tin Whistle", "c-tin-whistle trackName"),
//: longName for Tin Whistle; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Tin Whistle", "c-tin-whistle longName"),
//: shortName for Tin Whistle; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Tin Wh.", "c-tin-whistle shortName"),
//: traitName for Tin Whistle; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-tin-whistle traitName"),

//: description for Tin Whistle; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Whistle pitched in B♭ (notated at concert pitch).", "bflat-tin-whistle description"),
//: trackName for Tin Whistle; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tin Whistle", "bflat-tin-whistle trackName"),
//: longName for Tin Whistle; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Tin Whistle", "bflat-tin-whistle longName"),
//: shortName for Tin Whistle; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Tin Wh.", "bflat-tin-whistle shortName"),
//: traitName for Tin Whistle; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bflat-tin-whistle traitName"),

//: description for Slide Whistle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slide or swanee whistle.", "slide-whistle description"),
//: trackName for Slide Whistle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slide Whistle", "slide-whistle trackName"),
//: longName for Slide Whistle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slide Whistle", "slide-whistle longName"),
//: shortName for Slide Whistle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sl. Wh.", "slide-whistle shortName"),

//: description for French Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flageolet with four holes.", "french-flageolet description"),
//: trackName for French Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "French Flageolet", "french-flageolet trackName"),
//: longName for French Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "French Flageolet", "french-flageolet longName"),
//: shortName for French Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fr. Fla.", "french-flageolet shortName"),

//: description for English Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flageolet with six holes.", "english-flageolet description"),
//: trackName for English Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "English Flageolet", "english-flageolet trackName"),
//: longName for English Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "English Flageolet", "english-flageolet longName"),
//: shortName for English Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Eng. Fla.", "english-flageolet shortName"),

//: description for Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flageolet with six holes.", "flageolet description"),
//: trackName for Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flageolet", "flageolet trackName"),
//: longName for Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flageolet", "flageolet longName"),
//: shortName for Flageolet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fla.", "flageolet shortName"),

//: description for Garklein Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "The smallest modern recorder, pitched in C (an octave above the soprano).", "garklein-recorder description"),
//: trackName for Garklein Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Garklein Recorder", "garklein-recorder trackName"),
//: longName for Garklein Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Garklein Recorder", "garklein-recorder longName"),
//: shortName for Garklein Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gk. Rec.", "garklein-recorder shortName"),

//: description for Sopranino Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "The second smallest recorder, pitched in F (an octave above the alto).", "sopranino-recorder description"),
//: trackName for Sopranino Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Recorder", "sopranino-recorder trackName"),
//: longName for Sopranino Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Recorder", "sopranino-recorder longName"),
//: shortName for Sopranino Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Si. Rec.", "sopranino-recorder shortName"),

//: description for Soprano Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Also known as the descant recorder. Pitched in C.", "soprano-recorder description"),
//: trackName for Soprano Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Recorder", "soprano-recorder trackName"),
//: longName for Soprano Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Recorder", "soprano-recorder longName"),
//: shortName for Soprano Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Rec.", "soprano-recorder shortName"),

//: description for Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano or descant recorder, pitched in C.", "recorder description"),
//: trackName for Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Recorder", "recorder trackName"),
//: longName for Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Recorder", "recorder longName"),
//: shortName for Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rec.", "recorder shortName"),

//: description for Alto Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Also known as the treble recorder. Pitched in F. Sometimes with an extra key for low E.", "alto-recorder description"),
//: trackName for Alto Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Recorder", "alto-recorder trackName"),
//: longName for Alto Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Recorder", "alto-recorder longName"),
//: shortName for Alto Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Rec.", "alto-recorder shortName"),

//: description for Tenor Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Recorder pitched in C (an octave below the soprano).", "tenor-recorder description"),
//: trackName for Tenor Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Recorder", "tenor-recorder trackName"),
//: longName for Tenor Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Recorder", "tenor-recorder longName"),
//: shortName for Tenor Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Rec.", "tenor-recorder shortName"),

//: description for Bass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Recorder pitched in F (an octave below the alto).", "bass-recorder description"),
//: trackName for Bass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Recorder", "bass-recorder trackName"),
//: longName for Bass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Recorder", "bass-recorder longName"),
//: shortName for Bass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Rec.", "bass-recorder shortName"),

//: description for Greatbass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Recorder pitched in C (an octave below the tenor).", "greatbass-recorder description"),
//: trackName for Greatbass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Greatbass Recorder", "greatbass-recorder trackName"),
//: longName for Greatbass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Greatbass Recorder", "greatbass-recorder longName"),
//: shortName for Greatbass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gb. Rec.", "greatbass-recorder shortName"),

//: description for Contrabass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Recorder pitched in F (an octave below the bass).", "contrabass-recorder description"),
//: trackName for Contrabass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Recorder", "contrabass-recorder trackName"),
//: longName for Contrabass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Recorder", "contrabass-recorder longName"),
//: shortName for Contrabass Recorder; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Rec.", "contrabass-recorder shortName"),

//: description for Soprano Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano ocarina pitched in G.", "g-soprano-ocarina description"),
//: trackName for Soprano Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Ocarina", "g-soprano-ocarina trackName"),
//: longName for Soprano Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Soprano Ocarina", "g-soprano-ocarina longName"),
//: shortName for Soprano Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G S. Oc.", "g-soprano-ocarina shortName"),
//: traitName for Soprano Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G", "g-soprano-ocarina traitName"),

//: description for Soprano Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano ocarina pitched in F.", "f-soprano-ocarina description"),
//: trackName for Soprano Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Ocarina", "f-soprano-ocarina trackName"),
//: longName for Soprano Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Soprano Ocarina", "f-soprano-ocarina longName"),
//: shortName for Soprano Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F S. Oc.", "f-soprano-ocarina shortName"),
//: traitName for Soprano Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-soprano-ocarina traitName"),

//: description for Ocarina; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano ocarina pitched in C.", "ocarina description"),
//: trackName for Ocarina; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ocarina", "ocarina trackName"),
//: longName for Ocarina; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ocarina", "ocarina longName"),
//: shortName for Ocarina; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oc.", "ocarina shortName"),

//: description for Soprano Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano ocarina pitched in C.", "c-soprano-ocarina description"),
//: trackName for Soprano Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Ocarina", "c-soprano-ocarina trackName"),
//: longName for Soprano Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Soprano Ocarina", "c-soprano-ocarina longName"),
//: shortName for Soprano Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C S. Oc.", "c-soprano-ocarina shortName"),
//: traitName for Soprano Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "c-soprano-ocarina traitName"),

//: description for Soprano Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano ocarina pitched in B♭.", "bb-soprano-ocarina description"),
//: trackName for Soprano Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Ocarina", "bb-soprano-ocarina trackName"),
//: longName for Soprano Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Soprano Ocarina", "bb-soprano-ocarina longName"),
//: shortName for Soprano Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ S. Oc.", "bb-soprano-ocarina shortName"),
//: traitName for Soprano Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-soprano-ocarina traitName"),

//: description for Alto Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto ocarina pitched in G.", "g-alto-ocarina description"),
//: trackName for Alto Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Ocarina", "g-alto-ocarina trackName"),
//: longName for Alto Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Alto Ocarina", "g-alto-ocarina longName"),
//: shortName for Alto Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G A. Oc.", "g-alto-ocarina shortName"),
//: traitName for Alto Ocarina; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G", "g-alto-ocarina traitName"),

//: description for Alto Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto ocarina pitched in F.", "f-alto-ocarina description"),
//: trackName for Alto Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Ocarina", "f-alto-ocarina trackName"),
//: longName for Alto Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Alto Ocarina", "f-alto-ocarina longName"),
//: shortName for Alto Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F A. Oc.", "f-alto-ocarina shortName"),
//: traitName for Alto Ocarina; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-alto-ocarina traitName"),

//: description for Alto Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto ocarina pitched in C.", "c-alto-ocarina description"),
//: trackName for Alto Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Ocarina", "c-alto-ocarina trackName"),
//: longName for Alto Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Alto Ocarina", "c-alto-ocarina longName"),
//: shortName for Alto Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C A. Oc.", "c-alto-ocarina shortName"),
//: traitName for Alto Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "c-alto-ocarina traitName"),

//: description for Alto Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto ocarina pitched in B♭.", "bb-alto-ocarina description"),
//: trackName for Alto Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Ocarina", "bb-alto-ocarina trackName"),
//: longName for Alto Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Alto Ocarina", "bb-alto-ocarina longName"),
//: shortName for Alto Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ A. Oc.", "bb-alto-ocarina shortName"),
//: traitName for Alto Ocarina; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-alto-ocarina traitName"),

//: description for Bass Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass ocarina pitched in C.", "c-bass-ocarina description"),
//: trackName for Bass Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Ocarina", "c-bass-ocarina trackName"),
//: longName for Bass Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Bass Ocarina", "c-bass-ocarina longName"),
//: shortName for Bass Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C B. Oc.", "c-bass-ocarina shortName"),
//: traitName for Bass Ocarina; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "c-bass-ocarina traitName"),

//: description for Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano ocarina made from an animal horn. Pitched in C.", "gemshorn description"),
//: trackName for Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gemshorn", "gemshorn trackName"),
//: longName for Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gemshorn", "gemshorn longName"),
//: shortName for Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gh.", "gemshorn shortName"),

//: description for Soprano Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano ocarina made from an animal horn. Pitched in C.", "soprano-gemshorn description"),
//: trackName for Soprano Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Gemshorn", "soprano-gemshorn trackName"),
//: longName for Soprano Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Gemshorn", "soprano-gemshorn longName"),
//: shortName for Soprano Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Gh.", "soprano-gemshorn shortName"),

//: description for Alto Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto ocarina made from an animal horn. Pitched in F.", "alto-gemshorn description"),
//: trackName for Alto Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Gemshorn", "alto-gemshorn trackName"),
//: longName for Alto Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Gemshorn", "alto-gemshorn longName"),
//: shortName for Alto Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Gh.", "alto-gemshorn shortName"),

//: description for Tenor Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor ocarina made from an animal horn. Pitched in C (an octave below the soprano).", "tenor-gemshorn description"),
//: trackName for Tenor Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Gemshorn", "tenor-gemshorn trackName"),
//: longName for Tenor Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Gemshorn", "tenor-gemshorn longName"),
//: shortName for Tenor Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Gh.", "tenor-gemshorn shortName"),

//: description for Bass Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass ocarina made from an animal horn. Pitched in F (an octave below the alto).", "bass-gemshorn description"),
//: trackName for Bass Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Gemshorn", "bass-gemshorn trackName"),
//: longName for Bass Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Gemshorn", "bass-gemshorn longName"),
//: shortName for Bass Gemshorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Gh.", "bass-gemshorn shortName"),

//: description for Pan Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "End-blown flute made of a row of closed tubes.", "pan-flute description"),
//: trackName for Pan Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pan Flute", "pan-flute trackName"),
//: longName for Pan Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pan Flute", "pan-flute longName"),
//: shortName for Pan Flute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pn. Fl.", "pan-flute shortName"),

//: description for Quena; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "South American traditional flute pitched in C.", "quena description"),
//: trackName for Quena; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Quena", "quena trackName"),
//: longName for Quena; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Quena", "quena longName"),
//: shortName for Quena; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Qn.", "quena shortName"),

//: description for Quena; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "South American traditional flute pitched in C.", "c-quena description"),
//: trackName for Quena; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Quena", "c-quena trackName"),
//: longName for Quena; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Quena", "c-quena longName"),
//: shortName for Quena; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Qn.", "c-quena shortName"),
//: traitName for Quena; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-quena traitName"),

//: description for Quena; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "South American traditional flute pitched in G. The most common variant.", "g-quena description"),
//: trackName for Quena; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Quena", "g-quena trackName"),
//: longName for Quena; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Quena", "g-quena longName"),
//: shortName for Quena; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Qn.", "g-quena shortName"),
//: traitName for Quena; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*G", "g-quena traitName"),

//: description for Quena; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "South American traditional flute pitched in F.", "f-quena description"),
//: trackName for Quena; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Quena", "f-quena trackName"),
//: longName for Quena; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Quena", "f-quena longName"),
//: shortName for Quena; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Qn.", "f-quena shortName"),
//: traitName for Quena; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-quena traitName"),

//: description for Quena; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "South American traditional flute pitched in D.", "d-quena description"),
//: trackName for Quena; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Quena", "d-quena trackName"),
//: longName for Quena; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Quena", "d-quena longName"),
//: shortName for Quena; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Qn.", "d-quena shortName"),
//: traitName for Quena; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-quena traitName"),

//: description for Piccolo Heckelphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Very rare variant of the heckelphone in F, sounding a fourth higher than the oboe.", "piccolo-heckelphone description"),
//: trackName for Piccolo Heckelphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Heckelphone", "piccolo-heckelphone trackName"),
//: longName for Piccolo Heckelphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Heckelphone", "piccolo-heckelphone longName"),
//: shortName for Piccolo Heckelphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "P. Hph.", "piccolo-heckelphone shortName"),

//: description for Piccolo Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe in E♭, sounding a minor third above the standard oboe. Historically called the oboe musette.", "piccolo-oboe description"),
//: trackName for Piccolo Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Oboe", "piccolo-oboe trackName"),
//: longName for Piccolo Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Oboe", "piccolo-oboe longName"),
//: shortName for Piccolo Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "P. Ob.", "piccolo-oboe shortName"),

//: description for Baroque Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque oboe with three keys, generally made of boxwood.", "baroque-oboe description"),
//: trackName for Baroque Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Oboe", "baroque-oboe trackName"),
//: longName for Baroque Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Oboe", "baroque-oboe longName"),
//: shortName for Baroque Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bq. Ob.", "baroque-oboe shortName"),

//: description for Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Standard concert oboe.", "oboe description"),
//: trackName for Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe", "oboe trackName"),
//: longName for Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe", "oboe longName"),
//: shortName for Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ob.", "oboe shortName"),

//: description for Oboe d’amore; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe in A, sounding a minor third below the standard oboe.", "oboe-d'amore description"),
//: trackName for Oboe d’amore; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe d’amore", "oboe-d'amore trackName"),
//: longName for Oboe d’amore; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe d’amore", "oboe-d'amore longName"),
//: shortName for Oboe d’amore; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ob. d’a.", "oboe-d'amore shortName"),

//: description for Oboe da caccia; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe in F, sounding a perfect fifth below the standard oboe.", "oboe-da-caccia description"),
//: trackName for Oboe da caccia; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe da caccia", "oboe-da-caccia trackName"),
//: longName for Oboe da caccia; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe da caccia", "oboe-da-caccia longName"),
//: shortName for Oboe da caccia; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ob. d. ca.", "oboe-da-caccia shortName"),

//: description for English Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe in F, sounding a perfect fifth below the standard oboe.", "english-horn description"),
//: trackName for English Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "English Horn", "english-horn trackName"),
//: longName for English Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "English Horn", "english-horn longName"),
//: shortName for English Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E. Hn.", "english-horn shortName"),

//: description for Bass Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe in C, sounding an octave lower than the standard oboe. Similar, but not identical to, the heckelphone.", "bass-oboe description"),
//: trackName for Bass Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Oboe", "bass-oboe trackName"),
//: longName for Bass Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Oboe", "bass-oboe longName"),
//: shortName for Bass Oboe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Ob.", "bass-oboe shortName"),

//: description for Heckelphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oboe in C, sounding an octave lower than the standard oboe. Similar, but not identical to, the bass oboe.", "heckelphone description"),
//: trackName for Heckelphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Heckelphone", "heckelphone trackName"),
//: longName for Heckelphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Heckelphone", "heckelphone longName"),
//: shortName for Heckelphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hph.", "heckelphone shortName"),

//: description for Lupophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Very rare instrument similar to the heckelphone, with slightly smaller bore and lower range.", "lupophone description"),
//: trackName for Lupophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lupophone", "lupophone trackName"),
//: longName for Lupophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lupophone", "lupophone longName"),
//: shortName for Lupophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lph.", "lupophone shortName"),

//: description for Sopranino Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12th-century conical bore, double-reed instrument, pitched in F (an octave above the alto shawm).", "sopranino-shawm description"),
//: trackName for Sopranino Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Shawm", "sopranino-shawm trackName"),
//: longName for Sopranino Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Shawm", "sopranino-shawm longName"),
//: shortName for Sopranino Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Si. Sh.", "sopranino-shawm shortName"),

//: description for Soprano Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12th-century conical bore, double-reed instrument, pitched in C.", "soprano-shawm description"),
//: trackName for Soprano Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Shawm", "soprano-shawm trackName"),
//: longName for Soprano Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Shawm", "soprano-shawm longName"),
//: shortName for Soprano Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Sh.", "soprano-shawm shortName"),

//: description for Alto Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12th-century conical bore, double-reed instrument, pitched in F (a fifth below the soprano shawm).", "alto-shawm description"),
//: trackName for Alto Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Shawm", "alto-shawm trackName"),
//: longName for Alto Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Shawm", "alto-shawm longName"),
//: shortName for Alto Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Sh.", "alto-shawm shortName"),

//: description for Tenor Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12th-century conical bore, double-reed instrument, pitched in C (an octave below the soprano shawm).", "tenor-shawm description"),
//: trackName for Tenor Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Shawm", "tenor-shawm trackName"),
//: longName for Tenor Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Shawm", "tenor-shawm longName"),
//: shortName for Tenor Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Sh.", "tenor-shawm shortName"),

//: description for Bass Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12th-century conical bore, double-reed instrument, pitched in F (an octave below the alto shawm).", "bass-shawm description"),
//: trackName for Bass Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Shawm", "bass-shawm trackName"),
//: longName for Bass Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Shawm", "bass-shawm longName"),
//: shortName for Bass Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Sh.", "bass-shawm shortName"),

//: description for Great Bass Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12th-century conical bore, double-reed instrument, pitched in C (an octave below the tenor shawm).", "great-bass-shawm description"),
//: trackName for Great Bass Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Great Bass Shawm", "great-bass-shawm trackName"),
//: longName for Great Bass Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Great Bass Shawm", "great-bass-shawm longName"),
//: shortName for Great Bass Shawm; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G.B. Sh.", "great-bass-shawm shortName"),

//: description for Cromorne; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "French baroque reed instrument of uncertain identity. Not to be confused with the crumhorn.", "cromorne description"),
//: trackName for Cromorne; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cromorne", "cromorne trackName"),
//: longName for Cromorne; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cromorne", "cromorne longName"),
//: shortName for Cromorne; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cr.", "cromorne shortName"),

//: description for Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with curved end, pitched in C.", "crumhorn description"),
//: trackName for Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crumhorn", "crumhorn trackName"),
//: longName for Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crumhorn", "crumhorn longName"),
//: shortName for Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crh.", "crumhorn shortName"),

//: description for Soprano Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with curved end, pitched in C.", "soprano-crumhorn description"),
//: trackName for Soprano Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Crumhorn", "soprano-crumhorn trackName"),
//: longName for Soprano Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Crumhorn", "soprano-crumhorn longName"),
//: shortName for Soprano Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Crh.", "soprano-crumhorn shortName"),

//: description for Alto Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with curved end, pitched in F (a fifth below the soprano crumhorn).", "alto-crumhorn description"),
//: trackName for Alto Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Crumhorn", "alto-crumhorn trackName"),
//: longName for Alto Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Crumhorn", "alto-crumhorn longName"),
//: shortName for Alto Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Crh.", "alto-crumhorn shortName"),

//: description for Tenor Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with curved end, pitched in C (an octave below the soprano crumhorn).", "tenor-crumhorn description"),
//: trackName for Tenor Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Crumhorn", "tenor-crumhorn trackName"),
//: longName for Tenor Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Crumhorn", "tenor-crumhorn longName"),
//: shortName for Tenor Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Crh.", "tenor-crumhorn shortName"),

//: description for Bass Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with curved end, pitched in F (an octave below the alto crumhorn).", "bass-crumhorn description"),
//: trackName for Bass Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Crumhorn", "bass-crumhorn trackName"),
//: longName for Bass Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Crumhorn", "bass-crumhorn longName"),
//: shortName for Bass Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Crh.", "bass-crumhorn shortName"),

//: description for Greatbass Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with curved end, pitched in C (an octave below the tenor crumhorn).", "greatbass-crumhorn description"),
//: trackName for Greatbass Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Greatbass Crumhorn", "greatbass-crumhorn trackName"),
//: longName for Greatbass Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Greatbass Crumhorn", "greatbass-crumhorn longName"),
//: shortName for Greatbass Crumhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gb. Crh.", "greatbass-crumhorn shortName"),

//: description for Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with straight end and single bore, pitched in C.", "cornamuse description"),
//: trackName for Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornamuse", "cornamuse trackName"),
//: longName for Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornamuse", "cornamuse longName"),
//: shortName for Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cm.", "cornamuse shortName"),

//: description for Soprano Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with straight end and single bore, pitched in C.", "soprano-cornamuse description"),
//: trackName for Soprano Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Cornamuse", "soprano-cornamuse trackName"),
//: longName for Soprano Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Cornamuse", "soprano-cornamuse longName"),
//: shortName for Soprano Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Cm.", "soprano-cornamuse shortName"),

//: description for Alto Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with straight end and single bore, pitched in G (a fourth below the soprano cornamuse).", "alto-cornamuse description"),
//: trackName for Alto Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Cornamuse", "alto-cornamuse trackName"),
//: longName for Alto Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Cornamuse", "alto-cornamuse longName"),
//: shortName for Alto Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Cm.", "alto-cornamuse shortName"),

//: description for Tenor Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with straight end and single bore, pitched in C (an octave below the soprano cornamuse).", "tenor-cornamuse description"),
//: trackName for Tenor Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Cornamuse", "tenor-cornamuse trackName"),
//: longName for Tenor Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Cornamuse", "tenor-cornamuse longName"),
//: shortName for Tenor Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Cm.", "tenor-cornamuse shortName"),

//: description for Bass Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with straight end and single bore, pitched in F (a ninth below the alto cornamuse).", "bass-cornamuse description"),
//: trackName for Bass Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Cornamuse", "bass-cornamuse trackName"),
//: longName for Bass Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Cornamuse", "bass-cornamuse longName"),
//: shortName for Bass Cornamuse; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Cm.", "bass-cornamuse shortName"),

//: description for Soprano Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "20th-century instrument similar to the crumhorn and cornamuse, pitched in C.", "soprano-kelhorn description"),
//: trackName for Soprano Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Kelhorn", "soprano-kelhorn trackName"),
//: longName for Soprano Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Kelhorn", "soprano-kelhorn longName"),
//: shortName for Soprano Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Kh.", "soprano-kelhorn shortName"),

//: description for Alto Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "20th-century instrument similar to the crumhorn and cornamuse, pitched in F (a fifth below the soprano kelhorn).", "alto-kelhorn description"),
//: trackName for Alto Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Kelhorn", "alto-kelhorn trackName"),
//: longName for Alto Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Kelhorn", "alto-kelhorn longName"),
//: shortName for Alto Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Kh.", "alto-kelhorn shortName"),

//: description for Tenor Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "20th-century instrument similar to the crumhorn and cornamuse, pitched in C (an octave below the soprano kelhorn).", "tenor-kelhorn description"),
//: trackName for Tenor Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Kelhorn", "tenor-kelhorn trackName"),
//: longName for Tenor Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Kelhorn", "tenor-kelhorn longName"),
//: shortName for Tenor Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Kh.", "tenor-kelhorn shortName"),

//: description for Bass Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "20th-century instrument similar to the crumhorn and cornamuse, pitched in F (an octave below the alto kelhorn).", "bass-kelhorn description"),
//: trackName for Bass Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Kelhorn", "bass-kelhorn trackName"),
//: longName for Bass Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Kelhorn", "bass-kelhorn longName"),
//: shortName for Bass Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Kh.", "bass-kelhorn shortName"),

//: description for Greatbass Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "20th-century instrument similar to the crumhorn and cornamuse, pitched in C (an octave below the tenor kelhorn).", "greatbass-kelhorn description"),
//: trackName for Greatbass Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Greatbass Kelhorn", "greatbass-kelhorn trackName"),
//: longName for Greatbass Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Greatbass Kelhorn", "greatbass-kelhorn longName"),
//: shortName for Greatbass Kelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gb. Kh.", "greatbass-kelhorn shortName"),

//: description for Sopranino Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "16th-century double-reed instrument with a conical bore, pitched in F (a fourth higher than the soprano rauschpfeife).", "sopranino-rauschpfeife description"),
//: trackName for Sopranino Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Rauschpfeife", "sopranino-rauschpfeife trackName"),
//: longName for Sopranino Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Rauschpfeife", "sopranino-rauschpfeife longName"),
//: shortName for Sopranino Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Si. Rpf.", "sopranino-rauschpfeife shortName"),

//: description for Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "16th-century double-reed instrument with a conical bore, pitched in C.", "rauschpfeife description"),
//: trackName for Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rauschpfeife", "rauschpfeife trackName"),
//: longName for Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rauschpfeife", "rauschpfeife longName"),
//: shortName for Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rpf.", "rauschpfeife shortName"),

//: description for Soprano Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "16th-century double-reed instrument with a conical bore, pitched in C.", "soprano-rauschpfeife description"),
//: trackName for Soprano Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Rauschpfeife", "soprano-rauschpfeife trackName"),
//: longName for Soprano Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Rauschpfeife", "soprano-rauschpfeife longName"),
//: shortName for Soprano Rauschpfeife; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Rpf.", "soprano-rauschpfeife shortName"),

//: description for Duduk; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in F.", "f-duduk description"),
//: trackName for Duduk; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "f-duduk trackName"),
//: longName for Duduk; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Duduk", "f-duduk longName"),
//: shortName for Duduk; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Du.", "f-duduk shortName"),
//: traitName for Duduk; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-duduk traitName"),

//: description for Duduk; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in E.", "e-duduk description"),
//: trackName for Duduk; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "e-duduk trackName"),
//: longName for Duduk; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E Duduk", "e-duduk longName"),
//: shortName for Duduk; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E Du.", "e-duduk shortName"),
//: traitName for Duduk; tuning: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E", "e-duduk traitName"),

//: description for Duduk; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in D.", "d-duduk description"),
//: trackName for Duduk; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "d-duduk trackName"),
//: longName for Duduk; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Duduk", "d-duduk longName"),
//: shortName for Duduk; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Du.", "d-duduk shortName"),
//: traitName for Duduk; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-duduk traitName"),

//: description for Duduk; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in C.", "c-duduk description"),
//: trackName for Duduk; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "c-duduk trackName"),
//: longName for Duduk; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Duduk", "c-duduk longName"),
//: shortName for Duduk; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Du.", "c-duduk shortName"),
//: traitName for Duduk; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-duduk traitName"),

//: description for Duduk; tuning: B; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in B.", "b-duduk description"),
//: trackName for Duduk; tuning: B; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "b-duduk trackName"),
//: longName for Duduk; tuning: B; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B Duduk", "b-duduk longName"),
//: shortName for Duduk; tuning: B; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B Du.", "b-duduk shortName"),
//: traitName for Duduk; tuning: B; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B", "b-duduk traitName"),

//: description for Duduk; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in B♭.", "bb-duduk description"),
//: trackName for Duduk; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "bb-duduk trackName"),
//: longName for Duduk; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Duduk", "bb-duduk longName"),
//: shortName for Duduk; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Du.", "bb-duduk shortName"),
//: traitName for Duduk; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-duduk traitName"),

//: description for Duduk; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in A.", "duduk description"),
//: trackName for Duduk; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "duduk trackName"),
//: longName for Duduk; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "duduk longName"),
//: shortName for Duduk; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Du.", "duduk shortName"),

//: description for Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in A.", "a-duduk description"),
//: trackName for Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "a-duduk trackName"),
//: longName for Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A Duduk", "a-duduk longName"),
//: shortName for Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A Du.", "a-duduk shortName"),
//: traitName for Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*A", "a-duduk traitName"),

//: description for Duduk; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in G.", "g-duduk description"),
//: trackName for Duduk; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Duduk", "g-duduk trackName"),
//: longName for Duduk; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Duduk", "g-duduk longName"),
//: shortName for Duduk; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Du.", "g-duduk shortName"),
//: traitName for Duduk; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G", "g-duduk traitName"),

//: description for Bass Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Armenian double-reed instrument made of apricot wood, pitched in A (an octave below the normal duduk in A).", "a-bass-duduk description"),
//: trackName for Bass Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Duduk", "a-bass-duduk trackName"),
//: longName for Bass Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A Bass Duduk", "a-bass-duduk longName"),
//: shortName for Bass Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A B. Du.", "a-bass-duduk shortName"),
//: traitName for Bass Duduk; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*A", "a-bass-duduk traitName"),

//: description for Shenai; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Indian double-reed instrument with a flared bell.", "shenai description"),
//: trackName for Shenai; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shenai", "shenai trackName"),
//: longName for Shenai; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shenai", "shenai longName"),
//: shortName for Shenai; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "She.", "shenai shortName"),

//: description for Piccolo Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino clarinet in A♭.", "piccolo-clarinet description"),
//: trackName for Piccolo Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Clarinet", "piccolo-clarinet trackName"),
//: longName for Piccolo Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Clarinet", "piccolo-clarinet longName"),
//: shortName for Piccolo Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "P. Cl.", "piccolo-clarinet shortName"),

//: description for Soprano Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino clarinet (despite the name) in G.", "soprano-clarinet description"),
//: trackName for Soprano Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Clarinet", "soprano-clarinet trackName"),
//: longName for Soprano Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Clarinet", "soprano-clarinet longName"),
//: shortName for Soprano Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Cl.", "soprano-clarinet shortName"),

//: description for Clarinet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino clarinet in E♭.", "eb-clarinet description"),
//: trackName for Clarinet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "eb-clarinet trackName"),
//: longName for Clarinet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "eb-clarinet longName"),
//: shortName for Clarinet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cl.", "eb-clarinet shortName"),
//: traitName for Clarinet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "eb-clarinet traitName"),

//: description for Clarinet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino clarinet in D.", "d-clarinet description"),
//: trackName for Clarinet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "d-clarinet trackName"),
//: longName for Clarinet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "d-clarinet longName"),
//: shortName for Clarinet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cl.", "d-clarinet shortName"),
//: traitName for Clarinet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-clarinet traitName"),

//: description for Clarinet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano clarinet in C.", "c-clarinet description"),
//: trackName for Clarinet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "c-clarinet trackName"),
//: longName for Clarinet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "c-clarinet longName"),
//: shortName for Clarinet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cl.", "c-clarinet shortName"),
//: traitName for Clarinet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-clarinet traitName"),

//: description for Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano clarinet in B♭. One of the standard orchestral clarinets.", "bb-clarinet description"),
//: trackName for Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "bb-clarinet trackName"),
//: longName for Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "bb-clarinet longName"),
//: shortName for Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cl.", "bb-clarinet shortName"),
//: traitName for Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*B♭", "bb-clarinet traitName"),

//: description for Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano clarinet in B♭. One of the standard orchestral clarinets.", "clarinet description"),
//: trackName for Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "clarinet trackName"),
//: longName for Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "clarinet longName"),
//: shortName for Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cl.", "clarinet shortName"),

//: description for Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano clarinet in A. One of the standard orchestral clarinets.", "a-clarinet description"),
//: trackName for Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "a-clarinet trackName"),
//: longName for Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "a-clarinet longName"),
//: shortName for Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cl.", "a-clarinet shortName"),
//: traitName for Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "a-clarinet traitName"),

//: description for Clarinet; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano clarinet in G.", "g-clarinet description"),
//: trackName for Clarinet; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "g-clarinet trackName"),
//: longName for Clarinet; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clarinet", "g-clarinet longName"),
//: shortName for Clarinet; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cl.", "g-clarinet shortName"),
//: traitName for Clarinet; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G", "g-clarinet traitName"),

//: description for Basset Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Similar to the standard soprano clarinet, but with an extension to the lower range.", "basset-clarinet description"),
//: trackName for Basset Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Basset Clarinet", "basset-clarinet trackName"),
//: longName for Basset Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Basset Clarinet", "basset-clarinet longName"),
//: shortName for Basset Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ba. Cl.", "basset-clarinet shortName"),

//: description for Alto Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto clarinet in E♭.", "alto-clarinet description"),
//: trackName for Alto Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Clarinet", "alto-clarinet trackName"),
//: longName for Alto Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Clarinet", "alto-clarinet longName"),
//: shortName for Alto Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Cl.", "alto-clarinet shortName"),

//: description for Basset Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Member of the clarinet family with a larger bore and extended lower range.", "basset-horn description"),
//: trackName for Basset Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Basset Horn", "basset-horn trackName"),
//: longName for Basset Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Basset Horn", "basset-horn longName"),
//: shortName for Basset Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ba. Hn.", "basset-horn shortName"),

//: description for Bass Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass clarinet in B♭. An octave lower than the B♭ soprano clarinet.", "bass-clarinet description"),
//: trackName for Bass Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet", "bass-clarinet trackName"),
//: longName for Bass Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet", "bass-clarinet longName"),
//: shortName for Bass Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Cl.", "bass-clarinet shortName"),

//: description for Bass Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass clarinet in B♭. An octave lower than the B♭ soprano clarinet. Notated in the treble clef (‘French notation’).", "bb-bass-clarinet description"),
//: trackName for Bass Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet", "bb-bass-clarinet trackName"),
//: longName for Bass Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet", "bb-bass-clarinet longName"),
//: shortName for Bass Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Cl.", "bb-bass-clarinet shortName"),
//: traitName for Bass Clarinet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*(B♭)", "bb-bass-clarinet traitName"),

//: description for Bass Clarinet (bass clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass clarinet in B♭. An octave lower than the B♭ soprano clarinet. Notated in the bass clef (‘German notation’).", "bb-bass-clarinet-bass-clef description"),
//: trackName for Bass Clarinet (bass clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet (bass clef)", "bb-bass-clarinet-bass-clef trackName"),
//: longName for Bass Clarinet (bass clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet", "bb-bass-clarinet-bass-clef longName"),
//: shortName for Bass Clarinet (bass clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Cl.", "bb-bass-clarinet-bass-clef shortName"),
//: traitName for Bass Clarinet (bass clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*(B♭)", "bb-bass-clarinet-bass-clef traitName"),

//: description for Bass Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass clarinet in A. Extremely rare and almost never used today. Notated in the treble clef (‘French notation’).", "a-bass-clarinet description"),
//: trackName for Bass Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet", "a-bass-clarinet trackName"),
//: longName for Bass Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet", "a-bass-clarinet longName"),
//: shortName for Bass Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Cl.", "a-bass-clarinet shortName"),
//: traitName for Bass Clarinet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "a-bass-clarinet traitName"),

//: description for Bass Clarinet (bass clef); transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass clarinet in A. Extremely rare and almost never used today. Notated in the bass clef (‘German notation’).", "a-bass-clarinet-bass-clef) description"),
//: trackName for Bass Clarinet (bass clef); transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet (bass clef)", "a-bass-clarinet-bass-clef) trackName"),
//: longName for Bass Clarinet (bass clef); transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Clarinet", "a-bass-clarinet-bass-clef) longName"),
//: shortName for Bass Clarinet (bass clef); transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Cl.", "a-bass-clarinet-bass-clef) shortName"),
//: traitName for Bass Clarinet (bass clef); transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "a-bass-clarinet-bass-clef) traitName"),

//: description for Contra-alto Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contra-alto clarinet in E♭. An octave lower than the E♭ alto clarinet.", "contra-alto-clarinet description"),
//: trackName for Contra-alto Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contra-alto Clarinet", "contra-alto-clarinet trackName"),
//: longName for Contra-alto Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contra-alto Clarinet", "contra-alto-clarinet longName"),
//: shortName for Contra-alto Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C-a. Cl.", "contra-alto-clarinet shortName"),

//: description for Contrabass Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass clarinet in B♭. An octave lower than the B♭ bass clarinet.", "contrabass-clarinet description"),
//: trackName for Contrabass Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Clarinet", "contrabass-clarinet trackName"),
//: longName for Contrabass Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Clarinet", "contrabass-clarinet longName"),
//: shortName for Contrabass Clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Cl.", "contrabass-clarinet shortName"),

//: description for Sopranino Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Predecessor of the modern-day clarinet, pitched in F (an octave above the alto chalumeau).", "sopranino-chalumeau description"),
//: trackName for Sopranino Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Chalumeau", "sopranino-chalumeau trackName"),
//: longName for Sopranino Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Chalumeau", "sopranino-chalumeau longName"),
//: shortName for Sopranino Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Si. Cha.", "sopranino-chalumeau shortName"),

//: description for Soprano Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Predecessor of the modern-day clarinet, pitched in C (an octave above the tenor chalumeau).", "soprano-chalumeau description"),
//: trackName for Soprano Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Chalumeau", "soprano-chalumeau trackName"),
//: longName for Soprano Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Chalumeau", "soprano-chalumeau longName"),
//: shortName for Soprano Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Cha.", "soprano-chalumeau shortName"),

//: description for Alto Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Predecessor of the modern-day clarinet, pitched in F (a fourth above the tenor chalumeau).", "alto-chalumeau description"),
//: trackName for Alto Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Chalumeau", "alto-chalumeau trackName"),
//: longName for Alto Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Chalumeau", "alto-chalumeau longName"),
//: shortName for Alto Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Cha.", "alto-chalumeau shortName"),

//: description for Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Predecessor of the modern-day clarinet, pitched in C.", "chalumeau description"),
//: trackName for Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chalumeau", "chalumeau trackName"),
//: longName for Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chalumeau", "chalumeau longName"),
//: shortName for Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cha.", "chalumeau shortName"),

//: description for Tenor Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Predecessor of the modern-day clarinet, pitched in C (an octave below the soprano chalumeau).", "tenor-chalumeau description"),
//: trackName for Tenor Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Chalumeau", "tenor-chalumeau trackName"),
//: longName for Tenor Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Chalumeau", "tenor-chalumeau longName"),
//: shortName for Tenor Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Cha.", "tenor-chalumeau shortName"),

//: description for Bass Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Predecessor of the modern-day clarinet, pitched in F (an fifth below the tenor chalumeau).", "bass-chalumeau description"),
//: trackName for Bass Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Chalumeau", "bass-chalumeau trackName"),
//: longName for Bass Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Chalumeau", "bass-chalumeau longName"),
//: shortName for Bass Chalumeau; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Cha.", "bass-chalumeau shortName"),

//: description for Pocket Sax; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Keyless single-reed instrument with a cylindrical bore and slightly flared bell, in D.", "d-xaphoon description"),
//: trackName for Pocket Sax; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Sax", "d-xaphoon trackName"),
//: longName for Pocket Sax; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Sax", "d-xaphoon longName"),
//: shortName for Pocket Sax; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pkt. Sax", "d-xaphoon shortName"),
//: traitName for Pocket Sax; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-xaphoon traitName"),

//: description for Pocket Sax; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Keyless single-reed instrument with a cylindrical bore and slightly flared bell, in C.", "xaphoon description"),
//: trackName for Pocket Sax; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Sax", "xaphoon trackName"),
//: longName for Pocket Sax; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Sax", "xaphoon longName"),
//: shortName for Pocket Sax; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pkt. Sax", "xaphoon shortName"),
//: traitName for Pocket Sax; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "xaphoon traitName"),

//: description for Pocket Sax; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Keyless single-reed instrument with a cylindrical bore and slightly flared bell, in B♭.", "bb-xaphoon description"),
//: trackName for Pocket Sax; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Sax", "bb-xaphoon trackName"),
//: longName for Pocket Sax; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Sax", "bb-xaphoon longName"),
//: shortName for Pocket Sax; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pkt. Sax", "bb-xaphoon shortName"),
//: traitName for Pocket Sax; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-xaphoon traitName"),

//: description for Pocket Sax; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Keyless single-reed instrument with a cylindrical bore and slightly flared bell, in G.", "g-xaphoon description"),
//: trackName for Pocket Sax; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Sax", "g-xaphoon trackName"),
//: longName for Pocket Sax; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Sax", "g-xaphoon longName"),
//: shortName for Pocket Sax; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pkt. Sax", "g-xaphoon shortName"),
//: traitName for Pocket Sax; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G", "g-xaphoon traitName"),

//: description for Tarogato; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single-reed, conical bore instrument used in Hungarian and Romanian folk music.", "tarogato description"),
//: trackName for Tarogato; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tarogato", "tarogato trackName"),
//: longName for Tarogato; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tarogato", "tarogato longName"),
//: shortName for Tarogato; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tar.", "tarogato shortName"),

//: description for Octavin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Very rare single-reed, conical bore woodwind instrument.", "octavin description"),
//: trackName for Octavin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Octavin", "octavin trackName"),
//: longName for Octavin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Octavin", "octavin longName"),
//: shortName for Octavin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oct.", "octavin shortName"),

//: description for Sopranissimo Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in B♭ (an octave above the soprano).", "sopranissimo-saxophone description"),
//: trackName for Sopranissimo Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranissimo Saxophone", "sopranissimo-saxophone trackName"),
//: longName for Sopranissimo Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranissimo Saxophone", "sopranissimo-saxophone longName"),
//: shortName for Sopranissimo Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sio. Sax.", "sopranissimo-saxophone shortName"),

//: description for Sopranino Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in E♭ (an octave above the alto).", "sopranino-saxophone description"),
//: trackName for Sopranino Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Saxophone", "sopranino-saxophone trackName"),
//: longName for Sopranino Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Saxophone", "sopranino-saxophone longName"),
//: shortName for Sopranino Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Si. Sax.", "sopranino-saxophone shortName"),

//: description for Aulochrome; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Consists of two soprano saxophones joined together, played either separately or simultaneously.", "aulochrome description"),
//: trackName for Aulochrome; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Aulochrome", "aulochrome trackName"),
//: longName for Aulochrome; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Aulochrome", "aulochrome longName"),
//: shortName for Aulochrome; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Aul.", "aulochrome shortName"),

//: description for Soprano Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in B♭ (an octave above the tenor).", "soprano-saxophone description"),
//: trackName for Soprano Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Saxophone", "soprano-saxophone trackName"),
//: longName for Soprano Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Saxophone", "soprano-saxophone longName"),
//: shortName for Soprano Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Sax.", "soprano-saxophone shortName"),

//: description for Mezzo-Soprano Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in F (a tone above the alto).", "mezzo-soprano-saxophone description"),
//: trackName for Mezzo-Soprano Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mezzo-Soprano Saxophone", "mezzo-soprano-saxophone trackName"),
//: longName for Mezzo-Soprano Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mezzo-Soprano Saxophone", "mezzo-soprano-saxophone longName"),
//: shortName for Mezzo-Soprano Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "M.S. Sax.", "mezzo-soprano-saxophone shortName"),

//: description for Heckelphone-clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rare wooden instrument with a wide conical bore, akin to a saxophone.", "heckelphone-clarinet description"),
//: trackName for Heckelphone-clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Heckelphone-clarinet", "heckelphone-clarinet trackName"),
//: longName for Heckelphone-clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Heckelphone-clarinet", "heckelphone-clarinet longName"),
//: shortName for Heckelphone-clarinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hph.-cl.", "heckelphone-clarinet shortName"),

//: description for Alto Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in E♭ (an octave above the baritone).", "alto-saxophone description"),
//: trackName for Alto Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Saxophone", "alto-saxophone trackName"),
//: longName for Alto Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Saxophone", "alto-saxophone longName"),
//: shortName for Alto Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Sax.", "alto-saxophone shortName"),

//: description for Melody Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in C (a tone above the tenor).", "melody-saxophone description"),
//: trackName for Melody Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Melody Saxophone", "melody-saxophone trackName"),
//: longName for Melody Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Melody Saxophone", "melody-saxophone longName"),
//: shortName for Melody Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mel. Sax.", "melody-saxophone shortName"),

//: description for Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in B♭ (an octave below the soprano).", "saxophone description"),
//: trackName for Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone", "saxophone trackName"),
//: longName for Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone", "saxophone longName"),
//: shortName for Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sax.", "saxophone shortName"),

//: description for Tenor Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in B♭ (an octave below the soprano).", "tenor-saxophone description"),
//: trackName for Tenor Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Saxophone", "tenor-saxophone trackName"),
//: longName for Tenor Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Saxophone", "tenor-saxophone longName"),
//: shortName for Tenor Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Sax.", "tenor-saxophone shortName"),

//: description for Baritone Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in E♭ (an octave below the alto).", "baritone-saxophone description"),
//: trackName for Baritone Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Saxophone", "baritone-saxophone trackName"),
//: longName for Baritone Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Saxophone", "baritone-saxophone longName"),
//: shortName for Baritone Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Sax.", "baritone-saxophone shortName"),

//: description for Bass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in B♭ (an octave below the tenor).", "bass-saxophone description"),
//: trackName for Bass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Saxophone", "bass-saxophone trackName"),
//: longName for Bass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Saxophone", "bass-saxophone longName"),
//: shortName for Bass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Sax.", "bass-saxophone shortName"),

//: description for Contrabass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in E♭ (an octave below the baritone).", "contrabass-saxophone description"),
//: trackName for Contrabass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Saxophone", "contrabass-saxophone trackName"),
//: longName for Contrabass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Saxophone", "contrabass-saxophone longName"),
//: shortName for Contrabass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Sax.", "contrabass-saxophone shortName"),

//: description for Subcontrabass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxophone in B♭ (an octave below the bass).", "subcontrabass-saxophone description"),
//: trackName for Subcontrabass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Subcontrabass Saxophone", "subcontrabass-saxophone trackName"),
//: longName for Subcontrabass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Subcontrabass Saxophone", "subcontrabass-saxophone longName"),
//: shortName for Subcontrabass Saxophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Scb. Sax.", "subcontrabass-saxophone shortName"),

//: description for Bassoon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Standard concert bassoon.", "bassoon description"),
//: trackName for Bassoon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bassoon", "bassoon trackName"),
//: longName for Bassoon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bassoon", "bassoon longName"),
//: shortName for Bassoon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bsn.", "bassoon shortName"),

//: description for Contrabassoon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Larger version of the bassoon, sounding an octave lower.", "contrabassoon description"),
//: trackName for Contrabassoon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabassoon", "contrabassoon trackName"),
//: longName for Contrabassoon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabassoon", "contrabassoon longName"),
//: shortName for Contrabassoon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cbsn.", "contrabassoon shortName"),

//: description for Reed Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Double-reed instrument with an unusually wide conical bore, normally made of metal.", "reed-contrabass description"),
//: trackName for Reed Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Reed Contrabass", "reed-contrabass trackName"),
//: longName for Reed Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Reed Contrabass", "reed-contrabass longName"),
//: shortName for Reed Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rd. Cbs.", "reed-contrabass shortName"),

//: description for Dulcian; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument with a folded conical bore.", "dulcian description"),
//: trackName for Dulcian; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dulcian", "dulcian trackName"),
//: longName for Dulcian; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dulcian", "dulcian longName"),
//: shortName for Dulcian; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Du.", "dulcian shortName"),

//: description for Rackett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance double-reed instrument; a predecessor of the bassoon.", "rackett description"),
//: trackName for Rackett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rackett", "rackett trackName"),
//: longName for Rackett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rackett", "rackett longName"),
//: shortName for Rackett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ra.", "rackett shortName"),

//: description for Sopranino Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single- or double-reed metal instrument with a conical bore, in B♭ (an octave above the soprano).", "sopranino-sarrusophone description"),
//: trackName for Sopranino Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Sarrusophone", "sopranino-sarrusophone trackName"),
//: longName for Sopranino Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sopranino Sarrusophone", "sopranino-sarrusophone longName"),
//: shortName for Sopranino Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Si. Sar.", "sopranino-sarrusophone shortName"),

//: description for Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single- or double-reed metal instrument with a conical bore, in B♭.", "sarrusophone description"),
//: trackName for Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sarrusophone", "sarrusophone trackName"),
//: longName for Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sarrusophone", "sarrusophone longName"),
//: shortName for Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sar.", "sarrusophone shortName"),

//: description for Soprano Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single- or double-reed metal instrument with a conical bore, in B♭.", "soprano-sarrusophone description"),
//: trackName for Soprano Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Sarrusophone", "soprano-sarrusophone trackName"),
//: longName for Soprano Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Sarrusophone", "soprano-sarrusophone longName"),
//: shortName for Soprano Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Sar.", "soprano-sarrusophone shortName"),

//: description for Alto Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single- or double-reed metal instrument with a conical bore, in E♭.", "alto-sarrusophone description"),
//: trackName for Alto Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Sarrusophone", "alto-sarrusophone trackName"),
//: longName for Alto Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Sarrusophone", "alto-sarrusophone longName"),
//: shortName for Alto Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Sar.", "alto-sarrusophone shortName"),

//: description for Tenor Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single- or double-reed metal instrument with a conical bore, in B♭ (an octave below the soprano).", "tenor-sarrusophone description"),
//: trackName for Tenor Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Sarrusophone", "tenor-sarrusophone trackName"),
//: longName for Tenor Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Sarrusophone", "tenor-sarrusophone longName"),
//: shortName for Tenor Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Sar.", "tenor-sarrusophone shortName"),

//: description for Baritone Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single- or double-reed metal instrument with a conical bore, in E♭ (an octave below the alto).", "baritone-sarrusophone description"),
//: trackName for Baritone Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Sarrusophone", "baritone-sarrusophone trackName"),
//: longName for Baritone Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Sarrusophone", "baritone-sarrusophone longName"),
//: shortName for Baritone Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Sar.", "baritone-sarrusophone shortName"),

//: description for Bass Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single- or double-reed metal instrument with a conical bore, in B♭ (an octave below the tenor).", "bass-sarrusophone description"),
//: trackName for Bass Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Sarrusophone", "bass-sarrusophone trackName"),
//: longName for Bass Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Sarrusophone", "bass-sarrusophone longName"),
//: shortName for Bass Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Sar.", "bass-sarrusophone shortName"),

//: description for Contrabass Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Single- or double-reed metal instrument with a conical bore, in E♭ (an octave below the baritone).", "contrabass-sarrusophone description"),
//: trackName for Contrabass Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Sarrusophone", "contrabass-sarrusophone trackName"),
//: longName for Contrabass Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Sarrusophone", "contrabass-sarrusophone longName"),
//: shortName for Contrabass Sarrusophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Sar.", "contrabass-sarrusophone shortName"),

//: description for Bagpipe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bagpipe.", "bagpipe description"),
//: trackName for Bagpipe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bagpipe", "bagpipe trackName"),
//: longName for Bagpipe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bagpipe", "bagpipe longName"),
//: shortName for Bagpipe; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bagp.", "bagpipe shortName"),

// Free Reed
QT_TRANSLATE_NOOP("engraving/instruments/group", "Free Reed"),

//: description for Accordion; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bellows-driven free-reed instrument with a keyboard or buttons on one end, and buttons on the other.", "accordion description"),
//: trackName for Accordion; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Accordion", "accordion trackName"),
//: longName for Accordion; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Accordion", "accordion longName"),
//: shortName for Accordion; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acc.", "accordion shortName"),

//: description for Bandoneon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Type of concertina particularly popular in Argentina and Uruguay.", "bandoneon description"),
//: trackName for Bandoneon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bandoneon", "bandoneon trackName"),
//: longName for Bandoneon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bandoneon", "bandoneon longName"),
//: shortName for Bandoneon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ban.", "bandoneon shortName"),

//: description for Concertina; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bellows-driven free-reed instrument with buttons usually on both ends.", "concertina description"),
//: trackName for Concertina; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Concertina", "concertina trackName"),
//: longName for Concertina; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Concertina", "concertina longName"),
//: shortName for Concertina; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Conc.", "concertina shortName"),

//: description for Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-hole diatonic harmonica pitched in C.", "harmonica description"),
//: trackName for Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harmonica", "harmonica trackName"),
//: longName for Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harmonica", "harmonica longName"),
//: shortName for Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica shortName"),

//: description for 10-Hole Diatonic Harmonica; tuning: High G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-hole diatonic harmonica pitched in high G.", "harmonica-d10high-g description"),
//: trackName for 10-Hole Diatonic Harmonica; tuning: High G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole Diatonic Harmonica", "harmonica-d10high-g trackName"),
//: longName for 10-Hole Diatonic Harmonica; tuning: High G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole High G Diatonic Harmonica", "harmonica-d10high-g longName"),
//: shortName for 10-Hole Diatonic Harmonica; tuning: High G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-d10high-g shortName"),
//: traitName for 10-Hole Diatonic Harmonica; tuning: High G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "High G", "harmonica-d10high-g traitName"),

//: description for 10-Hole Diatonic Harmonica; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-hole diatonic harmonica pitched in F.", "harmonica-d10f description"),
//: trackName for 10-Hole Diatonic Harmonica; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole Diatonic Harmonica", "harmonica-d10f trackName"),
//: longName for 10-Hole Diatonic Harmonica; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole F Diatonic Harmonica", "harmonica-d10f longName"),
//: shortName for 10-Hole Diatonic Harmonica; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-d10f shortName"),
//: traitName for 10-Hole Diatonic Harmonica; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "harmonica-d10f traitName"),

//: description for 10-Hole Diatonic Harmonica; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-hole diatonic harmonica pitched in D.", "harmonica-d10d description"),
//: trackName for 10-Hole Diatonic Harmonica; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole Diatonic Harmonica", "harmonica-d10d trackName"),
//: longName for 10-Hole Diatonic Harmonica; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole D Diatonic Harmonica", "harmonica-d10d longName"),
//: shortName for 10-Hole Diatonic Harmonica; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-d10d shortName"),
//: traitName for 10-Hole Diatonic Harmonica; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "harmonica-d10d traitName"),

//: description for 10-Hole Diatonic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-hole diatonic harmonica pitched in C.", "harmonica-d10c description"),
//: trackName for 10-Hole Diatonic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole Diatonic Harmonica", "harmonica-d10c trackName"),
//: longName for 10-Hole Diatonic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole C Diatonic Harmonica", "harmonica-d10c longName"),
//: shortName for 10-Hole Diatonic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-d10c shortName"),
//: traitName for 10-Hole Diatonic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "harmonica-d10c traitName"),

//: description for 10-Hole Diatonic Harmonica; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-hole diatonic harmonica pitched in A.", "harmonica-d10a description"),
//: trackName for 10-Hole Diatonic Harmonica; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole Diatonic Harmonica", "harmonica-d10a trackName"),
//: longName for 10-Hole Diatonic Harmonica; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole A Diatonic Harmonica", "harmonica-d10a longName"),
//: shortName for 10-Hole Diatonic Harmonica; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-d10a shortName"),
//: traitName for 10-Hole Diatonic Harmonica; tuning: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "harmonica-d10a traitName"),

//: description for 10-Hole Diatonic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-hole diatonic harmonica pitched in G.", "harmonica-d10g description"),
//: trackName for 10-Hole Diatonic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole Diatonic Harmonica", "harmonica-d10g trackName"),
//: longName for 10-Hole Diatonic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole G Diatonic Harmonica", "harmonica-d10g longName"),
//: shortName for 10-Hole Diatonic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-d10g shortName"),
//: traitName for 10-Hole Diatonic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G", "harmonica-d10g traitName"),

//: description for 10-Hole Diatonic Harmonica; tuning: Low D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-hole diatonic harmonica pitched in low D.", "harmonica-d10low-d description"),
//: trackName for 10-Hole Diatonic Harmonica; tuning: Low D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole Diatonic Harmonica", "harmonica-d10low-d trackName"),
//: longName for 10-Hole Diatonic Harmonica; tuning: Low D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-Hole Low D Diatonic Harmonica", "harmonica-d10low-d longName"),
//: shortName for 10-Hole Diatonic Harmonica; tuning: Low D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-d10low-d shortName"),
//: traitName for 10-Hole Diatonic Harmonica; tuning: Low D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Low D", "harmonica-d10low-d traitName"),

//: description for 12-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-hole chromatic harmonica pitched in C.", "harmonica-c12c description"),
//: trackName for 12-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-Hole Chromatic Harmonica", "harmonica-c12c trackName"),
//: longName for 12-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-Hole C Chromatic Harmonica", "harmonica-c12c longName"),
//: shortName for 12-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-c12c shortName"),
//: traitName for 12-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "harmonica-c12c traitName"),

//: description for 12-Hole Chromatic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-hole chromatic harmonica pitched in G.", "harmonica-c12g description"),
//: trackName for 12-Hole Chromatic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-Hole Chromatic Harmonica", "harmonica-c12g trackName"),
//: longName for 12-Hole Chromatic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-Hole G Chromatic Harmonica", "harmonica-c12g longName"),
//: shortName for 12-Hole Chromatic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-c12g shortName"),
//: traitName for 12-Hole Chromatic Harmonica; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G", "harmonica-c12g traitName"),

//: description for 12-Hole Chromatic Harmonica; tuning: Tenor C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-hole chromatic tenor harmonica pitched in C.", "harmonica-c12tenor-c description"),
//: trackName for 12-Hole Chromatic Harmonica; tuning: Tenor C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-Hole Chromatic Harmonica", "harmonica-c12tenor-c trackName"),
//: longName for 12-Hole Chromatic Harmonica; tuning: Tenor C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-Hole Tenor C Chromatic Harmonica", "harmonica-c12tenor-c longName"),
//: shortName for 12-Hole Chromatic Harmonica; tuning: Tenor C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-c12tenor-c shortName"),
//: traitName for 12-Hole Chromatic Harmonica; tuning: Tenor C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor C", "harmonica-c12tenor-c traitName"),

//: description for 14-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "14-hole chromatic harmonica pitched in C.", "harmonica-c14c description"),
//: trackName for 14-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "14-Hole Chromatic Harmonica", "harmonica-c14c trackName"),
//: longName for 14-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "14-Hole C Chromatic Harmonica", "harmonica-c14c longName"),
//: shortName for 14-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-c14c shortName"),
//: traitName for 14-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "harmonica-c14c traitName"),

//: description for 16-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "16-hole chromatic harmonica pitched in C.", "harmonica-c16c description"),
//: trackName for 16-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "16-Hole Chromatic Harmonica", "harmonica-c16c trackName"),
//: longName for 16-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "16-Hole C Chromatic Harmonica", "harmonica-c16c longName"),
//: shortName for 16-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-c16c shortName"),
//: traitName for 16-Hole Chromatic Harmonica; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "harmonica-c16c traitName"),

//: description for 20-Hole Chordet Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Huang Chordet 20-hole double harmonica.", "harmonica-chordet description"),
//: trackName for 20-Hole Chordet Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "20-Hole Chordet Harmonica", "harmonica-chordet trackName"),
//: longName for 20-Hole Chordet Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "20-Hole Chordet Harmonica", "harmonica-chordet longName"),
//: shortName for 20-Hole Chordet Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonica-chordet shortName"),

//: description for Bass Hohner Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hohner 31-hole bass harmonica.", "bass-harmonica-hohner description"),
//: trackName for Bass Hohner Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Hohner Harmonica", "bass-harmonica-hohner trackName"),
//: longName for Bass Hohner Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Hohner Harmonica", "bass-harmonica-hohner longName"),
//: shortName for Bass Hohner Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bs. Harm.", "bass-harmonica-hohner shortName"),

//: description for Bass Huang Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Huang 30-hole bass harmonica.", "bass-harmonica-huang description"),
//: trackName for Bass Huang Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Huang Harmonica", "bass-harmonica-huang trackName"),
//: longName for Bass Huang Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Huang Harmonica", "bass-harmonica-huang longName"),
//: shortName for Bass Huang Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bs. Harm.", "bass-harmonica-huang shortName"),

//: description for Bass Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass harmonica (non-specific model).", "bass-harmonica description"),
//: trackName for Bass Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Harmonica", "bass-harmonica trackName"),
//: longName for Bass Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Harmonica", "bass-harmonica longName"),
//: shortName for Bass Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bs. Harm.", "bass-harmonica shortName"),

//: description for Melodica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mouth-blown free reed instrument with a keyboard.", "melodica description"),
//: trackName for Melodica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Melodica", "melodica trackName"),
//: longName for Melodica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Melodica", "melodica longName"),
//: shortName for Melodica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mel.", "melodica shortName"),

//: description for Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese mouth-blown free reed instrument.", "sheng description"),
//: trackName for Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sheng", "sheng trackName"),
//: longName for Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sheng", "sheng longName"),
//: shortName for Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "She.", "sheng shortName"),

//: description for Soprano Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese mouth-blown free reed instrument.", "soprano-sheng description"),
//: trackName for Soprano Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Sheng", "soprano-sheng trackName"),
//: longName for Soprano Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Sheng", "soprano-sheng longName"),
//: shortName for Soprano Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. She.", "soprano-sheng shortName"),

//: description for Alto Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese mouth-blown free reed instrument.", "alto-sheng description"),
//: trackName for Alto Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Sheng", "alto-sheng trackName"),
//: longName for Alto Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Sheng", "alto-sheng longName"),
//: shortName for Alto Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. She.", "alto-sheng shortName"),

//: description for Tenor Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese mouth-blown free reed instrument.", "tenor-sheng description"),
//: trackName for Tenor Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Sheng", "tenor-sheng trackName"),
//: longName for Tenor Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Sheng", "tenor-sheng longName"),
//: shortName for Tenor Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. She.", "tenor-sheng shortName"),

//: description for Bass Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese mouth-blown free reed instrument.", "bass-sheng description"),
//: trackName for Bass Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Sheng", "bass-sheng trackName"),
//: longName for Bass Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Sheng", "bass-sheng longName"),
//: shortName for Bass Sheng; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. She.", "bass-sheng shortName"),

// Brass
QT_TRANSLATE_NOOP("engraving/instruments/group", "Brass"),

//: description for Brass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brass section notated on a grand staff.", "brass description"),
//: trackName for Brass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brass", "brass trackName"),
//: longName for Brass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brass", "brass longName"),
//: shortName for Brass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Br.", "brass shortName"),

//: description for Horn; transposition: C alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in high C.", "c-horn-alto description"),
//: trackName for Horn; transposition: C alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "c-horn-alto trackName"),
//: longName for Horn; transposition: C alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "c-horn-alto longName"),
//: shortName for Horn; transposition: C alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "c-horn-alto shortName"),
//: traitName for Horn; transposition: C alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C alto", "c-horn-alto traitName"),
//: channel for Horn; transposition: C alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "c-horn-alto channel"),
//: channel for Horn; transposition: C alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "c-horn-alto channel"),

//: description for Horn; transposition: B♭ alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in high B♭.", "bb-horn-alto description"),
//: trackName for Horn; transposition: B♭ alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "bb-horn-alto trackName"),
//: longName for Horn; transposition: B♭ alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "bb-horn-alto longName"),
//: shortName for Horn; transposition: B♭ alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "bb-horn-alto shortName"),
//: traitName for Horn; transposition: B♭ alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ alto", "bb-horn-alto traitName"),
//: channel for Horn; transposition: B♭ alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bb-horn-alto channel"),
//: channel for Horn; transposition: B♭ alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bb-horn-alto channel"),

//: description for Horn; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in A.", "a-horn description"),
//: trackName for Horn; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "a-horn trackName"),
//: longName for Horn; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "a-horn longName"),
//: shortName for Horn; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "a-horn shortName"),
//: traitName for Horn; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "a-horn traitName"),
//: channel for Horn; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "a-horn channel"),
//: channel for Horn; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "a-horn channel"),

//: description for Horn; transposition: A♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in A♭.", "ab-horn description"),
//: trackName for Horn; transposition: A♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "ab-horn trackName"),
//: longName for Horn; transposition: A♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "ab-horn longName"),
//: shortName for Horn; transposition: A♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "ab-horn shortName"),
//: traitName for Horn; transposition: A♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A♭", "ab-horn traitName"),
//: channel for Horn; transposition: A♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "ab-horn channel"),
//: channel for Horn; transposition: A♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "ab-horn channel"),

//: description for Horn; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in G.", "g-horn description"),
//: trackName for Horn; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "g-horn trackName"),
//: longName for Horn; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "g-horn longName"),
//: shortName for Horn; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "g-horn shortName"),
//: traitName for Horn; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G", "g-horn traitName"),
//: channel for Horn; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "g-horn channel"),
//: channel for Horn; transposition: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "g-horn channel"),

//: description for Horn; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in E.", "e-horn description"),
//: trackName for Horn; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "e-horn trackName"),
//: longName for Horn; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "e-horn longName"),
//: shortName for Horn; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "e-horn shortName"),
//: traitName for Horn; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E", "e-horn traitName"),
//: channel for Horn; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "e-horn channel"),
//: channel for Horn; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "e-horn channel"),

//: description for Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in E♭.", "eb-horn description"),
//: trackName for Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "eb-horn trackName"),
//: longName for Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "eb-horn longName"),
//: shortName for Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "eb-horn shortName"),
//: traitName for Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "eb-horn traitName"),
//: channel for Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "eb-horn channel"),
//: channel for Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "eb-horn channel"),

//: description for Horn; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in D.", "d-horn description"),
//: trackName for Horn; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "d-horn trackName"),
//: longName for Horn; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "d-horn longName"),
//: shortName for Horn; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "d-horn shortName"),
//: traitName for Horn; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-horn traitName"),
//: channel for Horn; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "d-horn channel"),
//: channel for Horn; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "d-horn channel"),

//: description for Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in F. The most common modern orchestral horn.", "horn description"),
//: trackName for Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "horn trackName"),
//: longName for Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "horn longName"),
//: shortName for Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "horn shortName"),
//: traitName for Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*F", "horn traitName"),
//: channel for Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "horn channel"),
//: channel for Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "horn channel"),

//: description for Horn; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in low C.", "c-horn description"),
//: trackName for Horn; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "c-horn trackName"),
//: longName for Horn; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "c-horn longName"),
//: shortName for Horn; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "c-horn shortName"),
//: traitName for Horn; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-horn traitName"),
//: channel for Horn; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "c-horn channel"),
//: channel for Horn; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "c-horn channel"),

//: description for Horn (bass clef); transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in low C (notated in bass clef).", "c-horn-bass description"),
//: trackName for Horn (bass clef); transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn (bass clef)", "c-horn-bass trackName"),
//: longName for Horn (bass clef); transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "c-horn-bass longName"),
//: shortName for Horn (bass clef); transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "c-horn-bass shortName"),
//: traitName for Horn (bass clef); transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-horn-bass traitName"),
//: channel for Horn (bass clef); transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "c-horn-bass channel"),
//: channel for Horn (bass clef); transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "c-horn-bass channel"),

//: description for Horn; transposition: B♭ basso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn in low B♭.", "bb-horn-basso description"),
//: trackName for Horn; transposition: B♭ basso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "bb-horn-basso trackName"),
//: longName for Horn; transposition: B♭ basso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn", "bb-horn-basso longName"),
//: shortName for Horn; transposition: B♭ basso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hn.", "bb-horn-basso shortName"),
//: traitName for Horn; transposition: B♭ basso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ basso", "bb-horn-basso traitName"),
//: channel for Horn; transposition: B♭ basso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bb-horn-basso channel"),
//: channel for Horn; transposition: B♭ basso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bb-horn-basso channel"),

//: description for Vienna Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horn used primarily in Vienna for classical orchestral music.", "vienna-horn description"),
//: trackName for Vienna Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vienna Horn", "vienna-horn trackName"),
//: longName for Vienna Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vienna Horn", "vienna-horn longName"),
//: shortName for Vienna Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "V. Hn.", "vienna-horn shortName"),
//: channel for Vienna Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "vienna-horn channel"),
//: channel for Vienna Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "vienna-horn channel"),

//: description for Wagner Tuba; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner tuba in B♭.", "bb-wagner-tuba description"),
//: trackName for Wagner Tuba; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner Tuba", "bb-wagner-tuba trackName"),
//: longName for Wagner Tuba; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner Tuba", "bb-wagner-tuba longName"),
//: shortName for Wagner Tuba; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wag. Tb.", "bb-wagner-tuba shortName"),
//: traitName for Wagner Tuba; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-wagner-tuba traitName"),

//: description for Wagner Tuba; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner tuba in F.", "f-wagner-tuba description"),
//: trackName for Wagner Tuba; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner Tuba", "f-wagner-tuba trackName"),
//: longName for Wagner Tuba; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner Tuba", "f-wagner-tuba longName"),
//: shortName for Wagner Tuba; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wag. Tb.", "f-wagner-tuba shortName"),
//: traitName for Wagner Tuba; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*F", "f-wagner-tuba traitName"),

//: description for Wagner Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner tuba in F.", "wagner-tuba description"),
//: trackName for Wagner Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner Tuba", "wagner-tuba trackName"),
//: longName for Wagner Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wagner Tuba", "wagner-tuba longName"),
//: shortName for Wagner Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wag. Tb.", "wagner-tuba shortName"),

//: description for Cornet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano cornet in E♭.", "eb-cornet description"),
//: trackName for Cornet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet", "eb-cornet trackName"),
//: longName for Cornet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet", "eb-cornet longName"),
//: shortName for Cornet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cnt.", "eb-cornet shortName"),
//: traitName for Cornet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "eb-cornet traitName"),
//: channel for Cornet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "eb-cornet channel"),
//: channel for Cornet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "eb-cornet channel"),

//: description for Cornet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet in C.", "c-cornet description"),
//: trackName for Cornet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet", "c-cornet trackName"),
//: longName for Cornet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet", "c-cornet longName"),
//: shortName for Cornet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cnt.", "c-cornet shortName"),
//: traitName for Cornet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-cornet traitName"),
//: channel for Cornet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "c-cornet channel"),
//: channel for Cornet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "c-cornet channel"),

//: description for Cornet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet in B♭. The most common cornet.", "bb-cornet description"),
//: trackName for Cornet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet", "bb-cornet trackName"),
//: longName for Cornet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet", "bb-cornet longName"),
//: shortName for Cornet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cnt.", "bb-cornet shortName"),
//: traitName for Cornet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*B♭", "bb-cornet traitName"),
//: channel for Cornet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bb-cornet channel"),
//: channel for Cornet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bb-cornet channel"),

//: description for Cornet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet in A.", "a-cornet description"),
//: trackName for Cornet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet", "a-cornet trackName"),
//: longName for Cornet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornet", "a-cornet longName"),
//: shortName for Cornet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cnt.", "a-cornet shortName"),
//: traitName for Cornet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "a-cornet traitName"),
//: channel for Cornet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "a-cornet channel"),
//: channel for Cornet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "a-cornet channel"),

//: description for Saxhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano saxhorn.", "saxhorn description"),
//: trackName for Saxhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxhorn", "saxhorn trackName"),
//: longName for Saxhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxhorn", "saxhorn longName"),
//: shortName for Saxhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saxhorn", "saxhorn shortName"),
//: channel for Saxhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "saxhorn channel"),
//: channel for Saxhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "saxhorn channel"),

//: description for Alto Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto horn in F. (Known as ‘tenor horn’ in British English.)", "f-alto-horn description"),
//: trackName for Alto Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Horn", "f-alto-horn trackName"),
//: longName for Alto Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Horn", "f-alto-horn longName"),
//: shortName for Alto Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Hn.", "f-alto-horn shortName"),
//: traitName for Alto Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-alto-horn traitName"),
//: channel for Alto Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "f-alto-horn channel"),
//: channel for Alto Horn; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "f-alto-horn channel"),

//: description for Alto Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto horn in E♭. (Known as ‘tenor horn’ in British English.)", "eb-alto-horn description"),
//: trackName for Alto Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Horn", "eb-alto-horn trackName"),
//: longName for Alto Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Horn", "eb-alto-horn longName"),
//: shortName for Alto Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Hn.", "eb-alto-horn shortName"),
//: traitName for Alto Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*E♭", "eb-alto-horn traitName"),
//: channel for Alto Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "eb-alto-horn channel"),
//: channel for Alto Horn; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "eb-alto-horn channel"),

//: description for Baritone Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone horn (sometimes just called ‘baritone’). Notated in bass clef, at concert pitch.", "baritone-horn description"),
//: trackName for Baritone Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Horn", "baritone-horn trackName"),
//: longName for Baritone Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Horn", "baritone-horn longName"),
//: shortName for Baritone Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Hn.", "baritone-horn shortName"),
//: channel for Baritone Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "baritone-horn channel"),
//: channel for Baritone Horn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "baritone-horn channel"),

//: description for Baritone Horn (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone horn (sometimes just called ‘baritone’). Notated in treble clef, often as a transposing instrument.", "baritone-horn-treble description"),
//: trackName for Baritone Horn (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Horn (treble clef)", "baritone-horn-treble trackName"),
//: longName for Baritone Horn (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Horn", "baritone-horn-treble longName"),
//: shortName for Baritone Horn (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Hn.", "baritone-horn-treble shortName"),
//: channel for Baritone Horn (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "baritone-horn-treble channel"),
//: channel for Baritone Horn (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "baritone-horn-treble channel"),

//: description for Baritone Horn (Central European, treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Central European variant of the baritone horn. Notated in treble clef, often as a transposing instrument.", "baritone-horn-central-europe-treble description"),
//: trackName for Baritone Horn (Central European, treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Horn (Central European, treble clef)", "baritone-horn-central-europe-treble trackName"),
//: longName for Baritone Horn (Central European, treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Horn", "baritone-horn-central-europe-treble longName"),
//: shortName for Baritone Horn (Central European, treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Hn.", "baritone-horn-central-europe-treble shortName"),
//: channel for Baritone Horn (Central European, treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "baritone-horn-central-europe-treble channel"),
//: channel for Baritone Horn (Central European, treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "baritone-horn-central-europe-treble channel"),

//: description for Baritone Horn (Central European); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Central European variant of the baritone horn. Notated in bass clef, at concert pitch.", "baritone-horn-central-europe description"),
//: trackName for Baritone Horn (Central European); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Horn (Central European)", "baritone-horn-central-europe trackName"),
//: longName for Baritone Horn (Central European); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Horn", "baritone-horn-central-europe longName"),
//: shortName for Baritone Horn (Central European); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Hn.", "baritone-horn-central-europe shortName"),
//: channel for Baritone Horn (Central European); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "baritone-horn-central-europe channel"),
//: channel for Baritone Horn (Central European); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "baritone-horn-central-europe channel"),

//: description for Posthorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Valveless cylindrical horn with cupped mouthpiece.", "posthorn description"),
//: trackName for Posthorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Posthorn", "posthorn trackName"),
//: longName for Posthorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Posthorn", "posthorn longName"),
//: shortName for Posthorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Psthn.", "posthorn shortName"),
//: channel for Posthorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "posthorn channel"),
//: channel for Posthorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "posthorn channel"),

//: description for Piccolo Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo trumpet in B♭.", "bb-piccolo-trumpet description"),
//: trackName for Piccolo Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Trumpet", "bb-piccolo-trumpet trackName"),
//: longName for Piccolo Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Trumpet", "bb-piccolo-trumpet longName"),
//: shortName for Piccolo Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "P. Tpt.", "bb-piccolo-trumpet shortName"),
//: traitName for Piccolo Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*B♭", "bb-piccolo-trumpet traitName"),
//: channel for Piccolo Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bb-piccolo-trumpet channel"),
//: channel for Piccolo Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bb-piccolo-trumpet channel"),

//: description for Piccolo Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo trumpet in B♭.", "piccolo-trumpet description"),
//: trackName for Piccolo Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Trumpet", "piccolo-trumpet trackName"),
//: longName for Piccolo Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Trumpet", "piccolo-trumpet longName"),
//: shortName for Piccolo Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "P. Tpt.", "piccolo-trumpet shortName"),
//: channel for Piccolo Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "piccolo-trumpet channel"),
//: channel for Piccolo Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "piccolo-trumpet channel"),

//: description for Piccolo Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo trumpet in A.", "a-piccolo-trumpet description"),
//: trackName for Piccolo Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Trumpet", "a-piccolo-trumpet trackName"),
//: longName for Piccolo Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Trumpet", "a-piccolo-trumpet longName"),
//: shortName for Piccolo Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "P. Tpt.", "a-piccolo-trumpet shortName"),
//: traitName for Piccolo Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "a-piccolo-trumpet traitName"),
//: channel for Piccolo Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "a-piccolo-trumpet channel"),
//: channel for Piccolo Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "a-piccolo-trumpet channel"),

//: description for Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in F.", "f-trumpet description"),
//: trackName for Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "f-trumpet trackName"),
//: longName for Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "f-trumpet longName"),
//: shortName for Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tpt.", "f-trumpet shortName"),
//: traitName for Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-trumpet traitName"),
//: channel for Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "f-trumpet channel"),
//: channel for Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "f-trumpet channel"),

//: description for Trumpet; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in E.", "e-trumpet description"),
//: trackName for Trumpet; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "e-trumpet trackName"),
//: longName for Trumpet; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "e-trumpet longName"),
//: shortName for Trumpet; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tpt.", "e-trumpet shortName"),
//: traitName for Trumpet; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E", "e-trumpet traitName"),
//: channel for Trumpet; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "e-trumpet channel"),
//: channel for Trumpet; transposition: E; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "e-trumpet channel"),

//: description for Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in E♭.", "eb-trumpet description"),
//: trackName for Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "eb-trumpet trackName"),
//: longName for Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "eb-trumpet longName"),
//: shortName for Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tpt.", "eb-trumpet shortName"),
//: traitName for Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "eb-trumpet traitName"),
//: channel for Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "eb-trumpet channel"),
//: channel for Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "eb-trumpet channel"),

//: description for Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in D.", "d-trumpet description"),
//: trackName for Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "d-trumpet trackName"),
//: longName for Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "d-trumpet longName"),
//: shortName for Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tpt.", "d-trumpet shortName"),
//: traitName for Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-trumpet traitName"),
//: channel for Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "d-trumpet channel"),
//: channel for Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "d-trumpet channel"),

//: description for Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in C. Nowadays the most common orchestral trumpet.", "c-trumpet description"),
//: trackName for Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "c-trumpet trackName"),
//: longName for Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "c-trumpet longName"),
//: shortName for Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tpt.", "c-trumpet shortName"),
//: traitName for Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-trumpet traitName"),
//: channel for Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "c-trumpet channel"),
//: channel for Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "c-trumpet channel"),

//: description for Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in B♭.", "trumpet description"),
//: trackName for Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "trumpet trackName"),
//: longName for Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "trumpet longName"),
//: shortName for Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tpt.", "trumpet shortName"),
//: channel for Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "trumpet channel"),
//: channel for Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "trumpet channel"),

//: description for Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in B♭. Still the most common trumpet in non-orchestral contexts.", "bb-trumpet description"),
//: trackName for Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "bb-trumpet trackName"),
//: longName for Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "bb-trumpet longName"),
//: shortName for Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tpt.", "bb-trumpet shortName"),
//: traitName for Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*B♭", "bb-trumpet traitName"),
//: channel for Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bb-trumpet channel"),
//: channel for Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bb-trumpet channel"),

//: description for Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in A.", "a-trumpet description"),
//: trackName for Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "a-trumpet trackName"),
//: longName for Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet", "a-trumpet longName"),
//: shortName for Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tpt.", "a-trumpet shortName"),
//: traitName for Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A", "a-trumpet traitName"),
//: channel for Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "a-trumpet channel"),
//: channel for Trumpet; transposition: A; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "a-trumpet channel"),

//: description for Pocket Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in B♭, with the tubing wound into a smaller coil than the standard trumpet.", "pocket-trumpet description"),
//: trackName for Pocket Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Trumpet", "pocket-trumpet trackName"),
//: longName for Pocket Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pocket Trumpet", "pocket-trumpet longName"),
//: shortName for Pocket Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pkt. Tpt.", "pocket-trumpet shortName"),
//: channel for Pocket Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "pocket-trumpet channel"),
//: channel for Pocket Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "pocket-trumpet channel"),

//: description for Slide Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trumpet in D, fitted with a slide much like a trombone. A predecessor of the sackbut.", "slide-trumpet description"),
//: trackName for Slide Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slide Trumpet", "slide-trumpet trackName"),
//: longName for Slide Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slide Trumpet", "slide-trumpet longName"),
//: shortName for Slide Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sl.Tpt.", "slide-trumpet shortName"),
//: channel for Slide Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "slide-trumpet channel"),
//: channel for Slide Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "slide-trumpet channel"),

//: description for Tenor Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor trumpet in B♭.", "tenor-trumpet description"),
//: trackName for Tenor Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Trumpet", "tenor-trumpet trackName"),
//: longName for Tenor Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Trumpet", "tenor-trumpet longName"),
//: shortName for Tenor Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Tpt.", "tenor-trumpet shortName"),
//: channel for Tenor Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "tenor-trumpet channel"),
//: channel for Tenor Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "tenor-trumpet channel"),

//: description for Bass Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass trumpet in E♭.", "eb-bass-trumpet description"),
//: trackName for Bass Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trumpet", "eb-bass-trumpet trackName"),
//: longName for Bass Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trumpet", "eb-bass-trumpet longName"),
//: shortName for Bass Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Tpt.", "eb-bass-trumpet shortName"),
//: traitName for Bass Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "eb-bass-trumpet traitName"),
//: channel for Bass Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "eb-bass-trumpet channel"),
//: channel for Bass Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "eb-bass-trumpet channel"),

//: description for Bass Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass trumpet in C. The most common bass trumpet in use today.", "c-bass-trumpet description"),
//: trackName for Bass Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trumpet", "c-bass-trumpet trackName"),
//: longName for Bass Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trumpet", "c-bass-trumpet longName"),
//: shortName for Bass Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Tpt.", "c-bass-trumpet shortName"),
//: traitName for Bass Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "c-bass-trumpet traitName"),
//: channel for Bass Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "c-bass-trumpet channel"),
//: channel for Bass Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "c-bass-trumpet channel"),

//: description for Bass Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass trumpet in B♭.", "bass-trumpet description"),
//: trackName for Bass Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trumpet", "bass-trumpet trackName"),
//: longName for Bass Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trumpet", "bass-trumpet longName"),
//: shortName for Bass Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Tpt.", "bass-trumpet shortName"),
//: channel for Bass Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bass-trumpet channel"),
//: channel for Bass Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bass-trumpet channel"),

//: description for Bass Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass trumpet in B♭.", "bb-bass-trumpet description"),
//: trackName for Bass Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trumpet", "bb-bass-trumpet trackName"),
//: longName for Bass Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trumpet", "bb-bass-trumpet longName"),
//: shortName for Bass Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Tpt.", "bb-bass-trumpet shortName"),
//: traitName for Bass Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-bass-trumpet traitName"),
//: channel for Bass Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bb-bass-trumpet channel"),
//: channel for Bass Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bb-bass-trumpet channel"),

//: description for Baroque Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque trumpet in F.", "f-baroque-trumpet description"),
//: trackName for Baroque Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "f-baroque-trumpet trackName"),
//: longName for Baroque Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "f-baroque-trumpet longName"),
//: shortName for Baroque Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bq. Tpt.", "f-baroque-trumpet shortName"),
//: traitName for Baroque Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-baroque-trumpet traitName"),
//: channel for Baroque Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "f-baroque-trumpet channel"),
//: channel for Baroque Trumpet; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "f-baroque-trumpet channel"),

//: description for Baroque Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque trumpet in E♭.", "eb-baroque-trumpet description"),
//: trackName for Baroque Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "eb-baroque-trumpet trackName"),
//: longName for Baroque Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "eb-baroque-trumpet longName"),
//: shortName for Baroque Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bq. Tpt.", "eb-baroque-trumpet shortName"),
//: traitName for Baroque Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "eb-baroque-trumpet traitName"),
//: channel for Baroque Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "eb-baroque-trumpet channel"),
//: channel for Baroque Trumpet; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "eb-baroque-trumpet channel"),

//: description for Baroque Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque trumpet in D.", "d-baroque-trumpet description"),
//: trackName for Baroque Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "d-baroque-trumpet trackName"),
//: longName for Baroque Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "d-baroque-trumpet longName"),
//: shortName for Baroque Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bq. Tpt.", "d-baroque-trumpet shortName"),
//: traitName for Baroque Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*D", "d-baroque-trumpet traitName"),
//: channel for Baroque Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "d-baroque-trumpet channel"),
//: channel for Baroque Trumpet; transposition: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "d-baroque-trumpet channel"),

//: description for Baroque Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque trumpet in C.", "c-baroque-trumpet description"),
//: trackName for Baroque Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "c-baroque-trumpet trackName"),
//: longName for Baroque Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "c-baroque-trumpet longName"),
//: shortName for Baroque Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bq. Tpt.", "c-baroque-trumpet shortName"),
//: traitName for Baroque Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-baroque-trumpet traitName"),
//: channel for Baroque Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "c-baroque-trumpet channel"),
//: channel for Baroque Trumpet; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "c-baroque-trumpet channel"),

//: description for Baroque Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque trumpet in B♭.", "bb-baroque-trumpet description"),
//: trackName for Baroque Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "bb-baroque-trumpet trackName"),
//: longName for Baroque Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "bb-baroque-trumpet longName"),
//: shortName for Baroque Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bq. Tpt.", "bb-baroque-trumpet shortName"),
//: traitName for Baroque Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-baroque-trumpet traitName"),
//: channel for Baroque Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bb-baroque-trumpet channel"),
//: channel for Baroque Trumpet; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bb-baroque-trumpet channel"),

//: description for Baroque Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque trumpet in B♭.", "baroque-trumpet description"),
//: trackName for Baroque Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "baroque-trumpet trackName"),
//: longName for Baroque Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baroque Trumpet", "baroque-trumpet longName"),
//: shortName for Baroque Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bq. Tpt.", "baroque-trumpet shortName"),
//: channel for Baroque Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "baroque-trumpet channel"),
//: channel for Baroque Trumpet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "baroque-trumpet channel"),

//: description for Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano bugle.", "bugle description"),
//: trackName for Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bugle", "bugle trackName"),
//: longName for Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bugle", "bugle longName"),
//: shortName for Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bu.", "bugle shortName"),

//: description for Soprano Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano bugle.", "soprano-bugle description"),
//: trackName for Soprano Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Bugle", "soprano-bugle trackName"),
//: longName for Soprano Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Bugle", "soprano-bugle longName"),
//: shortName for Soprano Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Bu.", "soprano-bugle shortName"),

//: description for Alto Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto bugle.", "alto-bugle description"),
//: trackName for Alto Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Bugle", "alto-bugle trackName"),
//: longName for Alto Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Bugle", "alto-bugle longName"),
//: shortName for Alto Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Bu.", "alto-bugle shortName"),

//: description for Mellophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mellophone bugle in F.", "mellophone description"),
//: trackName for Mellophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mellophone", "mellophone trackName"),
//: longName for Mellophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mellophone", "mellophone longName"),
//: shortName for Mellophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mello.", "mellophone shortName"),

//: description for Baritone Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone bugle.", "baritone-bugle description"),
//: trackName for Baritone Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Bugle", "baritone-bugle trackName"),
//: longName for Baritone Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Bugle", "baritone-bugle longName"),
//: shortName for Baritone Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Bu.", "baritone-bugle shortName"),

//: description for Euphonium Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium bugle.", "euphonium-bugle description"),
//: trackName for Euphonium Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium Bugle", "euphonium-bugle trackName"),
//: longName for Euphonium Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium Bugle", "euphonium-bugle longName"),
//: shortName for Euphonium Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euph. Bu.", "euphonium-bugle shortName"),

//: description for Mellophone Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mellophone bugle in C.", "mellophon-bugle description"),
//: trackName for Mellophone Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mellophone Bugle", "mellophon-bugle trackName"),
//: longName for Mellophone Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mellophone Bugle", "mellophon-bugle longName"),
//: shortName for Mellophone Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mello. Bu.", "mellophon-bugle shortName"),

//: description for Contrabass Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass bugle.", "contrabass-bugle description"),
//: trackName for Contrabass Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Bugle", "contrabass-bugle trackName"),
//: longName for Contrabass Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Bugle", "contrabass-bugle longName"),
//: shortName for Contrabass Bugle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Bu.", "contrabass-bugle shortName"),

//: description for Fiscorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass flugelhorn, originally played in polka bands in central Europe.", "fiscorn description"),
//: trackName for Fiscorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fiscorn", "fiscorn trackName"),
//: longName for Fiscorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fiscorn", "fiscorn longName"),
//: shortName for Fiscorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fsc.", "fiscorn shortName"),
//: channel for Fiscorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "fiscorn channel"),
//: channel for Fiscorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "fiscorn channel"),

//: description for Flugelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flugelhorn in B♭.", "flugelhorn description"),
//: trackName for Flugelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flugelhorn", "flugelhorn trackName"),
//: longName for Flugelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flugelhorn", "flugelhorn longName"),
//: shortName for Flugelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flghn.", "flugelhorn shortName"),
//: channel for Flugelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "flugelhorn channel"),
//: channel for Flugelhorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "flugelhorn channel"),

//: description for Kuhlohorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Small flugelhorn in B♭, played using a deep bowled mouthpiece.", "kuhlohorn description"),
//: trackName for Kuhlohorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kuhlohorn", "kuhlohorn trackName"),
//: longName for Kuhlohorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kuhlohorn", "kuhlohorn longName"),
//: shortName for Kuhlohorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Klhn.", "kuhlohorn shortName"),
//: channel for Kuhlohorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "kuhlohorn channel"),
//: channel for Kuhlohorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "kuhlohorn channel"),

//: description for Alto Ophicleide; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto ophicleide in F.", "f-alto-ophicleide description"),
//: trackName for Alto Ophicleide; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Ophicleide", "f-alto-ophicleide trackName"),
//: longName for Alto Ophicleide; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Ophicleide", "f-alto-ophicleide longName"),
//: shortName for Alto Ophicleide; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Oph.", "f-alto-ophicleide shortName"),
//: traitName for Alto Ophicleide; transposition: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F", "f-alto-ophicleide traitName"),

//: description for Alto Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto ophicleide in E♭.", "eb-alto-ophicleide description"),
//: trackName for Alto Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Ophicleide", "eb-alto-ophicleide trackName"),
//: longName for Alto Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Ophicleide", "eb-alto-ophicleide longName"),
//: shortName for Alto Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Oph.", "eb-alto-ophicleide shortName"),
//: traitName for Alto Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*E♭", "eb-alto-ophicleide traitName"),

//: description for Ophicleide; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass ophicleide in C.", "ophicleide description"),
//: trackName for Ophicleide; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ophicleide", "ophicleide trackName"),
//: longName for Ophicleide; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ophicleide", "ophicleide longName"),
//: shortName for Ophicleide; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oph.", "ophicleide shortName"),

//: description for Bass Ophicleide; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass ophicleide in C.", "c-bass-ophicleide description"),
//: trackName for Bass Ophicleide; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Ophicleide", "c-bass-ophicleide trackName"),
//: longName for Bass Ophicleide; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Ophicleide", "c-bass-ophicleide longName"),
//: shortName for Bass Ophicleide; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Oph.", "c-bass-ophicleide shortName"),
//: traitName for Bass Ophicleide; transposition: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*C", "c-bass-ophicleide traitName"),

//: description for Bass Ophicleide; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass ophicleide in B♭.", "bb-bass-ophicleide description"),
//: trackName for Bass Ophicleide; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Ophicleide", "bb-bass-ophicleide trackName"),
//: longName for Bass Ophicleide; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Ophicleide", "bb-bass-ophicleide longName"),
//: shortName for Bass Ophicleide; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Oph.", "bb-bass-ophicleide shortName"),
//: traitName for Bass Ophicleide; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-bass-ophicleide traitName"),

//: description for Contrabass Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass ophicleide in E♭.", "eb-contrabass-ophicleide description"),
//: trackName for Contrabass Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Ophicleide", "eb-contrabass-ophicleide trackName"),
//: longName for Contrabass Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Ophicleide", "eb-contrabass-ophicleide longName"),
//: shortName for Contrabass Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Oph.", "eb-contrabass-ophicleide shortName"),
//: traitName for Contrabass Ophicleide; transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*E♭", "eb-contrabass-ophicleide traitName"),

//: description for Cornettino; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Medieval wind instrument, consisting of a conical wooden pipe covered in leather. The cornettino is the descant of the family.", "cornettino description"),
//: trackName for Cornettino; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornettino", "cornettino trackName"),
//: longName for Cornettino; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornettino", "cornettino longName"),
//: shortName for Cornettino; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Co.", "cornettino shortName"),

//: description for Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Medieval wind instrument, consisting of a conical wooden pipe covered in leather. The soprano is the most common cornett.", "cornett description"),
//: trackName for Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornett", "cornett trackName"),
//: longName for Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cornett", "cornett longName"),
//: shortName for Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Co.", "cornett shortName"),

//: description for Soprano Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Medieval wind instrument, consisting of a conical wooden pipe covered in leather. The soprano is the most common cornett.", "soprano-cornett description"),
//: trackName for Soprano Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Cornett", "soprano-cornett trackName"),
//: longName for Soprano Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Cornett", "soprano-cornett longName"),
//: shortName for Soprano Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Co.", "soprano-cornett shortName"),

//: description for Alto Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Medieval wind instrument, consisting of a conical wooden pipe covered in leather.", "alto-cornett description"),
//: trackName for Alto Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Cornett", "alto-cornett trackName"),
//: longName for Alto Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Cornett", "alto-cornett longName"),
//: shortName for Alto Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Co.", "alto-cornett shortName"),

//: description for Tenor Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Medieval wind instrument, consisting of a conical wooden pipe covered in leather.", "tenor-cornett description"),
//: trackName for Tenor Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Cornett", "tenor-cornett trackName"),
//: longName for Tenor Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Cornett", "tenor-cornett longName"),
//: shortName for Tenor Cornett; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Co.", "tenor-cornett shortName"),

//: description for Serpent; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Descendant of the cornett, and distant ancestor of the tuba.", "serpent description"),
//: trackName for Serpent; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Serpent", "serpent trackName"),
//: longName for Serpent; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Serpent", "serpent longName"),
//: shortName for Serpent; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Spt.", "serpent shortName"),

//: description for Soprano Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano trombone (usually pitched in B♭, an octave above the tenor).", "soprano-trombone description"),
//: trackName for Soprano Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Trombone", "soprano-trombone trackName"),
//: longName for Soprano Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Trombone", "soprano-trombone longName"),
//: shortName for Soprano Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Tbn.", "soprano-trombone shortName"),
//: channel for Soprano Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "soprano-trombone channel"),
//: channel for Soprano Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "soprano-trombone channel"),

//: description for Alto Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto trombone (pitched in E♭ or F).", "alto-trombone description"),
//: trackName for Alto Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Trombone", "alto-trombone trackName"),
//: longName for Alto Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Trombone", "alto-trombone longName"),
//: shortName for Alto Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Tbn.", "alto-trombone shortName"),
//: channel for Alto Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "alto-trombone channel"),
//: channel for Alto Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "alto-trombone channel"),

//: description for Tenor Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor trombone (pitched in B♭).", "tenor-trombone description"),
//: trackName for Tenor Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Trombone", "tenor-trombone trackName"),
//: longName for Tenor Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Trombone", "tenor-trombone longName"),
//: shortName for Tenor Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Tbn.", "tenor-trombone shortName"),
//: channel for Tenor Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "tenor-trombone channel"),
//: channel for Tenor Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "tenor-trombone channel"),

//: description for Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orchestral trombone (either tenor or bass; this is often not explicitly specified in scores).", "trombone description"),
//: trackName for Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trombone", "trombone trackName"),
//: longName for Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trombone", "trombone longName"),
//: shortName for Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tbn.", "trombone shortName"),
//: channel for Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "trombone channel"),
//: channel for Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "trombone channel"),

//: description for Trombone (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trombone (notated in treble clef as a transposing instrument in B♭).", "trombone-treble description"),
//: trackName for Trombone (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trombone (treble clef)", "trombone-treble trackName"),
//: longName for Trombone (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trombone", "trombone-treble longName"),
//: shortName for Trombone (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tbn.", "trombone-treble shortName"),
//: channel for Trombone (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "trombone-treble channel"),
//: channel for Trombone (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "trombone-treble channel"),

//: description for Bass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass trombone (pitched in B♭).", "bass-trombone description"),
//: trackName for Bass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trombone", "bass-trombone trackName"),
//: longName for Bass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Trombone", "bass-trombone longName"),
//: shortName for Bass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Tbn.", "bass-trombone shortName"),
//: channel for Bass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "bass-trombone channel"),
//: channel for Bass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "bass-trombone channel"),

//: description for Contrabass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Trombone (usually pitched in F).", "contrabass-trombone description"),
//: trackName for Contrabass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Trombone", "contrabass-trombone trackName"),
//: longName for Contrabass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Trombone", "contrabass-trombone longName"),
//: shortName for Contrabass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Tbn.", "contrabass-trombone shortName"),
//: channel for Contrabass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "contrabass-trombone channel"),
//: channel for Contrabass Trombone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "contrabass-trombone channel"),

//: description for Cimbasso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Instrument with a similar range to the contrabass trombone, most commonly encountered in 19th-century Italian opera scores.", "cimbasso description"),
//: trackName for Cimbasso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cimbasso", "cimbasso trackName"),
//: longName for Cimbasso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cimbasso", "cimbasso longName"),
//: shortName for Cimbasso; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cim.", "cimbasso shortName"),

//: description for Alto Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance and Baroque trombone. A descendant of the slide trumpet.", "alto-sackbut description"),
//: trackName for Alto Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Sackbut", "alto-sackbut trackName"),
//: longName for Alto Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Sackbut", "alto-sackbut longName"),
//: shortName for Alto Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Sack.", "alto-sackbut shortName"),

//: description for Tenor Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance and Baroque trombone. A descendant of the slide trumpet.", "tenor-sackbut description"),
//: trackName for Tenor Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Sackbut", "tenor-sackbut trackName"),
//: longName for Tenor Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Sackbut", "tenor-sackbut longName"),
//: shortName for Tenor Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Sack.", "tenor-sackbut shortName"),

//: description for Bass Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Renaissance and Baroque trombone. A descendant of the slide trumpet.", "bass-sackbut description"),
//: trackName for Bass Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Sackbut", "bass-sackbut trackName"),
//: longName for Bass Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Sackbut", "bass-sackbut longName"),
//: shortName for Bass Sackbut; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Sack.", "bass-sackbut shortName"),

//: description for Euphonium; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium (notated in bass clef at concert pitch).", "euphonium description"),
//: trackName for Euphonium; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium", "euphonium trackName"),
//: longName for Euphonium; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium", "euphonium longName"),
//: shortName for Euphonium; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euph.", "euphonium shortName"),

//: description for Euphonium (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium (notated in treble clef as a transposing instrument in B♭).", "euphonium-treble description"),
//: trackName for Euphonium (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium (treble clef)", "euphonium-treble trackName"),
//: longName for Euphonium (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euphonium", "euphonium-treble longName"),
//: shortName for Euphonium (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Euph.", "euphonium-treble shortName"),

//: description for Tuba (unspecified); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orchestral tuba (where the exact type is not specified).", "tuba description"),
//: trackName for Tuba (unspecified); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuba (unspecified)", "tuba trackName"),
//: longName for Tuba (unspecified); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuba", "tuba longName"),
//: shortName for Tuba (unspecified); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tba.", "tuba shortName"),

//: description for Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass tuba in F (notated in bass clef at concert pitch).", "f-tuba description"),
//: trackName for Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuba", "f-tuba trackName"),
//: longName for Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Tuba", "f-tuba longName"),
//: shortName for Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Tb.", "f-tuba shortName"),

//: description for Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass tuba in E♭ (notated in bass clef at concert pitch).", "eb-tuba description"),
//: trackName for Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuba", "eb-tuba trackName"),
//: longName for Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭ Tuba", "eb-tuba longName"),
//: shortName for Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭ Tb.", "eb-tuba shortName"),

//: description for Bass Tuba; tuning: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass tuba in E♭ (notated in bass clef at concert pitch).", "bass-eb-tuba description"),
//: trackName for Bass Tuba; tuning: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Tuba", "bass-eb-tuba trackName"),
//: longName for Bass Tuba; tuning: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭ Bass Tuba", "bass-eb-tuba longName"),
//: shortName for Bass Tuba; tuning: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭ Ba. Tb.", "bass-eb-tuba shortName"),
//: traitName for Bass Tuba; tuning: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "bass-eb-tuba traitName"),

//: description for Bass Tuba; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass tuba in F (notated in bass clef at concert pitch).", "bass-f-tuba description"),
//: trackName for Bass Tuba; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Tuba", "bass-f-tuba trackName"),
//: longName for Bass Tuba; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Bass Tuba", "bass-f-tuba longName"),
//: shortName for Bass Tuba; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "F Ba. Tb.", "bass-f-tuba shortName"),
//: traitName for Bass Tuba; tuning: F; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*F", "bass-f-tuba traitName"),

//: description for Bass Tuba (treble clef); transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass tuba in E♭ (notated in treble clef as a transposing instrument).", "eb-tuba-treble description"),
//: trackName for Bass Tuba (treble clef); transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Tuba (treble clef)", "eb-tuba-treble trackName"),
//: longName for Bass Tuba (treble clef); transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Tuba", "eb-tuba-treble longName"),
//: shortName for Bass Tuba (treble clef); transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ba. Tb.", "eb-tuba-treble shortName"),
//: traitName for Bass Tuba (treble clef); transposition: E♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "E♭", "eb-tuba-treble traitName"),

//: description for Contrabass Tuba; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass tuba in C (notated in bass clef).", "c-tuba description"),
//: trackName for Contrabass Tuba; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Tuba", "c-tuba trackName"),
//: longName for Contrabass Tuba; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Contrabass Tuba", "c-tuba longName"),
//: shortName for Contrabass Tuba; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C Cb. Tb.", "c-tuba shortName"),
//: traitName for Contrabass Tuba; tuning: C; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C", "c-tuba traitName"),

//: description for Contrabass Tuba; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass tuba in B♭ (notated in bass clef at concert pitch).", "bb-tuba description"),
//: trackName for Contrabass Tuba; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Tuba", "bb-tuba trackName"),
//: longName for Contrabass Tuba; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Contrabass Tuba", "bb-tuba longName"),
//: shortName for Contrabass Tuba; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭ Cb. Tb.", "bb-tuba shortName"),
//: traitName for Contrabass Tuba; tuning: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*B♭", "bb-tuba traitName"),

//: description for Contrabass Tuba (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass tuba in B♭ (notated in treble clef as a transposing instrument).", "bb-tuba-treble description"),
//: trackName for Contrabass Tuba (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Tuba (treble clef)", "bb-tuba-treble trackName"),
//: longName for Contrabass Tuba (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Tuba", "bb-tuba-treble longName"),
//: shortName for Contrabass Tuba (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Tb.", "bb-tuba-treble shortName"),
//: traitName for Contrabass Tuba (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B♭", "bb-tuba-treble traitName"),

//: description for Sub-Contrabass Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sub-contrabass tuba in C.", "subcontrabass-tuba description"),
//: trackName for Sub-Contrabass Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sub-Contrabass Tuba", "subcontrabass-tuba trackName"),
//: longName for Sub-Contrabass Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sub-Contrabass Tuba", "subcontrabass-tuba longName"),
//: shortName for Sub-Contrabass Tuba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "SCb. Tb.", "subcontrabass-tuba shortName"),

//: description for Sousaphone; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone in B♭ (notated in bass clef).", "bb-sousaphone description"),
//: trackName for Sousaphone; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone", "bb-sousaphone trackName"),
//: longName for Sousaphone; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone", "bb-sousaphone longName"),
//: shortName for Sousaphone; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sphn.", "bb-sousaphone shortName"),
//: traitName for Sousaphone; transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "(B♭)", "bb-sousaphone traitName"),

//: description for Sousaphone (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone in B♭ (notated in treble clef).", "bb-sousaphone-treble description"),
//: trackName for Sousaphone (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone (treble clef)", "bb-sousaphone-treble trackName"),
//: longName for Sousaphone (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone", "bb-sousaphone-treble longName"),
//: shortName for Sousaphone (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sphn.", "bb-sousaphone-treble shortName"),
//: traitName for Sousaphone (treble clef); transposition: B♭; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "(B♭)", "bb-sousaphone-treble traitName"),

//: description for Sousaphone (concert pitch); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone in B♭ (notated in treble clef at concert pitch).", "sousaphone description"),
//: trackName for Sousaphone (concert pitch); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone (concert pitch)", "sousaphone trackName"),
//: longName for Sousaphone (concert pitch); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sousaphone", "sousaphone longName"),
//: shortName for Sousaphone (concert pitch); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sphn.", "sousaphone shortName"),

//: description for Helicon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Instrument of the tuba family.", "helicon description"),
//: trackName for Helicon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Helicon", "helicon trackName"),
//: longName for Helicon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Helicon", "helicon longName"),
//: shortName for Helicon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Helicon", "helicon shortName"),

//: description for Conch; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Conch shell, sometimes fitted with a mouthpiece.", "conch description"),
//: trackName for Conch; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Conch", "conch trackName"),
//: longName for Conch; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Conch", "conch longName"),
//: shortName for Conch; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cnch.", "conch shortName"),

//: description for Horagai; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Type of conch shell used as a trumpet in Japan, fitted with a bronze or wooden mouthpiece.", "horagai description"),
//: trackName for Horagai; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horagai", "horagai trackName"),
//: longName for Horagai; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Horagai", "horagai longName"),
//: shortName for Horagai; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hor.", "horagai shortName"),

//: description for Alphorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Long wooden natural horn with conical bore and wooden cup-shaped mouthpiece, originating in the Alpine regions.", "alphorn description"),
//: trackName for Alphorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alphorn", "alphorn trackName"),
//: longName for Alphorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alphorn", "alphorn longName"),
//: shortName for Alphorn; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "AlpHn.", "alphorn shortName"),

//: description for Rag Dung; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Long Tibetan trumpet used for Buddhist religious purposes.", "rag-dung description"),
//: trackName for Rag Dung; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rag Dung", "rag-dung trackName"),
//: longName for Rag Dung; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rag Dung", "rag-dung longName"),
//: shortName for Rag Dung; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rg. Dng.", "rag-dung shortName"),
//: channel for Rag Dung; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "rag-dung channel"),
//: channel for Rag Dung; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "rag-dung channel"),

//: description for Didgeridoo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Aboriginal Australian drone instrument.", "didgeridoo description"),
//: trackName for Didgeridoo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Didgeridoo", "didgeridoo trackName"),
//: longName for Didgeridoo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Didgeridoo", "didgeridoo longName"),
//: shortName for Didgeridoo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Doo.", "didgeridoo shortName"),

//: description for Shofar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Typically made from a ram’s horn and used for Jewish religious purposes.", "shofar description"),
//: trackName for Shofar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shofar", "shofar trackName"),
//: longName for Shofar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shofar", "shofar longName"),
//: shortName for Shofar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sho.", "shofar shortName"),

//: description for Vuvuzela; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Plastic horn that produces a loud single pitch.", "vuvuzela description"),
//: trackName for Vuvuzela; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vuvuzela", "vuvuzela trackName"),
//: longName for Vuvuzela; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vuvuzela", "vuvuzela longName"),
//: shortName for Vuvuzela; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vuv.", "vuvuzela shortName"),

// Percussion - Pitched
QT_TRANSLATE_NOOP("engraving/instruments/group", "Percussion - Pitched"),

//: description for Timpani; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Large pitched orchestral drums, also known as kettle drums. Sometimes fitted with a pedal to allow quick changes of tuning.", "timpani description"),
//: trackName for Timpani; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Timpani", "timpani trackName"),
//: longName for Timpani; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Timpani", "timpani longName"),
//: shortName for Timpani; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Timp.", "timpani shortName"),

//: description for Roto-Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pitched drums that can be tuned quickly by rotating the drumhead.", "roto-toms description"),
//: trackName for Roto-Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Roto-Toms", "roto-toms trackName"),
//: longName for Roto-Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Roto-Toms", "roto-toms longName"),
//: shortName for Roto-Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Roto", "roto-toms shortName"),

//: description for Tubaphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Constructed from a series of metal tubes arranged in a keyboard configuration.", "tubaphone description"),
//: trackName for Tubaphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tubaphone", "tubaphone trackName"),
//: longName for Tubaphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tubaphone", "tubaphone longName"),
//: shortName for Tubaphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tph.", "tubaphone shortName"),

//: description for Soprano Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano steel drums.", "soprano-steel-drums description"),
//: trackName for Soprano Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Steel Drums", "soprano-steel-drums trackName"),
//: longName for Soprano Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Steel Drums", "soprano-steel-drums longName"),
//: shortName for Soprano Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. St. Dr.", "soprano-steel-drums shortName"),

//: description for Alto Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto steel drums.", "alto-steel-drums description"),
//: trackName for Alto Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Steel Drums", "alto-steel-drums trackName"),
//: longName for Alto Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Steel Drums", "alto-steel-drums longName"),
//: shortName for Alto Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. St. Dr.", "alto-steel-drums shortName"),

//: description for Guitar Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guitar steel drums.", "guitar-steel-drums description"),
//: trackName for Guitar Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guitar Steel Drums", "guitar-steel-drums trackName"),
//: longName for Guitar Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guitar Steel Drums", "guitar-steel-drums longName"),
//: shortName for Guitar Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gtr. St. Dr.", "guitar-steel-drums shortName"),

//: description for Tenor Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor steel drums.", "tenor-steel-drums description"),
//: trackName for Tenor Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Steel Drums", "tenor-steel-drums trackName"),
//: longName for Tenor Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Steel Drums", "tenor-steel-drums longName"),
//: shortName for Tenor Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. St. Dr.", "tenor-steel-drums shortName"),

//: description for Cello Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cello steel drums.", "cello-steel-drums description"),
//: trackName for Cello Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cello Steel Drums", "cello-steel-drums trackName"),
//: longName for Cello Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cello Steel Drums", "cello-steel-drums longName"),
//: shortName for Cello Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ce. St. Dr.", "cello-steel-drums shortName"),

//: description for Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Steel drums on a grand staff.", "steel-drums description"),
//: trackName for Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Steel Drums", "steel-drums trackName"),
//: longName for Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Steel Drums", "steel-drums longName"),
//: shortName for Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "St. Dr.", "steel-drums shortName"),

//: description for Bass Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass steel drums.", "bass-steel-drums description"),
//: trackName for Bass Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Steel Drums", "bass-steel-drums trackName"),
//: longName for Bass Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Steel Drums", "bass-steel-drums longName"),
//: shortName for Bass Steel Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. St. Dr.", "bass-steel-drums shortName"),

//: description for Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glockenspiel.", "glockenspiel description"),
//: trackName for Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glockenspiel", "glockenspiel trackName"),
//: longName for Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glockenspiel", "glockenspiel longName"),
//: shortName for Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glock.", "glockenspiel shortName"),

//: description for Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Xylophone.", "xylophone description"),
//: trackName for Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Xylophone", "xylophone trackName"),
//: longName for Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Xylophone", "xylophone longName"),
//: shortName for Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Xyl.", "xylophone shortName"),

//: description for Xylomarimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Xylophone with an extended range, matching a 5-octave marimba but sounding an octave higher.", "xylomarimba description"),
//: trackName for Xylomarimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Xylomarimba", "xylomarimba trackName"),
//: longName for Xylomarimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Xylomarimba", "xylomarimba longName"),
//: shortName for Xylomarimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "XMrm.", "xylomarimba shortName"),

//: description for Vibraphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vibraphone.", "vibraphone description"),
//: trackName for Vibraphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vibraphone", "vibraphone trackName"),
//: longName for Vibraphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vibraphone", "vibraphone longName"),
//: shortName for Vibraphone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vib.", "vibraphone shortName"),

//: description for Dulcimer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hammered dulcimer.", "dulcimer description"),
//: trackName for Dulcimer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dulcimer", "dulcimer trackName"),
//: longName for Dulcimer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dulcimer", "dulcimer longName"),
//: shortName for Dulcimer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dlc.", "dulcimer shortName"),

//: description for Cimbalom; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Concert cimbalom.", "cimbalom description"),
//: trackName for Cimbalom; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cimbalom", "cimbalom trackName"),
//: longName for Cimbalom; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cimbalom", "cimbalom longName"),
//: shortName for Cimbalom; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cimb.", "cimbalom shortName"),

//: description for Marimba (grand staff); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marimba notated on a grand staff.", "marimba description"),
//: trackName for Marimba (grand staff); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marimba (grand staff)", "marimba trackName"),
//: longName for Marimba (grand staff); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marimba", "marimba longName"),
//: shortName for Marimba (grand staff); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mrm.", "marimba shortName"),

//: description for Marimba (single staff); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marimba notated on a single staff.", "marimba-single description"),
//: trackName for Marimba (single staff); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marimba (single staff)", "marimba-single trackName"),
//: longName for Marimba (single staff); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marimba", "marimba-single longName"),
//: shortName for Marimba (single staff); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mrm.", "marimba-single shortName"),

//: description for Bass Marimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass marimba.", "bass-marimba description"),
//: trackName for Bass Marimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Marimba", "bass-marimba trackName"),
//: longName for Bass Marimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Marimba", "bass-marimba longName"),
//: shortName for Bass Marimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Mrm.", "bass-marimba shortName"),

//: description for Contrabass Marimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass marimba.", "contrabass-marimba description"),
//: trackName for Contrabass Marimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Marimba", "contrabass-marimba trackName"),
//: longName for Contrabass Marimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Marimba", "contrabass-marimba longName"),
//: shortName for Contrabass Marimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Mrm.", "contrabass-marimba shortName"),

//: description for Crotales; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crotales, sometimes called antique cymbals.", "crotales description"),
//: trackName for Crotales; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crotales", "crotales trackName"),
//: longName for Crotales; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crotales", "crotales longName"),
//: shortName for Crotales; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crot.", "crotales shortName"),

//: description for Almglocken; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Almglocken, or cow bells.", "almglocken description"),
//: trackName for Almglocken; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Almglocken", "almglocken trackName"),
//: longName for Almglocken; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Almglocken", "almglocken longName"),
//: shortName for Almglocken; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Almg.", "almglocken shortName"),

//: description for Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tubular bells (British English), or chimes (American English).", "tubular-bells description"),
//: trackName for Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chimes", "tubular-bells trackName"),
//: longName for Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chimes", "tubular-bells longName"),
//: shortName for Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cme.", "tubular-bells shortName"),

//: description for Carillon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuned bells installed in a bell tower and played with a keyboard.", "carillon description"),
//: trackName for Carillon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Carillon", "carillon trackName"),
//: longName for Carillon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Carillon", "carillon longName"),
//: shortName for Carillon; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Car.", "carillon shortName"),

//: description for Tuned Gongs; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuned gongs.", "tuned-gongs description"),
//: trackName for Tuned Gongs; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuned Gongs", "tuned-gongs trackName"),
//: longName for Tuned Gongs; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuned Gongs", "tuned-gongs longName"),
//: shortName for Tuned Gongs; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Td. Gon.", "tuned-gongs shortName"),

//: description for Hand Bells; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuned hand bells.", "hand-bells description"),
//: trackName for Hand Bells; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hand Bells", "hand-bells trackName"),
//: longName for Hand Bells; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hand Bells", "hand-bells longName"),
//: shortName for Hand Bells; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ha. Be.", "hand-bells shortName"),

//: description for Orff Soprano Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano glockenspiel for the Orff Schulwerk.", "orff-soprano-glockenspiel description"),
//: trackName for Orff Soprano Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Soprano Glockenspiel", "orff-soprano-glockenspiel trackName"),
//: longName for Orff Soprano Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Soprano Glockenspiel", "orff-soprano-glockenspiel longName"),
//: shortName for Orff Soprano Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O. S. Glk.", "orff-soprano-glockenspiel shortName"),

//: description for Orff Alto Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto glockenspiel for the Orff Schulwerk.", "orff-alto-glockenspiel description"),
//: trackName for Orff Alto Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Alto Glockenspiel", "orff-alto-glockenspiel trackName"),
//: longName for Orff Alto Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Alto Glockenspiel", "orff-alto-glockenspiel longName"),
//: shortName for Orff Alto Glockenspiel; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O. A. Glk.", "orff-alto-glockenspiel shortName"),

//: description for Orff Soprano Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano metallophone for the Orff Schulwerk.", "orff-soprano-metallophone description"),
//: trackName for Orff Soprano Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Soprano Metallophone", "orff-soprano-metallophone trackName"),
//: longName for Orff Soprano Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Soprano Metallophone", "orff-soprano-metallophone longName"),
//: shortName for Orff Soprano Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O. S. Met.", "orff-soprano-metallophone shortName"),

//: description for Orff Soprano Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano xylophone for the Orff Schulwerk.", "orff-soprano-xylophone description"),
//: trackName for Orff Soprano Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Soprano Xylophone", "orff-soprano-xylophone trackName"),
//: longName for Orff Soprano Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Soprano Xylophone", "orff-soprano-xylophone longName"),
//: shortName for Orff Soprano Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O. S. Xyl.", "orff-soprano-xylophone shortName"),

//: description for Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Generic metallophone for the Orff Schulwerk.", "metallophone description"),
//: trackName for Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metallophone", "metallophone trackName"),
//: longName for Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metallophone", "metallophone longName"),
//: shortName for Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Met.", "metallophone shortName"),

//: description for Orff Alto Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto metallophone for the Orff Schulwerk.", "orff-alto-metallophone description"),
//: trackName for Orff Alto Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Alto Metallophone", "orff-alto-metallophone trackName"),
//: longName for Orff Alto Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Alto Metallophone", "orff-alto-metallophone longName"),
//: shortName for Orff Alto Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O. A. Met.", "orff-alto-metallophone shortName"),

//: description for Orff Alto Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto xylophone for the Orff Schulwerk.", "orff-alto-xylophone description"),
//: trackName for Orff Alto Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Alto Xylophone", "orff-alto-xylophone trackName"),
//: longName for Orff Alto Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Alto Xylophone", "orff-alto-xylophone longName"),
//: shortName for Orff Alto Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O. A. Xyl.", "orff-alto-xylophone shortName"),

//: description for Orff Bass Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass metallophone for the Orff Schulwerk.", "orff-bass-metallophone description"),
//: trackName for Orff Bass Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Bass Metallophone", "orff-bass-metallophone trackName"),
//: longName for Orff Bass Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Bass Metallophone", "orff-bass-metallophone longName"),
//: shortName for Orff Bass Metallophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O. B. Met.", "orff-bass-metallophone shortName"),

//: description for Orff Bass Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass xylophone for the Orff Schulwerk.", "orff-bass-xylophone description"),
//: trackName for Orff Bass Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Bass Xylophone", "orff-bass-xylophone trackName"),
//: longName for Orff Bass Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orff Bass Xylophone", "orff-bass-xylophone longName"),
//: shortName for Orff Bass Xylophone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O. B. Xyl.", "orff-bass-xylophone shortName"),

//: description for Flexatone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flexatone.", "flexatone description"),
//: trackName for Flexatone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flexatone", "flexatone trackName"),
//: longName for Flexatone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flexatone", "flexatone longName"),
//: shortName for Flexatone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Flt.", "flexatone shortName"),

//: description for Musical Saw; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Musical saw, played with a violin or cello bow.", "musical-saw description"),
//: trackName for Musical Saw; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Musical Saw", "musical-saw trackName"),
//: longName for Musical Saw; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Musical Saw", "musical-saw longName"),
//: shortName for Musical Saw; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mu. Sw.", "musical-saw shortName"),

//: description for Musical Glasses; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wine glasses played by running moistened fingers around the rim. Sometimes called a glass harp.", "musical-glasses description"),
//: trackName for Musical Glasses; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Musical Glasses", "musical-glasses trackName"),
//: longName for Musical Glasses; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Musical Glasses", "musical-glasses longName"),
//: shortName for Musical Glasses; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mu. Gla.", "musical-glasses shortName"),

//: description for Glass Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Instrument made of spinning glass disks or bowls played by touching with the fingers.", "glass-harmonica description"),
//: trackName for Glass Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glass Harmonica", "glass-harmonica trackName"),
//: longName for Glass Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glass Harmonica", "glass-harmonica longName"),
//: shortName for Glass Harmonica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gla. Har.", "glass-harmonica shortName"),

//: description for Tuned Klaxon Horns; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuned klaxon horns or car horns.", "tuned-klaxon-horns description"),
//: trackName for Tuned Klaxon Horns; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuned Klaxon Horns", "tuned-klaxon-horns trackName"),
//: longName for Tuned Klaxon Horns; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tuned Klaxon Horns", "tuned-klaxon-horns longName"),
//: shortName for Tuned Klaxon Horns; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tn. Klx. Hns.", "tuned-klaxon-horns shortName"),

//: description for Alto Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto kalimba. A modern interpretation of the traditional Shona mbira.", "alto-kalimba description"),
//: trackName for Alto Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Kalimba", "alto-kalimba trackName"),
//: longName for Alto Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Kalimba", "alto-kalimba longName"),
//: shortName for Alto Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Kal.", "alto-kalimba shortName"),

//: description for Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kalimba (generic). A modern interpretation of the traditional Shona mbira.", "kalimba description"),
//: trackName for Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kalimba", "kalimba trackName"),
//: longName for Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kalimba", "kalimba longName"),
//: shortName for Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kal.", "kalimba shortName"),

//: description for Treble Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Treble kalimba. A modern interpretation of the traditional Shona mbira.", "treble-kalimba description"),
//: trackName for Treble Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Treble Kalimba", "treble-kalimba trackName"),
//: longName for Treble Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Treble Kalimba", "treble-kalimba longName"),
//: shortName for Treble Kalimba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tr. Kal.", "treble-kalimba shortName"),

// Percussion - Unpitched
QT_TRANSLATE_NOOP("engraving/instruments/group", "Percussion - Unpitched"),

//: description for Automobile Brake Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Automobile brake drums.", "automobile-brake-drums description"),
//: trackName for Automobile Brake Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Automobile Brake Drums", "automobile-brake-drums trackName"),
//: longName for Automobile Brake Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Automobile Brake Drums", "automobile-brake-drums longName"),
//: shortName for Automobile Brake Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Aut. Brk. Dr.", "automobile-brake-drums shortName"),

//: description for Bongos; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bongos.", "bongos description"),
//: trackName for Bongos; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bongos", "bongos trackName"),
//: longName for Bongos; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bongos", "bongos longName"),
//: shortName for Bongos; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bon.", "bongos shortName"),

//: description for Chinese Tom-Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese tom-toms.", "chinese-tom-toms description"),
//: trackName for Chinese Tom-Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese Tom-Toms", "chinese-tom-toms trackName"),
//: longName for Chinese Tom-Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese Tom-Toms", "chinese-tom-toms longName"),
//: shortName for Chinese Tom-Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ch. Toms", "chinese-tom-toms shortName"),

//: description for Bass Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass drum.", "bass-drum description"),
//: trackName for Bass Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Drum", "bass-drum trackName"),
//: longName for Bass Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Drum", "bass-drum longName"),
//: shortName for Bass Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "BD", "bass-drum shortName"),

//: description for Snare Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Snare drum, also known as side drum.", "snare-drum description"),
//: trackName for Snare Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Snare Drum", "snare-drum trackName"),
//: longName for Snare Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Snare Drum", "snare-drum longName"),
//: shortName for Snare Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "SD", "snare-drum shortName"),

//: description for Concert Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Concert tom-toms.", "tom-toms description"),
//: trackName for Concert Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Concert Toms", "tom-toms trackName"),
//: longName for Concert Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Toms", "tom-toms longName"),
//: shortName for Concert Toms; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Toms", "tom-toms shortName"),

//: description for Congas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Congas.", "congas description"),
//: trackName for Congas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Congas", "congas trackName"),
//: longName for Congas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Congas", "congas longName"),
//: shortName for Congas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Con.", "congas shortName"),

//: description for Cuica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cuica.", "cuica description"),
//: trackName for Cuica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cuica", "cuica trackName"),
//: longName for Cuica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cuica", "cuica longName"),
//: shortName for Cuica; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cu.", "cuica shortName"),

//: description for Large Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Drum Kit.", "drumset description"),
//: trackName for Large Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Large Drum Kit", "drumset trackName"),
//: longName for Large Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Drum Kit", "drumset longName"),
//: shortName for Large Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D. Kit", "drumset shortName"),

//: description for 4-Piece Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "4 piece drum kit.", "drum-kit-4 description"),
//: trackName for 4-Piece Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "4-Piece Drum Kit", "drum-kit-4 trackName"),
//: longName for 4-Piece Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Drum Kit", "drum-kit-4 longName"),
//: shortName for 4-Piece Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D. Kit", "drum-kit-4 shortName"),

//: description for 5-Piece Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5 piece drum kit.", "drum-kit-5 description"),
//: trackName for 5-Piece Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-Piece Drum Kit", "drum-kit-5 trackName"),
//: longName for 5-Piece Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Drum Kit", "drum-kit-5 longName"),
//: shortName for 5-Piece Drum Kit; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D. Kit", "drum-kit-5 shortName"),

//: description for Field Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Military field drum.", "military-drum description"),
//: trackName for Field Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Field Drum", "military-drum trackName"),
//: longName for Field Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Field Drum", "military-drum longName"),
//: shortName for Field Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Field Dr.", "military-drum shortName"),

//: description for Frame Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Frame drum.", "frame-drum description"),
//: trackName for Frame Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Frame Drum", "frame-drum trackName"),
//: longName for Frame Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Frame Drum", "frame-drum longName"),
//: shortName for Frame Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fr. Dr.", "frame-drum shortName"),

//: description for Piccolo Snare; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo snare drum.", "piccolo-snare-drum description"),
//: trackName for Piccolo Snare; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Snare", "piccolo-snare-drum trackName"),
//: longName for Piccolo Snare; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Snare", "piccolo-snare-drum longName"),
//: shortName for Piccolo Snare; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Picc. Sn.", "piccolo-snare-drum shortName"),

//: description for Slit Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slit drum.", "slit-drum description"),
//: trackName for Slit Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slit Drum", "slit-drum trackName"),
//: longName for Slit Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slit Drum", "slit-drum longName"),
//: shortName for Slit Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slt. Dr.", "slit-drum shortName"),

//: description for Tablas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pair of twin hand drums used in Indian classical music.", "tablas description"),
//: trackName for Tablas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tablas", "tablas trackName"),
//: longName for Tablas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tablas", "tablas longName"),
//: shortName for Tablas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tbs.", "tablas shortName"),

//: description for Timbales; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Timbales.", "timbales description"),
//: trackName for Timbales; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Timbales", "timbales trackName"),
//: longName for Timbales; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Timbales", "timbales longName"),
//: shortName for Timbales; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Timb.", "timbales shortName"),

//: description for Anvil; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Anvil.", "anvil description"),
//: trackName for Anvil; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Anvil", "anvil trackName"),
//: longName for Anvil; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Anvil", "anvil longName"),
//: shortName for Anvil; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Anv.", "anvil shortName"),

//: description for Bell Plate; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bell plate.", "bell-plate description"),
//: trackName for Bell Plate; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bell Plate", "bell-plate trackName"),
//: longName for Bell Plate; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bell Plate", "bell-plate longName"),
//: shortName for Bell Plate; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Be. Pla.", "bell-plate shortName"),

//: description for Bell Tree; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Inverted metal bowls nested on a vertical rod in order of pitch. The pitches are indefinite.", "bell-tree description"),
//: trackName for Bell Tree; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bell Tree", "bell-tree trackName"),
//: longName for Bell Tree; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bell Tree", "bell-tree longName"),
//: shortName for Bell Tree; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Be. Tr.", "bell-tree shortName"),

//: description for Bowl Gongs; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bowl gongs.", "bowl-gongs description"),
//: trackName for Bowl Gongs; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bowl Gongs", "bowl-gongs trackName"),
//: longName for Bowl Gongs; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bowl Gongs", "bowl-gongs longName"),
//: shortName for Bowl Gongs; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bw. Gon.", "bowl-gongs shortName"),

//: description for Chains; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chains.", "chains description"),
//: trackName for Chains; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chains", "chains trackName"),
//: longName for Chains; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chains", "chains longName"),
//: shortName for Chains; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chn.", "chains shortName"),

//: description for China Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "China cymbal for drum kit.", "chinese-cymbal description"),
//: trackName for China Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "China Cymbal", "chinese-cymbal trackName"),
//: longName for China Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "China Cymbal", "chinese-cymbal longName"),
//: shortName for China Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ch. Cym.", "chinese-cymbal shortName"),

//: description for Cowbell; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cowbell.", "cowbell description"),
//: trackName for Cowbell; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cowbell", "cowbell trackName"),
//: longName for Cowbell; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cowbell", "cowbell longName"),
//: shortName for Cowbell; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cwb.", "cowbell shortName"),

//: description for Suspended Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Suspended Cymbal.", "crash-cymbal description"),
//: trackName for Suspended Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Suspended Cymbal", "crash-cymbal trackName"),
//: longName for Suspended Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Suspended Cymbal", "crash-cymbal longName"),
//: shortName for Suspended Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sus. Cym.", "crash-cymbal shortName"),

//: description for Hand Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hand Cymbals.", "cymbal description"),
//: trackName for Hand Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hand Cymbals", "cymbal trackName"),
//: longName for Hand Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cymbals", "cymbal longName"),
//: shortName for Hand Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cym.", "cymbal shortName"),

//: description for Finger Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Finger cymbals of unspecified pitch.", "finger-cymbals description"),
//: trackName for Finger Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Finger Cymbals", "finger-cymbals trackName"),
//: longName for Finger Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Finger Cymbals", "finger-cymbals longName"),
//: shortName for Finger Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fi. Cym.", "finger-cymbals shortName"),

//: description for Hi-hat; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hi-hat. Combination of two cymbals and a pedal.", "hi-hat description"),
//: trackName for Hi-hat; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hi-hat", "hi-hat trackName"),
//: longName for Hi-hat; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hi-hat", "hi-hat longName"),
//: shortName for Hi-hat; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hi-hat", "hi-hat shortName"),

//: description for Iron Pipes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Iron pipes.", "iron-pipes description"),
//: trackName for Iron Pipes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Iron Pipes", "iron-pipes trackName"),
//: longName for Iron Pipes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Iron Pipes", "iron-pipes longName"),
//: shortName for Iron Pipes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ir. Pi.", "iron-pipes shortName"),

//: description for Mark Tree; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chimes hung from a horizontal bar in order of pitch. The pitches are indefinite.", "mark-tree description"),
//: trackName for Mark Tree; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mark Tree", "mark-tree trackName"),
//: longName for Mark Tree; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mark Tree", "mark-tree longName"),
//: shortName for Mark Tree; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mk. Tr.", "mark-tree shortName"),

//: description for Metal Castanets; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metal castanets.", "metal-castanets description"),
//: trackName for Metal Castanets; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metal Castanets", "metal-castanets trackName"),
//: longName for Metal Castanets; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metal Castanets", "metal-castanets longName"),
//: shortName for Metal Castanets; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Met. Cst.", "metal-castanets shortName"),

//: description for Metal Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metal wind chimes.", "metal-wind-chimes description"),
//: trackName for Metal Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metal Wind Chimes", "metal-wind-chimes trackName"),
//: longName for Metal Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metal Wind Chimes", "metal-wind-chimes longName"),
//: shortName for Metal Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Met. Wn Ch.", "metal-wind-chimes shortName"),

//: description for Ride Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ride cymbal.", "ride-cymbal description"),
//: trackName for Ride Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ride Cymbal", "ride-cymbal trackName"),
//: longName for Ride Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ride Cymbal", "ride-cymbal longName"),
//: shortName for Ride Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "R. Cym.", "ride-cymbal shortName"),

//: description for Sleigh Bells; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sleigh bells.", "sleigh-bells description"),
//: trackName for Sleigh Bells; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sleigh Bells", "sleigh-bells trackName"),
//: longName for Sleigh Bells; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sleigh Bells", "sleigh-bells longName"),
//: shortName for Sleigh Bells; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sle. Be.", "sleigh-bells shortName"),

//: description for Splash Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Splash cymbal.", "splash-cymbal description"),
//: trackName for Splash Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Splash Cymbal", "splash-cymbal trackName"),
//: longName for Splash Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Splash Cymbal", "splash-cymbal longName"),
//: shortName for Splash Cymbal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sp. Cym.", "splash-cymbal shortName"),

//: description for Tam-tam; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Large unpitched gong.", "tam-tam description"),
//: trackName for Tam-tam; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tam-tam", "tam-tam trackName"),
//: longName for Tam-tam; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tam-tam", "tam-tam longName"),
//: shortName for Tam-tam; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tam", "tam-tam shortName"),

//: description for Thundersheet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Thundersheet.", "thundersheet description"),
//: trackName for Thundersheet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Thundersheet", "thundersheet trackName"),
//: longName for Thundersheet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Thundersheet", "thundersheet longName"),
//: shortName for Thundersheet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Thu.", "thundersheet shortName"),

//: description for Triangle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Triangle.", "triangle description"),
//: trackName for Triangle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Triangle", "triangle trackName"),
//: longName for Triangle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Triangle", "triangle longName"),
//: shortName for Triangle; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Trgl.", "triangle shortName"),

//: description for Bamboo Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bamboo wind chimes.", "bamboo-wind-chimes description"),
//: trackName for Bamboo Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bamboo Wind Chimes", "bamboo-wind-chimes trackName"),
//: longName for Bamboo Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bamboo Wind Chimes", "bamboo-wind-chimes longName"),
//: shortName for Bamboo Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bam. Wn. Ch.", "bamboo-wind-chimes shortName"),

//: description for Castanets; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Castanets.", "castanets description"),
//: trackName for Castanets; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Castanets", "castanets trackName"),
//: longName for Castanets; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Castanets", "castanets longName"),
//: shortName for Castanets; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cst.", "castanets shortName"),

//: description for Claves; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Claves.", "claves description"),
//: trackName for Claves; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Claves", "claves trackName"),
//: longName for Claves; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Claves", "claves longName"),
//: shortName for Claves; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clv.", "claves shortName"),

//: description for Güiro; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Güiro.", "guiro description"),
//: trackName for Güiro; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Güiro", "guiro trackName"),
//: longName for Güiro; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Güiro", "guiro longName"),
//: shortName for Güiro; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gro.", "guiro shortName"),

//: description for Temple Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Temple blocks, sometimes known as Chinese temple blocks or wooden bells.", "temple-blocks description"),
//: trackName for Temple Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Temple Blocks", "temple-blocks trackName"),
//: longName for Temple Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Temple Blocks", "temple-blocks longName"),
//: shortName for Temple Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tmp. Bl.", "temple-blocks shortName"),

//: description for Wood Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wood blocks.", "wood-blocks description"),
//: trackName for Wood Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wood Blocks", "wood-blocks trackName"),
//: longName for Wood Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wood Blocks", "wood-blocks longName"),
//: shortName for Wood Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wd. Bl.", "wood-blocks shortName"),

//: description for Wooden Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wooden wind chimes.", "wooden-wind-chimes description"),
//: trackName for Wooden Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wooden Wind Chimes", "wooden-wind-chimes trackName"),
//: longName for Wooden Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wooden Wind Chimes", "wooden-wind-chimes longName"),
//: shortName for Wooden Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wd. Wn. Ch.", "wooden-wind-chimes shortName"),

//: description for Cabasa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cabasa.", "cabasa description"),
//: trackName for Cabasa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cabasa", "cabasa trackName"),
//: longName for Cabasa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cabasa", "cabasa longName"),
//: shortName for Cabasa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cabs.", "cabasa shortName"),

//: description for Glass Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glass wind chimes.", "glass-wind-chimes description"),
//: trackName for Glass Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glass Wind Chimes", "glass-wind-chimes trackName"),
//: longName for Glass Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Glass Wind Chimes", "glass-wind-chimes longName"),
//: shortName for Glass Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Gl. Wn Ch.", "glass-wind-chimes shortName"),

//: description for Maracas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Maracas.", "maracas description"),
//: trackName for Maracas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Maracas", "maracas trackName"),
//: longName for Maracas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Maracas", "maracas longName"),
//: shortName for Maracas; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mrcs.", "maracas shortName"),

//: description for Percussion; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Orchestral percussion drumset.", "percussion description"),
//: trackName for Percussion; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Percussion", "percussion trackName"),
//: longName for Percussion; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Percussion", "percussion longName"),
//: shortName for Percussion; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Perc.", "percussion shortName"),

//: description for Quijada; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Dried donkey or horse jawbone, traditionally used as a rattle in some Latin American countries.", "quijada description"),
//: trackName for Quijada; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Quijada", "quijada trackName"),
//: longName for Quijada; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Quijada", "quijada longName"),
//: shortName for Quijada; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Qui.", "quijada shortName"),

//: description for Ratchet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ratchet, also known as a rattle.", "ratchet description"),
//: trackName for Ratchet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ratchet", "ratchet trackName"),
//: longName for Ratchet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ratchet", "ratchet longName"),
//: shortName for Ratchet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rat.", "ratchet shortName"),

//: description for Sandpaper Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pair of blocks wrapped in sandpaper, played by rubbing together.", "sandpaper-blocks description"),
//: trackName for Sandpaper Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sandpaper Blocks", "sandpaper-blocks trackName"),
//: longName for Sandpaper Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sandpaper Blocks", "sandpaper-blocks longName"),
//: shortName for Sandpaper Blocks; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sa. Bl.", "sandpaper-blocks shortName"),

//: description for Shaker; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shaker.", "shaker description"),
//: trackName for Shaker; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shaker", "shaker trackName"),
//: longName for Shaker; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shaker", "shaker longName"),
//: shortName for Shaker; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sh.", "shaker shortName"),

//: description for Shell Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shell wind chimes.", "shell-wind-chimes description"),
//: trackName for Shell Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shell Wind Chimes", "shell-wind-chimes trackName"),
//: longName for Shell Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shell Wind Chimes", "shell-wind-chimes longName"),
//: shortName for Shell Wind Chimes; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sh. Wn Ch.", "shell-wind-chimes shortName"),

//: description for Stones; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Stones.", "stones description"),
//: trackName for Stones; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Stones", "stones trackName"),
//: longName for Stones; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Stones", "stones longName"),
//: shortName for Stones; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sto.", "stones shortName"),

//: description for Tambourine; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tambourine.", "tambourine description"),
//: trackName for Tambourine; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tambourine", "tambourine trackName"),
//: longName for Tambourine; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tambourine", "tambourine longName"),
//: shortName for Tambourine; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tamb.", "tambourine shortName"),

//: description for Tubo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Large shaker in the form of a tube.", "tubo description"),
//: trackName for Tubo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tubo", "tubo trackName"),
//: longName for Tubo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tubo", "tubo longName"),
//: shortName for Tubo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tu.", "tubo shortName"),

//: description for Vibraslap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vibraslap.", "vibraslap description"),
//: trackName for Vibraslap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vibraslap", "vibraslap trackName"),
//: longName for Vibraslap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vibraslap", "vibraslap longName"),
//: shortName for Vibraslap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vibslp.", "vibraslap shortName"),

//: description for Whip; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Two wooden boards joined by a hinge, played by being brought together rapidly. Also known as a slap stick.", "whip description"),
//: trackName for Whip; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Whip", "whip trackName"),
//: longName for Whip; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Whip", "whip longName"),
//: shortName for Whip; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Wh.", "whip shortName"),

// Percussion - Marching
QT_TRANSLATE_NOOP("engraving/instruments/group", "Percussion - Marching"),

//: description for Marching Snare Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marching snare drum.", "marching-snare description"),
//: trackName for Marching Snare Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marching Snare Drum", "marching-snare trackName"),
//: longName for Marching Snare Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Snare Drum", "marching-snare longName"),
//: shortName for Marching Snare Drum; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S.D.", "marching-snare shortName"),

//: description for Marching Tenor Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marching tenor drums.", "marching-tenor-drums description"),
//: trackName for Marching Tenor Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marching Tenor Drums", "marching-tenor-drums trackName"),
//: longName for Marching Tenor Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Drums", "marching-tenor-drums longName"),
//: shortName for Marching Tenor Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T.D.", "marching-tenor-drums shortName"),

//: description for Marching Bass Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marching bass drums.", "marching-bass-drums description"),
//: trackName for Marching Bass Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marching Bass Drums", "marching-bass-drums trackName"),
//: longName for Marching Bass Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Drums", "marching-bass-drums longName"),
//: shortName for Marching Bass Drums; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B.D.", "marching-bass-drums shortName"),

//: description for Marching Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marching cymbals.", "marching-cymbals description"),
//: trackName for Marching Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Marching Cymbals", "marching-cymbals trackName"),
//: longName for Marching Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cymbals", "marching-cymbals longName"),
//: shortName for Marching Cymbals; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cym.", "marching-cymbals shortName"),

// Percussion - Body
QT_TRANSLATE_NOOP("engraving/instruments/group", "Percussion - Body"),

//: description for Finger Snap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Finger snap.", "finger-snap description"),
//: trackName for Finger Snap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Finger Snap", "finger-snap trackName"),
//: longName for Finger Snap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Finger Snap", "finger-snap longName"),
//: shortName for Finger Snap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fi. Sna.", "finger-snap shortName"),

//: description for Hand Clap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hand clap.", "hand-clap description"),
//: trackName for Hand Clap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hand Clap", "hand-clap trackName"),
//: longName for Hand Clap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hand Clap", "hand-clap longName"),
//: shortName for Hand Clap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hd. Clp.", "hand-clap shortName"),

//: description for Slap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hand slap.", "slap description"),
//: trackName for Slap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slap", "slap trackName"),
//: longName for Slap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Slap", "slap longName"),
//: shortName for Slap; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sla.", "slap shortName"),

//: description for Stamp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Foot stamp.", "stamp description"),
//: trackName for Stamp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Stamp", "stamp trackName"),
//: longName for Stamp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Stamp", "stamp longName"),
//: shortName for Stamp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sta.", "stamp shortName"),

// Vocals
QT_TRANSLATE_NOOP("engraving/instruments/group", "Vocals"),

//: description for Boy Soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Boy soprano voice.", "boy-soprano description"),
//: trackName for Boy Soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Boy Soprano", "boy-soprano trackName"),
//: longName for Boy Soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Boy Soprano", "boy-soprano longName"),
//: shortName for Boy Soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. S.", "boy-soprano shortName"),

//: description for Soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano voice.", "soprano description"),
//: trackName for Soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano", "soprano trackName"),
//: longName for Soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano", "soprano longName"),
//: shortName for Soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S.", "soprano shortName"),

//: description for Soprano (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano voice (notated in C clef).", "soprano-c-clef description"),
//: trackName for Soprano (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano (C clef)", "soprano-c-clef trackName"),
//: longName for Soprano (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano", "soprano-c-clef longName"),
//: shortName for Soprano (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S.", "soprano-c-clef shortName"),

//: description for Mezzo-soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mezzo-soprano voice.", "mezzo-soprano description"),
//: trackName for Mezzo-soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mezzo-soprano", "mezzo-soprano trackName"),
//: longName for Mezzo-soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mezzo-soprano", "mezzo-soprano longName"),
//: shortName for Mezzo-soprano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mzs.", "mezzo-soprano shortName"),

//: description for Mezzo-soprano (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mezzo-soprano voice (notated in C clef).", "mezzo-soprano-c-clef description"),
//: trackName for Mezzo-soprano (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mezzo-soprano (C clef)", "mezzo-soprano-c-clef trackName"),
//: longName for Mezzo-soprano (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mezzo-soprano", "mezzo-soprano-c-clef longName"),
//: shortName for Mezzo-soprano (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mzs.", "mezzo-soprano-c-clef shortName"),

//: description for Countertenor; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Counter tenor or male alto voice.", "countertenor description"),
//: trackName for Countertenor; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Countertenor", "countertenor trackName"),
//: longName for Countertenor; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Countertenor", "countertenor longName"),
//: shortName for Countertenor; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ct.", "countertenor shortName"),

//: description for Alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto voice.", "alto description"),
//: trackName for Alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto", "alto trackName"),
//: longName for Alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto", "alto longName"),
//: shortName for Alto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A.", "alto shortName"),

//: description for Alto (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto voice (notated in C clef).", "alto-c-clef description"),
//: trackName for Alto (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto (C clef)", "alto-c-clef trackName"),
//: longName for Alto (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto", "alto-c-clef longName"),
//: shortName for Alto (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A.", "alto-c-clef shortName"),

//: description for Contralto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Female alto voice.", "contralto description"),
//: trackName for Contralto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contralto", "contralto trackName"),
//: longName for Contralto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contralto", "contralto longName"),
//: shortName for Contralto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contr.", "contralto shortName"),

//: description for Tenor; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor voice.", "tenor description"),
//: trackName for Tenor; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor", "tenor trackName"),
//: longName for Tenor; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor", "tenor longName"),
//: shortName for Tenor; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T.", "tenor shortName"),

//: description for Tenor (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor voice (notated in C clef).", "tenor-c-clef description"),
//: trackName for Tenor (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor (C clef)", "tenor-c-clef trackName"),
//: longName for Tenor (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor", "tenor-c-clef longName"),
//: shortName for Tenor (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T.", "tenor-c-clef shortName"),

//: description for Baritone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone voice.", "baritone description"),
//: trackName for Baritone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone", "baritone trackName"),
//: longName for Baritone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone", "baritone longName"),
//: shortName for Baritone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar.", "baritone shortName"),

//: description for Baritone (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone voice (notated in C clef).", "baritone-c-clef description"),
//: trackName for Baritone (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone (C clef)", "baritone-c-clef trackName"),
//: longName for Baritone (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone", "baritone-c-clef longName"),
//: shortName for Baritone (C clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar.", "baritone-c-clef shortName"),

//: description for Voice; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Voice (unspecified type).", "voice description"),
//: trackName for Voice; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Voice", "voice trackName"),
//: longName for Voice; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Voice", "voice longName"),
//: shortName for Voice; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vo.", "voice shortName"),

//: description for Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass voice.", "bass description"),
//: trackName for Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass", "bass trackName"),
//: longName for Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass", "bass longName"),
//: shortName for Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B.", "bass shortName"),

//: description for Women; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Women’s voices.", "women description"),
//: trackName for Women; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Women", "women trackName"),
//: longName for Women; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Women", "women longName"),
//: shortName for Women; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "W.", "women shortName"),
//: channel for Women; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano", "women channel"),
//: channel for Women; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto", "women channel"),

//: description for Men; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Men’s voices.", "men description"),
//: trackName for Men; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Men", "men trackName"),
//: longName for Men; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Men", "men longName"),
//: shortName for Men; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "M.", "men shortName"),
//: channel for Men; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor", "men channel"),
//: channel for Men; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass", "men channel"),

//: description for Kazoo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kazoo.", "kazoo description"),
//: trackName for Kazoo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kazoo", "kazoo trackName"),
//: longName for Kazoo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kazoo", "kazoo longName"),
//: shortName for Kazoo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Kaz.", "kazoo shortName"),

// Keyboards
QT_TRANSLATE_NOOP("engraving/instruments/group", "Keyboards"),

//: description for Celesta; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Celesta.", "celesta description"),
//: trackName for Celesta; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Celesta", "celesta trackName"),
//: longName for Celesta; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Celesta", "celesta longName"),
//: shortName for Celesta; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cel.", "celesta shortName"),

//: description for Clavichord; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clavichord.", "clavichord description"),
//: trackName for Clavichord; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clavichord", "clavichord trackName"),
//: longName for Clavichord; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clavichord", "clavichord longName"),
//: shortName for Clavichord; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cch.", "clavichord shortName"),

//: description for Clavinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electrically amplified clavichord.", "clavinet description"),
//: trackName for Clavinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clavinet", "clavinet trackName"),
//: longName for Clavinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clavinet", "clavinet longName"),
//: shortName for Clavinet; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Clav.", "clavinet shortName"),

//: description for Harpsichord; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harpsichord.", "harpsichord description"),
//: trackName for Harpsichord; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harpsichord", "harpsichord trackName"),
//: longName for Harpsichord; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harpsichord", "harpsichord longName"),
//: shortName for Harpsichord; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hch.", "harpsichord shortName"),

//: description for Virginal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Virginal.", "virginal description"),
//: trackName for Virginal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Virginal", "virginal trackName"),
//: longName for Virginal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Virginal", "virginal longName"),
//: shortName for Virginal; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vir.", "virginal shortName"),

//: description for Electric Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric piano.", "electric-piano description"),
//: trackName for Electric Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Piano", "electric-piano trackName"),
//: longName for Electric Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Piano", "electric-piano longName"),
//: shortName for Electric Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "El. Pno.", "electric-piano shortName"),

//: description for Grand Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Specifically a grand piano.", "grand-piano description"),
//: trackName for Grand Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Grand Piano", "grand-piano trackName"),
//: longName for Grand Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Grand Piano", "grand-piano longName"),
//: shortName for Grand Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pno.", "grand-piano shortName"),

//: description for Honky Tonk Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Honky-tonk (very out of tune) piano.", "honky-tonk-piano description"),
//: trackName for Honky Tonk Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Honky Tonk Piano", "honky-tonk-piano trackName"),
//: longName for Honky Tonk Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Honky Tonk Piano", "honky-tonk-piano longName"),
//: shortName for Honky Tonk Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hnk. Pno.", "honky-tonk-piano shortName"),

//: description for Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piano.", "piano description"),
//: trackName for Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piano", "piano trackName"),
//: longName for Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piano", "piano longName"),
//: shortName for Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pno.", "piano shortName"),

//: description for Toy Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Toy piano.", "toy-piano description"),
//: trackName for Toy Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Toy Piano", "toy-piano trackName"),
//: longName for Toy Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Toy Piano", "toy-piano longName"),
//: shortName for Toy Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Toy Pno.", "toy-piano shortName"),

//: description for Upright Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Specifically an upright piano.", "upright-piano description"),
//: trackName for Upright Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Upright Piano", "upright-piano trackName"),
//: longName for Upright Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Upright Piano", "upright-piano longName"),
//: shortName for Upright Piano; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pno.", "upright-piano shortName"),

//: description for Hammond Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hammond electronic organ.", "hammond-organ description"),
//: trackName for Hammond Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hammond Organ", "hammond-organ trackName"),
//: longName for Hammond Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hammond Organ", "hammond-organ longName"),
//: shortName for Hammond Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hm. Org.", "hammond-organ shortName"),

//: description for Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Organ (generic).", "organ description"),
//: trackName for Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Organ", "organ trackName"),
//: longName for Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Organ", "organ longName"),
//: shortName for Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Org.", "organ shortName"),

//: description for Percussive Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electronic organ with percussion feature.", "percussive-organ description"),
//: trackName for Percussive Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Percussive Organ", "percussive-organ trackName"),
//: longName for Percussive Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Percussive Organ", "percussive-organ longName"),
//: shortName for Percussive Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Perc. Org.", "percussive-organ shortName"),

//: description for Pipe Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pipe organ.", "pipe-organ description"),
//: trackName for Pipe Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pipe Organ", "pipe-organ trackName"),
//: longName for Pipe Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pipe Organ", "pipe-organ longName"),
//: shortName for Pipe Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Org.", "pipe-organ shortName"),

//: description for Rotary Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hammond organ with Leslie rotary speaker.", "rotary-organ description"),
//: trackName for Rotary Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rotary Organ", "rotary-organ trackName"),
//: longName for Rotary Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rotary Organ", "rotary-organ longName"),
//: shortName for Rotary Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rot. Org.", "rotary-organ shortName"),

//: description for Harmonium; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harmonium.", "harmonium description"),
//: trackName for Harmonium; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harmonium", "harmonium trackName"),
//: longName for Harmonium; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harmonium", "harmonium longName"),
//: shortName for Harmonium; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harm.", "harmonium shortName"),

//: description for Reed Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Reed organ.", "reed-organ description"),
//: trackName for Reed Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Reed Organ", "reed-organ trackName"),
//: longName for Reed Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Reed Organ", "reed-organ longName"),
//: shortName for Reed Organ; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rd. Org.", "reed-organ shortName"),

// Electronic
QT_TRANSLATE_NOOP("engraving/instruments/group", "Electronic"),

//: description for Mallet Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mallet synthesizer.", "mallet-synthesizer description"),
//: trackName for Mallet Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mallet Synthesizer", "mallet-synthesizer trackName"),
//: longName for Mallet Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mallet Synthesizer", "mallet-synthesizer longName"),
//: shortName for Mallet Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mal. Syn.", "mallet-synthesizer shortName"),

//: description for Ondes Martenot; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ondes Martenot.", "ondes-martenot description"),
//: trackName for Ondes Martenot; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ondes Martenot", "ondes-martenot trackName"),
//: longName for Ondes Martenot; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ondes Martenot", "ondes-martenot longName"),
//: shortName for Ondes Martenot; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O.M.", "ondes-martenot shortName"),

//: description for Percussion Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Percussion synthesizer.", "percussion-synthesizer description"),
//: trackName for Percussion Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Percussion Synthesizer", "percussion-synthesizer trackName"),
//: longName for Percussion Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Percussion Synthesizer", "percussion-synthesizer longName"),
//: shortName for Percussion Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Perc. Syn.", "percussion-synthesizer shortName"),

//: description for Atmosphere Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Atmosphere synth effect (General MIDI program 100).", "atmosphere-synth description"),
//: trackName for Atmosphere Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Atmosphere Synthesizer", "atmosphere-synth trackName"),
//: longName for Atmosphere Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Atmosphere Synthesizer", "atmosphere-synth longName"),
//: shortName for Atmosphere Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "atmosphere-synth shortName"),

//: description for Bass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass synthesizer.", "bass-synthesizer description"),
//: trackName for Bass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Synthesizer", "bass-synthesizer trackName"),
//: longName for Bass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Synthesizer", "bass-synthesizer longName"),
//: shortName for Bass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "bass-synthesizer shortName"),
//: channel for Bass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "synth-bass-1", "bass-synthesizer channel"),
//: channel for Bass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "synth-bass-2", "bass-synthesizer channel"),

//: description for Bowed Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bowed synth pad (General MIDI program 93).", "bowed-synth description"),
//: trackName for Bowed Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bowed Synthesizer", "bowed-synth trackName"),
//: longName for Bowed Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bowed Synthesizer", "bowed-synth longName"),
//: shortName for Bowed Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "bowed-synth shortName"),

//: description for Brass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brass synthesizer.", "brass-synthesizer description"),
//: trackName for Brass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brass Synthesizer", "brass-synthesizer trackName"),
//: longName for Brass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brass Synthesizer", "brass-synthesizer longName"),
//: shortName for Brass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "brass-synthesizer shortName"),
//: channel for Brass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "synth-brass-1", "brass-synthesizer channel"),
//: channel for Brass Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "synth-brass-2", "brass-synthesizer channel"),

//: description for Brightness Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brightness synth effect (General MIDI program 101).", "brightness-synth description"),
//: trackName for Brightness Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brightness Synthesizer", "brightness-synth trackName"),
//: longName for Brightness Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brightness Synthesizer", "brightness-synth longName"),
//: shortName for Brightness Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "brightness-synth shortName"),

//: description for Choir Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Choir synth pad (General MIDI program 92).", "choir-synth description"),
//: trackName for Choir Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Choir Synthesizer", "choir-synth trackName"),
//: longName for Choir Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Choir Synthesizer", "choir-synth longName"),
//: shortName for Choir Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "choir-synth shortName"),

//: description for Crystal Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crystal synth effect (General MIDI program 99).", "crystal-synth description"),
//: trackName for Crystal Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crystal Synthesizer", "crystal-synth trackName"),
//: longName for Crystal Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Crystal Synthesizer", "crystal-synth longName"),
//: shortName for Crystal Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "crystal-synth shortName"),

//: description for Echoes Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Echoes synth effect (General MIDI program 103).", "echoes-synth description"),
//: trackName for Echoes Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Echoes Synthesizer", "echoes-synth trackName"),
//: longName for Echoes Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Echoes Synthesizer", "echoes-synth longName"),
//: shortName for Echoes Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "echoes-synth shortName"),

//: description for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "General MIDI effect synthesizer (generic).", "effect-synth description"),
//: trackName for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Effect Synthesizer", "effect-synth trackName"),
//: longName for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Effect Synthesizer", "effect-synth longName"),
//: shortName for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "effect-synth shortName"),
//: channel for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "rain", "effect-synth channel"),
//: channel for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "soundtrack", "effect-synth channel"),
//: channel for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "crystal", "effect-synth channel"),
//: channel for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "atmosphere", "effect-synth channel"),
//: channel for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "brightness", "effect-synth channel"),
//: channel for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "goblins", "effect-synth channel"),
//: channel for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "echoes", "effect-synth channel"),
//: channel for Effect Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "scifi", "effect-synth channel"),

//: description for Goblins Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Goblins synth effect (General MIDI program 102).", "goblins-synth description"),
//: trackName for Goblins Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Goblins Synthesizer", "goblins-synth trackName"),
//: longName for Goblins Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Goblins Synthesizer", "goblins-synth longName"),
//: shortName for Goblins Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "goblins-synth shortName"),

//: description for Halo Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Halo synth pad (General MIDI program 95).", "halo-synth description"),
//: trackName for Halo Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Halo Synthesizer", "halo-synth trackName"),
//: longName for Halo Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Halo Synthesizer", "halo-synth longName"),
//: shortName for Halo Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "halo-synth shortName"),

//: description for Metallic Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metallic synth pad (General MIDI program 94).", "metallic-synth description"),
//: trackName for Metallic Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metallic Synthesizer", "metallic-synth trackName"),
//: longName for Metallic Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Metallic Synthesizer", "metallic-synth longName"),
//: shortName for Metallic Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "metallic-synth shortName"),

//: description for New Age Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "New age synth pad (General MIDI program 89).", "new-age-synth description"),
//: trackName for New Age Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "New Age Synthesizer", "new-age-synth trackName"),
//: longName for New Age Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "New Age Synthesizer", "new-age-synth longName"),
//: shortName for New Age Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "new-age-synth shortName"),

//: description for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "General MIDI synth pad (generic).", "pad-synth description"),
//: trackName for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pad Synthesizer", "pad-synth trackName"),
//: longName for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pad Synthesizer", "pad-synth longName"),
//: shortName for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "pad-synth shortName"),
//: channel for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "new age", "pad-synth channel"),
//: channel for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "warm", "pad-synth channel"),
//: channel for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "polysynth", "pad-synth channel"),
//: channel for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "choir", "pad-synth channel"),
//: channel for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "bowed", "pad-synth channel"),
//: channel for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "metallic", "pad-synth channel"),
//: channel for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "halo", "pad-synth channel"),
//: channel for Pad Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "sweep", "pad-synth channel"),

//: description for Poly Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Polysynth synth pad (General MIDI program 91).", "poly-synth description"),
//: trackName for Poly Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Poly Synthesizer", "poly-synth trackName"),
//: longName for Poly Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Poly Synthesizer", "poly-synth longName"),
//: shortName for Poly Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "poly-synth shortName"),

//: description for Rain Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rain synth effect (General MIDI program 97).", "rain-synth description"),
//: trackName for Rain Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rain Synthesizer", "rain-synth trackName"),
//: longName for Rain Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Rain Synthesizer", "rain-synth longName"),
//: shortName for Rain Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "rain-synth shortName"),

//: description for Saw Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sawtooth wave synthesizer.", "saw-synth description"),
//: trackName for Saw Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saw Synthesizer", "saw-synth trackName"),
//: longName for Saw Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Saw Synthesizer", "saw-synth longName"),
//: shortName for Saw Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "saw-synth shortName"),

//: description for Sci-fi Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sci-fi synth effect (General MIDI program 104).", "sci-fi-synth description"),
//: trackName for Sci-fi Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sci-fi Synthesizer", "sci-fi-synth trackName"),
//: longName for Sci-fi Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sci-fi Synthesizer", "sci-fi-synth longName"),
//: shortName for Sci-fi Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "sci-fi-synth shortName"),

//: description for Sine Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sine wave synthesizer.", "sine-synth description"),
//: trackName for Sine Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sine Synthesizer", "sine-synth trackName"),
//: longName for Sine Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sine Synthesizer", "sine-synth longName"),
//: shortName for Sine Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "sine-synth shortName"),

//: description for Soundtrack Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soundtrack synth effect (General MIDI program 98).", "soundtrack-synth description"),
//: trackName for Soundtrack Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soundtrack Synthesizer", "soundtrack-synth trackName"),
//: longName for Soundtrack Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soundtrack Synthesizer", "soundtrack-synth longName"),
//: shortName for Soundtrack Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "soundtrack-synth shortName"),

//: description for Square Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Square wave synthesizer.", "square-synth description"),
//: trackName for Square Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Square Synthesizer", "square-synth trackName"),
//: longName for Square Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Square Synthesizer", "square-synth longName"),
//: shortName for Square Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "square-synth shortName"),

//: description for String Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "String synthesizer.", "string-synthesizer description"),
//: trackName for String Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "String Synthesizer", "string-synthesizer trackName"),
//: longName for String Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "String Synthesizer", "string-synthesizer longName"),
//: shortName for String Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "string-synthesizer shortName"),
//: channel for String Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "synth-string-1", "string-synthesizer channel"),
//: channel for String Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "synth-string-2", "string-synthesizer channel"),

//: description for Sweep Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sweep synth pad (General MIDI program 96).", "sweep-synth description"),
//: trackName for Sweep Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sweep Synthesizer", "sweep-synth trackName"),
//: longName for Sweep Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sweep Synthesizer", "sweep-synth longName"),
//: shortName for Sweep Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "sweep-synth shortName"),

//: description for Theremin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Theremin.", "theremin description"),
//: trackName for Theremin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Theremin", "theremin trackName"),
//: longName for Theremin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Theremin", "theremin longName"),
//: shortName for Theremin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Thmn.", "theremin shortName"),

//: description for Warm Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Warm synth pad (General MIDI program 90).", "warm-synth description"),
//: trackName for Warm Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Warm Synthesizer", "warm-synth trackName"),
//: longName for Warm Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Warm Synthesizer", "warm-synth longName"),
//: shortName for Warm Synthesizer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Synth.", "warm-synth shortName"),

// Strings - Plucked
QT_TRANSLATE_NOOP("engraving/instruments/group", "Strings - Plucked"),

//: description for Harp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harp.", "harp description"),
//: trackName for Harp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harp", "harp trackName"),
//: longName for Harp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Harp", "harp longName"),
//: shortName for Harp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Hrp.", "harp shortName"),
//: channel for Harp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "staccato", "harp channel"),
//: channel for Harp; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "flageoletti", "harp channel"),

//: description for Cavaquinho; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Small Portuguese 4-string guitar (staff notation).", "cavaquinho description"),
//: trackName for Cavaquinho; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cavaquinho", "cavaquinho trackName"),
//: longName for Cavaquinho; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cavaquinho", "cavaquinho longName"),
//: shortName for Cavaquinho; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cava.", "cavaquinho shortName"),

//: description for Cavaquinho (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Small Portuguese 4-string guitar (tablature).", "cavaquinho-tablature description"),
//: trackName for Cavaquinho (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cavaquinho (tablature)", "cavaquinho-tablature trackName"),
//: longName for Cavaquinho (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cavaquinho", "cavaquinho-tablature longName"),

//: description for Soprano Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano guitar.", "soprano-guitar description"),
//: trackName for Soprano Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Guitar", "soprano-guitar trackName"),
//: longName for Soprano Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Soprano Guitar", "soprano-guitar longName"),
//: shortName for Soprano Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "S. Guit.", "soprano-guitar shortName"),
//: channel for Soprano Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "soprano-guitar channel"),
//: channel for Soprano Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "soprano-guitar channel"),

//: description for Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto guitar.", "alto-guitar description"),
//: trackName for Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Guitar", "alto-guitar trackName"),
//: longName for Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Guitar", "alto-guitar longName"),
//: shortName for Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Guit.", "alto-guitar shortName"),
//: channel for Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "alto-guitar channel"),
//: channel for Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "alto-guitar channel"),

//: description for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric guitar (notated with 8va bassa treble clef).", "electric-guitar description"),
//: trackName for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Guitar", "electric-guitar trackName"),
//: longName for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Guitar", "electric-guitar longName"),
//: shortName for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "El. Guit.", "electric-guitar shortName"),
//: channel for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "electric-guitar channel"),
//: channel for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "electric-guitar channel"),
//: channel for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "jazz", "electric-guitar channel"),
//: channel for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "harmonics", "electric-guitar channel"),
//: channel for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "distortion", "electric-guitar channel"),
//: channel for Electric Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "overdriven", "electric-guitar channel"),

//: description for Electric Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric guitar (notated with normal treble clef).", "electric-guitar-treble-clef description"),
//: trackName for Electric Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Guitar (treble clef)", "electric-guitar-treble-clef trackName"),
//: longName for Electric Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Guitar", "electric-guitar-treble-clef longName"),
//: shortName for Electric Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "El. Guit.", "electric-guitar-treble-clef shortName"),

//: description for Acoustic Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic steel-string guitar (staff notation, with 8va bassa treble clef).", "guitar-steel description"),
//: trackName for Acoustic Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic Guitar", "guitar-steel trackName"),
//: longName for Acoustic Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic Guitar", "guitar-steel longName"),
//: shortName for Acoustic Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guit.", "guitar-steel shortName"),
//: channel for Acoustic Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "guitar-steel channel"),
//: channel for Acoustic Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "guitar-steel channel"),
//: channel for Acoustic Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "jazz", "guitar-steel channel"),

//: description for Acoustic Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic steel-string guitar (staff notation, with normal treble clef).", "guitar-steel-treble-clef description"),
//: trackName for Acoustic Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic Guitar (treble clef)", "guitar-steel-treble-clef trackName"),
//: longName for Acoustic Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guitar", "guitar-steel-treble-clef longName"),
//: shortName for Acoustic Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guit.", "guitar-steel-treble-clef shortName"),

//: description for Classical Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic nylon-string guitar (staff notation, with 8va bassa treble clef).", "guitar-nylon description"),
//: trackName for Classical Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Classical Guitar", "guitar-nylon trackName"),
//: longName for Classical Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Classical Guitar", "guitar-nylon longName"),
//: shortName for Classical Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guit.", "guitar-nylon shortName"),
//: channel for Classical Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "guitar-nylon channel"),
//: channel for Classical Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "guitar-nylon channel"),

//: description for Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic nylon-string guitar (staff notation, with normal treble clef).", "guitar-nylon-treble-clef description"),
//: trackName for Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guitar (treble clef)", "guitar-nylon-treble-clef trackName"),
//: longName for Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guitar", "guitar-nylon-treble-clef longName"),
//: shortName for Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guit.", "guitar-nylon-treble-clef shortName"),
//: channel for Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "guitar-nylon-treble-clef channel"),
//: channel for Guitar (treble clef); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "guitar-nylon-treble-clef channel"),

//: description for Electric Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric guitar (tablature).", "electric-guitar-tablature description"),
//: trackName for Electric Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Guitar (tablature)", "electric-guitar-tablature trackName"),
//: longName for Electric Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Guitar", "electric-guitar-tablature longName"),

//: description for Classical Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic nylon-string guitar (tablature).", "guitar-nylon-tablature description"),
//: trackName for Classical Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Classical Guitar (tablature)", "guitar-nylon-tablature trackName"),
//: longName for Classical Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Classical Guitar", "guitar-nylon-tablature longName"),

//: description for Acoustic Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic steel-string guitar (tablature).", "guitar-steel-tablature description"),
//: trackName for Acoustic Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic Guitar (tablature)", "guitar-steel-tablature trackName"),
//: longName for Acoustic Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guitar", "guitar-steel-tablature longName"),

//: description for Pedal Steel Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pedal steel guitar.", "pedal-steel-guitar description"),
//: trackName for Pedal Steel Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pedal Steel Guitar", "pedal-steel-guitar trackName"),
//: longName for Pedal Steel Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pedal Steel Guitar", "pedal-steel-guitar longName"),
//: shortName for Pedal Steel Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ped. St. Guit.", "pedal-steel-guitar shortName"),
//: channel for Pedal Steel Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "pedal-steel-guitar channel"),
//: channel for Pedal Steel Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "pedal-steel-guitar channel"),
//: channel for Pedal Steel Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "jazz", "pedal-steel-guitar channel"),

//: description for Baritone Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone guitar.", "baritone-guitar description"),
//: trackName for Baritone Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Guitar", "baritone-guitar trackName"),
//: longName for Baritone Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Guitar", "baritone-guitar longName"),
//: shortName for Baritone Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Guit.", "baritone-guitar shortName"),

//: description for Contra Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guitar with a second, fretless neck with up to nine bass strings. Developed in Vienna in the mid-19th century.", "contra-guitar description"),
//: trackName for Contra Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contra Guitar", "contra-guitar trackName"),
//: longName for Contra Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contra Guitar", "contra-guitar longName"),
//: shortName for Contra Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "C. Guit.", "contra-guitar shortName"),
//: channel for Contra Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "contra-guitar channel"),
//: channel for Contra Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "contra-guitar channel"),

//: description for 7-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "7-string guitar (staff notation).", "7-string-guitar description"),
//: trackName for 7-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "7-string Guitar", "7-string-guitar trackName"),
//: longName for 7-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "7-string Guitar", "7-string-guitar longName"),
//: shortName for 7-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Guit.", "7-string-guitar shortName"),

//: description for 7-string Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "7-string guitar (tablature).", "7-string-guitar-tablature description"),
//: trackName for 7-string Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "7-string Guitar (tablature)", "7-string-guitar-tablature trackName"),
//: longName for 7-string Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "7-string Guitar", "7-string-guitar-tablature longName"),

//: description for 11-string Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "11-string alto guitar.", "11-string-alto-guitar description"),
//: trackName for 11-string Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "11-string Alto Guitar", "11-string-alto-guitar trackName"),
//: longName for 11-string Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "11-string Alto Guitar", "11-string-alto-guitar longName"),
//: shortName for 11-string Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "11-str. A. Guit.", "11-string-alto-guitar shortName"),
//: channel for 11-string Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "11-string-alto-guitar channel"),
//: channel for 11-string Alto Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "11-string-alto-guitar channel"),

//: description for 12-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-string guitar.", "12-string-guitar description"),
//: trackName for 12-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-string Guitar", "12-string-guitar trackName"),
//: longName for 12-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-string Guitar", "12-string-guitar longName"),
//: shortName for 12-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "12-str. Guit.", "12-string-guitar shortName"),
//: channel for 12-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "open", "12-string-guitar channel"),
//: channel for 12-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "mute", "12-string-guitar channel"),
//: channel for 12-string Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "jazz", "12-string-guitar channel"),

//: description for 5-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-string electric bass guitar (staff notation).", "5-string-electric-bass description"),
//: trackName for 5-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-str. Electric Bass", "5-string-electric-bass trackName"),
//: longName for 5-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-str. Electric Bass", "5-string-electric-bass longName"),
//: shortName for 5-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "El. B.", "5-string-electric-bass shortName"),
//: channel for 5-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "slap", "5-string-electric-bass channel"),
//: channel for 5-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pop", "5-string-electric-bass channel"),

//: description for 5-str. Electric Bass (high C/tenor); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-string electric bass guitar, high C tuning (staff notation).", "5-string-electric-bass-high-c description"),
//: trackName for 5-str. Electric Bass (high C/tenor); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-str. Electric Bass (high C/tenor)", "5-string-electric-bass-high-c trackName"),
//: longName for 5-str. Electric Bass (high C/tenor); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-str. Electric Bass", "5-string-electric-bass-high-c longName"),
//: shortName for 5-str. Electric Bass (high C/tenor); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "El. B.", "5-string-electric-bass-high-c shortName"),
//: channel for 5-str. Electric Bass (high C/tenor); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "slap", "5-string-electric-bass-high-c channel"),
//: channel for 5-str. Electric Bass (high C/tenor); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pop", "5-string-electric-bass-high-c channel"),

//: description for 5-str. Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-string electric bass guitar (tablature).", "5-string-electric-bass-tab description"),
//: trackName for 5-str. Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-str. Electric Bass (tablature)", "5-string-electric-bass-tab trackName"),
//: longName for 5-str. Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-str. Electric Bass", "5-string-electric-bass-tab longName"),

//: description for 5-str. Electric Bass (high C/tenor) (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-string electric bass guitar, high C tuning (tablature).", "5-string-electric-bass-tab-high-c description"),
//: trackName for 5-str. Electric Bass (high C/tenor) (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-str. Electric Bass (high C/tenor) (tablature)", "5-string-electric-bass-tab-high-c trackName"),
//: longName for 5-str. Electric Bass (high C/tenor) (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-str. Electric Bass", "5-string-electric-bass-tab-high-c longName"),

//: description for 6-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-string electric bass guitar (staff notation).", "6-string-electric-bass description"),
//: trackName for 6-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-str. Electric Bass", "6-string-electric-bass trackName"),
//: longName for 6-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-str. Electric Bass", "6-string-electric-bass longName"),
//: shortName for 6-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "El. B.", "6-string-electric-bass shortName"),
//: channel for 6-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "slap", "6-string-electric-bass channel"),
//: channel for 6-str. Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pop", "6-string-electric-bass channel"),

//: description for 6-str. Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-string electric bass guitar (tablature).", "6-string-electric-bass-tab description"),
//: trackName for 6-str. Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-str. Electric Bass (tablature)", "6-string-electric-bass-tab trackName"),
//: longName for 6-str. Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-str. Electric Bass", "6-string-electric-bass-tab longName"),

//: description for Bass Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass guitar (staff notation).", "bass-guitar description"),
//: trackName for Bass Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Guitar", "bass-guitar trackName"),
//: longName for Bass Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Guitar", "bass-guitar longName"),
//: shortName for Bass Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Guit.", "bass-guitar shortName"),
//: channel for Bass Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "slap", "bass-guitar channel"),
//: channel for Bass Guitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pop", "bass-guitar channel"),

//: description for Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric bass guitar (staff notation).", "electric-bass description"),
//: trackName for Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Bass", "electric-bass trackName"),
//: longName for Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Bass", "electric-bass longName"),
//: shortName for Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "El. B.", "electric-bass shortName"),
//: channel for Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "slap", "electric-bass channel"),
//: channel for Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pop", "electric-bass channel"),

//: description for Fretless Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fretless electric bass guitar.", "fretless-electric-bass description"),
//: trackName for Fretless Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fretless Electric Bass", "fretless-electric-bass trackName"),
//: longName for Fretless Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Fretless Electric Bass", "fretless-electric-bass longName"),
//: shortName for Fretless Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Frtl. El. B.", "fretless-electric-bass shortName"),
//: channel for Fretless Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "slap", "fretless-electric-bass channel"),
//: channel for Fretless Electric Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pop", "fretless-electric-bass channel"),

//: description for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic bass guitar.", "acoustic-bass description"),
//: trackName for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic Bass", "acoustic-bass trackName"),
//: longName for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Acoustic Bass", "acoustic-bass longName"),
//: shortName for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass", "acoustic-bass shortName"),
//: channel for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "slap", "acoustic-bass channel"),
//: channel for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pop", "acoustic-bass channel"),
//: channel for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "acoustic-bass channel"),
//: channel for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "acoustic-bass channel"),
//: channel for Acoustic Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "acoustic-bass channel"),

//: description for Bass Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass guitar (tablature).", "bass-guitar-tablature description"),
//: trackName for Bass Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Guitar (tablature)", "bass-guitar-tablature trackName"),
//: longName for Bass Guitar (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Guitar", "bass-guitar-tablature longName"),

//: description for Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric bass guitar (tablature).", "electric-bass-4-str-tab description"),
//: trackName for Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Bass (tablature)", "electric-bass-4-str-tab trackName"),
//: longName for Electric Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Electric Bass", "electric-bass-4-str-tab longName"),

//: description for Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-string banjo (staff notation).", "banjo description"),
//: trackName for Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Banjo", "banjo trackName"),
//: longName for Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Banjo", "banjo longName"),
//: shortName for Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bj.", "banjo shortName"),

//: description for Tenor Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "4-string tenor banjo.", "tenor-banjo description"),
//: trackName for Tenor Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Banjo", "tenor-banjo trackName"),
//: longName for Tenor Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Banjo", "tenor-banjo longName"),
//: shortName for Tenor Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Bj.", "tenor-banjo shortName"),

//: description for Banjo (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-string banjo (tablature).", "banjo-tablature description"),
//: trackName for Banjo (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Banjo (tablature)", "banjo-tablature trackName"),
//: longName for Banjo (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Banjo", "banjo-tablature longName"),

//: description for Irish Tenor Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "4-string Irish tenor banjo (staff notation).", "irish-tenor-banjo description"),
//: trackName for Irish Tenor Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Irish Tenor Banjo", "irish-tenor-banjo trackName"),
//: longName for Irish Tenor Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Irish Tenor Banjo", "irish-tenor-banjo longName"),
//: shortName for Irish Tenor Banjo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "ITB", "irish-tenor-banjo shortName"),

//: description for Irish Tenor Banjo (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "4-string Irish tenor banjo (tablature).", "irish-tenor-banjo-tablature description"),
//: trackName for Irish Tenor Banjo (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Irish Tenor Banjo (tablature)", "irish-tenor-banjo-tablature trackName"),
//: longName for Irish Tenor Banjo (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Irish Tenor Banjo", "irish-tenor-banjo-tablature longName"),

//: description for Tenor Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor ukulele with bottom string tuned to G4.", "tenor-ukulele description"),
//: trackName for Tenor Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Ukulele", "tenor-ukulele trackName"),
//: longName for Tenor Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Ukulele", "tenor-ukulele longName"),
//: shortName for Tenor Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ten. Uk.", "tenor-ukulele shortName"),

//: description for Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Standard ukulele (staff notation).", "ukulele description"),
//: trackName for Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ukulele", "ukulele trackName"),
//: longName for Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ukulele", "ukulele longName"),
//: shortName for Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Uk.", "ukulele shortName"),

//: description for Ukulele (low G); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor ukulele with bottom string tuned to G3.", "ukulele-low-g description"),
//: trackName for Ukulele (low G); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ukulele (low G)", "ukulele-low-g trackName"),
//: longName for Ukulele (low G); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ukulele", "ukulele-low-g longName"),
//: shortName for Ukulele (low G); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Uk.", "ukulele-low-g shortName"),

//: description for Ukulele (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Standard ukulele (tablature).", "ukulele-4-str-tab description"),
//: trackName for Ukulele (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ukulele (tablature)", "ukulele-4-str-tab trackName"),
//: longName for Ukulele (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ukulele", "ukulele-4-str-tab longName"),

//: description for Baritone Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone ukulele.", "baritone-ukulele description"),
//: trackName for Baritone Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Ukulele", "baritone-ukulele trackName"),
//: longName for Baritone Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baritone Ukulele", "baritone-ukulele longName"),
//: shortName for Baritone Ukulele; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. Uk.", "baritone-ukulele shortName"),

//: description for Mandolin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandolin (staff notation).", "mandolin description"),
//: trackName for Mandolin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandolin", "mandolin trackName"),
//: longName for Mandolin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandolin", "mandolin longName"),
//: shortName for Mandolin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mdn.", "mandolin shortName"),

//: description for Mandolin (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandolin (tablature).", "mandolin-tablature description"),
//: trackName for Mandolin (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandolin (tablature)", "mandolin-tablature trackName"),
//: longName for Mandolin (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandolin", "mandolin-tablature longName"),

//: description for Alto Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Larger ancestor of the mandolin.", "alto-mandola description"),
//: trackName for Alto Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Mandola", "alto-mandola trackName"),
//: longName for Alto Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Mandola", "alto-mandola longName"),
//: shortName for Alto Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Mda.", "alto-mandola shortName"),

//: description for Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Larger ancestor of the mandolin.", "mandola description"),
//: trackName for Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandola", "mandola trackName"),
//: longName for Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandola", "mandola longName"),
//: shortName for Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mda.", "mandola shortName"),

//: description for Tenor Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Larger ancestor of the mandolin.", "tenor-mandola description"),
//: trackName for Tenor Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Mandola", "tenor-mandola trackName"),
//: longName for Tenor Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Mandola", "tenor-mandola longName"),
//: shortName for Tenor Mandola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Mda.", "tenor-mandola shortName"),

//: description for Octave Mandolin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Larger ancestor of the mandolin. Tuned an octave lower than the mandolin.", "octave-mandolin description"),
//: trackName for Octave Mandolin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Octave Mandolin", "octave-mandolin trackName"),
//: longName for Octave Mandolin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Octave Mandolin", "octave-mandolin longName"),
//: shortName for Octave Mandolin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "OM.", "octave-mandolin shortName"),

//: description for Mandocello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Larger ancestor of the mandolin. Tuned an octave lower than the standard mandola.", "mandocello description"),
//: trackName for Mandocello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandocello", "mandocello trackName"),
//: longName for Mandocello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mandocello", "mandocello longName"),
//: shortName for Mandocello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mncl.", "mandocello shortName"),

//: description for Mtn. Dulcimer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Also known as the Appalachian dulcimer, among other names. A fretted string instrument of the zither family. (Staff notation).", "mtn-dulcimer-std description"),
//: trackName for Mtn. Dulcimer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer", "mtn-dulcimer-std trackName"),
//: longName for Mtn. Dulcimer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer", "mtn-dulcimer-std longName"),
//: shortName for Mtn. Dulcimer; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dc.", "mtn-dulcimer-std shortName"),

//: description for Mtn. Dulcimer (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Also known as the Appalachian dulcimer, among other names. A fretted string instrument of the zither family. (Tablature).", "mtn-dulcimer-std-chrom-tab description"),
//: trackName for Mtn. Dulcimer (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer (tablature)", "mtn-dulcimer-std-chrom-tab trackName"),
//: longName for Mtn. Dulcimer (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer", "mtn-dulcimer-std-chrom-tab longName"),

//: description for Mtn. Dulcimer - Baritone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Larger version of the mountain or Appalachian dulcimer. (Staff notation).", "mtn-dulcimer-baritone description"),
//: trackName for Mtn. Dulcimer - Baritone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer - Baritone", "mtn-dulcimer-baritone trackName"),
//: longName for Mtn. Dulcimer - Baritone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer - Baritone", "mtn-dulcimer-baritone longName"),
//: shortName for Mtn. Dulcimer - Baritone; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bar. M.D.", "mtn-dulcimer-baritone shortName"),

//: description for Mtn. Dulcimer - Baritone (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Larger version of the mountain or Appalachian dulcimer. (Tablature).", "mtn-dulcimer-bartn-chrom-tab description"),
//: trackName for Mtn. Dulcimer - Baritone (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer - Baritone (tablature)", "mtn-dulcimer-bartn-chrom-tab trackName"),
//: longName for Mtn. Dulcimer - Baritone (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer - Baritone", "mtn-dulcimer-bartn-chrom-tab longName"),

//: description for Mtn. Dulcimer - Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Very large mountain or Appalachian dulcimer, an octave lower than the regular dulcimer. (Staff notation).", "mtn-dulcimer-bass description"),
//: trackName for Mtn. Dulcimer - Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer - Bass", "mtn-dulcimer-bass trackName"),
//: longName for Mtn. Dulcimer - Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer - Bass", "mtn-dulcimer-bass longName"),
//: shortName for Mtn. Dulcimer - Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bs. M.D.", "mtn-dulcimer-bass shortName"),

//: description for Mtn. Dulcimer - Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Very large mountain or Appalachian dulcimer, an octave lower than the regular dulcimer. (Tablature).", "mtn-dulcimer-bass-chrom-tab description"),
//: trackName for Mtn. Dulcimer - Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer - Bass (tablature)", "mtn-dulcimer-bass-chrom-tab trackName"),
//: longName for Mtn. Dulcimer - Bass (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Mtn. Dulcimer - Bass", "mtn-dulcimer-bass-chrom-tab longName"),

//: description for Lute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-course lute (staff notation).", "lute description"),
//: trackName for Lute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lute", "lute trackName"),
//: longName for Lute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lute", "lute longName"),
//: shortName for Lute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lt.", "lute shortName"),

//: description for Lute (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-course lute (tablature).", "lute-tablature description"),
//: trackName for Lute (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lute (tablature)", "lute-tablature trackName"),
//: longName for Lute (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lute", "lute-tablature longName"),

//: description for Tenor Lute; course: 5-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-course Renaissance tenor lute.", "ren.-tenor-lute-5-course description"),
//: trackName for Tenor Lute; course: 5-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-5-course trackName"),
//: longName for Tenor Lute; course: 5-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-5-course longName"),
//: shortName for Tenor Lute; course: 5-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lt.", "ren.-tenor-lute-5-course shortName"),
//: traitName for Tenor Lute; course: 5-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "5-course", "ren.-tenor-lute-5-course traitName"),

//: description for Tenor Lute; course: 6-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-course Renaissance tenor lute.", "ren.-tenor-lute-6-course description"),
//: trackName for Tenor Lute; course: 6-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-6-course trackName"),
//: longName for Tenor Lute; course: 6-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-6-course longName"),
//: shortName for Tenor Lute; course: 6-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lt.", "ren.-tenor-lute-6-course shortName"),
//: traitName for Tenor Lute; course: 6-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "6-course", "ren.-tenor-lute-6-course traitName"),

//: description for Tenor Lute; course: 7-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "7-course Renaissance tenor lute.", "ren.-tenor-lute-7-course description"),
//: trackName for Tenor Lute; course: 7-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-7-course trackName"),
//: longName for Tenor Lute; course: 7-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-7-course longName"),
//: shortName for Tenor Lute; course: 7-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lt.", "ren.-tenor-lute-7-course shortName"),
//: traitName for Tenor Lute; course: 7-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "7-course", "ren.-tenor-lute-7-course traitName"),

//: description for Tenor Lute; course: 8-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "8-course Renaissance tenor lute.", "ren.-tenor-lute-8-course description"),
//: trackName for Tenor Lute; course: 8-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-8-course trackName"),
//: longName for Tenor Lute; course: 8-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-8-course longName"),
//: shortName for Tenor Lute; course: 8-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lt.", "ren.-tenor-lute-8-course shortName"),
//: traitName for Tenor Lute; course: 8-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "8-course", "ren.-tenor-lute-8-course traitName"),

//: description for Tenor Lute; course: 9-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "9-course Renaissance tenor lute.", "ren.-tenor-lute-9-course description"),
//: trackName for Tenor Lute; course: 9-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-9-course trackName"),
//: longName for Tenor Lute; course: 9-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-9-course longName"),
//: shortName for Tenor Lute; course: 9-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lt.", "ren.-tenor-lute-9-course shortName"),
//: traitName for Tenor Lute; course: 9-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "9-course", "ren.-tenor-lute-9-course traitName"),

//: description for Tenor Lute; course: 10-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-course Renaissance tenor lute.", "ren.-tenor-lute-10-course description"),
//: trackName for Tenor Lute; course: 10-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-10-course trackName"),
//: longName for Tenor Lute; course: 10-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "ren.-tenor-lute-10-course longName"),
//: shortName for Tenor Lute; course: 10-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lt.", "ren.-tenor-lute-10-course shortName"),
//: traitName for Tenor Lute; course: 10-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "10-course", "ren.-tenor-lute-10-course traitName"),

//: description for Tenor Lute; course: 13-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "13-course Baroque lute.", "baroque-lute-13-course description"),
//: trackName for Tenor Lute; course: 13-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "baroque-lute-13-course trackName"),
//: longName for Tenor Lute; course: 13-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Lute", "baroque-lute-13-course longName"),
//: shortName for Tenor Lute; course: 13-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Lt.", "baroque-lute-13-course shortName"),
//: traitName for Tenor Lute; course: 13-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "13-course", "baroque-lute-13-course traitName"),

//: description for Theorbo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "14-course theorbo.", "theorbo-14-course description"),
//: trackName for Theorbo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Theorbo", "theorbo-14-course trackName"),
//: longName for Theorbo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Theorbo", "theorbo-14-course longName"),
//: shortName for Theorbo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Thb.", "theorbo-14-course shortName"),

//: description for Archlute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "14-course archlute.", "archlute-14-course description"),
//: trackName for Archlute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Archlute", "archlute-14-course trackName"),
//: longName for Archlute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Archlute", "archlute-14-course longName"),
//: shortName for Archlute; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Lt.", "archlute-14-course shortName"),

//: description for Piccolo Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo balalaika, tuned a fifth above the prima.", "balalaika-piccolo description"),
//: trackName for Piccolo Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Balalaika", "balalaika-piccolo trackName"),
//: longName for Piccolo Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Piccolo Balalaika", "balalaika-piccolo longName"),
//: shortName for Piccolo Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pic. Bal.", "balalaika-piccolo shortName"),

//: description for Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Prima balalaika. The most common balalaika.", "balalaika description"),
//: trackName for Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Balalaika", "balalaika trackName"),
//: longName for Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Balalaika", "balalaika longName"),
//: shortName for Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bal.", "balalaika shortName"),

//: description for Prima Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Prima balalaika. The most common balalaika.", "balalaika-prima description"),
//: trackName for Prima Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Prima Balalaika", "balalaika-prima trackName"),
//: longName for Prima Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Prima Balalaika", "balalaika-prima longName"),
//: shortName for Prima Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pr. Bal.", "balalaika-prima shortName"),

//: description for Secunda Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Secunda balalaika, tuned a fifth below the prima.", "balalaika-secunda description"),
//: trackName for Secunda Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Secunda Balalaika", "balalaika-secunda trackName"),
//: longName for Secunda Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Secunda Balalaika", "balalaika-secunda longName"),
//: shortName for Secunda Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sec. Bal.", "balalaika-secunda shortName"),

//: description for Alto Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto balalaika, tuned an octave below the prima.", "balalaika-alto description"),
//: trackName for Alto Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Balalaika", "balalaika-alto trackName"),
//: longName for Alto Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Balalaika", "balalaika-alto longName"),
//: shortName for Alto Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Al. Bal.", "balalaika-alto shortName"),

//: description for Bass Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass balalaika, tuned an octave below the alto.", "balalaika-bass description"),
//: trackName for Bass Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Balalaika", "balalaika-bass trackName"),
//: longName for Bass Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bass Balalaika", "balalaika-bass longName"),
//: shortName for Bass Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "B. Bal.", "balalaika-bass shortName"),

//: description for Contrabass Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass balalaika, tuned an octave below the bass.", "balalaika-contrabass description"),
//: trackName for Contrabass Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Balalaika", "balalaika-contrabass trackName"),
//: longName for Contrabass Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass Balalaika", "balalaika-contrabass longName"),
//: shortName for Contrabass Balalaika; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb. Bal.", "balalaika-contrabass shortName"),

//: description for Bouzouki; course: 3-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Greek lute, with 3 courses.", "bouzouki-3-course description"),
//: trackName for Bouzouki; course: 3-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bouzouki", "bouzouki-3-course trackName"),
//: longName for Bouzouki; course: 3-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bouzouki", "bouzouki-3-course longName"),
//: shortName for Bouzouki; course: 3-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bou.", "bouzouki-3-course shortName"),
//: traitName for Bouzouki; course: 3-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "3-course", "bouzouki-3-course traitName"),

//: description for Bouzouki; course: 4-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Greek lute, with 4 courses.", "bouzouki-4-course description"),
//: trackName for Bouzouki; course: 4-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bouzouki", "bouzouki-4-course trackName"),
//: longName for Bouzouki; course: 4-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bouzouki", "bouzouki-4-course longName"),
//: shortName for Bouzouki; course: 4-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bou.", "bouzouki-4-course shortName"),
//: traitName for Bouzouki; course: 4-course; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "4-course", "bouzouki-4-course traitName"),

//: description for Koto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Japanese plucked half-tube zither.", "koto description"),
//: trackName for Koto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Koto", "koto trackName"),
//: longName for Koto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Koto", "koto longName"),
//: shortName for Koto; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Ko.", "koto shortName"),

//: description for Oud; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Short-neck lute-type fretless stringed instrument, common in the Middle East and North Africa.", "oud description"),
//: trackName for Oud; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oud", "oud trackName"),
//: longName for Oud; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Oud", "oud longName"),
//: shortName for Oud; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "O.", "oud shortName"),

//: description for Shamisen; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Traditional Japanese three-stringed instrument played with a plectrum.", "shamisen description"),
//: trackName for Shamisen; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shamisen", "shamisen trackName"),
//: longName for Shamisen; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Shamisen", "shamisen longName"),
//: shortName for Shamisen; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sh.", "shamisen shortName"),

//: description for Sitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Plucked string instrument used in Indian classical music.", "sitar description"),
//: trackName for Sitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sitar", "sitar trackName"),
//: longName for Sitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Sitar", "sitar longName"),
//: shortName for Sitar; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Si.", "sitar shortName"),

//: description for Prim; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "The smallest tamburica, mostly used as a lead instrument.", "prim description"),
//: trackName for Prim; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Prim", "prim trackName"),
//: longName for Prim; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Prim", "prim longName"),
//: shortName for Prim; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pr.", "prim shortName"),

//: description for Brač; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A larger tamburica than the prim, played in a similar way.", "brac description"),
//: trackName for Brač; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brač", "brac trackName"),
//: longName for Brač; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Brač", "brac longName"),
//: shortName for Brač; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Br.", "brac shortName"),

//: description for Bugarija; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A tamburica mostly used as a harmony/rhythm instrument.", "bugarija description"),
//: trackName for Bugarija; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bugarija", "bugarija trackName"),
//: longName for Bugarija; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bugarija", "bugarija longName"),
//: shortName for Bugarija; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bu.", "bugarija shortName"),

//: description for Berda; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "The largest tamburica, used for playing bass lines.", "berda description"),
//: trackName for Berda; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Berda", "berda trackName"),
//: longName for Berda; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Berda", "berda longName"),
//: shortName for Berda; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Be.", "berda shortName"),

//: description for Čelo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A tamburica similar in size to the bugarija, usually given counterpoint lines.", "celo description"),
//: trackName for Čelo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Čelo", "celo trackName"),
//: longName for Čelo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Čelo", "celo longName"),
//: shortName for Čelo; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Č.", "celo shortName"),

//: description for Bandurria; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Spanish folk instrument similar to the mandolin. (Staff notation).", "bandurria description"),
//: trackName for Bandurria; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bandurria", "bandurria trackName"),
//: longName for Bandurria; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bandurria", "bandurria longName"),
//: shortName for Bandurria; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Band.", "bandurria shortName"),

//: description for Bandurria (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Spanish folk instrument similar to the mandolin. (Tablature).", "bandurria-tablature description"),
//: trackName for Bandurria (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bandurria (tablature)", "bandurria-tablature trackName"),
//: longName for Bandurria (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bandurria", "bandurria-tablature longName"),

//: description for Laúd; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Spanish lute similar to the bandurria. (Staff notation).", "laud description"),
//: trackName for Laúd; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Laúd", "laud trackName"),
//: longName for Laúd; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Laúd", "laud longName"),
//: shortName for Laúd; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Laúd", "laud shortName"),

//: description for Laúd (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Spanish lute similar to the bandurria. (Tablature).", "laud-tablature description"),
//: trackName for Laúd (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Laúd (tablature)", "laud-tablature trackName"),
//: longName for Laúd (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Laúd", "laud-tablature longName"),

// Strings - Bowed
QT_TRANSLATE_NOOP("engraving/instruments/group", "Strings - Bowed"),

//: description for Strings; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "String section notated on a grand staff.", "strings description"),
//: trackName for Strings; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Strings", "strings trackName"),
//: longName for Strings; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Strings", "strings longName"),
//: shortName for Strings; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "St.", "strings shortName"),
//: channel for Strings; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "strings channel"),
//: channel for Strings; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "strings channel"),
//: channel for Strings; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "strings channel"),

//: description for Double Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass (double bass).", "double-bass description"),
//: trackName for Double Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Double Bass", "double-bass trackName"),
//: longName for Double Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Double Bass", "double-bass longName"),
//: shortName for Double Bass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Db.", "double-bass shortName"),

//: description for Violin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Solo violin.", "violin description"),
//: trackName for Violin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violin", "violin trackName"),
//: longName for Violin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violin", "violin longName"),
//: shortName for Violin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vln.", "violin shortName"),
//: channel for Violin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "violin channel"),
//: channel for Violin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "violin channel"),
//: channel for Violin; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "violin channel"),

//: description for Violins (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violin section.", "violins description"),
//: trackName for Violins (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violins (section)", "violins trackName"),
//: longName for Violins (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violins", "violins longName"),
//: shortName for Violins (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vlns.", "violins shortName"),
//: channel for Violins (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "violins channel"),
//: channel for Violins (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "violins channel"),
//: channel for Violins (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "violins channel"),

//: description for Viola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Solo viola.", "viola description"),
//: trackName for Viola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola", "viola trackName"),
//: longName for Viola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola", "viola longName"),
//: shortName for Viola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vla.", "viola shortName"),
//: channel for Viola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "viola channel"),
//: channel for Viola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "viola channel"),
//: channel for Viola; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "viola channel"),

//: description for Violas (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola section.", "violas description"),
//: trackName for Violas (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violas (section)", "violas trackName"),
//: longName for Violas (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violas", "violas longName"),
//: shortName for Violas (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vlas.", "violas shortName"),
//: channel for Violas (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "violas channel"),
//: channel for Violas (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "violas channel"),
//: channel for Violas (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "violas channel"),

//: description for Violoncello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violoncello.", "violoncello description"),
//: trackName for Violoncello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violoncello", "violoncello trackName"),
//: longName for Violoncello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violoncello", "violoncello longName"),
//: shortName for Violoncello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vc.", "violoncello shortName"),
//: channel for Violoncello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "violoncello channel"),
//: channel for Violoncello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "violoncello channel"),
//: channel for Violoncello; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "violoncello channel"),

//: description for Violoncellos (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violoncello section.", "violoncellos description"),
//: trackName for Violoncellos (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violoncellos (section)", "violoncellos trackName"),
//: longName for Violoncellos (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violoncellos", "violoncellos longName"),
//: shortName for Violoncellos (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vcs.", "violoncellos shortName"),
//: channel for Violoncellos (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "violoncellos channel"),
//: channel for Violoncellos (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "violoncellos channel"),
//: channel for Violoncellos (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "violoncellos channel"),

//: description for Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass (double bass).", "contrabass description"),
//: trackName for Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass", "contrabass trackName"),
//: longName for Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass", "contrabass longName"),
//: shortName for Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cb.", "contrabass shortName"),
//: channel for Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "contrabass channel"),
//: channel for Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "contrabass channel"),
//: channel for Contrabass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "contrabass channel"),

//: description for Contrabasses (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabass (double bass) section.", "contrabasses description"),
//: trackName for Contrabasses (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabasses (section)", "contrabasses trackName"),
//: longName for Contrabasses (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Contrabasses", "contrabasses longName"),
//: shortName for Contrabasses (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Cbs.", "contrabasses shortName"),
//: channel for Contrabasses (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "contrabasses channel"),
//: channel for Contrabasses (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "contrabasses channel"),
//: channel for Contrabasses (section); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "contrabasses channel"),

//: description for Treble Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Treble viol.", "treble-viol description"),
//: trackName for Treble Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Treble Viol", "treble-viol trackName"),
//: longName for Treble Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Treble Viol", "treble-viol longName"),
//: shortName for Treble Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tr. Vl.", "treble-viol shortName"),
//: channel for Treble Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "treble-viol channel"),
//: channel for Treble Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "treble-viol channel"),
//: channel for Treble Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "treble-viol channel"),

//: description for Alto Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto viol.", "alto-viol description"),
//: trackName for Alto Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Viol", "alto-viol trackName"),
//: longName for Alto Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Alto Viol", "alto-viol longName"),
//: shortName for Alto Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "A. Vl.", "alto-viol shortName"),
//: channel for Alto Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "alto-viol channel"),
//: channel for Alto Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "alto-viol channel"),
//: channel for Alto Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "alto-viol channel"),

//: description for Pardessus de viole; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Highest-pitched member of the viol family.", "pardessus-de-viole description"),
//: trackName for Pardessus de viole; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pardessus de viole", "pardessus-de-viole trackName"),
//: longName for Pardessus de viole; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pardessus de viole", "pardessus-de-viole longName"),
//: shortName for Pardessus de viole; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Pds. v.", "pardessus-de-viole shortName"),
//: channel for Pardessus de viole; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "pardessus-de-viole channel"),
//: channel for Pardessus de viole; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "pardessus-de-viole channel"),
//: channel for Pardessus de viole; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "pardessus-de-viole channel"),

//: description for Tenor Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor viol.", "tenor-viol description"),
//: trackName for Tenor Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Viol", "tenor-viol trackName"),
//: longName for Tenor Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Tenor Viol", "tenor-viol longName"),
//: shortName for Tenor Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "T. Vl.", "tenor-viol shortName"),
//: channel for Tenor Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "tenor-viol channel"),
//: channel for Tenor Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "tenor-viol channel"),
//: channel for Tenor Viol; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "tenor-viol channel"),

//: description for Baryton; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Similar to the viol, but with an extra set of plucked strings.", "baryton description"),
//: trackName for Baryton; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baryton", "baryton trackName"),
//: longName for Baryton; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Baryton", "baryton longName"),
//: shortName for Baryton; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Bary.", "baryton shortName"),
//: channel for Baryton; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "baryton channel"),
//: channel for Baryton; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "baryton channel"),
//: channel for Baryton; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "baryton channel"),

//: description for Viola da gamba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola da gamba (staff notation).", "viola-da-gamba description"),
//: trackName for Viola da gamba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola da gamba", "viola-da-gamba trackName"),
//: longName for Viola da gamba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola da gamba", "viola-da-gamba longName"),
//: shortName for Viola da gamba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vla. d. g.", "viola-da-gamba shortName"),
//: channel for Viola da gamba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "viola-da-gamba channel"),
//: channel for Viola da gamba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "viola-da-gamba channel"),
//: channel for Viola da gamba; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "viola-da-gamba channel"),

//: description for Viola da gamba (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola da gamba (tablature).", "viola-da-gamba-tablature description"),
//: trackName for Viola da gamba (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola da gamba (tablature)", "viola-da-gamba-tablature trackName"),
//: longName for Viola da gamba (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Viola da gamba", "viola-da-gamba-tablature longName"),
//: shortName for Viola da gamba (tablature); Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Vla. d. g.", "viola-da-gamba-tablature shortName"),

//: description for Violone; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Large viol with the lowest string tuned to G. Sometimes called the G violone or great bass viol.", "violone description"),
//: trackName for Violone; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violone", "violone trackName"),
//: longName for Violone; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Violone", "violone longName"),
//: shortName for Violone; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "G Vne.", "violone shortName"),
//: traitName for Violone; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "*G", "violone traitName"),
//: channel for Violone; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "violone channel"),
//: channel for Violone; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "violone channel"),
//: channel for Violone; tuning: G; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "violone channel"),

//: description for Violone; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Large viol with the lowest string tuned to D. Sometimes called the D violone.", "d-violone description"),
//: trackName for Violone; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Violone", "d-violone trackName"),
//: longName for Violone; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Violone", "d-violone longName"),
//: shortName for Violone; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D Vne.", "d-violone shortName"),
//: traitName for Violone; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "D", "d-violone traitName"),
//: channel for Violone; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "d-violone channel"),
//: channel for Violone; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "d-violone channel"),
//: channel for Violone; tuning: D; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "d-violone channel"),

//: description for Octobass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Extremely large and rare bowed string instrument, essentially a larger version of the double bass.", "octobass description"),
//: trackName for Octobass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Octobass", "octobass trackName"),
//: longName for Octobass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Octobass", "octobass longName"),
//: shortName for Octobass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Otb.", "octobass shortName"),
//: channel for Octobass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "octobass channel"),
//: channel for Octobass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "octobass channel"),
//: channel for Octobass; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "octobass channel"),

//: description for Erhu; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Chinese two-stringed bowed instrument.", "erhu description"),
//: trackName for Erhu; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Erhu", "erhu trackName"),
//: longName for Erhu; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Erhu", "erhu longName"),
//: shortName for Erhu; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Eh.", "erhu shortName"),
//: channel for Erhu; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "erhu channel"),
//: channel for Erhu; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "erhu channel"),
//: channel for Erhu; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "erhu channel"),

//: description for Nyckelharpa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Swedish bowed instrument with keys to change the pitch of the strings.", "nyckelharpa description"),
//: trackName for Nyckelharpa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Nyckelharpa", "nyckelharpa trackName"),
//: longName for Nyckelharpa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Nyckelharpa", "nyckelharpa longName"),
//: shortName for Nyckelharpa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "Nyh.", "nyckelharpa shortName"),
//: channel for Nyckelharpa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "arco", "nyckelharpa channel"),
//: channel for Nyckelharpa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "pizzicato", "nyckelharpa channel"),
//: channel for Nyckelharpa; Please see https://github.com/musescore/MuseScore/wiki/Translating-instrument-names
QT_TRANSLATE_NOOP3("engraving/instruments", "tremolo", "nyckelharpa channel"),

// Score orders
QT_TRANSLATE_NOOP("engraving/scoreorder", "Orchestral"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Choir"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Marching Band"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Big Band"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Jazz Combo"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Rock Band"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Concert Band"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Brass Band"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Woodwind Ensemble"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "Brass Ensemble"),
QT_TRANSLATE_NOOP("engraving/scoreorder", "String Ensemble"),
