/*
 * SPDX-License-Identifier: GPL-3.0-only
 * MuseScore-CLA-applies
 *
 * MuseScore
 * Music Composition & Notation
 *
 * Copyright (C) 2021 MuseScore BVBA and others
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include "styledef.h"

#include "draw/types/geometry.h"

#include "types/constants.h"

#include "dom/articulation.h"
#include "dom/mscore.h"
#include "dom/realizedharmony.h"
#include "dom/stafftype.h"
#include "dom/textbase.h"
#include "dom/tremolo.h"
#include "dom/tuplet.h"
#include "dom/types.h"

using namespace mu;
using namespace mu::draw;
using namespace mu::engraving;

//! Keep in sync with Sid in styledef.h
const std::array<StyleDef::StyleValue, size_t(Sid::STYLES)> StyleDef::styleValues { {
    { Sid::pageWidth,               "pageWidth",               210.0 / INCH },
    { Sid::pageHeight,              "pageHeight",              297.0 / INCH }, // A4
    { Sid::pagePrintableWidth,      "pagePrintableWidth",      180.0 / INCH },
    { Sid::pageEvenLeftMargin,      "pageEvenLeftMargin",      15.0 / INCH },
    { Sid::pageOddLeftMargin,       "pageOddLeftMargin",       15.0 / INCH },
    { Sid::pageEvenTopMargin,       "pageEvenTopMargin",       15.0 / INCH },
    { Sid::pageEvenBottomMargin,    "pageEvenBottomMargin",    15.0 / INCH },
    { Sid::pageOddTopMargin,        "pageOddTopMargin",        15.0 / INCH },
    { Sid::pageOddBottomMargin,     "pageOddBottomMargin",     15.0 / INCH },
    { Sid::pageTwosided,            "pageTwosided",            true },

    { Sid::staffUpperBorder,        "staffUpperBorder",        Spatium(7.0) },
    { Sid::staffLowerBorder,        "staffLowerBorder",        Spatium(7.0) },
    { Sid::staffHeaderFooterPadding, "staffHeaderFooterPadding", Spatium(1.0) },
    { Sid::staffDistance,           "staffDistance",           Spatium(6.5) },
    { Sid::instrumentNameOffset,    "instrumentNameOffset",    Spatium(1.0) },
    { Sid::akkoladeDistance,        "akkoladeDistance",        Spatium(6.5) },
    { Sid::minSystemDistance,       "minSystemDistance",       Spatium(8.5) },
    { Sid::maxSystemDistance,       "maxSystemDistance",       Spatium(15.0) },
    { Sid::alignSystemToMargin,     "alignSystemToMargin",     true },

    { Sid::enableVerticalSpread,    "enableVerticalSpread",    true },
    { Sid::spreadSystem,            "spreadSystem",            2.5 },
    { Sid::spreadSquareBracket,     "spreadSquareBracket",     1.2 },
    { Sid::spreadCurlyBracket,      "spreadCurlyBracket",      1.1 },
    { Sid::minSystemSpread,         "minSystemSpread",         Spatium(8.5) },
    { Sid::maxSystemSpread,         "maxSystemSpread",         Spatium(32.0) },
    { Sid::minStaffSpread,          "minSpreadSpread",         Spatium(3.5) },
    { Sid::maxStaffSpread,          "maxSpreadSpread",         Spatium(20.0) },
    { Sid::maxAkkoladeDistance,     "maxAkkoladeDistance",     Spatium(6.5) },
    { Sid::maxPageFillSpread,       "maxPageFillSpread",       Spatium(6.0) },

    { Sid::lyricsPlacement,         "lyricsPlacement",         PlacementV::BELOW },
    { Sid::lyricsPosAbove,          "lyricsPosAbove",          PointF(0.0, -2.0) },
    { Sid::lyricsPosBelow,          "lyricsPosBelow",          PointF(.0, 3.0) },
    { Sid::lyricsMinTopDistance,    "lyricsMinTopDistance",    Spatium(1.0) },
    { Sid::lyricsMinBottomDistance, "lyricsMinBottomDistance", Spatium(1.5) },
    { Sid::lyricsMinDistance,       "lyricsMinDistance",       Spatium(0.25) },
    { Sid::lyricsLineHeight,        "lyricsLineHeight",        1.0 },
    { Sid::lyricsDashMinLength,     "lyricsDashMinLength",     Spatium(0.4) },
    { Sid::lyricsDashMaxLength,     "lyricsDashMaxLength",     Spatium(0.8) },
    { Sid::lyricsDashMaxDistance,   "lyricsDashMaxDistance",   Spatium(16.0) },
    { Sid::lyricsDashForce,         "lyricsDashForce",         true },
    { Sid::lyricsAlignVerseNumber,  "lyricsAlignVerseNumber",  true },
    { Sid::lyricsLineThickness,     "lyricsLineThickness",     Spatium(0.1) },
    { Sid::lyricsMelismaAlign,      "lyricsMelismaAlign",      Align(AlignH::LEFT, AlignV::BASELINE) },

    { Sid::lyricsMelismaPad,        "lyricsMelismaPad",        Spatium(0.10) }, // the empty space before a melisma line
    { Sid::lyricsDashPad,           "lyricsDashPad",           Spatium(0.05) }, // the min. empty space before and after a dash
    { Sid::lyricsDashLineThickness, "lyricsDashLineThickness", Spatium(0.1) },  // in sp. units
    { Sid::lyricsDashYposRatio,     "lyricsDashYposRatio",     0.60 },          // the fraction of lyrics font x-height to raise the dashes above text base line

    { Sid::lyricsOddFontFace,       "lyricsOddFontFace",       "Edwin" },
    { Sid::lyricsOddFontSize,       "lyricsOddFontSize",       10.0 },
    { Sid::lyricsOddLineSpacing,    "lyricsOddLineSpacing",    1.0 },
    { Sid::lyricsOddFontSpatiumDependent, "lyricsOddFontSpatiumDependent", true },
    { Sid::lyricsOddFontStyle,      "lyricsOddFontStyle",      int(FontStyle::Normal) },
    { Sid::lyricsOddColor,          "lyricsOddColor",          Color::BLACK },
    { Sid::lyricsOddAlign,          "lyricsOddAlign",          Align(AlignH::HCENTER, AlignV::BASELINE) },
    { Sid::lyricsOddFrameType,      "lyricsOddFrameType",      int(FrameType::NO_FRAME) },
    { Sid::lyricsOddFramePadding,   "lyricsOddFramePadding",   0.2 },
    { Sid::lyricsOddFrameWidth,     "lyricsOddFrameWidth",     0.1 },
    { Sid::lyricsOddFrameRound,     "lyricsOddFrameRound",     0 },
    { Sid::lyricsOddFrameFgColor,   "lyricsOddFrameFgColor",   Color::BLACK },
    { Sid::lyricsOddFrameBgColor,   "lyricsOddFrameBgColor",   Color::transparent },

    { Sid::lyricsEvenFontFace,      "lyricsEvenFontFace",      "Edwin" },
    { Sid::lyricsEvenFontSize,      "lyricsEvenFontSize",      10.0 },
    { Sid::lyricsEvenLineSpacing,   "lyricsEvenLineSpacing",   1.0 },
    { Sid::lyricsEvenFontSpatiumDependent, "lyricsEvenFontSpatiumDependent", true },
    { Sid::lyricsEvenFontStyle,     "lyricsEvenFontStyle",     int(FontStyle::Normal) },
    { Sid::lyricsEvenColor,         "lyricsEvenColor",         Color::BLACK },
    { Sid::lyricsEvenAlign,         "lyricsEvenAlign",         Align(AlignH::HCENTER, AlignV::BASELINE) },
    { Sid::lyricsEvenFrameType,     "lyricsEvenFrameType",     int(FrameType::NO_FRAME) },
    { Sid::lyricsEvenFramePadding,  "lyricsEvenFramePadding",  0.2 },
    { Sid::lyricsEvenFrameWidth,    "lyricsEvenFrameWidth",    0.1 },
    { Sid::lyricsEvenFrameRound,    "lyricsEvenFrameRound",    0 },
    { Sid::lyricsEvenFrameFgColor,  "lyricsEvenFrameFgColor",  Color::BLACK },
    { Sid::lyricsEvenFrameBgColor,  "lyricsEvenFrameBgColor",  Color::transparent },

    { Sid::figuredBassFontFamily,   "figuredBassFontFamily",   String(u"MScoreBC") },

    //      { Sid::figuredBassFontSize,     "figuredBassFontSize",     PropertyValue(8.0) },
    { Sid::figuredBassYOffset,      "figuredBassYOffset",      6.0 },
    { Sid::figuredBassLineHeight,   "figuredBassLineHeight",   1.0 },
    { Sid::figuredBassAlignment,    "figuredBassAlignment",    0 },
    { Sid::figuredBassStyle,        "figuredBassStyle",        0 },
    { Sid::systemFrameDistance,     "systemFrameDistance",     Spatium(7.0) },
    { Sid::frameSystemDistance,     "frameSystemDistance",     Spatium(7.0) },
    { Sid::minMeasureWidth,         "minMeasureWidth",         Spatium(8.0) },
    { Sid::barWidth,                "barWidth",                Spatium(0.18) },
    { Sid::doubleBarWidth,          "doubleBarWidth",          Spatium(0.18) },

    { Sid::endBarWidth,             "endBarWidth",             Spatium(0.55) },
    { Sid::doubleBarDistance,       "doubleBarDistance",       Spatium(0.37) },
    { Sid::endBarDistance,          "endBarDistance",          Spatium(0.37) },
    { Sid::repeatBarlineDotSeparation, "repeatBarlineDotSeparation", Spatium(0.37) },
    { Sid::repeatBarTips,           "repeatBarTips",           false },
    { Sid::startBarlineSingle,      "startBarlineSingle",      false },
    { Sid::startBarlineMultiple,    "startBarlineMultiple",    true },

    { Sid::bracketWidth,            "bracketWidth",            Spatium(0.45) },
    { Sid::bracketDistance,         "bracketDistance",         Spatium(0.45) },
    { Sid::akkoladeWidth,           "akkoladeWidth",           Spatium(1.5) },
    { Sid::akkoladeBarDistance,     "akkoladeBarDistance",     Spatium(.35) },

    { Sid::dividerLeft,             "dividerLeft",             false },
    { Sid::dividerLeftSym,          "dividerLeftSym",          String(u"systemDivider") },
    { Sid::dividerLeftX,            "dividerLeftX",            0.0 },
    { Sid::dividerLeftY,            "dividerLeftY",            0.0 },
    { Sid::dividerRight,            "dividerRight",            false },
    { Sid::dividerRightSym,         "dividerRightSym",         String(u"systemDivider") },
    { Sid::dividerRightX,           "dividerRightX",           0.0 },
    { Sid::dividerRightY,           "dividerRightY",           0.0 },

    { Sid::clefLeftMargin,          "clefLeftMargin",          Spatium(0.75) },     // 0.64 (gould: <= 1)
    { Sid::keysigLeftMargin,        "keysigLeftMargin",        Spatium(0.5) },
    { Sid::ambitusMargin,           "ambitusMargin",           Spatium(0.5) },

    { Sid::timesigLeftMargin,       "timesigLeftMargin",       Spatium(0.63) },
    { Sid::timesigScale,            "timesigScale",            ScaleF(1.0, 1.0) },
    { Sid::midClefKeyRightMargin,   "midClefKeyRightMargin",   Spatium(1.0) },
    { Sid::clefKeyRightMargin,      "clefKeyRightMargin",      Spatium(0.8) },
    { Sid::clefKeyDistance,         "clefKeyDistance",         Spatium(1.0) },   // gould: 1 - 1.25
    { Sid::clefTimesigDistance,     "clefTimesigDistance",     Spatium(1.0) },
    { Sid::keyTimesigDistance,      "keyTimesigDistance",      Spatium(1.0) },    // gould: 1 - 1.5
    { Sid::keyBarlineDistance,      "keyBarlineDistance",      Spatium(1.0) },
    { Sid::systemHeaderDistance,    "systemHeaderDistance",    Spatium(2.5) },     // gould: 2.5
    { Sid::systemHeaderTimeSigDistance, "systemHeaderTimeSigDistance", Spatium(2.0) },  // gould: 2.0
    { Sid::systemTrailerRightMargin, "systemTrailerRightMargin", Spatium(0.5) },

    { Sid::clefBarlineDistance,     "clefBarlineDistance",     Spatium(0.5) },
    { Sid::timesigBarlineDistance,  "timesigBarlineDistance",  Spatium(0.5) },
    { Sid::useStraightNoteFlags,    "useStraightNoteFlags",    false },
    { Sid::stemWidth,               "stemWidth",               Spatium(0.10) },
    { Sid::shortenStem,             "shortenStem",             true },
    { Sid::stemLength,              "stemLength",              PropertyValue(3.5) },
    { Sid::stemLengthSmall,         "stemLengthSmall",         PropertyValue(2.25) },
    { Sid::shortStemStartLocation,  "shortStemStartLocation",  1 },
    { Sid::shortestStem,            "shortestStem",            PropertyValue(2.5) },
    { Sid::beginRepeatLeftMargin,   "beginRepeatLeftMargin",   Spatium(1.0) },
    { Sid::minNoteDistance,         "minNoteDistance",         Spatium(0.5) },
    { Sid::barNoteDistance,         "barNoteDistance",         Spatium(1.3) },     // was 1.2

    { Sid::barAccidentalDistance,   "barAccidentalDistance",   Spatium(0.65) },
    { Sid::noteBarDistance,         "noteBarDistance",         Spatium(1.5) },
    { Sid::measureSpacing,          "measureSpacing",          1.5 },
    { Sid::measureRepeatNumberPos,  "measureRepeatNumberPos",  Spatium(-0.5) },
    { Sid::mrNumberSeries,          "mrNumberSeries",          false },
    { Sid::mrNumberEveryXMeasures,  "mrNumberEveryXMeasures",  4 },
    { Sid::mrNumberSeriesWithParentheses, "mrNumberSeriesWithParentheses", true },
    { Sid::oneMeasureRepeatShow1,   "oneMeasureRepeatShow1",   false },
    { Sid::fourMeasureRepeatShowExtenders, "fourMeasureRepeatShowExtenders", false },
    { Sid::staffLineWidth,          "staffLineWidth",          Spatium(0.11) },
    { Sid::ledgerLineWidth,         "ledgerLineWidth",         Spatium(0.16) },     // 0.1875
    { Sid::ledgerLineLength,        "ledgerLineLength",        Spatium(0.33) },     // notehead width + this value
    { Sid::stemSlashPosition,         "stemSlashPosition",         Spatium(2.0) },
    { Sid::stemSlashAngle,          "stemSlashAngle",          40.0 },
    { Sid::stemSlashThickness,          "stemSlashThickness",          Spatium(0.125), },
    { Sid::accidentalDistance,      "accidentalDistance",      Spatium(0.22) },
    { Sid::accidentalNoteDistance,  "accidentalNoteDistance",  Spatium(0.25) },
    { Sid::bracketedAccidentalPadding,  "bracketedAccidentalPadding",  Spatium(0.175) }, // Padding inside parentheses for bracketed accidentals
    { Sid::alignAccidentalsLeft,    "alignAccidentalsLeft",    false },   // When laid out in columns, whether accidentals align left or right. Musescore <= 3.5 uses left alignment.
    { Sid::keysigAccidentalDistance, "keysigAccidentalDistance", Spatium(0.3) },
    { Sid::keysigNaturalDistance,   "keysigNaturalDistance",   Spatium(0.4) },

    { Sid::beamWidth,               "beamWidth",               Spatium(0.5) },      // was 0.48
    { Sid::useWideBeams,            "useWideBeams",            false },
    { Sid::beamMinLen,              "beamMinLen",              Spatium(1.1) },
    { Sid::beamNoSlope,             "beamNoSlope",             false },
    { Sid::snapCustomBeamsToGrid,   "snapCustomBeamsToGrid",   true },

    { Sid::dotMag,                  "dotMag",                  PropertyValue(1.0) },
    { Sid::dotNoteDistance,         "dotNoteDistance",         Spatium(0.5) },
    { Sid::dotRestDistance,         "dotRestDistance",         Spatium(0.25) },
    { Sid::dotDotDistance,          "dotDotDistance",          Spatium(0.65) },
    { Sid::propertyDistanceHead,    "propertyDistanceHead",    Spatium(0.4) },
    { Sid::propertyDistanceStem,    "propertyDistanceStem",    Spatium(0.4) },
    { Sid::propertyDistance,        "propertyDistance",        Spatium(0.4) },

    { Sid::articulationMag,         "articulationMag",         PropertyValue(1.0) },
    { Sid::articulationPosAbove,    "articulationPosAbove",    PointF(0.0, 0.0) },
    { Sid::articulationAnchorDefault, "articulationAnchorDefault", int(ArticulationAnchor::AUTO) },
    { Sid::articulationAnchorLuteFingering, "articulationAnchorLuteFingering", int(ArticulationAnchor::BOTTOM) },
    { Sid::articulationAnchorOther, "articulationAnchorOther", int(ArticulationAnchor::TOP) },
    { Sid::articulationStemHAlign,  "articulationStemHAlign",  int(ArticulationStemSideAlign::AVERAGE) },
    { Sid::articulationKeepTogether, "articulationKeepTogether", true },
    { Sid::lastSystemFillLimit,     "lastSystemFillLimit",     PropertyValue(0.3) },

    { Sid::hairpinPlacement,        "hairpinPlacement",        PlacementV::BELOW },
    { Sid::hairpinPosAbove,         "hairpinPosAbove",         PointF(0.0, -2.0) },
    { Sid::hairpinPosBelow,         "hairpinPosBelow",         PointF(.0, 2) },
    { Sid::hairpinLinePosAbove,     "hairpinLinePosAbove",     PointF(0.0, -1.5) },
    { Sid::hairpinLinePosBelow,     "hairpinLinePosBelow",     PointF(.0, 2.5) },
    { Sid::hairpinHeight,           "hairpinHeight",           Spatium(1.15) },
    { Sid::hairpinContHeight,       "hairpinContHeight",       Spatium(0.5) },
    { Sid::hairpinLineWidth,        "hairpinWidth",            Spatium(0.12) },
    { Sid::hairpinFontFace,         "hairpinFontFace",         "Edwin" },
    { Sid::hairpinFontSize,         "hairpinFontSize",         10.0 },
    { Sid::hairpinLineSpacing,      "hairpinLineSpacing",      1.0 },
    { Sid::hairpinFontSpatiumDependent, "hairpinFontSpatiumDependent", true },
    { Sid::hairpinFontStyle,        "hairpinFontStyle",        int(FontStyle::Italic) },
    { Sid::hairpinColor,            "hairpinColor",            Color::BLACK },
    { Sid::hairpinTextAlign,        "hairpinTextAlign",        Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::hairpinFrameType,        "hairpinFrameType",        int(FrameType::NO_FRAME) },
    { Sid::hairpinFramePadding,     "hairpinFramePadding",     0.2 },
    { Sid::hairpinFrameWidth,       "hairpinFrameWidth",       0.1 },
    { Sid::hairpinFrameRound,       "hairpinFrameRound",       0 },
    { Sid::hairpinFrameFgColor,     "hairpinFrameFgColor",     Color::BLACK },
    { Sid::hairpinFrameBgColor,     "hairpinFrameBgColor",     Color::transparent },
    { Sid::hairpinText,             "hairpinText",             String() },
    { Sid::hairpinCrescText,        "hairpinCrescText",        String(u"cresc.") },
    { Sid::hairpinDecrescText,      "hairpinDecrescText",      String(u"dim.") },
    { Sid::hairpinCrescContText,    "hairpinCrescContText",    String(u"(cresc.)") },
    { Sid::hairpinDecrescContText,  "hairpinDecrescContText",  String(u"(dim.)") },
    { Sid::hairpinLineStyle,        "hairpinLineStyle",        PropertyValue(LineType::SOLID) },
    { Sid::hairpinDashLineLen,      "hairpinDashLineLen",      3.0 },
    { Sid::hairpinDashGapLen,       "hairpinDashGapLen",       3.0 },
    { Sid::hairpinLineLineStyle,    "hairpinLineLineStyle",    PropertyValue(LineType::DASHED) },
    { Sid::hairpinLineDashLineLen,  "hairpinLineDashLineLen",  6.0 },
    { Sid::hairpinLineDashGapLen,   "hairpinLineDashGapLen",   9.0 },

    { Sid::pedalPlacement,          "pedalPlacement",          PlacementV::BELOW },
    { Sid::pedalPosAbove,           "pedalPosAbove",           PointF(.0, -1) },
    { Sid::pedalPosBelow,           "pedalPosBelow",           PointF(.0, 2.5) },
    { Sid::pedalLineWidth,          "pedalLineWidth",          Spatium(0.11) },
    { Sid::pedalLineStyle,          "pedalLineStyle",          PropertyValue(LineType::SOLID) },
    { Sid::pedalDashLineLen,        "pedalDashLineLen",        4.0 },
    { Sid::pedalDashGapLen,         "pedalDashGapLen",         4.0 },
    { Sid::pedalHookHeight,         "pedalHookHeight",         Spatium(-1.2) },
    { Sid::pedalFontFace,           "pedalFontFace",           "Edwin" },
    { Sid::pedalFontSize,           "pedalFontSize",           12.0 },
    { Sid::pedalLineSpacing,        "pedalLineSpacing",        1.0 },
    { Sid::pedalFontSpatiumDependent, "pedalFontSpatiumDependent", true },
    { Sid::pedalFontStyle,          "pedalFontStyle",          int(FontStyle::Normal) },
    { Sid::pedalColor,              "pedalColor",              Color::BLACK },
    { Sid::pedalTextAlign,          "pedalTextAlign",          Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::pedalFrameType,          "pedalFrameType",          int(FrameType::NO_FRAME) },
    { Sid::pedalFramePadding,       "pedalFramePadding",       0.2 },
    { Sid::pedalFrameWidth,         "pedalFrameWidth",         0.1 },
    { Sid::pedalFrameRound,         "pedalFrameRound",         0 },
    { Sid::pedalFrameFgColor,       "pedalFrameFgColor",       Color::BLACK },
    { Sid::pedalFrameBgColor,       "pedalFrameBgColor",       Color::transparent },
    { Sid::pedalText,               "pedalText",               String(u"<sym>keyboardPedalPed</sym>") },
    { Sid::pedalHookText,           "pedalHookText",           String() },
    { Sid::pedalContinueText,       "pedalContinueText",       String(u"(<sym>keyboardPedalPed</sym>)") },
    { Sid::pedalContinueHookText,   "pedalContinueHookText",   String() },
    { Sid::pedalEndText,            "pedalEndText",            String() },
    { Sid::pedalRosetteEndText,     "pedalRosetteEndText",     String(u"<sym>keyboardPedalUp</sym>") },

    { Sid::trillPlacement,          "trillPlacement",          PlacementV::ABOVE },
    { Sid::trillPosAbove,           "trillPosAbove",           PointF(.0, -0.5) },
    { Sid::trillPosBelow,           "trillPosBelow",           PointF(.0, 2) },

    { Sid::vibratoPlacement,        "vibratoPlacement",        PlacementV::ABOVE },
    { Sid::vibratoPosAbove,         "vibratoPosAbove",         PointF(.0, -1) },
    { Sid::vibratoPosBelow,         "vibratoPosBelow",         PointF(.0, 1) },

    { Sid::harmonyFretDist,          "harmonyFretDist",        Spatium(1.0) },
    { Sid::minHarmonyDistance,       "minHarmonyDistance",     Spatium(0.5) },
    { Sid::maxHarmonyBarDistance,    "maxHarmonyBarDistance",  Spatium(3.0) },
    { Sid::maxChordShiftAbove,       "maxChordShiftAbove",     Spatium(0.0) },
    { Sid::maxChordShiftBelow,       "maxChordShiftBelow",     Spatium(0.0) },

    { Sid::harmonyPlacement,         "harmonyPlacement",           PlacementV::ABOVE },
    { Sid::romanNumeralPlacement,    "romanNumeralPlacement",      PlacementV::BELOW },
    { Sid::nashvilleNumberPlacement, "nashvilleNumberPlacement",   PlacementV::ABOVE },
    { Sid::harmonyVoiceLiteral,      "harmonyVoiceLiteral",        true },
    { Sid::harmonyVoicing,           "harmonyVoicing",             int(Voicing::AUTO) },
    { Sid::harmonyDuration,          "harmonyDuration",            int(HDuration::UNTIL_NEXT_CHORD_SYMBOL) },

    { Sid::chordSymbolAPosAbove,      "chordSymbolPosAbove",       PointF(.0, -2.5) },
    { Sid::chordSymbolAPosBelow,      "chordSymbolPosBelow",       PointF(.0, 3.5) },

    { Sid::chordSymbolBPosAbove,      "chordSymbolBPosAbove",      PointF(.0, -5.0) },
    { Sid::chordSymbolBPosBelow,      "chordSymbolBPosBelow",      PointF(.0, 3.5) },

    { Sid::romanNumeralPosAbove,      "romanNumeralPosAbove",      PointF(.0, -2.5) },
    { Sid::romanNumeralPosBelow,      "romanNumeralPosBelow",      PointF(.0, 3.5) },

    { Sid::nashvilleNumberPosAbove,   "nashvilleNumberPosAbove",   PointF(.0, -2.5) },
    { Sid::nashvilleNumberPosBelow,   "nashvilleNumberPosBelow",   PointF(.0, 3.5) },

    { Sid::chordSymbolAFontFace,      "chordSymbolAFontFace",      "Edwin" },
    { Sid::chordSymbolAFontSize,      "chordSymbolAFontSize",      10.0 },
    { Sid::chordSymbolALineSpacing,   "chordSymbolALineSpacing",   1.0 },
    { Sid::chordSymbolAFontSpatiumDependent, "chordSymbolAFontSpatiumDependent", true },
    { Sid::chordSymbolAFontStyle,     "chordSymbolAFontStyle",     int(FontStyle::Normal) },
    { Sid::chordSymbolAColor,         "chordSymbolAColor",         PropertyValue::fromValue(Color::BLACK) },
    { Sid::chordSymbolAAlign,         "chordSymbolAAlign",         Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::chordSymbolAFrameType,     "chordSymbolAFrameType",     int(FrameType::NO_FRAME) },
    { Sid::chordSymbolAFramePadding,  "chordSymbolAFramePadding",  0.2 },
    { Sid::chordSymbolAFrameWidth,    "chordSymbolAFrameWidth",    0.1 },
    { Sid::chordSymbolAFrameRound,    "chordSymbolAFrameRound",    0 },
    { Sid::chordSymbolAFrameFgColor,  "chordSymbolAFrameFgColor",  PropertyValue::fromValue(Color::BLACK) },
    { Sid::chordSymbolAFrameBgColor,  "chordSymbolAFrameBgColor",  PropertyValue::fromValue(Color::transparent) },

    { Sid::chordSymbolBFontFace,      "chordSymbolBFontFace",      "Edwin" },
    { Sid::chordSymbolBFontSize,      "chordSymbolBFontSize",      10.0 },
    { Sid::chordSymbolBLineSpacing,   "chordSymbolBLineSpacing",   1.0 },
    { Sid::chordSymbolBFontSpatiumDependent, "chordSymbolBFontSpatiumDependent", true },
    { Sid::chordSymbolBFontStyle,     "chordSymbolBFontStyle",     int(FontStyle::Italic) },
    { Sid::chordSymbolBColor,         "chordSymbolBColor",         PropertyValue::fromValue(Color::BLACK) },
    { Sid::chordSymbolBAlign,         "chordSymbolBAlign",         Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::chordSymbolBFrameType,     "chordSymbolBFrameType",     int(FrameType::NO_FRAME) },
    { Sid::chordSymbolBFramePadding,  "chordSymbolBFramePadding",  0.2 },
    { Sid::chordSymbolBFrameWidth,    "chordSymbolBFrameWidth",    0.1 },
    { Sid::chordSymbolBFrameRound,    "chordSymbolBFrameRound",    0 },
    { Sid::chordSymbolBFrameFgColor,  "chordSymbolBFrameFgColor",  PropertyValue::fromValue(Color::BLACK) },
    { Sid::chordSymbolBFrameBgColor,  "chordSymbolBFrameBgColor",  PropertyValue::fromValue(Color::transparent) },

    { Sid::romanNumeralFontFace,      "romanNumeralFontFace",      "Campania" },
    { Sid::romanNumeralFontSize,      "romanNumeralFontSize",      12.0 },
    { Sid::romanNumeralLineSpacing,   "romanNumeralLineSpacing",   1.0 },
    { Sid::romanNumeralFontSpatiumDependent, "romanNumeralFontSpatiumDependent", true },
    { Sid::romanNumeralFontStyle,     "romanNumeralFontStyle",     int(FontStyle::Normal) },
    { Sid::romanNumeralColor,         "romanNumeralColor",         PropertyValue::fromValue(Color::BLACK) },
    { Sid::romanNumeralAlign,         "romanNumeralAlign",         Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::romanNumeralFrameType,     "romanNumeralFrameType",     int(FrameType::NO_FRAME) },
    { Sid::romanNumeralFramePadding,  "romanNumeralFramePadding",  0.2 },
    { Sid::romanNumeralFrameWidth,    "romanNumeralFrameWidth",    0.1 },
    { Sid::romanNumeralFrameRound,    "romanNumeralFrameRound",    0 },
    { Sid::romanNumeralFrameFgColor,  "romanNumeralFrameFgColor",  PropertyValue::fromValue(Color::BLACK) },
    { Sid::romanNumeralFrameBgColor,  "romanNumeralFrameBgColor",  PropertyValue::fromValue(Color::transparent) },

    { Sid::nashvilleNumberFontFace,      "nashvilleNumberFontFace",      "Edwin" },
    { Sid::nashvilleNumberFontSize,      "nashvilleNumberFontSize",      12.0 },
    { Sid::nashvilleNumberLineSpacing,   "nashvilleNumberLineSpacing",   1.0 },
    { Sid::nashvilleNumberFontSpatiumDependent, "nashvilleNumberFontSpatiumDependent", true },
    { Sid::nashvilleNumberFontStyle,     "nashvilleNumberFontStyle",     int(FontStyle::Normal) },
    { Sid::nashvilleNumberColor,         "nashvilleNumberColor",         PropertyValue::fromValue(Color::BLACK) },
    { Sid::nashvilleNumberAlign,         "nashvilleNumberAlign",         Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::nashvilleNumberFrameType,     "nashvilleNumberFrameType",     int(FrameType::NO_FRAME) },
    { Sid::nashvilleNumberFramePadding,  "nashvilleNumberFramePadding",  0.2 },
    { Sid::nashvilleNumberFrameWidth,    "nashvilleNumberFrameWidth",    0.1 },
    { Sid::nashvilleNumberFrameRound,    "nashvilleNumberFrameRound",    0 },
    { Sid::nashvilleNumberFrameFgColor,  "nashvilleNumberFrameFgColor",  PropertyValue::fromValue(Color::BLACK) },
    { Sid::nashvilleNumberFrameBgColor,  "nashvilleNumberFrameBgColor",  PropertyValue::fromValue(Color::transparent) },

    { Sid::capoPosition,            "capoPosition",            PropertyValue(0) },
    { Sid::fretNumMag,              "fretNumMag",              PropertyValue(2.0) },
    { Sid::fretNumPos,              "fretNumPos",              PropertyValue(0) },
    { Sid::fretY,                   "fretY",                   Spatium(1.0) },
    { Sid::fretMinDistance,         "fretMinDistance",         Spatium(0.5) },
    { Sid::fretMag,                 "fretMag",                 PropertyValue(1.0) },
    { Sid::fretPlacement,           "fretPlacement",           PlacementV::ABOVE },
    { Sid::fretStrings,             "fretStrings",             6 },
    { Sid::fretFrets,               "fretFrets",               5 },
    { Sid::fretNut,                 "fretNut",                 true },
    { Sid::fretDotSize,             "fretDotSize",             PropertyValue(1.0) },
    { Sid::fretStringSpacing,       "fretStringSpacing",       Spatium(0.7) },
    { Sid::fretFretSpacing,         "fretFretSpacing",         Spatium(0.8) },
    { Sid::fretOrientation,         "fretOrientation",         int(Orientation::VERTICAL) },
    { Sid::maxFretShiftAbove,       "maxFretShiftAbove",       Spatium(0.0) },
    { Sid::maxFretShiftBelow,       "maxFretShiftBelow",       Spatium(0.0) },

    { Sid::showPageNumber,          "showPageNumber",          true },
    { Sid::showPageNumberOne,       "showPageNumberOne",       false },
    { Sid::pageNumberOddEven,       "pageNumberOddEven",       true },
    { Sid::showMeasureNumber,       "showMeasureNumber",       true },
    { Sid::showMeasureNumberOne,    "showMeasureNumberOne",    false },
    { Sid::measureNumberInterval,   "measureNumberInterval",   PropertyValue(5) },
    { Sid::measureNumberSystem,     "measureNumberSystem",     true },
    { Sid::measureNumberAllStaves,  "measureNumberAllStaffs",  false }, // need to keep staffs and not staves here for backward compatibility
    { Sid::smallNoteMag,            "smallNoteMag",            PropertyValue(.7) },
    { Sid::graceNoteMag,            "graceNoteMag",            PropertyValue(0.7) },
    { Sid::graceToMainNoteDist,     "graceToMainNoteDist",     Spatium(0.45) },
    { Sid::graceToGraceNoteDist,    "graceToGraceNoteDist",    Spatium(0.3) },
    { Sid::smallStaffMag,           "smallStaffMag",           PropertyValue(0.7) },
    { Sid::smallClefMag,            "smallClefMag",            PropertyValue(0.8) },

    { Sid::genClef,                 "genClef",                 true },
    { Sid::hideTabClefAfterFirst,   "hideTabClefAfterFirst",   true },
    { Sid::genKeysig,               "genKeysig",               true },
    { Sid::genCourtesyTimesig,      "genCourtesyTimesig",      true },
    { Sid::genCourtesyKeysig,       "genCourtesyKeysig",       true },
    { Sid::genCourtesyClef,         "genCourtesyClef",         true },
    { Sid::swingRatio,              "swingRatio",              PropertyValue(60) },
    { Sid::swingUnit,               "swingUnit",               PropertyValue(String(u"")) },
    { Sid::useStandardNoteNames,    "useStandardNoteNames",    true },
    { Sid::useGermanNoteNames,      "useGermanNoteNames",      false },
    { Sid::useFullGermanNoteNames,  "useFullGermanNoteNames",  false },

    { Sid::useSolfeggioNoteNames,   "useSolfeggioNoteNames",   false },
    { Sid::useFrenchNoteNames,      "useFrenchNoteNames",      false },
    { Sid::automaticCapitalization, "automaticCapitalization", true },
    { Sid::lowerCaseMinorChords,    "lowerCaseMinorChords",    false },
    { Sid::lowerCaseBassNotes,      "lowerCaseBassNotes",      false },
    { Sid::allCapsNoteNames,        "allCapsNoteNames",        false },
    { Sid::chordStyle,              "chordStyle",              PropertyValue(String(u"std")) },
    { Sid::chordsXmlFile,           "chordsXmlFile",           false },
    { Sid::chordDescriptionFile,    "chordDescriptionFile",    PropertyValue(String(u"chords_std.xml")) },
    { Sid::chordExtensionMag,       "chordExtensionMag",       PropertyValue(1.0) },
    { Sid::chordExtensionAdjust,    "chordExtensionAdjust",    PropertyValue(0.0) },
    { Sid::chordModifierMag,        "chordModifierMag",        PropertyValue(1.0) },
    { Sid::chordModifierAdjust,     "chordModifierAdjust",     PropertyValue(0.0) },
    { Sid::concertPitch,            "concertPitch",            false },

    { Sid::multiVoiceRestTwoSpaceOffset,    "multiVoiceRestTwoSpaceOffset", false },
    { Sid::createMultiMeasureRests, "createMultiMeasureRests", false },
    { Sid::minEmptyMeasures,        "minEmptyMeasures",        PropertyValue(2) },
    { Sid::minMMRestWidth,          "minMMRestWidth",          Spatium(6) },
    { Sid::mmRestNumberPos,         "mmRestNumberPos",         Spatium(-0.5) },
    { Sid::mmRestNumberMaskHBar,    "mmRestNumberMaskHBar",    true },
    { Sid::multiMeasureRestMargin,  "multiMeasureRestMargin",  Spatium(1.2) },
    { Sid::mmRestHBarThickness,     "mmRestHBarThickness",     Spatium(0.7) },
    { Sid::mmRestHBarVStrokeThickness, "mmRestHBarVStrokeThickness", Spatium(0.2) },
    { Sid::mmRestHBarVStrokeHeight, "mmRestHBarVStrokeHeight", Spatium(2.0) },
    { Sid::oldStyleMultiMeasureRests, "oldStyleMultiMeasureRests", false },
    { Sid::mmRestOldStyleMaxMeasures, "mmRestOldStyleMaxMeasures", PropertyValue(9) },
    { Sid::mmRestOldStyleSpacing,   "mmRestOldStyleSpacing",   Spatium(0.85) },
    { Sid::hideEmptyStaves,         "hideEmptyStaves",         false },
    { Sid::dontHideStavesInFirstSystem,
      "dontHideStavesInFirstSystem",    true },
    { Sid::enableIndentationOnFirstSystem,
      "enableIndentationOnFirstSystem", true },
    { Sid::firstSystemIndentationValue, "firstSystemIndentationValue", Spatium(5.0) },
    { Sid::alwaysShowBracketsWhenEmptyStavesAreHidden,
      "alwaysShowBracketsWhenEmptyStavesAreHidden", false },
    { Sid::alwaysShowSquareBracketsWhenEmptyStavesAreHidden,
      "alwaysShowSquareBracketsWhenEmptyStavesAreHidden", false },
    { Sid::hideInstrumentNameIfOneInstrument,
      "hideInstrumentNameIfOneInstrument", true },
    { Sid::gateTime,                "gateTime",                PropertyValue(100) },
    { Sid::tenutoGateTime,          "tenutoGateTime",          PropertyValue(100) },
    { Sid::staccatoGateTime,        "staccatoGateTime",        PropertyValue(50) },
    { Sid::slurGateTime,            "slurGateTime",            PropertyValue(100) },

    { Sid::ArpeggioNoteDistance,    "ArpeggioNoteDistance",    Spatium(.4) },
    { Sid::ArpeggioAccidentalDistance,    "ArpeggioAccidentalDistance",    Spatium(.3) },
    { Sid::ArpeggioAccidentalDistanceMin,    "ArpeggioAccidentalDistanceMin",    Spatium(0.33) },
    { Sid::ArpeggioLineWidth,       "ArpeggioLineWidth",       Spatium(.18) },
    { Sid::ArpeggioHookLen,         "ArpeggioHookLen",         Spatium(.8) },
    { Sid::ArpeggioHiddenInStdIfTab, "ArpeggioHiddenInStdIfTab", false },
    { Sid::SlurEndWidth,            "slurEndWidth",            Spatium(.05) },
    { Sid::SlurMidWidth,            "slurMidWidth",            Spatium(.21) },
    { Sid::SlurDottedWidth,         "slurDottedWidth",         Spatium(.10) },
    { Sid::MinTieLength,            "minTieLength",            Spatium(1.0) },
    { Sid::MinStraightGlissandoLength, "minStraightGlissandoLength", Spatium(1.2) },
    { Sid::MinWigglyGlissandoLength, "minWigglyGlissandoLength", Spatium(2.0) },
    { Sid::SlurMinDistance,         "slurMinDistance",         Spatium(0.5) },
    { Sid::HeaderToLineStartDistance,   "headerSlurTieDistance",   Spatium(1.0) },

    { Sid::tiePlacementSingleNote,   "tiePlacementSingleNote", TiePlacement::OUTSIDE },
    { Sid::tiePlacementChord,        "tiePlacementChord",      TiePlacement::OUTSIDE },
    { Sid::tieMinShoulderHeight,     "tieMinShoulderHeight",   Spatium(0.3) },
    { Sid::tieMaxShoulderHeight,     "tieMaxShoulderHeight",   Spatium(2.0) },

    { Sid::SectionPause,            "sectionPause",            PropertyValue(double(3.0)) },
    { Sid::MusicalSymbolFont,       "musicalSymbolFont",       PropertyValue(String(u"Leland")) },
    { Sid::MusicalTextFont,         "musicalTextFont",         PropertyValue(String(u"Leland Text")) },

    { Sid::showHeader,              "showHeader",              true },
    { Sid::headerFirstPage,         "headerFirstPage",         false },
    { Sid::headerOddEven,           "headerOddEven",           true },
    { Sid::evenHeaderL,             "evenHeaderL",             PropertyValue(String(u"$p")) },
    { Sid::evenHeaderC,             "evenHeaderC",             PropertyValue(String()) },
    { Sid::evenHeaderR,             "evenHeaderR",             PropertyValue(String()) },
    { Sid::oddHeaderL,              "oddHeaderL",              PropertyValue(String()) },
    { Sid::oddHeaderC,              "oddHeaderC",              PropertyValue(String()) },
    { Sid::oddHeaderR,              "oddHeaderR",              PropertyValue(String(u"$p")) },
    { Sid::showFooter,              "showFooter",              true },

    { Sid::footerFirstPage,         "footerFirstPage",         true },
    { Sid::footerOddEven,           "footerOddEven",           true },
    { Sid::evenFooterL,             "evenFooterL",             PropertyValue(String()) },
    { Sid::evenFooterC,             "evenFooterC",             PropertyValue(String(u"$C")) },
    { Sid::evenFooterR,             "evenFooterR",             PropertyValue(String()) },
    { Sid::oddFooterL,              "oddFooterL",              PropertyValue(String()) },
    { Sid::oddFooterC,              "oddFooterC",              PropertyValue(String(u"$C")) },
    { Sid::oddFooterR,              "oddFooterR",              PropertyValue(String()) },

    { Sid::voltaPosAbove,           "voltaPosAbove",           PointF(0.0, -3.0) },
    { Sid::voltaHook,               "voltaHook",               Spatium(2.2) },
    { Sid::voltaLineWidth,          "voltaLineWidth",          Spatium(0.11) },
    { Sid::voltaLineStyle,          "voltaLineStyle",          PropertyValue(LineType::SOLID) },
    { Sid::voltaDashLineLen,        "voltaDashLineLen",        5.0 },
    { Sid::voltaDashGapLen,         "voltaDashGapLen",         5.0 },
    { Sid::voltaFontFace,           "voltaFontFace",           "Edwin" },
    { Sid::voltaFontSize,           "voltaFontSize",           11.0 },
    { Sid::voltaLineSpacing,        "voltaLineSpacing",        1.0 },
    { Sid::voltaFontSpatiumDependent, "voltaFontSpatiumDependent", true },
    { Sid::voltaFontStyle,          "voltaFontStyle",          int(FontStyle::Bold) },
    { Sid::voltaColor,              "voltaColor",              PropertyValue::fromValue(Color::BLACK) },
    { Sid::voltaAlign,              "voltaAlign",              Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::voltaOffset,             "voltaOffset",             PointF(0.6, 2.2) },
    { Sid::voltaFrameType,          "voltaFrameType",          int(FrameType::NO_FRAME) },
    { Sid::voltaFramePadding,       "voltaFramePadding",       0.2 },
    { Sid::voltaFrameWidth,         "voltaFrameWidth",         0.1 },
    { Sid::voltaFrameRound,         "voltaFrameRound",         0 },
    { Sid::voltaFrameFgColor,       "voltaFrameFgColor",       PropertyValue::fromValue(Color::BLACK) },
    { Sid::voltaFrameBgColor,       "voltaFrameBgColor",       PropertyValue::fromValue(Color::transparent) },

    { Sid::ottava8VAPlacement,      "ottava8VAPlacement",      PlacementV::ABOVE },
    { Sid::ottava8VBPlacement,      "ottava8VBPlacement",      PlacementV::BELOW },
    { Sid::ottava15MAPlacement,     "ottava15MAPlacement",     PlacementV::ABOVE },
    { Sid::ottava15MBPlacement,     "ottava15MBPlacement",     PlacementV::BELOW },
    { Sid::ottava22MAPlacement,     "ottava22MAPlacement",     PlacementV::ABOVE },
    { Sid::ottava22MBPlacement,     "ottava22MBPlacement",     PlacementV::BELOW },

    { Sid::ottava8VAText,           "ottava8VAText",           String(u"<sym>ottavaAlta</sym>") },
    { Sid::ottava8VAContinueText,   "ottava8VAContinueText",   String(u"<sym>ottavaAlta</sym>") },
    { Sid::ottava8VBText,           "ottava8VBText",           String(u"<sym>ottavaBassa</sym>") },
    { Sid::ottava8VBContinueText,   "ottava8VBContinueText",   String(u"<sym>ottavaBassa</sym>") },
    { Sid::ottava15MAText,          "ottava15MAText",          String(u"<sym>quindicesimaAlta</sym>") },
    { Sid::ottava15MAContinueText,  "ottava15MAContinueText",  String(u"<sym>quindicesimaAlta</sym>") },
    { Sid::ottava15MBText,          "ottava15MBText",          String(u"<sym>quindicesimaBassa</sym>") },
    { Sid::ottava15MBContinueText,  "ottava15MBContinueText",  String(u"<sym>quindicesimaBassa</sym>") },
    { Sid::ottava22MAText,          "ottava22MAText",          String(u"<sym>ventiduesimaAlta</sym>") },
    { Sid::ottava22MAContinueText,  "ottava22MAContinueText",  String(u"<sym>ventiduesimaAlta</sym>") },
    { Sid::ottava22MBText,          "ottava22MBText",          String(u"<sym>ventiduesimaBassa</sym>") },
    { Sid::ottava22MBContinueText, "ottava22MBContinueText",   String(u"<sym>ventiduesimaBassa</sym>") },

    { Sid::ottava8VAnoText,         "ottava8VAnoText",         String(u"<sym>ottava</sym>") },
    { Sid::ottava8VAnoContinueText, "ottava8VAnoContinueText", String(u"<sym>ottava</sym>") },
    { Sid::ottava8VBnoText,         "ottava8VBnoText",         String(u"<sym>ottava</sym>") },
    { Sid::ottava8VBnoContinueText, "ottava8VBnoContinueText", String(u"<sym>ottava</sym>") },
    { Sid::ottava15MAnoText,        "ottava15MAnoText",        String(u"<sym>quindicesima</sym>") },
    { Sid::ottava15MAnoContinueText, "ottava15MAnoContinueText", String(u"<sym>quindicesima</sym>") },
    { Sid::ottava15MBnoText,        "ottava15MBnoText",        String(u"<sym>quindicesima</sym>") },
    { Sid::ottava15MBnoContinueText, "ottava15MBnoContinueText", String(u"<sym>quindicesima</sym>") },
    { Sid::ottava22MAnoText,        "ottava22MAnoText",        String(u"<sym>ventiduesima</sym>") },
    { Sid::ottava22MAnoContinueText, "ottava22MAnoContinueText", String(u"<sym>ventiduesima</sym>") },
    { Sid::ottava22MBnoText,        "ottava22MBnoText",        String(u"<sym>ventiduesima</sym>") },
    { Sid::ottava22MBnoContinueText, "ottava22MBnoContinueText", String(u"<sym>ventiduesima</sym>") },

    { Sid::ottavaPosAbove,          "ottavaPosAbove",          PointF(.0, -2.0) },
    { Sid::ottavaPosBelow,          "ottavaPosBelow",          PointF(.0, 2.0) },
    { Sid::ottavaHookAbove,         "ottavaHookAbove",         Spatium(1) },
    { Sid::ottavaHookBelow,         "ottavaHookBelow",         Spatium(-1) },
    { Sid::ottavaLineWidth,         "ottavaLineWidth",         Spatium(0.11) },
    { Sid::ottavaLineStyle,         "ottavaLineStyle",         PropertyValue(LineType::DASHED) },
    { Sid::ottavaDashLineLen,       "ottavaDashLineLen",       6.0 },
    { Sid::ottavaDashGapLen,        "ottavaDashGapLen",        6.0 },
    { Sid::ottavaNumbersOnly,       "ottavaNumbersOnly",       true },
    { Sid::ottavaFontFace,          "ottavaFontFace",          "Edwin" },
    { Sid::ottavaFontSize,          "ottavaFontSize",          10.0 },
    { Sid::ottavaLineSpacing,       "ottavaLineSpacing",       1.0 },
    { Sid::ottavaFontSpatiumDependent, "ottavaFontSpatiumDependent", true },
    { Sid::ottavaFontStyle,         "ottavaFontStyle",         int(FontStyle::Normal) },
    { Sid::ottavaColor,             "ottavaColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::ottavaTextAlignAbove,    "ottavaTextAlignAbove",    Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::ottavaTextAlignBelow,    "ottavaTextAlignBelow",    Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::ottavaFrameType,         "ottavaFrameType",         int(FrameType::NO_FRAME) },
    { Sid::ottavaFramePadding,      "ottavaFramePadding",      0.2 },
    { Sid::ottavaFrameWidth,        "ottavaFrameWidth",        0.1 },
    { Sid::ottavaFrameRound,        "ottavaFrameRound",        0 },
    { Sid::ottavaFrameFgColor,      "ottavaFrameFgColor",      PropertyValue::fromValue(Color::BLACK) },
    { Sid::ottavaFrameBgColor,      "ottavaFrameBgColor",      PropertyValue::fromValue(Color::transparent) },

    { Sid::tabClef,                 "tabClef",                 PropertyValue(int(ClefType::TAB)) },

    { Sid::tremoloWidth,            "tremoloWidth",            Spatium(1.2) },  // tremolo stroke width: notehead width
    { Sid::tremoloBoxHeight,        "tremoloBoxHeight",        Spatium(0.65) },
    { Sid::tremoloStrokeWidth,      "tremoloLineWidth",        Spatium(0.5) },  // was 0.35
    { Sid::tremoloDistance,         "tremoloDistance",         Spatium(0.8) },
    { Sid::tremoloStyle,            "tremoloStrokeStyle",      int(TremoloStyle::DEFAULT) },
    { Sid::tremoloStrokeLengthMultiplier, "tremoloStrokeLengthMultiplier", 0.62 },
    { Sid::tremoloNoteSidePadding,  "tremoloNoteSidePadding",  Spatium(1.25) },
    { Sid::tremoloOutSidePadding,   "tremoloOutSidePadding",   Spatium(0.5) },

    { Sid::linearStretch,           "linearStretch",           PropertyValue(double(1.5)) },
    { Sid::crossMeasureValues,      "crossMeasureValues",      false },
    { Sid::keySigNaturals,          "keySigNaturals",          PropertyValue(int(KeySigNatural::NONE)) },

    { Sid::tupletMaxSlope,          "tupletMaxSlope",          PropertyValue(double(0.5)) },
    { Sid::tupletOufOfStaff,        "tupletOufOfStaff",        true },
    { Sid::tupletVHeadDistance,     "tupletVHeadDistance",     Spatium(.5) },
    { Sid::tupletVStemDistance,     "tupletVStemDistance",     Spatium(.5) },
    { Sid::tupletStemLeftDistance,  "tupletStemLeftDistance",  Spatium(.5) },
    { Sid::tupletStemRightDistance, "tupletStemRightDistance", Spatium(.5) },
    { Sid::tupletNoteLeftDistance,  "tupletNoteLeftDistance",  Spatium(0.0) },
    { Sid::tupletNoteRightDistance, "tupletNoteRightDistance", Spatium(0.0) },
    { Sid::tupletBracketWidth,      "tupletBracketWidth",      Spatium(0.1) },
    { Sid::tupletDirection,         "tupletDirection",         DirectionV::AUTO },
    { Sid::tupletNumberType,        "tupletNumberType",        int(TupletNumberType::SHOW_NUMBER) },
    { Sid::tupletBracketType,       "tupletBracketType",       int(TupletBracketType::AUTO_BRACKET) },
    { Sid::tupletFontFace,          "tupletFontFace",          "Edwin" },
    { Sid::tupletFontSize,          "tupletFontSize",          9.0 },
    { Sid::tupletLineSpacing,       "tupletLineSpacing",       1.0 },
    { Sid::tupletFontSpatiumDependent, "tupletFontSpatiumDependent", true },
    { Sid::tupletFontStyle,         "tupletFontStyle",         int(FontStyle::Italic) },
    { Sid::tupletColor,             "tupletColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::tupletAlign,             "tupletAlign",             Align(AlignH::HCENTER, AlignV::VCENTER) },
    { Sid::tupletBracketHookHeight, "tupletBracketHookHeight", Spatium(0.75) },
    { Sid::tupletOffset,            "tupletOffset",            PointF() },
    { Sid::tupletFrameType,         "tupletFrameType",         int(FrameType::NO_FRAME) },
    { Sid::tupletFramePadding,      "tupletFramePadding",      0.2 },
    { Sid::tupletFrameWidth,        "tupletFrameWidth",        0.1 },
    { Sid::tupletFrameRound,        "tupletFrameRound",        0 },
    { Sid::tupletFrameFgColor,      "tupletFrameFgColor",      PropertyValue::fromValue(Color::BLACK) },
    { Sid::tupletFrameBgColor,      "tupletFrameBgColor",      PropertyValue::fromValue(Color::transparent) },

    { Sid::barreLineWidth,          "barreLineWidth",          PropertyValue(1.0) },
    { Sid::scaleBarlines,           "scaleBarlines",           false },
    { Sid::barGraceDistance,        "barGraceDistance",        Spatium(1.0) },
    { Sid::minVerticalDistance,     "minVerticalDistance",     Spatium(0.5) },
    { Sid::ornamentStyle,           "ornamentStyle",           int(OrnamentStyle::DEFAULT) },
    { Sid::spatium,                 "Spatium",                 24.8 },

    { Sid::autoplaceHairpinDynamicsDistance, "autoplaceHairpinDynamicsDistance", Spatium(0.5) },

    { Sid::dynamicsOverrideFont,    "dynamicsOverrideFont",    false },
    { Sid::dynamicsFont,            "dynamicsFont",            PropertyValue(String(u"Leland")) },
    { Sid::dynamicsSize,            "dynamicsSize",            1.0 }, // percentage of the standard size
    { Sid::dynamicsPlacement,       "dynamicsPlacement",       PlacementV::BELOW },
    { Sid::dynamicsPosAbove,        "dynamicsPosAbove",        PointF(.0, -1.5) },
    { Sid::dynamicsPosBelow,        "dynamicsPosBelow",        PointF(.0, 2.5) },
    { Sid::avoidBarLines,           "avoidBarLines",           true },
    { Sid::snapToDynamics,          "snapToDynamics",          true },
    { Sid::centerOnNotehead,        "centerOnNotehead",        true },
    { Sid::dynamicsMinDistance,         "dynamicsMinDistance",               Spatium(0.5) },
    { Sid::autoplaceVerticalAlignRange, "autoplaceVerticalAlignRange",     int(VerticalAlignRange::SYSTEM) },

    { Sid::textLinePlacement,         "textLinePlacement",         PlacementV::ABOVE },
    { Sid::textLinePosAbove,          "textLinePosAbove",          PointF(.0, -1.0) },
    { Sid::textLinePosBelow,          "textLinePosBelow",          PointF(.0, 1.0) },
    { Sid::textLineFrameType,         "textLineFrameType",          int(FrameType::NO_FRAME) },
    { Sid::textLineFramePadding,      "textLineFramePadding",       0.2 },
    { Sid::textLineFrameWidth,        "textLineFrameWidth",         0.1 },
    { Sid::textLineFrameRound,        "textLineFrameRound",         0 },
    { Sid::textLineFrameFgColor,      "textLineFrameFgColor",       PropertyValue::fromValue(Color::BLACK) },
    { Sid::textLineFrameBgColor,      "textLineFrameBgColor",       PropertyValue::fromValue(Color::transparent) },

    { Sid::systemTextLinePlacement,         "systemTextLinePlacement",         PlacementV::ABOVE },
    { Sid::systemTextLinePosAbove,          "systemTextLinePosAbove",          PointF(.0, -1.0) },
    { Sid::systemTextLinePosBelow,          "systemTextLinePosBelow",          PointF(.0, 1.0) },
    { Sid::systemTextLineFrameType,         "systemTextLineFrameType",          int(FrameType::NO_FRAME) },
    { Sid::systemTextLineFramePadding,      "systemTextLineFramePadding",       0.2 },
    { Sid::systemTextLineFrameWidth,        "systemTextLineFrameWidth",         0.1 },
    { Sid::systemTextLineFrameRound,        "systemTextLineFrameRound",         0 },
    { Sid::systemTextLineFrameFgColor,      "systemTextLineFrameFgColor",       PropertyValue::fromValue(Color::BLACK) },
    { Sid::systemTextLineFrameBgColor,      "systemTextLineFrameBgColor",       PropertyValue::fromValue(Color::transparent) },

    { Sid::tremoloBarLineWidth,       "tremoloBarLineWidth",       Spatium(0.12) },
    { Sid::jumpPosAbove,              "jumpPosAbove",              PointF(.0, -2.0) },
    { Sid::markerPosAbove,            "markerPosAbove",            PointF(.0, -2.0) },

    { Sid::defaultFontFace,               "defaultFontFace",               "Edwin" },
    { Sid::defaultFontSize,               "defaultFontSize",               10.0 },
    { Sid::defaultLineSpacing,            "defaultLineSpacing",            1.0 },
    { Sid::defaultFontSpatiumDependent,   "defaultFontSpatiumDependent",   true },
    { Sid::defaultFontStyle,              "defaultFontStyle",              int(FontStyle::Normal) },
    { Sid::defaultColor,                  "defaultColor",                  PropertyValue::fromValue(Color::BLACK) },
    { Sid::defaultAlign,                  "defaultAlign",                  Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::defaultFrameType,              "defaultFrameType",              int(FrameType::NO_FRAME) },
    { Sid::defaultFramePadding,           "defaultFramePadding",           Spatium(0.2) },
    { Sid::defaultFrameWidth,             "defaultFrameWidth",             Spatium(0.1) },
    { Sid::defaultFrameRound,             "defaultFrameRound",             0 },
    { Sid::defaultFrameFgColor,           "defaultFrameFgColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::defaultFrameBgColor,           "defaultFrameBgColor",           PropertyValue::fromValue(Color::transparent) },
    { Sid::defaultOffset,                 "defaultOffset",                 PointF() },
    { Sid::defaultOffsetType,             "defaultOffsetType",             int(OffsetType::SPATIUM) },
    { Sid::defaultSystemFlag,             "defaultSystemFlag",             false },
    { Sid::defaultText,                   "defaultText",                   String(u"") },

    { Sid::titleFontFace,                 "titleFontFace",                 "Edwin" },
    { Sid::titleFontSize,                 "titleFontSize",                 22.0 },
    { Sid::titleLineSpacing,              "titleLineSpacing",              1.0 },
    { Sid::titleFontSpatiumDependent,     "titleFontSpatiumDependent",     false },
    { Sid::titleFontStyle,                "titleFontStyle",                int(FontStyle::Normal) },
    { Sid::titleColor,                    "titleColor",                    PropertyValue::fromValue(Color::BLACK) },
    { Sid::titleAlign,                    "titleAlign",                    Align(AlignH::HCENTER, AlignV::TOP) },
    { Sid::titleOffset,                   "titleOffset",                   PointF() },
    { Sid::titleOffsetType,               "titleOffsetType",               int(OffsetType::ABS) },
    { Sid::titleFrameType,                "titleFrameType",                int(FrameType::NO_FRAME) },
    { Sid::titleFramePadding,             "titleFramePadding",             0.2 },
    { Sid::titleFrameWidth,               "titleFrameWidth",               0.1 },
    { Sid::titleFrameRound,               "titleFrameRound",               0 },
    { Sid::titleFrameFgColor,             "titleFrameFgColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::titleFrameBgColor,             "titleFrameBgColor",             PropertyValue::fromValue(Color::transparent) },

    { Sid::subTitleFontFace,              "subTitleFontFace",              "Edwin" },
    { Sid::subTitleFontSize,              "subTitleFontSize",              14.0 },
    { Sid::subTitleLineSpacing,           "subTitleLineSpacing",           1.0 },
    { Sid::subTitleFontSpatiumDependent,  "subTitleFontSpatiumDependent",  false },
    { Sid::subTitleFontStyle,             "subTitleFontStyle",             int(FontStyle::Normal) },
    { Sid::subTitleColor,                 "subTitleColor",                 PropertyValue::fromValue(Color::BLACK) },
    { Sid::subTitleAlign,                 "subTitleAlign",                 Align(AlignH::HCENTER, AlignV::TOP) },
    { Sid::subTitleOffset,                "subTitleOffset",                PointF(0.0, 10.0) },
    { Sid::subTitleOffsetType,            "subTitleOffsetType",            int(OffsetType::ABS) },
    { Sid::subTitleFrameType,             "subTitleFrameType",             int(FrameType::NO_FRAME) },
    { Sid::subTitleFramePadding,          "subTitleFramePadding",          0.2 },
    { Sid::subTitleFrameWidth,            "subTitleFrameWidth",            0.1 },
    { Sid::subTitleFrameRound,            "subTitleFrameRound",            0 },
    { Sid::subTitleFrameFgColor,          "subTitleFrameFgColor",          PropertyValue::fromValue(Color::BLACK) },
    { Sid::subTitleFrameBgColor,          "subTitleFrameBgColor",          PropertyValue::fromValue(Color::transparent) },

    { Sid::composerFontFace,              "composerFontFace",              "Edwin" },
    { Sid::composerFontSize,              "composerFontSize",              10.0 },
    { Sid::composerLineSpacing,           "composerLineSpacing",           1.0 },
    { Sid::composerFontSpatiumDependent,  "composerFontSpatiumDependent",  false },
    { Sid::composerFontStyle,             "composerFontStyle",             int(FontStyle::Normal) },
    { Sid::composerColor,                 "composerColor",                 PropertyValue::fromValue(Color::BLACK) },
    { Sid::composerAlign,                 "composerAlign",                 Align(AlignH::RIGHT, AlignV::BOTTOM) },
    { Sid::composerOffset,                "composerOffset",                PointF() },
    { Sid::composerOffsetType,            "composerOffsetType",            int(OffsetType::ABS) },
    { Sid::composerFrameType,             "composerFrameType",             int(FrameType::NO_FRAME) },
    { Sid::composerFramePadding,          "composerFramePadding",          0.2 },
    { Sid::composerFrameWidth,            "composerFrameWidth",            0.1 },
    { Sid::composerFrameRound,            "composerFrameRound",            0 },
    { Sid::composerFrameFgColor,          "composerFrameFgColor",          PropertyValue::fromValue(Color::BLACK) },
    { Sid::composerFrameBgColor,          "composerFrameBgColor",          PropertyValue::fromValue(Color::transparent) },

    { Sid::lyricistFontFace,              "lyricistFontFace",              "Edwin" },
    { Sid::lyricistFontSize,              "lyricistFontSize",              10.0 },
    { Sid::lyricistLineSpacing,           "lyricistLineSpacing",           1.0 },
    { Sid::lyricistFontSpatiumDependent,  "lyricistFontSpatiumDependent",  false },
    { Sid::lyricistFontStyle,             "lyricistFontStyle",             int(FontStyle::Normal) },
    { Sid::lyricistColor,                 "lyricistColor",                 PropertyValue::fromValue(Color::BLACK) },
    { Sid::lyricistAlign,                 "lyricistAlign",                 Align(AlignH::LEFT, AlignV::BOTTOM) },
    { Sid::lyricistOffset,                "lyricistOffset",                PointF() },
    { Sid::lyricistOffsetType,            "lyricistOffsetType",            int(OffsetType::ABS) },
    { Sid::lyricistFrameType,             "lyricistFrameType",             int(FrameType::NO_FRAME) },
    { Sid::lyricistFramePadding,          "lyricistFramePadding",          0.2 },
    { Sid::lyricistFrameWidth,            "lyricistFrameWidth",            0.1 },
    { Sid::lyricistFrameRound,            "lyricistFrameRound",            0 },
    { Sid::lyricistFrameFgColor,          "lyricistFrameFgColor",          PropertyValue::fromValue(Color::BLACK) },
    { Sid::lyricistFrameBgColor,          "lyricistFrameBgColor",          PropertyValue::fromValue(Color::transparent) },

    { Sid::fingeringFontFace,             "fingeringFontFace",             "Edwin" },
    { Sid::fingeringFontSize,             "fingeringFontSize",             8.0 },
    { Sid::fingeringLineSpacing,          "fingeringLineSpacing",          1.0 },
    { Sid::fingeringFontSpatiumDependent, "fingeringFontSpatiumDependent", true },
    { Sid::fingeringFontStyle,            "fingeringFontStyle",             int(FontStyle::Normal) },
    { Sid::fingeringColor,                "fingeringColor",                PropertyValue::fromValue(Color::BLACK) },
    { Sid::fingeringAlign,                "fingeringAlign",                Align(AlignH::HCENTER, AlignV::VCENTER) },
    { Sid::fingeringFrameType,            "fingeringFrameType",            int(FrameType::NO_FRAME) },
    { Sid::fingeringFramePadding,         "fingeringFramePadding",         0.2 },
    { Sid::fingeringFrameWidth,           "fingeringFrameWidth",           0.1 },
    { Sid::fingeringFrameRound,           "fingeringFrameRound",           0 },
    { Sid::fingeringFrameFgColor,         "fingeringFrameFgColor",         PropertyValue::fromValue(Color::BLACK) },
    { Sid::fingeringFrameBgColor,         "fingeringFrameBgColor",         PropertyValue::fromValue(Color::transparent) },
    { Sid::fingeringOffset,               "fingeringOffset",               PointF() },

    { Sid::lhGuitarFingeringFontFace,     "lhGuitarFingeringFontFace",     "Edwin" },
    { Sid::lhGuitarFingeringFontSize,     "lhGuitarFingeringFontSize",     8.0 },
    { Sid::lhGuitarFingeringLineSpacing,  "lhGuitarFingeringLineSpacing",  1.0 },
    { Sid::lhGuitarFingeringFontSpatiumDependent, "lhGuitarFingeringFontSpatiumDependent", true },
    { Sid::lhGuitarFingeringFontStyle,    "lhGuitarFingeringFontStyle",    int(FontStyle::Normal) },
    { Sid::lhGuitarFingeringColor,        "lhGuitarFingeringColor",        PropertyValue::fromValue(Color::BLACK) },
    { Sid::lhGuitarFingeringAlign,        "lhGuitarFingeringAlign",        Align(AlignH::RIGHT, AlignV::VCENTER) },
    { Sid::lhGuitarFingeringFrameType,    "lhGuitarFingeringFrameType",    int(FrameType::NO_FRAME) },
    { Sid::lhGuitarFingeringFramePadding, "lhGuitarFingeringFramePadding", 0.2 },
    { Sid::lhGuitarFingeringFrameWidth,   "lhGuitarFingeringFrameWidth",   0.1 },
    { Sid::lhGuitarFingeringFrameRound,   "lhGuitarFingeringFrameRound",   0 },
    { Sid::lhGuitarFingeringFrameFgColor, "lhGuitarFingeringFrameFgColor", PropertyValue::fromValue(Color::BLACK) },
    { Sid::lhGuitarFingeringFrameBgColor, "lhGuitarFingeringFrameBgColor", PropertyValue::fromValue(Color::transparent) },
    { Sid::lhGuitarFingeringOffset,       "lhGuitarFingeringOffset",       PointF(-0.5, 0.0) },

    { Sid::rhGuitarFingeringFontFace,     "rhGuitarFingeringFontFace",     "Edwin" },
    { Sid::rhGuitarFingeringFontSize,     "rhGuitarFingeringFontSize",     8.0 },
    { Sid::rhGuitarFingeringLineSpacing,  "rhGuitarFingeringLineSpacing",  1.0 },
    { Sid::rhGuitarFingeringFontSpatiumDependent, "rhGuitarFingeringFontSpatiumDependent", true },
    { Sid::rhGuitarFingeringFontStyle,    "rhGuitarFingeringFontStyle",    int(FontStyle::Italic) },
    { Sid::rhGuitarFingeringColor,        "rhGuitarFingeringColor",        PropertyValue::fromValue(Color::BLACK) },
    { Sid::rhGuitarFingeringAlign,        "rhGuitarFingeringAlign",        Align(AlignH::HCENTER, AlignV::VCENTER) },
    { Sid::rhGuitarFingeringFrameType,    "rhGuitarFingeringFrameType",    int(FrameType::NO_FRAME) },
    { Sid::rhGuitarFingeringFramePadding, "rhGuitarFingeringFramePadding", 0.2 },
    { Sid::rhGuitarFingeringFrameWidth,   "rhGuitarFingeringFrameWidth",   0.1 },
    { Sid::rhGuitarFingeringFrameRound,   "rhGuitarFingeringFrameRound",   0 },
    { Sid::rhGuitarFingeringFrameFgColor, "rhGuitarFingeringFrameFgColor", PropertyValue::fromValue(Color::BLACK) },
    { Sid::rhGuitarFingeringFrameBgColor, "rhGuitarFingeringFrameBgColor", PropertyValue::fromValue(Color::transparent) },
    { Sid::rhGuitarFingeringOffset,       "rhGuitarFingeringOffset",       PointF() },

    { Sid::stringNumberFontFace,          "stringNumberFontFace",          "Edwin" },
    { Sid::stringNumberFontSize,          "stringNumberFontSize",          8.0 },
    { Sid::stringNumberLineSpacing,       "stringNumberLineSpacing",       1.0 },
    { Sid::stringNumberFontSpatiumDependent, "stringNumberFontSpatiumDependent", true },
    { Sid::stringNumberFontStyle,         "stringNumberFontStyle",         int(FontStyle::Normal) },
    { Sid::stringNumberColor,             "stringNumberColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::stringNumberAlign,             "stringNumberAlign",             Align(AlignH::HCENTER, AlignV::VCENTER) },
    { Sid::stringNumberFrameType,         "stringNumberFrameType",         int(FrameType::CIRCLE) },
    { Sid::stringNumberFramePadding,      "stringNumberFramePadding",      0.2 },
    { Sid::stringNumberFrameWidth,        "stringNumberFrameWidth",        0.1 },
    { Sid::stringNumberFrameRound,        "stringNumberFrameRound",        0 },
    { Sid::stringNumberFrameFgColor,      "stringNumberFrameFgColor",      PropertyValue::fromValue(Color::BLACK) },
    { Sid::stringNumberFrameBgColor,      "stringNumberFrameBgColor",      PropertyValue::fromValue(Color::transparent) },
    { Sid::stringNumberOffset,            "stringNumberOffset",            PointF(0.0, 0.0) },
    { Sid::preferSameStringForTranspose,  "preferSameStringForTranspose",  false },

    { Sid::stringTuningsFontSize,         "stringTuningsFontSize",         9.0 },

    { Sid::harpPedalDiagramFontFace,          "harpPedalDiagramFontFace",          "Edwin" },
    { Sid::harpPedalDiagramFontSize,          "harpPedalDiagramFontSize",          10.0 },
    { Sid::harpPedalDiagramLineSpacing,       "harpPedalDiagramLineSpacing",       1.0 },
    { Sid::harpPedalDiagramFontSpatiumDependent, "harpPedalDiagramFontSpatiumDependent", true },
    { Sid::harpPedalDiagramFontStyle,         "harpPedalDiagramFontStyle",         int(FontStyle::Normal) },
    { Sid::harpPedalDiagramColor,             "harpPedalDiagramColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::harpPedalDiagramAlign,             "harpPedalDiagramAlign",             Align(AlignH::HCENTER, AlignV::VCENTER) },
    { Sid::harpPedalDiagramFrameType,         "harpPedalDiagramFrameType",         int(FrameType::NO_FRAME) },
    { Sid::harpPedalDiagramFramePadding,      "harpPedalDiagramFramePadding",      0.2 },
    { Sid::harpPedalDiagramFrameWidth,        "harpPedalDiagramFrameWidth",        0.1 },
    { Sid::harpPedalDiagramFrameRound,        "harpPedalDiagramFrameRound",        0 },
    { Sid::harpPedalDiagramFrameFgColor,      "harpPedalDiagramFrameFgColor",      PropertyValue::fromValue(Color::BLACK) },
    { Sid::harpPedalDiagramFrameBgColor,      "harpPedalDiagramFrameBgColor",
      PropertyValue::fromValue(draw::Color::transparent) },
    { Sid::harpPedalDiagramOffset,            "harpPedalDiagramOffset",            PointF() },
    { Sid::harpPedalDiagramPlacement,         "harpPedalDiagramPlacement",         PlacementV::ABOVE },
    { Sid::harpPedalDiagramPosAbove,          "harpPedalDiagramPosAbove",          PointF(.0, -1.0) },
    { Sid::harpPedalDiagramPosBelow,          "harpPedalDiagramPosBelow",          PointF(.0, 2.5) },
    { Sid::harpPedalDiagramMinDistance,       "harpPedalDiagramMinDistance",       Spatium(.5) },

    { Sid::harpPedalTextDiagramFontFace,          "harpPedalTextDiagramFontFace",          "Edwin" },
    { Sid::harpPedalTextDiagramFontSize,          "harpPedalTextDiagramFontSize",          8.0 },
    { Sid::harpPedalTextDiagramLineSpacing,       "harpPedalTextDiagramLineSpacing",       1.0 },
    { Sid::harpPedalTextDiagramFontSpatiumDependent, "harpPedalTextDiagramFontSpatiumDependent", true },
    { Sid::harpPedalTextDiagramFontStyle,         "harpPedalTextDiagramFontStyle",         int(FontStyle::Normal) },
    { Sid::harpPedalTextDiagramColor,             "harpPedalTextDiagramColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::harpPedalTextDiagramAlign,             "harpPedalTextDiagramAlign",             Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::harpPedalTextDiagramFrameType,         "harpPedalTextDiagramFrameType",         int(FrameType::NO_FRAME) },
    { Sid::harpPedalTextDiagramFramePadding,      "harpPedalTextDiagramFramePadding",      0.2 },
    { Sid::harpPedalTextDiagramFrameWidth,        "harpPedalTextDiagramFrameWidth",        0.1 },
    { Sid::harpPedalTextDiagramFrameRound,        "harpPedalTextDiagramFrameRound",        0 },
    { Sid::harpPedalTextDiagramFrameFgColor,      "harpPedalTextDiagramFrameFgColor",      PropertyValue::fromValue(Color::BLACK) },
    { Sid::harpPedalTextDiagramFrameBgColor,      "harpPedalTextDiagramFrameBgColor",
      PropertyValue::fromValue(draw::Color::transparent) },
    { Sid::harpPedalTextDiagramOffset,            "harpPedalTextDiagramOffset",            PointF() },
    { Sid::harpPedalTextDiagramPlacement,         "harpPedalTextDiagramPlacement",         PlacementV::BELOW },
    { Sid::harpPedalTextDiagramPosAbove,          "harpPedalTextDiagramPosAbove",          PointF(.0, -1.5) },
    { Sid::harpPedalTextDiagramPosBelow,          "harpPedalTextDiagramPosBelow",          PointF(.0, 2.5) },
    { Sid::harpPedalTextDiagramMinDistance,       "harpPedalTextDiagramMinDistance",       Spatium(.5) },

    { Sid::longInstrumentFontFace,        "longInstrumentFontFace",       "Edwin" },
    { Sid::longInstrumentFontSize,        "longInstrumentFontSize",       10.0 },
    { Sid::longInstrumentLineSpacing,     "longInstrumentLineSpacing",    1.0 },
    { Sid::longInstrumentFontSpatiumDependent, "longInstrumentFontSpatiumDependent", true },
    { Sid::longInstrumentFontStyle,       "longInstrumentFontStyle",      int(FontStyle::Normal) },
    { Sid::longInstrumentColor,           "longInstrumentColor",          PropertyValue::fromValue(Color::BLACK) },
    { Sid::longInstrumentAlign,           "longInstrumentAlign",          Align(AlignH::RIGHT, AlignV::VCENTER) },
    { Sid::longInstrumentOffset,          "longInstrumentOffset",         PointF(.0, .0) },
    { Sid::longInstrumentFrameType,       "longInstrumentFrameType",      int(FrameType::NO_FRAME) },
    { Sid::longInstrumentFramePadding,    "longInstrumentFramePadding",   0.2 },
    { Sid::longInstrumentFrameWidth,      "longInstrumentFrameWidth",     0.1 },
    { Sid::longInstrumentFrameRound,      "longInstrumentFrameRound",     0 },
    { Sid::longInstrumentFrameFgColor,    "longInstrumentFrameFgColor",   PropertyValue::fromValue(Color::BLACK) },
    { Sid::longInstrumentFrameBgColor,    "longInstrumentFrameBgColor",   PropertyValue::fromValue(Color::transparent) },

    { Sid::shortInstrumentFontFace,       "shortInstrumentFontFace",      "Edwin" },
    { Sid::shortInstrumentFontSize,       "shortInstrumentFontSize",      10.0 },
    { Sid::shortInstrumentLineSpacing,    "shortInstrumentLineSpacing",   1.0 },
    { Sid::shortInstrumentFontSpatiumDependent, "shortInstrumentFontSpatiumDependent", true },
    { Sid::shortInstrumentFontStyle,      "shortInstrumentFontStyle",     int(FontStyle::Normal) },
    { Sid::shortInstrumentColor,          "shortInstrumentColor",         PropertyValue::fromValue(Color::BLACK) },
    { Sid::shortInstrumentAlign,          "shortInstrumentAlign",         Align(AlignH::RIGHT, AlignV::VCENTER) },
    { Sid::shortInstrumentOffset,         "shortInstrumentOffset",        PointF(.0, .0) },
    { Sid::shortInstrumentFrameType,      "shortInstrumentFrameType",     int(FrameType::NO_FRAME) },
    { Sid::shortInstrumentFramePadding,   "shortInstrumentFramePadding",  0.2 },
    { Sid::shortInstrumentFrameWidth,     "shortInstrumentFrameWidth",    0.1 },
    { Sid::shortInstrumentFrameRound,     "shortInstrumentFrameRound",    0 },
    { Sid::shortInstrumentFrameFgColor,   "shortInstrumentFrameFgColor",  PropertyValue::fromValue(Color::BLACK) },
    { Sid::shortInstrumentFrameBgColor,   "shortInstrumentFrameBgColor",  PropertyValue::fromValue(Color::transparent) },

    { Sid::partInstrumentFontFace,        "partInstrumentFontFace",       "Edwin" },
    { Sid::partInstrumentFontSize,        "partInstrumentFontSize",       14.0 },
    { Sid::partInstrumentLineSpacing,     "partInstrumentLineSpacing",    1.0 },
    { Sid::partInstrumentFontSpatiumDependent, "partInstrumentFontSpatiumDependent", false },
    { Sid::partInstrumentFontStyle,       "partInstrumentFontStyle",      int(FontStyle::Normal) },
    { Sid::partInstrumentColor,           "partInstrumentColor",          PropertyValue::fromValue(Color::BLACK) },
    { Sid::partInstrumentAlign,           "partInstrumentAlign",          Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::partInstrumentOffset,          "partInstrumentOffset",         PointF() },
    { Sid::partInstrumentFrameType,       "partInstrumentFrameType",      int(FrameType::NO_FRAME) },
    { Sid::partInstrumentFramePadding,    "partInstrumentFramePadding",   0.2 },
    { Sid::partInstrumentFrameWidth,      "partInstrumentFrameWidth",     0.1 },
    { Sid::partInstrumentFrameRound,      "partInstrumentFrameRound",     0 },
    { Sid::partInstrumentFrameFgColor,    "partInstrumentFrameFgColor",   PropertyValue::fromValue(Color::BLACK) },
    { Sid::partInstrumentFrameBgColor,    "partInstrumentFrameBgColor",   PropertyValue::fromValue(Color::transparent) },

    // OBSOLETE after version 4.1. Dynamic text now takes its setting from expression.
    { Sid::dynamicsFontFace,              "dynamicsFontFace",             "Edwin" },
    { Sid::dynamicsFontSize,              "dynamicsFontSize",             10.0 },
    { Sid::dynamicsLineSpacing,           "dynamicsLineSpacing",          1.0 },
    { Sid::dynamicsFontSpatiumDependent,  "dynamicsFontSpatiumDependent", true },
    { Sid::dynamicsFontStyle,             "dynamicsFontStyle",            int(FontStyle::Italic) },
    { Sid::dynamicsColor,                 "dynamicsColor",                PropertyValue::fromValue(Color::BLACK) },
    { Sid::dynamicsAlign,                 "dynamicsAlign",                Align(AlignH::HCENTER, AlignV::BASELINE) },
    { Sid::dynamicsFrameType,             "dynamicsFrameType",            int(FrameType::NO_FRAME) },
    { Sid::dynamicsFramePadding,          "dynamicsFramePadding",         0.2 },
    { Sid::dynamicsFrameWidth,            "dynamicsFrameWidth",           0.1 },
    { Sid::dynamicsFrameRound,            "dynamicsFrameRound",           0 },
    { Sid::dynamicsFrameFgColor,          "dynamicsFrameFgColor",         PropertyValue::fromValue(Color::BLACK) },
    { Sid::dynamicsFrameBgColor,          "dynamicsFrameBgColor",         PropertyValue::fromValue(Color::transparent) },

    { Sid::expressionFontFace,            "expressionFontFace",           "Edwin" },
    { Sid::expressionFontSize,            "expressionFontSize",           10.0 },
    { Sid::expressionLineSpacing,         "expressionLineSpacing",        1.0 },
    { Sid::expressionFontSpatiumDependent, "expressionFontSpatiumDependent", true },
    { Sid::expressionFontStyle,           "expressionFontStyle",          int(FontStyle::Italic) },
    { Sid::expressionColor,               "expressionColor",              PropertyValue::fromValue(Color::BLACK) },
    { Sid::expressionAlign,               "expressionAlign",              Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::expressionPlacement,           "expressionPlacement",          PlacementV::BELOW },
    { Sid::expressionOffset,              "expressionOffset",             PointF(.0, 2.5) },
    { Sid::expressionPosAbove,            "expressionPosAbove",           PointF(.0, -1.5) },
    { Sid::expressionPosBelow,            "expressionPosBelow",           PointF(.0, 2.5) },
    { Sid::expressionFrameType,           "expressionFrameType",          int(FrameType::NO_FRAME) },
    { Sid::expressionFramePadding,        "expressionFramePadding",       0.2 },
    { Sid::expressionFrameWidth,          "expressionFrameWidth",         0.1 },
    { Sid::expressionFrameRound,          "expressionFrameRound",         0 },
    { Sid::expressionFrameFgColor,        "expressionFrameFgColor",       PropertyValue::fromValue(Color::BLACK) },
    { Sid::expressionFrameBgColor,        "expressionFrameBgColor",       PropertyValue::fromValue(Color::transparent) },
    { Sid::expressionMinDistance,         "expressionMinDistance",        Spatium(.5) },

    { Sid::tempoFontFace,                 "tempoFontFace",                "Edwin" },
    { Sid::tempoFontSize,                 "tempoFontSize",                12.0 },
    { Sid::tempoLineSpacing,              "tempoLineSpacing",             1.0 },
    { Sid::tempoFontSpatiumDependent,     "tempoFontSpatiumDependent",    true },
    { Sid::tempoFontStyle,                "tempoFontStyle",               int(FontStyle::Bold) },
    { Sid::tempoColor,                    "tempoColor",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::tempoAlign,                    "tempoAlign",                   Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::tempoSystemFlag,               "tempoSystemFlag",              true },
    { Sid::tempoPlacement,                "tempoPlacement",               PlacementV::ABOVE },
    { Sid::tempoPosAbove,                 "tempoPosAbove",                PointF(.0, -2.0) },
    { Sid::tempoPosBelow,                 "tempoPosBelow",                PointF(.0, 3.0) },
    { Sid::tempoMinDistance,              "tempoMinDistance",             Spatium(.5) },
    { Sid::tempoFrameType,                "tempoFrameType",               int(FrameType::NO_FRAME) },
    { Sid::tempoFramePadding,             "tempoFramePadding",            0.2 },
    { Sid::tempoFrameWidth,               "tempoFrameWidth",              0.1 },
    { Sid::tempoFrameRound,               "tempoFrameRound",              0 },
    { Sid::tempoFrameFgColor,             "tempoFrameFgColor",            PropertyValue::fromValue(draw::Color::BLACK) },
    { Sid::tempoFrameBgColor,             "tempoFrameBgColor",            PropertyValue::fromValue(draw::Color::transparent) },

    { Sid::tempoChangeFontFace,                 "tempoChangeFontFace",                "Edwin" },
    { Sid::tempoChangeFontSize,                 "tempoChangeFontSize",                12.0 },
    { Sid::tempoChangeLineSpacing,              "tempoChangeLineSpacing",             1.0 },
    { Sid::tempoChangeFontSpatiumDependent,     "tempoChangeFontSpatiumDependent",    true },
    { Sid::tempoChangeFontStyle,                "tempoChangeFontStyle",               int(FontStyle::Bold) },
    { Sid::tempoChangeColor,                    "tempoChangeColor",                   PropertyValue::fromValue(draw::Color::BLACK) },
    { Sid::tempoChangeAlign,                    "tempoChangeAlign",                   Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::tempoChangeSystemFlag,               "tempoChangeSystemFlag",              true },
    { Sid::tempoChangePlacement,                "tempoChangePlacement",               PlacementV::ABOVE },
    { Sid::tempoChangePosAbove,                 "tempoChangePosAbove",                PointF(.0, -2.0) },
    { Sid::tempoChangePosBelow,                 "tempoChangePosBelow",                PointF(.0, 3.0) },
    { Sid::tempoChangeMinDistance,              "tempoChangeMinDistance",             Spatium(.5) },
    { Sid::tempoChangeFrameType,                "tempoChangeFrameType",               int(FrameType::NO_FRAME) },
    { Sid::tempoChangeFramePadding,             "tempoChangeFramePadding",            0.2 },
    { Sid::tempoChangeFrameWidth,               "tempoChangeFrameWidth",              0.1 },
    { Sid::tempoChangeFrameRound,               "tempoChangeFrameRound",              0 },
    { Sid::tempoChangeFrameFgColor,             "tempoChangeFrameFgColor",            PropertyValue::fromValue(draw::Color::BLACK) },
    { Sid::tempoChangeFrameBgColor,             "tempoChangeFrameBgColor",            PropertyValue::fromValue(draw::Color::transparent) },
    { Sid::tempoChangeLineWidth,                "tempoChangeLineWidth",         Spatium(0.15) },
    { Sid::tempoChangeLineStyle,                "tempoChangeLineStyle",         PropertyValue(LineType::DASHED) },
    { Sid::tempoChangeDashLineLen,              "tempoChangeDashLineLen",       6.0 },
    { Sid::tempoChangeDashGapLen,               "tempoChangeDashGapLen",        9.0 },

    { Sid::metronomeFontFace,             "metronomeFontFace",            "Edwin" },
    { Sid::metronomeFontSize,             "metronomeFontSize",            12.0 },
    { Sid::metronomeLineSpacing,          "metronomeLineSpacing",         1.0 },
    { Sid::metronomeFontSpatiumDependent, "metronomeFontSpatiumDependent", false },
    { Sid::metronomeFontStyle,            "metronomeFontStyle",           int(FontStyle::Normal) },
    { Sid::metronomeColor,                "metronomeColor",               PropertyValue::fromValue(Color::BLACK) },
    { Sid::metronomePlacement,            "metronomePlacement",           PlacementV::ABOVE },
    { Sid::metronomeAlign,                "metronomeAlign",               Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::metronomeOffset,               "metronomeOffset",              PointF() },
    { Sid::metronomeFrameType,            "metronomeFrameType",           int(FrameType::NO_FRAME) },
    { Sid::metronomeFramePadding,         "metronomeFramePadding",        0.2 },
    { Sid::metronomeFrameWidth,           "metronomeFrameWidth",          0.1 },
    { Sid::metronomeFrameRound,           "metronomeFrameRound",          0 },
    { Sid::metronomeFrameFgColor,         "metronomeFrameFgColor",        PropertyValue::fromValue(Color::BLACK) },
    { Sid::metronomeFrameBgColor,         "metronomeFrameBgColor",        PropertyValue::fromValue(Color::transparent) },

    { Sid::measureNumberFontFace,         "measureNumberFontFace",        "Edwin" },
    { Sid::measureNumberFontSize,         "measureNumberFontSize",        8.0 },
    { Sid::measureNumberLineSpacing,      "measureNumberLineSpacing",     1.0 },
    { Sid::measureNumberFontSpatiumDependent, "measureNumberFontSpatiumDependent", false },
    { Sid::measureNumberFontStyle,        "measureNumberFontStyle",       2 },
    { Sid::measureNumberColor,            "measureNumberColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::measureNumberPosAbove,         "measureNumberOffset",          PointF(0.0, -2.0) }, // This measureNumberOffset cannot be renamed to measureNumberPosAbove for backward compatibility
    { Sid::measureNumberPosBelow,         "measureNumberPosBelow",        PointF(0.0, 2.0) },
    { Sid::measureNumberOffsetType,       "measureNumberOffsetType",      int(OffsetType::SPATIUM) },
    { Sid::measureNumberVPlacement,       "measureNumberVPlacement",      PlacementV::ABOVE },
    { Sid::measureNumberHPlacement,       "measureNumberHPlacement",      PlacementH::LEFT },
    { Sid::measureNumberAlign,            "measureNumberAlign",           Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::measureNumberFrameType,        "measureNumberFrameType",       int(FrameType::NO_FRAME) },
    { Sid::measureNumberFramePadding,     "measureNumberFramePadding",    0.2 },
    { Sid::measureNumberFrameWidth,       "measureNumberFrameWidth",      0.1 },
    { Sid::measureNumberFrameRound,       "measureNumberFrameRound",      0 },
    { Sid::measureNumberFrameFgColor,     "measureNumberFrameFgColor",    PropertyValue::fromValue(Color::BLACK) },
    { Sid::measureNumberFrameBgColor,     "measureNumberFrameBgColor",    PropertyValue::fromValue(Color::transparent) },

    { Sid::mmRestShowMeasureNumberRange,  "mmRestShowMeasureNumberRange", false },
    { Sid::mmRestRangeBracketType,        "mmRestRangeBracketType",       int(MMRestRangeBracketType::BRACKETS) },

    { Sid::mmRestRangeFontFace,           "mmRestRangeFontFace",          "Edwin" },
    { Sid::mmRestRangeFontSize,           "mmRestRangeFontSize",          8.0 },
    { Sid::mmRestRangeFontSpatiumDependent, "mmRestRangeFontSpatiumDependent", false },
    { Sid::mmRestRangeFontStyle,          "mmRestRangeFontStyle",         int(FontStyle::Italic) },
    { Sid::mmRestRangeColor,              "mmRestRangeColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::mmRestRangePosAbove,           "measureNumberPosAbove",        PointF(0.0, -3.0) },
    { Sid::mmRestRangePosBelow,           "measureNumberPosBelow",        PointF(0.0, 1.0) },
    { Sid::mmRestRangeOffsetType,         "mmRestRangeOffsetType",        int(OffsetType::SPATIUM) },
    { Sid::mmRestRangeVPlacement,         "mmRestRangeVPlacement",        PlacementV::BELOW },
    { Sid::mmRestRangeHPlacement,         "mmRestRangeHPlacement",        PlacementH::CENTER },
    { Sid::mmRestRangeAlign,              "mmRestRangeAlign",             Align(AlignH::HCENTER, AlignV::BASELINE) },
    { Sid::mmRestRangeFrameType,          "mmRestRangeFrameType",         int(FrameType::NO_FRAME) },
    { Sid::mmRestRangeFramePadding,       "mmRestRangeFramePadding",      0.2 },
    { Sid::mmRestRangeFrameWidth,         "mmRestRangeFrameWidth",        0.1 },
    { Sid::mmRestRangeFrameRound,         "mmRestRangeFrameRound",        0 },
    { Sid::mmRestRangeFrameFgColor,       "mmRestRangeFrameFgColor",      PropertyValue::fromValue(Color::BLACK) },
    { Sid::mmRestRangeFrameBgColor,       "mmRestRangeFrameBgColor",      PropertyValue::fromValue(Color::transparent) },

    { Sid::translatorFontFace,            "translatorFontFace",           "Edwin" },
    { Sid::translatorFontSize,            "translatorFontSize",           10.0 },
    { Sid::translatorLineSpacing,         "translatorLineSpacing",        1.0 },
    { Sid::translatorFontSpatiumDependent, "translatorFontSpatiumDependent", false },
    { Sid::translatorFontStyle,           "translatorFontStyle",          int(FontStyle::Normal) },
    { Sid::translatorColor,               "translatorColor",              PropertyValue::fromValue(Color::BLACK) },
    { Sid::translatorAlign,               "translatorAlign",              Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::translatorOffset,              "translatorOffset",             PointF() },
    { Sid::translatorFrameType,           "translatorFrameType",          int(FrameType::NO_FRAME) },
    { Sid::translatorFramePadding,        "translatorFramePadding",       0.2 },
    { Sid::translatorFrameWidth,          "translatorFrameWidth",         0.1 },
    { Sid::translatorFrameRound,          "translatorFrameRound",         0 },
    { Sid::translatorFrameFgColor,        "translatorFrameFgColor",       PropertyValue::fromValue(Color::BLACK) },
    { Sid::translatorFrameBgColor,        "translatorFrameBgColor",       PropertyValue::fromValue(Color::transparent) },

    { Sid::systemTextFontFace,            "systemFontFace",               "Edwin" },
    { Sid::systemTextFontSize,            "systemFontSize",               10.0 },
    { Sid::systemTextLineSpacing,         "systemTextLineSpacing",        1.0 },
    { Sid::systemTextFontSpatiumDependent, "systemFontSpatiumDependent",  true },
    { Sid::systemTextFontStyle,           "systemFontStyle",              int(FontStyle::Normal) },
    { Sid::systemTextColor,               "systemTextColor",              PropertyValue::fromValue(Color::BLACK) },
    { Sid::systemTextAlign,               "systemAlign",                  Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::systemTextOffsetType,          "systemOffsetType",             int(OffsetType::SPATIUM) },
    { Sid::systemTextPlacement,           "systemPlacement",              PlacementV::ABOVE },
    { Sid::systemTextPosAbove,            "systemPosAbove",               PointF(.0, -2.0) },
    { Sid::systemTextPosBelow,            "systemPosBelow",               PointF(.0, 3.5) },
    { Sid::systemTextMinDistance,         "systemMinDistance",            Spatium(0.5) },
    { Sid::systemTextFrameType,           "systemFrameType",              int(FrameType::NO_FRAME) },
    { Sid::systemTextFramePadding,        "systemFramePadding",           0.2 },
    { Sid::systemTextFrameWidth,          "systemFrameWidth",             0.1 },
    { Sid::systemTextFrameRound,          "systemFrameRound",             0 },
    { Sid::systemTextFrameFgColor,        "systemFrameFgColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::systemTextFrameBgColor,        "systemFrameBgColor",           PropertyValue::fromValue(Color::transparent) },

    { Sid::staffTextFontFace,             "staffFontFace",                "Edwin" },
    { Sid::staffTextFontSize,             "staffFontSize",                10.0 },
    { Sid::staffTextLineSpacing,          "staffTextLineSpacing",         1.0 },
    { Sid::staffTextFontSpatiumDependent, "staffFontSpatiumDependent",    true },
    { Sid::staffTextFontStyle,            "staffFontStyle",               int(FontStyle::Normal) },
    { Sid::staffTextColor,                "staffTextColor",               PropertyValue::fromValue(Color::BLACK) },
    { Sid::staffTextAlign,                "staffAlign",                   Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::staffTextOffsetType,           "systemOffsetType",             int(OffsetType::SPATIUM) },
    { Sid::staffTextPlacement,            "staffPlacement",               PlacementV::ABOVE },
    { Sid::staffTextPosAbove,             "staffPosAbove",                PointF(.0, -1.0) },
    { Sid::staffTextPosBelow,             "staffPosBelow",                PointF(.0, 2.5) },
    { Sid::staffTextMinDistance,          "staffMinDistance",             Spatium(0.5) },
    { Sid::staffTextFrameType,            "staffFrameType",               int(FrameType::NO_FRAME) },
    { Sid::staffTextFramePadding,         "staffFramePadding",            0.2 },
    { Sid::staffTextFrameWidth,           "staffFrameWidth",              0.1 },
    { Sid::staffTextFrameRound,           "staffFrameRound",              0 },
    { Sid::staffTextFrameFgColor,         "staffFrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::staffTextFrameBgColor,         "staffFrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::rehearsalMarkFontFace,         "rehearsalMarkFontFace",        "Edwin" },
    { Sid::rehearsalMarkFontSize,         "rehearsalMarkFontSize",        14.0 },
    { Sid::rehearsalMarkLineSpacing,      "rehearsalMarkLineSpacing",     1.0 },
    { Sid::rehearsalMarkFontSpatiumDependent, "rehearsalMarkFontSpatiumDependent", true },
    { Sid::rehearsalMarkFontStyle,        "rehearsalMarkFontStyle",       int(FontStyle::Bold) },
    { Sid::rehearsalMarkColor,            "rehearsalMarkColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::rehearsalMarkAlign,            "rehearsalMarkAlign",           Align(AlignH::HCENTER, AlignV::BASELINE) },
    { Sid::rehearsalMarkFrameType,        "rehearsalMarkFrameType",       int(FrameType::SQUARE) },
    { Sid::rehearsalMarkFramePadding,     "rehearsalMarkFramePadding",    0.5 },
    { Sid::rehearsalMarkFrameWidth,       "rehearsalMarkFrameWidth",      0.16 },
    { Sid::rehearsalMarkFrameRound,       "rehearsalMarkFrameRound",      0 },
    { Sid::rehearsalMarkFrameFgColor,     "rehearsalMarkFrameFgColor",    PropertyValue::fromValue(Color::BLACK) },
    { Sid::rehearsalMarkFrameBgColor,     "rehearsalMarkFrameBgColor",    PropertyValue::fromValue(Color::transparent) },
    { Sid::rehearsalMarkPlacement,        "rehearsalMarkPlacement",       PlacementV::ABOVE },
    { Sid::rehearsalMarkPosAbove,         "rehearsalMarkPosAbove",        PointF(.0, -3.0) },
    { Sid::rehearsalMarkPosBelow,         "rehearsalMarkPosBelow",        PointF(.0, 4.0) },
    { Sid::rehearsalMarkMinDistance,      "rehearsalMarkMinDistance",     Spatium(0.5) },

    { Sid::repeatLeftFontFace,            "repeatLeftFontFace",           "Edwin" },
    { Sid::repeatLeftFontSize,            "repeatLeftFontSize",           18.0 },
    { Sid::repeatLeftLineSpacing,         "repeatLeftLineSpacing",        1.0 },
    { Sid::repeatLeftFontSpatiumDependent, "repeatLeftFontSpatiumDependent", true },
    { Sid::repeatLeftFontStyle,           "repeatLeftFontStyle",          int(FontStyle::Normal) },
    { Sid::repeatLeftColor,               "repeatLeftColor",              PropertyValue::fromValue(Color::BLACK) },
    { Sid::repeatLeftAlign,               "repeatLeftAlign",              Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::repeatLeftPlacement,           "repeatLeftPlacement",          PlacementV::ABOVE },
    { Sid::repeatLeftFrameType,           "repeatLeftFrameType",          int(FrameType::NO_FRAME) },
    { Sid::repeatLeftFramePadding,        "repeatLeftFramePadding",       0.2 },
    { Sid::repeatLeftFrameWidth,          "repeatLeftFrameWidth",         0.1 },
    { Sid::repeatLeftFrameRound,          "repeatLeftFrameRound",         0 },
    { Sid::repeatLeftFrameFgColor,        "repeatLeftFrameFgColor",       PropertyValue::fromValue(Color::BLACK) },
    { Sid::repeatLeftFrameBgColor,        "repeatLeftFrameBgColor",       PropertyValue::fromValue(Color::transparent) },

    { Sid::repeatRightFontFace,           "repeatRightFontFace",          "Edwin" },
    { Sid::repeatRightFontSize,           "repeatRightFontSize",          11.0 },
    { Sid::repeatRightLineSpacing,        "repeatRightLineSpacing",       1.0 },
    { Sid::repeatRightFontSpatiumDependent, "repeatRightFontSpatiumDependent", true },
    { Sid::repeatRightFontStyle,          "repeatRightFontStyle",         int(FontStyle::Normal) },
    { Sid::repeatRightColor,              "repeatRightColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::repeatRightAlign,              "repeatRightAlign",             Align(AlignH::RIGHT, AlignV::BASELINE) },
    { Sid::repeatRightPlacement,          "repeatRightPlacement",         PlacementV::ABOVE },
    { Sid::repeatRightFrameType,          "repeatRightFrameType",         int(FrameType::NO_FRAME) },
    { Sid::repeatRightFramePadding,       "repeatRightFramePadding",      0.2 },
    { Sid::repeatRightFrameWidth,         "repeatRightFrameWidth",        0.1 },
    { Sid::repeatRightFrameRound,         "repeatRightFrameRound",        0 },
    { Sid::repeatRightFrameFgColor,       "repeatRightFrameFgColor",      PropertyValue::fromValue(Color::BLACK) },
    { Sid::repeatRightFrameBgColor,       "repeatRightFrameBgColor",      PropertyValue::fromValue(Color::transparent) },

    { Sid::frameFontFace,                 "frameFontFace",                "Edwin" },
    { Sid::frameFontSize,                 "frameFontSize",                10.0 },
    { Sid::frameLineSpacing,              "frameLineSpacing",             1.0 },
    { Sid::frameFontSpatiumDependent,     "frameFontSpatiumDependent",    false },
    { Sid::frameFontStyle,                "frameFontStyle",               int(FontStyle::Normal) },
    { Sid::frameColor,                    "frameColor",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::frameAlign,                    "frameAlign",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::frameOffset,                   "frameOffset",                  PointF() },
    { Sid::frameFrameType,                "frameFrameType",               int(FrameType::NO_FRAME) },
    { Sid::frameFramePadding,             "frameFramePadding",            0.2 },
    { Sid::frameFrameWidth,               "frameFrameWidth",              0.1 },
    { Sid::frameFrameRound,               "frameFrameRound",              0 },
    { Sid::frameFrameFgColor,             "frameFrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::frameFrameBgColor,             "frameFrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::textLineFontFace,              "textLineFontFace",             "Edwin" },
    { Sid::textLineFontSize,              "textLineFontSize",             10.0 },
    { Sid::textLineLineSpacing,           "textLineLineSpacing",          1.0 },
    { Sid::textLineFontSpatiumDependent,  "textLineFontSpatiumDependent", true },
    { Sid::textLineFontStyle,             "textLineFontStyle",            int(FontStyle::Normal) },
    { Sid::textLineColor,                 "textLineColor",                PropertyValue::fromValue(Color::BLACK) },
    { Sid::textLineTextAlign,             "textLineTextAlign",            Align(AlignH::LEFT, AlignV::VCENTER) },
    { Sid::textLineSystemFlag,            "textLineSystemFlag",           false },

    { Sid::systemTextLineFontFace,              "systemTextLineFontFace",             "Edwin" },
    { Sid::systemTextLineFontSize,              "systemTextLineFontSize",             12.0 },
    { Sid::systemTextLineFontSpatiumDependent,  "systemTextLineFontSpatiumDependent", true },
    { Sid::systemTextLineFontStyle,             "systemTextLineFontStyle",            int(FontStyle::Normal) },
    { Sid::systemTextLineColor,                 "systemTextLineColor",                PropertyValue::fromValue(Color::BLACK) },
    { Sid::systemTextLineTextAlign,             "systemTextLineTextAlign",
      Align(AlignH::LEFT, AlignV::VCENTER) },
    { Sid::systemTextLineSystemFlag,            "systemTextLineSystemFlag",           true },

    { Sid::glissandoFontFace,             "glissandoFontFace",            "Edwin" },
    { Sid::glissandoFontSize,             "glissandoFontSize",            PropertyValue(8.0) },
    { Sid::glissandoLineSpacing,         "glissandoLineSpacing",          1.0 },
    { Sid::glissandoFontSpatiumDependent, "glissandoFontSpatiumDependent", true },
    { Sid::glissandoFontStyle,            "glissandoFontStyle",           int(FontStyle::Italic) },
    { Sid::glissandoColor,                "glissandoColor",               PropertyValue::fromValue(Color::BLACK) },
    { Sid::glissandoAlign,                "glissandoAlign",               Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::glissandoOffset,               "glissandoOffset",              PointF() },
    { Sid::glissandoFrameType,            "glissandoFrameType",           int(FrameType::NO_FRAME) },
    { Sid::glissandoFramePadding,         "glissandoFramePadding",        0.2 },
    { Sid::glissandoFrameWidth,           "glissandoFrameWidth",          0.1 },
    { Sid::glissandoFrameRound,           "glissandoFrameRound",          0 },
    { Sid::glissandoFrameFgColor,         "glissandoFrameFgColor",        PropertyValue::fromValue(Color::BLACK) },
    { Sid::glissandoFrameBgColor,         "glissandoFrameBgColor",        PropertyValue::fromValue(Color::transparent) },
    { Sid::glissandoLineWidth,            "glissandoLineWidth",           Spatium(0.15) },
    { Sid::glissandoText,                 "glissandoText",                String(u"gliss.") },
    { Sid::glissandoStyle,                "glissandoStyle",               GlissandoStyle::CHROMATIC },
    { Sid::glissandoStyleHarp,            "glissandoStyleHarp",           GlissandoStyle::DIATONIC },

    { Sid::bendFontFace,                  "bendFontFace",                 "Edwin" },
    { Sid::bendFontSize,                  "bendFontSize",                 8.0 },
    { Sid::bendLineSpacing,               "bendLineSpacing",              1.0 },
    { Sid::bendFontSpatiumDependent,      "bendFontSpatiumDependent",     true },
    { Sid::bendFontStyle,                 "bendFontStyle",                int(FontStyle::Normal) },
    { Sid::bendColor,                     "bendColor",                    PropertyValue::fromValue(Color::BLACK) },
    { Sid::bendAlign,                     "bendAlign",                    Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::bendOffset,                    "bendOffset",                   PointF() },
    { Sid::bendFrameType,                 "bendFrameType",                int(FrameType::NO_FRAME) },
    { Sid::bendFramePadding,              "bendFramePadding",             0.2 },
    { Sid::bendFrameWidth,                "bendFrameWidth",               0.1 },
    { Sid::bendFrameRound,                "bendFrameRound",               0 },
    { Sid::bendFrameFgColor,              "bendFrameFgColor",             PropertyValue::fromValue(Color::BLACK) },
    { Sid::bendFrameBgColor,              "bendFrameBgColor",             PropertyValue::fromValue(Color::transparent) },
    { Sid::bendLineWidth,                 "bendLineWidth",                Spatium(0.15) },
    { Sid::bendArrowWidth,                "bendArrowWidth",               Spatium(.5) },

    { Sid::guitarBendLineWidth,           "guitarBendLineWidth",          Spatium(0.13) },
    { Sid::guitarBendLineWidthTab,        "guitarBendLineWidthTab",       Spatium(0.15) },
    { Sid::guitarBendHeightAboveTABStaff, "guitarBendHeightAboveTABStaff", 1.5 }, // in units of TAB lines dist
    { Sid::guitarBendPartialBendHeight,   "guitarBendPartialBendHeight",  Spatium(1.5) },
    { Sid::guitarBendUseFull,             "guitarBendUseFull",            false },
    { Sid::guitarBendArrowWidth,          "guitarBendArrowWidth",         Spatium(1.0) },
    { Sid::guitarBendArrowHeight,         "guitarBendArrowHeight",        Spatium(1.0) },
    { Sid::useCueSizeFretForGraceBends,   "useCueSizeFretForGraceBends",  false },

    { Sid::headerFontFace,                "headerFontFace",               "Edwin" },
    { Sid::headerFontSize,                "headerFontSize",               11.0 },
    { Sid::headerLineSpacing,             "headerLineSpacing",            1.0 },
    { Sid::headerFontSpatiumDependent,    "headerFontSpatiumDependent",   false },
    { Sid::headerFontStyle,               "headerFontStyle",              1 },
    { Sid::headerColor,                   "headerColor",                  PropertyValue::fromValue(Color::BLACK) },
    { Sid::headerAlign,                   "headerAlign",                  Align(AlignH::HCENTER, AlignV::TOP) },
    { Sid::headerOffset,                  "headerOffset",                 PointF() },
    { Sid::headerFrameType,               "headerFrameType",              int(FrameType::NO_FRAME) },
    { Sid::headerFramePadding,            "headerFramePadding",           0.2 },
    { Sid::headerFrameWidth,              "headerFrameWidth",             0.1 },
    { Sid::headerFrameRound,              "headerFrameRound",             0 },
    { Sid::headerFrameFgColor,            "headerFrameFgColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::headerFrameBgColor,            "headerFrameBgColor",           PropertyValue::fromValue(Color::transparent) },

    { Sid::footerFontFace,                "footerFontFace",               "Edwin" },
    { Sid::footerFontSize,                "footerFontSize",               9.0 },
    { Sid::footerLineSpacing,             "footerLineSpacing",            1.0 },
    { Sid::footerFontSpatiumDependent,    "footerFontSpatiumDependent",   false },
    { Sid::footerFontStyle,               "footerFontStyle",              int(FontStyle::Normal) },
    { Sid::footerColor,                   "footerColor",                  PropertyValue::fromValue(Color::BLACK) },
    { Sid::footerAlign,                   "footerAlign",                  Align(AlignH::HCENTER, AlignV::BOTTOM) },
    { Sid::footerOffset,                  "footerOffset",                 PointF(0.0, 0.0) },
    { Sid::footerFrameType,               "footerFrameType",              int(FrameType::NO_FRAME) },
    { Sid::footerFramePadding,            "footerFramePadding",           0.2 },
    { Sid::footerFrameWidth,              "footerFrameWidth",             0.1 },
    { Sid::footerFrameRound,              "footerFrameRound",             0 },
    { Sid::footerFrameFgColor,            "footerFrameFgColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::footerFrameBgColor,            "footerFrameBgColor",           PropertyValue::fromValue(Color::transparent) },

    { Sid::instrumentChangeFontFace,      "instrumentChangeFontFace",     "Edwin" },
    { Sid::instrumentChangeFontSize,      "instrumentChangeFontSize",     10.0 },
    { Sid::instrumentChangeLineSpacing,   "instrumentChangeLineSpacing",  1.0 },
    { Sid::instrumentChangeFontSpatiumDependent, "instrumentChangeFontSpatiumDependent", true },
    { Sid::instrumentChangeFontStyle,     "instrumentChangeFontStyle",    int(FontStyle::Bold) },
    { Sid::instrumentChangeColor,         "instrumentChangeColor",        PropertyValue::fromValue(Color::BLACK) },
    { Sid::instrumentChangeAlign,         "instrumentChangeAlign",        Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::instrumentChangeOffset,        "instrumentChangeOffset",       PointF() },
    { Sid::instrumentChangePlacement,     "instrumentChangePlacement",    PlacementV::ABOVE },
    { Sid::instrumentChangePosAbove,      "instrumentChangePosAbove",     PointF(.0, -2.0) },
    { Sid::instrumentChangePosBelow,      "instrumentChangePosBelow",     PointF(.0, 3.5) },
    { Sid::instrumentChangeMinDistance,   "instrumentChangeMinDistance",  Spatium(0.5) },
    { Sid::instrumentChangeFrameType,     "instrumentChangeFrameType",    int(FrameType::NO_FRAME) },
    { Sid::instrumentChangeFramePadding,  "instrumentChangeFramePadding", 0.2 },
    { Sid::instrumentChangeFrameWidth,    "instrumentChangeFrameWidth",   0.1 },
    { Sid::instrumentChangeFrameRound,    "instrumentChangeFrameRound",   0 },
    { Sid::instrumentChangeFrameFgColor,  "instrumentChangeFrameFgColor", PropertyValue::fromValue(Color::BLACK) },
    { Sid::instrumentChangeFrameBgColor,  "instrumentChangeFrameBgColor", PropertyValue::fromValue(Color::transparent) },

    { Sid::stickingFontFace,              "stickingFontFace",     "Edwin" },
    { Sid::stickingFontSize,              "stickingFontSize",     10.0 },
    { Sid::stickingLineSpacing,           "stickingLineSpacing",  1.0 },
    { Sid::stickingFontSpatiumDependent,  "stickingFontSpatiumDependent", true },
    { Sid::stickingFontStyle,             "stickingFontStyle",    int(FontStyle::Normal) },
    { Sid::stickingColor,                 "stickingColor",        PropertyValue::fromValue(Color::BLACK) },
    { Sid::stickingAlign,                 "stickingAlign",        Align(AlignH::LEFT, AlignV::BASELINE) },
    { Sid::stickingOffset,                "stickingOffset",       PointF() },
    { Sid::stickingPlacement,             "stickingPlacement",    PlacementV::BELOW },
    { Sid::stickingPosAbove,              "stickingPosAbove",     PointF(.0, -2.0) },
    { Sid::stickingPosBelow,              "stickingPosBelow",     PointF(.0, 2.0) },
    { Sid::stickingMinDistance,           "stickingMinDistance",  Spatium(0.5) },
    { Sid::stickingFrameType,             "stickingFrameType",    int(FrameType::NO_FRAME) },
    { Sid::stickingFramePadding,          "stickingFramePadding", 0.2 },
    { Sid::stickingFrameWidth,            "stickingFrameWidth",   0.1 },
    { Sid::stickingFrameRound,            "stickingFrameRound",   0 },
    { Sid::stickingFrameFgColor,          "stickingFrameFgColor", PropertyValue::fromValue(Color::BLACK) },
    { Sid::stickingFrameBgColor,          "stickingFrameBgColor", PropertyValue::fromValue(Color::transparent) },

    { Sid::figuredBassFontFace,           "figuredBassFontFace",          "MScoreBC" },
    { Sid::figuredBassFontSize,           "figuredBassFontSize",          8.0 },
    { Sid::figuredBassLineSpacing,        "figuredBassLineSpacing",       1.0 },
    { Sid::figuredBassFontSpatiumDependent, "figuredBassFontSpatiumDependent", true },
    { Sid::figuredBassFontStyle,          "figuredBassFontStyle",         int(FontStyle::Normal) },
    { Sid::figuredBassColor,              "figuredBassColor",             PropertyValue::fromValue(Color::BLACK) },

    { Sid::user1Name,                     "user1Name",                    "" },
    { Sid::user1FontFace,                 "user1FontFace",                "Edwin" },
    { Sid::user1FontSize,                 "user1FontSize",                10.0 },
    { Sid::user1LineSpacing,              "user1LineSpacing",             1.0 },
    { Sid::user1FontSpatiumDependent,     "user1FontSpatiumDependent",    true },
    { Sid::user1FontStyle,                "user1FontStyle",               int(FontStyle::Normal) },
    { Sid::user1Color,                    "user1Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user1Align,                    "user1Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user1Offset,                   "user1Offset",                  PointF() },
    { Sid::user1OffsetType,               "user1OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user1FrameType,                "user1FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user1FramePadding,             "user1FramePadding",            0.2 },
    { Sid::user1FrameWidth,               "user1FrameWidth",              0.1 },
    { Sid::user1FrameRound,               "user1FrameRound",              0 },
    { Sid::user1FrameFgColor,             "user1FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user1FrameBgColor,             "user1FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user2Name,                     "user2Name",                    "" },
    { Sid::user2FontFace,                 "user2FontFace",                "Edwin" },
    { Sid::user2FontSize,                 "user2FontSize",                10.0 },
    { Sid::user2LineSpacing,              "user2LineSpacing",             1.0 },
    { Sid::user2FontSpatiumDependent,     "user2FontSpatiumDependent",    true },
    { Sid::user2FontStyle,                "user2FontStyle",               int(FontStyle::Normal) },
    { Sid::user2Color,                    "user2Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user2Align,                    "user2Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user2Offset,                   "user2Offset",                  PointF() },
    { Sid::user2OffsetType,               "user2OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user2FrameType,                "user2FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user2FramePadding,             "user2FramePadding",            0.2 },
    { Sid::user2FrameWidth,               "user2FrameWidth",              0.1 },
    { Sid::user2FrameRound,               "user2FrameRound",              0 },
    { Sid::user2FrameFgColor,             "user2FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user2FrameBgColor,             "user2FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user3Name,                     "user3Name",                    "" },
    { Sid::user3FontFace,                 "user3FontFace",                "Edwin" },
    { Sid::user3FontSize,                 "user3FontSize",                10.0 },
    { Sid::user3LineSpacing,              "user3LineSpacing",             1.0 },
    { Sid::user3FontSpatiumDependent,     "user3FontSpatiumDependent",    true },
    { Sid::user3FontStyle,                "user3FontStyle",               int(FontStyle::Normal) },
    { Sid::user3Color,                    "user3Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user3Align,                    "user3Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user3Offset,                   "user3Offset",                  PointF() },
    { Sid::user3OffsetType,               "user3OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user3FrameType,                "user3FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user3FramePadding,             "user3FramePadding",            0.2 },
    { Sid::user3FrameWidth,               "user3FrameWidth",              0.1 },
    { Sid::user3FrameRound,               "user3FrameRound",              0 },
    { Sid::user3FrameFgColor,             "user3FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user3FrameBgColor,             "user3FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user4Name,                     "user4Name",                    "" },
    { Sid::user4FontFace,                 "user4FontFace",                "Edwin" },
    { Sid::user4FontSize,                 "user4FontSize",                10.0 },
    { Sid::user4LineSpacing,              "user4LineSpacing",             1.0 },
    { Sid::user4FontSpatiumDependent,     "user4FontSpatiumDependent",    true },
    { Sid::user4FontStyle,                "user4FontStyle",               int(FontStyle::Normal) },
    { Sid::user4Color,                    "user4Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user4Align,                    "user4Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user4Offset,                   "user4Offset",                  PointF() },
    { Sid::user4OffsetType,               "user4OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user4FrameType,                "user4FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user4FramePadding,             "user4FramePadding",            0.2 },
    { Sid::user4FrameWidth,               "user4FrameWidth",              0.1 },
    { Sid::user4FrameRound,               "user4FrameRound",              0 },
    { Sid::user4FrameFgColor,             "user4FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user4FrameBgColor,             "user4FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user5Name,                     "user5Name",                    "" },
    { Sid::user5FontFace,                 "user5FontFace",                "Edwin" },
    { Sid::user5FontSize,                 "user5FontSize",                10.0 },
    { Sid::user5LineSpacing,              "user5LineSpacing",             1.0 },
    { Sid::user5FontSpatiumDependent,     "user5FontSpatiumDependent",    true },
    { Sid::user5FontStyle,                "user5FontStyle",               int(FontStyle::Normal) },
    { Sid::user5Color,                    "user5Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user5Align,                    "user5Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user5Offset,                   "user5Offset",                  PointF() },
    { Sid::user5OffsetType,               "user5OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user5FrameType,                "user5FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user5FramePadding,             "user5FramePadding",            0.2 },
    { Sid::user5FrameWidth,               "user5FrameWidth",              0.1 },
    { Sid::user5FrameRound,               "user5FrameRound",              0 },
    { Sid::user5FrameFgColor,             "user5FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user5FrameBgColor,             "user5FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user6Name,                     "user6Name",                    "" },
    { Sid::user6FontFace,                 "user6FontFace",                "Edwin" },
    { Sid::user6FontSize,                 "user6FontSize",                10.0 },
    { Sid::user6LineSpacing,              "user6LineSpacing",             1.0 },
    { Sid::user6FontSpatiumDependent,     "user6FontSpatiumDependent",    true },
    { Sid::user6FontStyle,                "user6FontStyle",               int(FontStyle::Normal) },
    { Sid::user6Color,                    "user6Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user6Align,                    "user6Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user6Offset,                   "user6Offset",                  PointF() },
    { Sid::user6OffsetType,               "user6OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user6FrameType,                "user6FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user6FramePadding,             "user6FramePadding",            0.2 },
    { Sid::user6FrameWidth,               "user6FrameWidth",              0.1 },
    { Sid::user6FrameRound,               "user6FrameRound",              0 },
    { Sid::user6FrameFgColor,             "user6FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user6FrameBgColor,             "user6FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user7Name,                     "user7Name",                    "" },
    { Sid::user7FontFace,                 "user7FontFace",                "Edwin" },
    { Sid::user7FontSize,                 "user7FontSize",                10.0 },
    { Sid::user7LineSpacing,              "user7LineSpacing",             1.0 },
    { Sid::user7FontSpatiumDependent,     "user7FontSpatiumDependent",    true },
    { Sid::user7FontStyle,                "user7FontStyle",               int(FontStyle::Normal) },
    { Sid::user7Color,                    "user7Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user7Align,                    "user7Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user7Offset,                   "user7Offset",                  PointF() },
    { Sid::user7OffsetType,               "user7OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user7FrameType,                "user7FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user7FramePadding,             "user7FramePadding",            0.2 },
    { Sid::user7FrameWidth,               "user7FrameWidth",              0.1 },
    { Sid::user7FrameRound,               "user7FrameRound",              0 },
    { Sid::user7FrameFgColor,             "user7FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user7FrameBgColor,             "user7FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user8Name,                     "user8Name",                    "" },
    { Sid::user8FontFace,                 "user8FontFace",                "Edwin" },
    { Sid::user8FontSize,                 "user8FontSize",                10.0 },
    { Sid::user8LineSpacing,              "user8LineSpacing",             1.0 },
    { Sid::user8FontSpatiumDependent,     "user8FontSpatiumDependent",    true },
    { Sid::user8FontStyle,                "user8FontStyle",               int(FontStyle::Normal) },
    { Sid::user8Color,                    "user8Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user8Align,                    "user8Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user8Offset,                   "user8Offset",                  PointF() },
    { Sid::user8OffsetType,               "user8OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user8FrameType,                "user8FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user8FramePadding,             "user8FramePadding",            0.2 },
    { Sid::user8FrameWidth,               "user8FrameWidth",              0.1 },
    { Sid::user8FrameRound,               "user8FrameRound",              0 },
    { Sid::user8FrameFgColor,             "user8FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user8FrameBgColor,             "user8FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user9Name,                     "user9Name",                    "" },
    { Sid::user9FontFace,                 "user9FontFace",                "Edwin" },
    { Sid::user9FontSize,                 "user9FontSize",                10.0 },
    { Sid::user9LineSpacing,              "user9LineSpacing",             1.0 },
    { Sid::user9FontSpatiumDependent,     "user9FontSpatiumDependent",    true },
    { Sid::user9FontStyle,                "user9FontStyle",               int(FontStyle::Normal) },
    { Sid::user9Color,                    "user9Color",                   PropertyValue::fromValue(Color::BLACK) },
    { Sid::user9Align,                    "user9Align",                   Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user9Offset,                   "user9Offset",                  PointF() },
    { Sid::user9OffsetType,               "user9OffsetType",              int(OffsetType::SPATIUM) },
    { Sid::user9FrameType,                "user9FrameType",               int(FrameType::NO_FRAME) },
    { Sid::user9FramePadding,             "user9FramePadding",            0.2 },
    { Sid::user9FrameWidth,               "user9FrameWidth",              0.1 },
    { Sid::user9FrameRound,               "user9FrameRound",              0 },
    { Sid::user9FrameFgColor,             "user9FrameFgColor",            PropertyValue::fromValue(Color::BLACK) },
    { Sid::user9FrameBgColor,             "user9FrameBgColor",            PropertyValue::fromValue(Color::transparent) },

    { Sid::user10Name,                    "user10Name",                   "" },
    { Sid::user10FontFace,                "user10FontFace",               "Edwin" },
    { Sid::user10FontSize,                "user10FontSize",               10.0 },
    { Sid::user10LineSpacing,             "user10LineSpacing",            1.0 },
    { Sid::user10FontSpatiumDependent,    "user10FontSpatiumDependent",   true },
    { Sid::user10FontStyle,               "user10FontStyle",              int(FontStyle::Normal) },
    { Sid::user10Color,                   "user10Color",                  PropertyValue::fromValue(Color::BLACK) },
    { Sid::user10Align,                   "user10Align",                  Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user10Offset,                  "user10Offset",                 PointF() },
    { Sid::user10OffsetType,              "user10OffsetType",             int(OffsetType::SPATIUM) },
    { Sid::user10FrameType,               "user10FrameType",              int(FrameType::NO_FRAME) },
    { Sid::user10FramePadding,            "user10FramePadding",           0.2 },
    { Sid::user10FrameWidth,              "user10FrameWidth",             0.1 },
    { Sid::user10FrameRound,              "user10FrameRound",             0 },
    { Sid::user10FrameFgColor,            "user10FrameFgColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::user10FrameBgColor,            "user10FrameBgColor",           PropertyValue::fromValue(Color::transparent) },

    { Sid::user11Name,                    "user11Name",                   "" },
    { Sid::user11FontFace,                "user11FontFace",               "Edwin" },
    { Sid::user11FontSize,                "user11FontSize",               10.0 },
    { Sid::user11LineSpacing,             "user11LineSpacing",            1.0 },
    { Sid::user11FontSpatiumDependent,    "user11FontSpatiumDependent",   true },
    { Sid::user11FontStyle,               "user11FontStyle",              int(FontStyle::Normal) },
    { Sid::user11Color,                   "user11Color",                  PropertyValue::fromValue(Color::BLACK) },
    { Sid::user11Align,                   "user11Align",                  Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user11Offset,                  "user11Offset",                 PointF() },
    { Sid::user11OffsetType,              "user11OffsetType",             int(OffsetType::SPATIUM) },
    { Sid::user11FrameType,               "user11FrameType",              int(FrameType::NO_FRAME) },
    { Sid::user11FramePadding,            "user11FramePadding",           0.2 },
    { Sid::user11FrameWidth,              "user11FrameWidth",             0.1 },
    { Sid::user11FrameRound,              "user11FrameRound",             0 },
    { Sid::user11FrameFgColor,            "user11FrameFgColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::user11FrameBgColor,            "user11FrameBgColor",           PropertyValue::fromValue(Color::transparent) },

    { Sid::user12Name,                    "user12Name",                   "" },
    { Sid::user12FontFace,                "user12FontFace",               "Edwin" },
    { Sid::user12FontSize,                "user12FontSize",               10.0 },
    { Sid::user12LineSpacing,             "user12LineSpacing",            1.0 },
    { Sid::user12FontSpatiumDependent,    "user12FontSpatiumDependent",   true },
    { Sid::user12FontStyle,               "user12FontStyle",              int(FontStyle::Normal) },
    { Sid::user12Color,                   "user12Color",                  PropertyValue::fromValue(Color::BLACK) },
    { Sid::user12Align,                   "user12Align",                  Align(AlignH::LEFT, AlignV::TOP) },
    { Sid::user12Offset,                  "user12Offset",                 PointF() },
    { Sid::user12OffsetType,              "user12OffsetType",             int(OffsetType::SPATIUM) },
    { Sid::user12FrameType,               "user12FrameType",              int(FrameType::NO_FRAME) },
    { Sid::user12FramePadding,            "user12FramePadding",           0.2 },
    { Sid::user12FrameWidth,              "user12FrameWidth",             0.1 },
    { Sid::user12FrameRound,              "user12FrameRound",             0 },
    { Sid::user12FrameFgColor,            "user12FrameFgColor",           PropertyValue::fromValue(Color::BLACK) },
    { Sid::user12FrameBgColor,            "user12FrameBgColor",           PropertyValue::fromValue(Color::transparent) },

    { Sid::letRingFontFace,               "letRingFontFace",              "Edwin" },
    { Sid::letRingFontSize,               "letRingFontSize",              10.0 },
    { Sid::letRingLineSpacing,            "letRingLineSpacing",           1.0 },
    { Sid::letRingFontSpatiumDependent,   "letRingFontSpatiumDependent",  true },
    { Sid::letRingFontStyle,              "letRingFontStyle",             int(FontStyle::Normal) },
    { Sid::letRingColor,                  "letRingColor",                 PropertyValue::fromValue(Color::BLACK) },
    { Sid::letRingTextAlign,              "letRingTextAlign",             Align(AlignH::LEFT, AlignV::VCENTER) },
    { Sid::letRingHookHeight,             "letRingHookHeight",            Spatium(0.6) },
    { Sid::letRingPlacement,              "letRingPlacement",             PlacementV::BELOW },
    { Sid::letRingPosAbove,               "letRingPosAbove",              PointF(.0, 0.0) },
    { Sid::letRingPosBelow,               "letRingPosBelow",              PointF(.0, 0.0) },
    { Sid::letRingLineWidth,              "letRingLineWidth",             Spatium(0.11) },
    { Sid::letRingLineStyle,              "letRingLineStyle",             PropertyValue(LineType::DASHED) },
    { Sid::letRingDashLineLen,            "letRingDashLineLen",           5.0 },
    { Sid::letRingDashGapLen,             "letRingDashGapLen",            5.0 },
    { Sid::letRingText,                   "letRingText",                  "let ring" },
    { Sid::letRingFrameType,              "letRingFrameType",             int(FrameType::NO_FRAME) },
    { Sid::letRingFramePadding,           "letRingFramePadding",          0.2 },
    { Sid::letRingFrameWidth,             "letRingFrameWidth",            0.1 },
    { Sid::letRingFrameRound,             "letRingFrameRound",            0 },
    { Sid::letRingFrameFgColor,           "letRingFrameFgColor",          PropertyValue::fromValue(Color::BLACK) },
    { Sid::letRingFrameBgColor,           "letRingFrameBgColor",          PropertyValue::fromValue(Color::transparent) },
    { Sid::letRingEndHookType,            "letRingEndHookType",           HookType::HOOK_90T },

    { Sid::palmMuteFontFace,              "palmMuteFontFace",              "Edwin" },
    { Sid::palmMuteFontSize,              "palmMuteFontSize",              10.0 },
    { Sid::palmMuteLineSpacing,           "palmMuteLineSpacing",           1.0 },
    { Sid::palmMuteFontSpatiumDependent,  "palmMuteFontSpatiumDependent",  true },
    { Sid::palmMuteFontStyle,             "palmMuteFontStyle",             int(FontStyle::Normal) },
    { Sid::palmMuteColor,                 "palmMuteColor",                 PropertyValue::fromValue(Color::BLACK) },
    { Sid::palmMuteTextAlign,             "palmMuteTextAlign",             Align(AlignH::LEFT, AlignV::VCENTER) },
    { Sid::palmMuteHookHeight,            "palmMuteHookHeight",            Spatium(0.6) },
    { Sid::palmMutePlacement,             "palmMutePlacement",             PlacementV::BELOW },
    { Sid::palmMutePosAbove,              "palmMutePosAbove",              PointF(.0, 0.0) },
    { Sid::palmMutePosBelow,              "palmMutePosBelow",              PointF(.0, 0.0) },
    { Sid::palmMuteLineWidth,             "palmMuteLineWidth",             Spatium(0.11) },
    { Sid::palmMuteLineStyle,             "palmMuteLineStyle",             PropertyValue(LineType::DASHED) },
    { Sid::palmMuteDashLineLen,           "palmMuteDashLineLen",           5.0 },
    { Sid::palmMuteDashGapLen,            "palmMuteDashGapLen",            5.0 },
    { Sid::palmMuteText,                  "palmMuteText",                  "P.M." },
    { Sid::palmMuteFrameType,             "palmMuteFrameType",             int(FrameType::NO_FRAME) },
    { Sid::palmMuteFramePadding,          "palmMuteFramePadding",          0.2 },
    { Sid::palmMuteFrameWidth,            "palmMuteFrameWidth",            0.1 },
    { Sid::palmMuteFrameRound,            "palmMuteFrameRound",            0 },
    { Sid::palmMuteFrameFgColor,          "palmMuteFrameFgColor",          PropertyValue::fromValue(Color::BLACK) },
    { Sid::palmMuteFrameBgColor,          "palmMuteFrameBgColor",          PropertyValue::fromValue(Color::transparent) },
    { Sid::palmMuteEndHookType,           "palmMuteEndHookType",           HookType::HOOK_90T },

    { Sid::fermataPosAbove,               "fermataPosAbove",               PointF(.0, -0.5) },
    { Sid::fermataPosBelow,               "fermataPosBelow",               PointF(.0, 0.5) },
    { Sid::fermataMinDistance,            "fermataMinDistance",            Spatium(0.4) },

    { Sid::fingeringPlacement,            "fingeringPlacement",            PlacementV::ABOVE },

    { Sid::articulationMinDistance,       "articulationMinDistance",       Spatium(0.4) },
    { Sid::fingeringMinDistance,          "fingeringMinDistance",          Spatium(0.5) },
    { Sid::hairpinMinDistance,            "hairpinMinDistance",            Spatium(0.7) },
    { Sid::letRingMinDistance,            "letRingMinDistance",            Spatium(0.7) },
    { Sid::ottavaMinDistance,             "ottavaMinDistance",             Spatium(0.7) },
    { Sid::palmMuteMinDistance,           "palmMuteMinDistance",           Spatium(0.7) },
    { Sid::pedalMinDistance,              "pedalMinDistance",              Spatium(0.7) },
    { Sid::repeatMinDistance,             "repeatMinDistance",             Spatium(0.5) },
    { Sid::textLineMinDistance,           "textLineMinDistance",           Spatium(0.7) },
    { Sid::systemTextLineMinDistance,     "systemTextLineMinDistance",     Spatium(0.7) },
    { Sid::trillMinDistance,              "trillMinDistance",              Spatium(0.5) },
    { Sid::vibratoMinDistance,            "vibratoMinDistance",            Spatium(1.0) },
    { Sid::voltaMinDistance,              "voltaMinDistance",              Spatium(1.0) },
    { Sid::figuredBassMinDistance,        "figuredBassMinDistance",        Spatium(0.5) },
    { Sid::tupletMinDistance,             "tupletMinDistance",             Spatium(0.5) },

    /// Display options for tab elements (simple and common styles)

    { Sid::slurShowTabSimple, "slurShowTabSimple", true },
    { Sid::slurShowTabCommon, "slurShowTabCommon", true },
    { Sid::fermataShowTabSimple, "fermataShowTabSimple", true },
    { Sid::fermataShowTabCommon, "fermataShowTabCommon", true },
    { Sid::dynamicsShowTabSimple, "dynamicsShowTabSimple", true },
    { Sid::dynamicsShowTabCommon, "dynamicsShowTabCommon", true },
    { Sid::hairpinShowTabSimple, "hairpinShowTabSimple", true },
    { Sid::hairpinShowTabCommon, "hairpinShowTabCommon", true },
    { Sid::accentShowTabSimple, "accentShowTabSimple", true },
    { Sid::accentShowTabCommon, "accentShowTabCommon", true },
    { Sid::staccatoShowTabSimple, "staccatoShowTabSimple", true },
    { Sid::staccatoShowTabCommon, "staccatoShowTabCommon", true },
    { Sid::harmonicMarkShowTabSimple, "harmonicMarkShowTabSimple", true },
    { Sid::harmonicMarkShowTabCommon, "harmonicMarkShowTabCommon", true },
    { Sid::letRingShowTabSimple, "letRingShowTabSimple", true },
    { Sid::letRingShowTabCommon, "letRingShowTabCommon", true },
    { Sid::palmMuteShowTabSimple, "palmMuteShowTabSimple", true },
    { Sid::palmMuteShowTabCommon, "palmMuteShowTabCommon", true },
    { Sid::rasgueadoShowTabSimple, "rasgueadoShowTabSimple", true },
    { Sid::rasgueadoShowTabCommon, "rasgueadoShowTabCommon", true },
    { Sid::mordentShowTabSimple, "mordentShowTabSimple", true },
    { Sid::mordentShowTabCommon, "mordentShowTabCommon", true },
    { Sid::turnShowTabSimple, "turnShowTabSimple", true },
    { Sid::turnShowTabCommon, "turnShowTabCommon", true },
    { Sid::wahShowTabSimple, "wahShowTabSimple", true },
    { Sid::wahShowTabCommon, "wahShowTabCommon", true },
    { Sid::golpeShowTabSimple, "golpeShowTabSimple", true },
    { Sid::golpeShowTabCommon, "golpeShowTabCommon", true },

    { Sid::tabShowTiedFret, "tabShowTiedFret", int(ShowTiedFret::TIE_AND_FRET) },
    { Sid::tabParenthesizeTiedFret, "tabParenthesizeTiedFret", int(ParenthesizeTiedFret::START_OF_SYSTEM) },
    { Sid::parenthesizeTiedFretIfArticulation, "parenthesizeTiedFretIfArticulation", true },

    { Sid::chordlineThickness, "chordlineThickness", Spatium(0.16) },

    { Sid::autoplaceEnabled,              "autoplaceEnabled",              true },
    { Sid::defaultsVersion,               "defaultsVersion",               Constants::MSC_VERSION }
} };
