/*
 * SPDX-License-Identifier: GPL-3.0-only
 * MuseScore-CLA-applies
 *
 * MuseScore
 * Music Composition & Notation
 *
 * Copyright (C) 2024 MuseScore BVBA and others
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
#ifndef MU_UPDATE_MUSESOUNDSCHECKUPDATESCENARIO_H
#define MU_UPDATE_MUSESOUNDSCHECKUPDATESCENARIO_H

#include "async/asyncable.h"
#include "progress.h"

#include "modularity/ioc.h"
#include "iinteractive.h"
#include "actions/iactionsdispatcher.h"
#include "multiinstances/imultiinstancesprovider.h"
#include "../iupdateconfiguration.h"
#include "../imusesoundscheckupdateservice.h"

#include "../imusesoundscheckupdatescenario.h"

namespace mu::update {
class MuseSoundsCheckUpdateScenario : public IMuseSoundsCheckUpdateScenario, public async::Asyncable
{
    INJECT(framework::IInteractive, interactive);
    INJECT(actions::IActionsDispatcher, dispatcher);
    INJECT(mi::IMultiInstancesProvider, multiInstancesProvider);
    INJECT(IUpdateConfiguration, configuration);

    INJECT(IMuseSoundsCheckUpdateService, service);

public:
    void delayedInit();

    void checkForUpdate() override;

private:
    bool isCheckStarted() const;

    bool shouldIgnoreUpdate(const ReleaseInfo& info) const;
    void setIgnoredUpdate(const std::string& version);

    void doCheckForUpdate(bool manual);
    void th_checkForUpdate();

    void showReleaseInfo(const ReleaseInfo& info);

    bool m_checkProgress = false;
    framework::ProgressPtr m_checkProgressChannel = nullptr;
};
}

#endif // MU_UPDATE_MUSESOUNDSCHECKUPDATESCENARIO_H
