/***************************************************************************
 *   Copyright (C) 2005 by Vincent Wagelaar                                *
 *   vincent@ricardis.tudelft.nl                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PREFS_H
#define PREFS_H

#include <qwidget.h>
#include <kconfigdialog.h>
#include <kfilemetainfo.h>
#include <klistview.h>
#include <kdirlister.h>
#include <kglobal.h>
#include <qlayout.h>
#include <klocale.h>

class MediumItem;
class DiskFreeSettings;
class QCheckListItem;

class MediumListView : public KListView
{
    friend class MediumItem;
    Q_OBJECT

public:
    MediumListView(QWidget *parent = 0, const char *name = 0);
signals:
    void stateChange(QCheckListItem *item, bool state);

//protected slots:
//    void slotStateChange(QCheckListItem *item, bool state);

protected:
    void _myStateChange(QCheckListItem *item, bool state);

private:


};


class MediumItem : public QCheckListItem
{
    friend class MediumListView;
    public:
        MediumItem(QListView *parent, const QString name, const KFileItem medium);
        const QString itemURL() const;
    protected:
        virtual void stateChange(bool state);
    private:
        KFileItem mMedium;
};


class MediumWidget : public QWidget
{
    Q_OBJECT

public:
    MediumWidget(KFileItemList items, QWidget *parent, const char *name);
    void initFiles();
    QStringList excludedDrives();
    void setExcludedDrives(QStringList drives);
signals:
    void changed();
protected slots:
    void slotStateChange(QCheckListItem *item, bool state);
private:
    KFileItemList mMedia;
    KListView *mMediaListView;
    QStringList mExcludedList;
};

class Prefs : public KConfigDialog
{
    Q_OBJECT

public:
    Prefs(QWidget *parent, KFileItemList files, DiskFreeSettings *settings, const char *name);
protected slots:
    virtual void updateWidgets();
    virtual void updateWidgetsDefault();
    virtual void updateSettings();
protected:
    virtual bool hasChanged();
    virtual bool isDefault();
private:
    MediumWidget *mMediumWidget;
    DiskFreeSettings *mSettings;
};

#endif
