/* dyndnsupdate --- cachefile.c --- Mar 27 2002
 * Copyright (c) 2002 Fredrik "xzabite" Haglund (xzabite@xzabite.org)
 * http://xzabite.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <strings.h>
#include "cachefile.h"

void save_ipcache(char *ipaddr)
{
   FILE *outfile;  
   outfile = fopen("/var/dyndnsupdate/ipcache","w");
   if (outfile == NULL) {
     print_error("can't write to file: /var/dyndnsupdate/ipcache","");
     exit(1);
   }
   fputs(ipaddr, outfile);
   fclose(outfile);
}

int check_ipcache(char *newip)
{
   char str[MAXLENG+1];
   char ipaddr[MAXLENG+1];
   FILE *infile;
   int isthesame;

   ipaddr[0] = '\0';
 
   if ((infile = fopen("/var/dyndnsupdate/ipcache","r")) == NULL)
     printf("");
   else {
     fgets(str, MAXLENG, infile);
     strcat(ipaddr, str);
     fclose(infile);
   }
   isthesame = strcmp(ipaddr, newip);
   if (isthesame) {
     return 1;
   } else {
     return 0;
   }
}
