/***************************************************************************
 *   Copyright (C) 2009 by the Quassel Project                             *
 *   devel@quassel-irc.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) version 3.                                           *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SSLINFODLG_H
#define SSLINFODLG_H

#include <QDialog>

#include "ui_sslinfodlg.h"

class QSslSocket;

// ========================================
//  SslInfoDialog
// ========================================

class QSslCertificate;

class SslInfoDlg : public QDialog {
  Q_OBJECT

public:
  SslInfoDlg(const QSslSocket *socket, QWidget *parent = 0);
  inline const QSslSocket *socket() const { return _socket; }

private slots:
  void setCurrentCert(int index);

private:
  Ui::SslInfoDlg ui;
  const QSslSocket *_socket;
};

#endif
