/*
 * libgtop-2.0.vapi - modified from the output generated by vapigen.
 */

[CCode (cprefix = "GTop", gir_namespace = "GTop", gir_version = "2.0", lower_case_cprefix = "g_top_")]
namespace GTop {

    [CCode (cheader_filename = "glibtop.h", cname = "glibtop", cprefix = "glibtop_", has_type_id = false)]
    public struct Context {

        public uint flags;
        public uint method;
        public uint error_method;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak int[] input;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak int[] output;
        public int socket;
        public int ncpu;
        public int real_ncpu;
        public uint os_version_code;
        public weak string name;
        public weak string server_command;
        public weak string server_host;
        public weak string server_user;
        public weak string server_rsh;
        public uint features;
        public uint server_port;
        public GTop.SysDeps sysdeps;
        public GTop.SysDeps required;
        public int pid;

        public void close_p ();
        public void close_r ();
        public void close_s ();
        public void get_cpu_l (out GTop.Cpu buf);
        public void get_cpu_s (out GTop.Cpu buf);
        public void get_fsusage_l (out GTop.FsUsage buf, string mount_dir);
        public void get_fsusage_s (out GTop.FsUsage buf, string mount_dir);
        public void get_loadavg_l (out GTop.LoadAvg buf);
        public void get_loadavg_s (out GTop.LoadAvg buf);
        public void get_mem_l (out GTop.Memory buf);
        public void get_mem_s (out GTop.Memory buf);
        public void get_msg_limits_l (out GTop.MsgLimits buf);
        public void get_msg_limits_s (out GTop.MsgLimits buf);
        public void get_netload_l (out GTop.NetLoad buf, string @interface);
        public void get_netload_s (out GTop.NetLoad buf, string @interface);
        public string[] get_netlist (out GTop.NetList buf);
        public ulong get_parameter_l (uint parameter, void* data_ptr, ulong data_size);
        public void get_ppp_l (out GTop.Ppp buf, ushort device);
        public void get_ppp_s (out GTop.Ppp buf, ushort device);
        public uint16 get_proc_affinity_l (out GTop.ProcAffinity buf, int pid);
        public uint16 get_proc_affinity_s (out GTop.ProcAffinity buf, int pid);
        public string get_proc_args_l (out GTop.ProcArgs buf, int pid, uint max_len);
        public string get_proc_args_s (out GTop.ProcArgs buf, int pid, uint max_len);
        public void get_proc_kernel_l (out GTop.ProcKernel buf, int pid);
        public void get_proc_kernel_s (out GTop.ProcKernel buf, int pid);
        public void get_proc_mem_l (out GTop.ProcMem buf, int pid);
        public void get_proc_mem_s (out GTop.ProcMem buf, int pid);
        public void get_proc_segment_l (out GTop.ProcSegment buf, int pid);
        public void get_proc_segment_s (out GTop.ProcSegment buf, int pid);
        public void get_proc_signal_l (out GTop.ProcSignal buf, int pid);
        public void get_proc_signal_s (out GTop.ProcSignal buf, int pid);
        public void get_proc_state_l (out GTop.ProcState buf, int pid);
        public void get_proc_state_s (out GTop.ProcState buf, int pid);
        public void get_proc_time_l (out GTop.ProcTime buf, int pid);
        public void get_proc_time_s (out GTop.ProcTime buf, int pid);
        public void get_proc_uid_l (out GTop.ProcUid buf, int pid);
        public void get_proc_uid_s (out GTop.ProcUid buf, int pid);
        public int get_proclist_l (out GTop.ProcList buf, int64 which, int64 arg);
        public int get_proclist_s (out GTop.ProcList buf, int64 which, int64 arg);
        public void get_sem_limits_l (out GTop.SemLimits buf);
        public void get_sem_limits_s (out GTop.SemLimits buf);
        public void get_shm_limits_l (out GTop.ShmLimits buf);
        public void get_shm_limits_s (out GTop.ShmLimits buf);
        public void get_swap_l (out GTop.Swap buf);
        public void get_swap_s (out GTop.Swap buf);
        public void get_sysdeps_r (out GTop.SysDeps buf);
        public unowned GTop.SysInfo? get_sysinfo_s ();
        public void get_uptime_l (out GTop.Uptime buf);
        public void get_uptime_s (out GTop.Uptime buf);
        public void init_p (ulong features, uint flags);
        public void open_l (string program_name, ulong features, uint flags);
        public void open_p (string program_name, ulong features, uint flags);
        public void open_s (string program_name, ulong features, uint flags);
        public void set_parameter_l (uint parameter, void* data_ptr, ulong data_size);
    }

    [CCode (cheader_filename = "glibtop/command.h", cname = "glibtop_command", has_type_id = false)]
    public struct Command {
        public uint64 command;
        public uint64 size;
        public uint64 data_size;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] parameter;
    }

    [CCode (cheader_filename = "glibtop/cpu.h", cname = "glibtop_cpu", has_type_id = false)]
    public struct Cpu {
        public uint64 flags;
        public uint64 total;
        public uint64 user;
        public uint64 nice;
        public uint64 sys;
        public uint64 idle;
        public uint64 iowait;
        public uint64 irq;
        public uint64 softirq;
        public uint64 frequency;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_total;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_user;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_nice;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_sys;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_idle;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_iowait;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_irq;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_softirq;
        public uint64 xcpu_flags;
    }

    [CCode (cheader_filename = "glibtop/sysinfo.h", cname = "glibtop_entry", has_type_id = false)]
    public struct Entry {
        public GLib.PtrArray labels;
        public GLib.HashTable values;
        public GLib.HashTable descriptions;
    }

    [CCode (cheader_filename = "glibtop/fsusage.h", cname = "glibtop_fsusage", has_type_id = false)]
    public struct FsUsage {
        public uint64 flags;
        public uint64 blocks;
        public uint64 bfree;
        public uint64 bavail;
        public uint64 files;
        public uint64 ffree;
        public uint32 block_size;
        public uint64 read;
        public uint64 write;
    }

    [CCode (cheader_filename = "glibtop/loadavg.h", cname = "glibtop_loadavg", has_type_id = false)]
    public struct LoadAvg {
        public uint64 flags;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak double[] loadavg;
        public uint64 nr_running;
        public uint64 nr_tasks;
        public uint64 last_pid;
    }

    [CCode (cheader_filename = "glibtop/procmap.h", cname = "glibtop_map_entry", has_type_id = false)]
    public struct MapEntry {
        public uint64 flags;
        public uint64 start;
        public uint64 end;
        public uint64 offset;
        public uint64 perm;
        public uint64 inode;
        public uint64 device;
        public uint64 size;
        public uint64 rss;
        public uint64 shared_clean;
        public uint64 shared_dirty;
        public uint64 private_clean;
        public uint64 private_dirty;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] filename;
    }

    [CCode (cheader_filename = "glibtop/mem.h", cname = "glibtop_mem", has_type_id = false)]
    public struct Memory {
        public uint64 flags;
        public uint64 total;
        public uint64 used;
        public uint64 free;
        public uint64 shared;
        public uint64 buffer;
        public uint64 cached;
        public uint64 user;
        public uint64 locked;
    }

    [CCode (cheader_filename = "glibtop/mountlist.h", cname = "glibtop_mountentry", has_type_id = false)]
    public struct MountEntry {
        public uint64 dev;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] devname;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] mountdir;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] type;
    }

    [CCode (cheader_filename = "glibtop/mountlist.h", cname = "glibtop_mountlist", has_type_id = false)]
    public struct MountList {
        public uint64 flags;
        public uint64 number;
        public uint64 total;
        public uint64 size;
    }

    [CCode (cheader_filename = "glibtop/msg_limits.h", cname = "glibtop_msg_limits", has_type_id = false)]
    public struct MsgLimits {
        public uint64 flags;
        public uint64 msgpool;
        public uint64 msgmap;
        public uint64 msgmax;
        public uint64 msgmnb;
        public uint64 msgmni;
        public uint64 msgssz;
        public uint64 msgtql;
    }

    [CCode (cheader_filename = "glibtop/netlist.h", cname = "glibtop_netlist", has_type_id = false)]
    public struct NetList {
        public uint64 flags;
        public uint32 number;
    }

    [CCode (cheader_filename = "glibtop/netload.h", cname = "glibtop_netload", has_type_id = false)]
    public struct NetLoad {
        public uint64 flags;
        public uint64 if_flags;
        public uint32 mtu;
        public uint32 subnet;
        public uint32 address;
        public uint64 packets_in;
        public uint64 packets_out;
        public uint64 packets_total;
        public uint64 bytes_in;
        public uint64 bytes_out;
        public uint64 bytes_total;
        public uint64 errors_in;
        public uint64 errors_out;
        public uint64 errors_total;
        public uint64 collisions;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint8[] address6;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint8[] prefix6;
        public uint8 scope6;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint8[] hwaddress;
    }

    [CCode (cheader_filename = "glibtop/procopenfiles.h", cname = "glibtop_open_files_entry", has_type_id = false)]
    public struct OpenFilesEntry {
        public int fd;
        public uint16 type;
        [CCode (array_length = false, array_null_terminated = true, cname = "info.sock.dest_host")]
        public weak char[] info_sock_dest_host;
        [CCode (cname = "info.sock.dest_port")]
        public int info_sock_dest_port;
        [CCode (array_length = false, array_null_terminated = true, cname = "info.file.name")]
        public weak char[] info_file_name;
        [CCode (array_length = false, array_null_terminated = true, cname = "info.localsock.name")]
        public weak char[] info_localsock_name;
    }

    [CCode (cheader_filename = "glibtop/ppp.h", cname = "glibtop_ppp", has_type_id = false)]
    public struct Ppp {
        public uint64 flags;
        public uint64 state;
        public uint64 bytes_in;
        public uint64 bytes_out;
    }

    [CCode (cheader_filename = "glibtop/procaffinity.h", cname = "glibtop_proc_affinity", has_type_id = false)]
    public struct ProcAffinity {
        public uint64 flags;
        public uint32 number;
        public bool all;
    }

    [CCode (cheader_filename = "glibtop/procargs.h", cname = "glibtop_proc_args", has_type_id = false)]
    public struct ProcArgs {
        public uint64 flags;
        public uint64 size;
    }

    [CCode (cheader_filename = "glibtop/prockernel.h", cname = "glibtop_proc_kernel", has_type_id = false)]
    public struct ProcKernel {
        public uint64 flags;
        public uint64 k_flags;
        public uint64 min_flt;
        public uint64 maj_flt;
        public uint64 cmin_flt;
        public uint64 cmaj_flt;
        public uint64 kstk_esp;
        public uint64 kstk_eip;
        public uint64 nwchan;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] wchan;
    }

    [CCode (cheader_filename = "glibtop/procmap.h", cname = "glibtop_proc_map", has_type_id = false)]
    public struct ProcMap {
        public uint64 flags;
        public uint64 number;
        public uint64 total;
        public uint64 size;
    }

    [CCode (cheader_filename = "glibtop/procmem.h", cname = "glibtop_proc_mem", has_type_id = false)]
    public struct ProcMem {
        public uint64 flags;
        public uint64 size;
        public uint64 vsize;
        public uint64 resident;
        public uint64 share;
        public uint64 rss;
        public uint64 rss_rlim;
    }

    [CCode (cheader_filename = "glibtop/procopenfiles.h", cname = "glibtop_proc_open_files", has_type_id = false)]
    public struct ProcOpenFiles {
        public uint64 flags;
        public uint64 number;
        public uint64 total;
        public uint64 size;
    }

    [CCode (cheader_filename = "glibtop/procsegment.h", cname = "glibtop_proc_segment", has_type_id = false)]
    public struct ProcSegment {
        public uint64 flags;
        public uint64 text_rss;
        public uint64 shlib_rss;
        public uint64 data_rss;
        public uint64 stack_rss;
        public uint64 dirty_size;
        public uint64 start_code;
        public uint64 end_code;
        public uint64 start_stack;
    }

    [CCode (cheader_filename = "glibtop/procsignal.h", cname = "glibtop_proc_signal", has_type_id = false)]
    public struct ProcSignal {
        public uint64 flags;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] @signal;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] blocked;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] sigignore;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] sigcatch;
    }

    [CCode (cheader_filename = "glibtop/procstate.h", cname = "glibtop_proc_state", has_type_id = false)]
    public struct ProcState {
        public uint64 flags;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] cmd;
        public uint state;
        public int uid;
        public int gid;
        public int ruid;
        public int rgid;
        public int has_cpu;
        public int processor;
        public int last_processor;
    }

    [CCode (cheader_filename = "glibtop/proctime.h", cname = "glibtop_proc_time", has_type_id = false)]
    public struct ProcTime {
        public uint64 flags;
        public uint64 start_time;
        public uint64 rtime;
        public uint64 utime;
        public uint64 stime;
        public uint64 cutime;
        public uint64 cstime;
        public uint64 timeout;
        public uint64 it_real_value;
        public uint64 frequency;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_utime;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak uint64[] xcpu_stime;
    }

    [CCode (cheader_filename = "glibtop/procuid.h", cname = "glibtop_proc_uid", has_type_id = false)]
    public struct ProcUid {
        public uint64 flags;
        public int32 uid;
        public int32 euid;
        public int32 gid;
        public int32 egid;
        public int32 suid;
        public int32 sgid;
        public int32 fsuid;
        public int32 fsgid;
        public int32 pid;
        public int32 ppid;
        public int32 pgrp;
        public int32 session;
        public int32 tty;
        public int32 tpgid;
        public int32 priority;
        public int32 nice;
        public int32 ngroups;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak int32[] groups;
    }

    [CCode (cheader_filename = "glibtop/procwd.h", cname = "glibtop_proc_wd", has_type_id = false)]
    public struct ProcWd {
        public uint64 flags;
        public uint32 number;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] root;
        [CCode (array_length = false, array_null_terminated = true)]
        public weak char[] exe;
    }

    [CCode (cheader_filename = "glibtop/proclist.h", cname = "glibtop_proclist", has_type_id = false)]
    public struct ProcList {
        public uint64 flags;
        public uint64 number;
        public uint64 total;
        public uint64 size;
    }

    [CCode (cheader_filename = "glibtop/command.h", cname = "glibtop_response", has_type_id = false)]
    public struct Response {
        public int64 offset;
        public uint64 size;
        public uint64 data_size;
        public GTop.ResponseUnion u;
    }

    [CCode (cheader_filename = "glibtop/command.h", cname = "glibtop_response_union")]
    public struct ResponseUnion {
        public GTop.Union data;
        public GTop.SysDeps sysdeps;
    }

    [CCode (cheader_filename = "glibtop/sem_limits.h", cname = "glibtop_sem_limits", has_type_id = false)]
    public struct SemLimits {
        public uint64 flags;
        public uint64 semmap;
        public uint64 semmni;
        public uint64 semmns;
        public uint64 semmnu;
        public uint64 semmsl;
        public uint64 semopm;
        public uint64 semume;
        public uint64 semusz;
        public uint64 semvmx;
        public uint64 semaem;
    }

    [CCode (cheader_filename = "glibtop/shm_limits.h", cname = "glibtop_shm_limits", has_type_id = false)]
    public struct ShmLimits {
        public uint64 flags;
        public uint64 shmmax;
        public uint64 shmmin;
        public uint64 shmmni;
        public uint64 shmseg;
        public uint64 shmall;
    }

    [CCode (cheader_filename = "glibtop/signal.h", cname = "glibtop_signame", has_type_id = false)]
    public struct SigName {
        public int number;
        public weak string name;
        public weak string label;
    }

    [CCode (cheader_filename = "glibtop/swap.h", cname = "glibtop_swap", has_type_id = false)]
    public struct Swap {
        public uint64 flags;
        public uint64 total;
        public uint64 used;
        public uint64 free;
        public uint64 pagein;
        public uint64 pageout;
    }

    [CCode (cheader_filename = "glibtop/sysdeps.h", cname = "glibtop_sysdeps", has_type_id = false)]
    public struct SysDeps {
        public uint64 flags;
        public uint64 features;
        public uint64 cpu;
        public uint64 mem;
        public uint64 swap;
        public uint64 uptime;
        public uint64 loadavg;
        public uint64 shm_limits;
        public uint64 msg_limits;
        public uint64 sem_limits;
        public uint64 proclist;
        public uint64 proc_state;
        public uint64 proc_uid;
        public uint64 proc_mem;
        public uint64 proc_time;
        public uint64 proc_signal;
        public uint64 proc_kernel;
        public uint64 proc_segment;
        public uint64 proc_args;
        public uint64 proc_map;
        public uint64 proc_open_files;
        public uint64 mountlist;
        public uint64 fsusage;
        public uint64 netlist;
        public uint64 netload;
        public uint64 ppp;
        public uint64 proc_wd;
        public uint64 proc_affinity;
    }

    [CCode (cheader_filename = "glibtop/sysinfo.h", cname = "glibtop_sysinfo", has_type_id = false)]
    public struct SysInfo {
        public uint64 flags;
        public uint64 ncpu;
        [CCode (array_length = false, array_null_terminated = true)]
        public unowned Entry[] cpuinfo;
    }

    [CCode (cheader_filename = "glibtop/union.h", cname = "glibtop_union")]
    public struct Union {
        public GTop.Cpu cpu;
        public GTop.Memory mem;
        public GTop.Swap swap;
        public GTop.Uptime uptime;
        public GTop.LoadAvg loadavg;
        public GTop.ShmLimits shm_limits;
        public GTop.MsgLimits msg_limits;
        public GTop.SemLimits sem_limits;
        public GTop.ProcList proclist;
        public GTop.ProcState proc_state;
        public GTop.ProcUid proc_uid;
        public GTop.ProcMem proc_mem;
        public GTop.ProcTime proc_time;
        public GTop.ProcSignal proc_signal;
        public GTop.ProcKernel proc_kernel;
        public GTop.ProcSegment proc_segment;
        public GTop.ProcArgs proc_args;
        public GTop.ProcMap proc_map;
        public GTop.MountList mountlist;
        public GTop.FsUsage fsusage;
        public GTop.NetList netlist;
        public GTop.NetLoad netload;
        public GTop.Ppp ppp;
        public GTop.ProcOpenFiles proc_open_files;
        public GTop.ProcWd proc_wd;
        public GTop.ProcAffinity proc_affinity;
    }

    [CCode (cheader_filename = "glibtop/uptime.h", cname = "glibtop_uptime", has_type_id = false)]
    public struct Uptime {
        public uint64 flags;
        public double uptime;
        public double idletime;
        public uint64 boot_time;
    }

    [CCode (cheader_filename = "glibtop.h", cname = "AUTH_NAMESZ")]
    public const int AUTH_NAMESZ;
    [CCode (cheader_filename = "glibtop.h", cname = "AUTH_TIMEOUT")]
    public const int AUTH_TIMEOUT;
    [CCode (cheader_filename = "glibtop.h", cname = "CONN_INTERNET")]
    public const int CONN_INTERNET;
    [CCode (cheader_filename = "glibtop.h", cname = "CONN_IPC")]
    public const int CONN_IPC;
    [CCode (cheader_filename = "glibtop.h", cname = "CONN_UNIX")]
    public const int CONN_UNIX;
    [CCode (cheader_filename = "glibtop.h", cname = "DEFAULT_PORT")]
    public const int DEFAULT_PORT;
    [CCode (cheader_filename = "glibtop.h", cname = "DEFAUTH_NAME")]
    public const string DEFAUTH_NAME;
    [CCode (cheader_filename = "glibtop.h", cname = "EOT_CHR")]
    public const int EOT_CHR;
    [CCode (cheader_filename = "glibtop.h", cname = "EOT_STR")]
    public const string EOT_STR;
    [CCode (cheader_filename = "glibtop.h", cname = "FALSE")]
    public const int FALSE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_CPU")]
    public const int GLIBTOP_CMND_CPU;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_FSUSAGE")]
    public const int GLIBTOP_CMND_FSUSAGE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_LOADAVG")]
    public const int GLIBTOP_CMND_LOADAVG;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_MEM")]
    public const int GLIBTOP_CMND_MEM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_MOUNTLIST")]
    public const int GLIBTOP_CMND_MOUNTLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_MSG_LIMITS")]
    public const int GLIBTOP_CMND_MSG_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_NETLIST")]
    public const int GLIBTOP_CMND_NETLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_NETLOAD")]
    public const int GLIBTOP_CMND_NETLOAD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PPP")]
    public const int GLIBTOP_CMND_PPP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROCLIST")]
    public const int GLIBTOP_CMND_PROCLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_AFFINITY")]
    public const int GLIBTOP_CMND_PROC_AFFINITY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_ARGS")]
    public const int GLIBTOP_CMND_PROC_ARGS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_KERNEL")]
    public const int GLIBTOP_CMND_PROC_KERNEL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_MAP")]
    public const int GLIBTOP_CMND_PROC_MAP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_MEM")]
    public const int GLIBTOP_CMND_PROC_MEM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_OPEN_FILES")]
    public const int GLIBTOP_CMND_PROC_OPEN_FILES;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_SEGMENT")]
    public const int GLIBTOP_CMND_PROC_SEGMENT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_SIGNAL")]
    public const int GLIBTOP_CMND_PROC_SIGNAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_STATE")]
    public const int GLIBTOP_CMND_PROC_STATE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_TIME")]
    public const int GLIBTOP_CMND_PROC_TIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_UID")]
    public const int GLIBTOP_CMND_PROC_UID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_PROC_WD")]
    public const int GLIBTOP_CMND_PROC_WD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_QUIT")]
    public const int GLIBTOP_CMND_QUIT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_SEM_LIMITS")]
    public const int GLIBTOP_CMND_SEM_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_SHM_LIMITS")]
    public const int GLIBTOP_CMND_SHM_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_SWAP")]
    public const int GLIBTOP_CMND_SWAP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_SYSDEPS")]
    public const int GLIBTOP_CMND_SYSDEPS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CMND_UPTIME")]
    public const int GLIBTOP_CMND_UPTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_FREQUENCY")]
    public const int GLIBTOP_CPU_FREQUENCY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_IDLE")]
    public const int GLIBTOP_CPU_IDLE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_IOWAIT")]
    public const int GLIBTOP_CPU_IOWAIT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_IRQ")]
    public const int GLIBTOP_CPU_IRQ;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_NICE")]
    public const int GLIBTOP_CPU_NICE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_SOFTIRQ")]
    public const int GLIBTOP_CPU_SOFTIRQ;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_SYS")]
    public const int GLIBTOP_CPU_SYS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_TOTAL")]
    public const int GLIBTOP_CPU_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_CPU_USER")]
    public const int GLIBTOP_CPU_USER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_ERROR_METHOD_ABORT")]
    public const int GLIBTOP_ERROR_METHOD_ABORT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_ERROR_METHOD_IGNORE")]
    public const int GLIBTOP_ERROR_METHOD_IGNORE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_ERROR_METHOD_WARN")]
    public const int GLIBTOP_ERROR_METHOD_WARN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_ERROR_METHOD_WARN_ONCE")]
    public const int GLIBTOP_ERROR_METHOD_WARN_ONCE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_EXCLUDE_IDLE")]
    public const int GLIBTOP_EXCLUDE_IDLE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_EXCLUDE_NOTTY")]
    public const int GLIBTOP_EXCLUDE_NOTTY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_EXCLUDE_SYSTEM")]
    public const int GLIBTOP_EXCLUDE_SYSTEM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FEATURES_EXCEPT")]
    public const int GLIBTOP_FEATURES_EXCEPT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FEATURES_NO_SERVER")]
    public const int GLIBTOP_FEATURES_NO_SERVER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FILE_ENTRY_FD")]
    public const int GLIBTOP_FILE_ENTRY_FD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FILE_ENTRY_INETSOCKET_DST_HOST")]
    public const int GLIBTOP_FILE_ENTRY_INETSOCKET_DST_HOST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FILE_ENTRY_INETSOCKET_DST_PORT")]
    public const int GLIBTOP_FILE_ENTRY_INETSOCKET_DST_PORT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FILE_ENTRY_NAME")]
    public const int GLIBTOP_FILE_ENTRY_NAME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FILE_ENTRY_TYPE")]
    public const int GLIBTOP_FILE_ENTRY_TYPE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FSUSAGE_BAVAIL")]
    public const int GLIBTOP_FSUSAGE_BAVAIL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FSUSAGE_BFREE")]
    public const int GLIBTOP_FSUSAGE_BFREE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FSUSAGE_BLOCKS")]
    public const int GLIBTOP_FSUSAGE_BLOCKS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FSUSAGE_BLOCK_SIZE")]
    public const int GLIBTOP_FSUSAGE_BLOCK_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FSUSAGE_FFREE")]
    public const int GLIBTOP_FSUSAGE_FFREE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FSUSAGE_FILES")]
    public const int GLIBTOP_FSUSAGE_FILES;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FSUSAGE_READ")]
    public const int GLIBTOP_FSUSAGE_READ;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_FSUSAGE_WRITE")]
    public const int GLIBTOP_FSUSAGE_WRITE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_INIT_NO_INIT")]
    public const int GLIBTOP_INIT_NO_INIT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_INIT_NO_OPEN")]
    public const int GLIBTOP_INIT_NO_OPEN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_MSGMAP")]
    public const int GLIBTOP_IPC_MSGMAP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_MSGMAX")]
    public const int GLIBTOP_IPC_MSGMAX;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_MSGMNB")]
    public const int GLIBTOP_IPC_MSGMNB;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_MSGMNI")]
    public const int GLIBTOP_IPC_MSGMNI;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_MSGPOOL")]
    public const int GLIBTOP_IPC_MSGPOOL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_MSGSSZ")]
    public const int GLIBTOP_IPC_MSGSSZ;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_MSGTQL")]
    public const int GLIBTOP_IPC_MSGTQL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMAEM")]
    public const int GLIBTOP_IPC_SEMAEM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMMAP")]
    public const int GLIBTOP_IPC_SEMMAP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMMNI")]
    public const int GLIBTOP_IPC_SEMMNI;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMMNS")]
    public const int GLIBTOP_IPC_SEMMNS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMMNU")]
    public const int GLIBTOP_IPC_SEMMNU;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMMSL")]
    public const int GLIBTOP_IPC_SEMMSL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMOPM")]
    public const int GLIBTOP_IPC_SEMOPM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMUME")]
    public const int GLIBTOP_IPC_SEMUME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMUSZ")]
    public const int GLIBTOP_IPC_SEMUSZ;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SEMVMX")]
    public const int GLIBTOP_IPC_SEMVMX;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SHMALL")]
    public const int GLIBTOP_IPC_SHMALL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SHMMAX")]
    public const int GLIBTOP_IPC_SHMMAX;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SHMMIN")]
    public const int GLIBTOP_IPC_SHMMIN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SHMMNI")]
    public const int GLIBTOP_IPC_SHMMNI;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_IPC_SHMSEG")]
    public const int GLIBTOP_IPC_SHMSEG;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_KERN_PROC_ALL")]
    public const int GLIBTOP_KERN_PROC_ALL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_KERN_PROC_MASK")]
    public const int GLIBTOP_KERN_PROC_MASK;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_KERN_PROC_PGRP")]
    public const int GLIBTOP_KERN_PROC_PGRP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_KERN_PROC_PID")]
    public const int GLIBTOP_KERN_PROC_PID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_KERN_PROC_RUID")]
    public const int GLIBTOP_KERN_PROC_RUID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_KERN_PROC_SESSION")]
    public const int GLIBTOP_KERN_PROC_SESSION;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_KERN_PROC_TTY")]
    public const int GLIBTOP_KERN_PROC_TTY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_KERN_PROC_UID")]
    public const int GLIBTOP_KERN_PROC_UID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_LOADAVG_LAST_PID")]
    public const int GLIBTOP_LOADAVG_LAST_PID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_LOADAVG_LOADAVG")]
    public const int GLIBTOP_LOADAVG_LOADAVG;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_LOADAVG_NR_RUNNING")]
    public const int GLIBTOP_LOADAVG_NR_RUNNING;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_LOADAVG_NR_TASKS")]
    public const int GLIBTOP_LOADAVG_NR_TASKS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_DEVICE")]
    public const int GLIBTOP_MAP_ENTRY_DEVICE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_END")]
    public const int GLIBTOP_MAP_ENTRY_END;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_FILENAME")]
    public const int GLIBTOP_MAP_ENTRY_FILENAME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_INODE")]
    public const int GLIBTOP_MAP_ENTRY_INODE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_OFFSET")]
    public const int GLIBTOP_MAP_ENTRY_OFFSET;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_PERM")]
    public const int GLIBTOP_MAP_ENTRY_PERM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_PRIVATE_CLEAN")]
    public const int GLIBTOP_MAP_ENTRY_PRIVATE_CLEAN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_PRIVATE_DIRTY")]
    public const int GLIBTOP_MAP_ENTRY_PRIVATE_DIRTY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_RSS")]
    public const int GLIBTOP_MAP_ENTRY_RSS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_SHARED_CLEAN")]
    public const int GLIBTOP_MAP_ENTRY_SHARED_CLEAN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_SHARED_DIRTY")]
    public const int GLIBTOP_MAP_ENTRY_SHARED_DIRTY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_SIZE")]
    public const int GLIBTOP_MAP_ENTRY_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_ENTRY_START")]
    public const int GLIBTOP_MAP_ENTRY_START;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_FILENAME_LEN")]
    public const int GLIBTOP_MAP_FILENAME_LEN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_PERM_EXECUTE")]
    public const int GLIBTOP_MAP_PERM_EXECUTE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_PERM_PRIVATE")]
    public const int GLIBTOP_MAP_PERM_PRIVATE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_PERM_READ")]
    public const int GLIBTOP_MAP_PERM_READ;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_PERM_SHARED")]
    public const int GLIBTOP_MAP_PERM_SHARED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAP_PERM_WRITE")]
    public const int GLIBTOP_MAP_PERM_WRITE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_CMND")]
    public const int GLIBTOP_MAX_CMND;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_CPU")]
    public const int GLIBTOP_MAX_CPU;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_FSUSAGE")]
    public const int GLIBTOP_MAX_FSUSAGE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_GROUPS")]
    public const int GLIBTOP_MAX_GROUPS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_LOADAVG")]
    public const int GLIBTOP_MAX_LOADAVG;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_MAP_ENTRY")]
    public const int GLIBTOP_MAX_MAP_ENTRY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_MEM")]
    public const int GLIBTOP_MAX_MEM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_MOUNTLIST")]
    public const int GLIBTOP_MAX_MOUNTLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_MSG_LIMITS")]
    public const int GLIBTOP_MAX_MSG_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_NETLIST")]
    public const int GLIBTOP_MAX_NETLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_NETLOAD")]
    public const int GLIBTOP_MAX_NETLOAD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_OPEN_FILE_ENTRY")]
    public const int GLIBTOP_MAX_OPEN_FILE_ENTRY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PPP")]
    public const int GLIBTOP_MAX_PPP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROCLIST")]
    public const int GLIBTOP_MAX_PROCLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_ARGS")]
    public const int GLIBTOP_MAX_PROC_ARGS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_KERNEL")]
    public const int GLIBTOP_MAX_PROC_KERNEL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_MAP")]
    public const int GLIBTOP_MAX_PROC_MAP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_MEM")]
    public const int GLIBTOP_MAX_PROC_MEM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_OPEN_FILES")]
    public const int GLIBTOP_MAX_PROC_OPEN_FILES;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_SEGMENT")]
    public const int GLIBTOP_MAX_PROC_SEGMENT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_SIGNAL")]
    public const int GLIBTOP_MAX_PROC_SIGNAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_STATE")]
    public const int GLIBTOP_MAX_PROC_STATE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_TIME")]
    public const int GLIBTOP_MAX_PROC_TIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_PROC_UID")]
    public const int GLIBTOP_MAX_PROC_UID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_SEM_LIMITS")]
    public const int GLIBTOP_MAX_SEM_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_SHM_LIMITS")]
    public const int GLIBTOP_MAX_SHM_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_SWAP")]
    public const int GLIBTOP_MAX_SWAP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_SYSDEPS")]
    public const int GLIBTOP_MAX_SYSDEPS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_SYSINFO")]
    public const int GLIBTOP_MAX_SYSINFO;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MAX_UPTIME")]
    public const int GLIBTOP_MAX_UPTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MEM_BUFFER")]
    public const int GLIBTOP_MEM_BUFFER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MEM_CACHED")]
    public const int GLIBTOP_MEM_CACHED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MEM_FREE")]
    public const int GLIBTOP_MEM_FREE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MEM_LOCKED")]
    public const int GLIBTOP_MEM_LOCKED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MEM_SHARED")]
    public const int GLIBTOP_MEM_SHARED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MEM_TOTAL")]
    public const int GLIBTOP_MEM_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MEM_USED")]
    public const int GLIBTOP_MEM_USED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MEM_USER")]
    public const int GLIBTOP_MEM_USER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_METHOD_DIRECT")]
    public const int GLIBTOP_METHOD_DIRECT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_METHOD_INET")]
    public const int GLIBTOP_METHOD_INET;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_METHOD_PIPE")]
    public const int GLIBTOP_METHOD_PIPE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_METHOD_UNIX")]
    public const int GLIBTOP_METHOD_UNIX;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MOUNTENTRY_LEN")]
    public const int GLIBTOP_MOUNTENTRY_LEN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MOUNTLIST_NUMBER")]
    public const int GLIBTOP_MOUNTLIST_NUMBER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MOUNTLIST_SIZE")]
    public const int GLIBTOP_MOUNTLIST_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_MOUNTLIST_TOTAL")]
    public const int GLIBTOP_MOUNTLIST_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NCPU")]
    public const int GLIBTOP_NCPU;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLIST_NUMBER")]
    public const int GLIBTOP_NETLIST_NUMBER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_ADDRESS")]
    public const int GLIBTOP_NETLOAD_ADDRESS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_ADDRESS6")]
    public const int GLIBTOP_NETLOAD_ADDRESS6;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_BYTES_IN")]
    public const int GLIBTOP_NETLOAD_BYTES_IN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_BYTES_OUT")]
    public const int GLIBTOP_NETLOAD_BYTES_OUT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_BYTES_TOTAL")]
    public const int GLIBTOP_NETLOAD_BYTES_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_COLLISIONS")]
    public const int GLIBTOP_NETLOAD_COLLISIONS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_ERRORS_IN")]
    public const int GLIBTOP_NETLOAD_ERRORS_IN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_ERRORS_OUT")]
    public const int GLIBTOP_NETLOAD_ERRORS_OUT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_ERRORS_TOTAL")]
    public const int GLIBTOP_NETLOAD_ERRORS_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_HWADDRESS")]
    public const int GLIBTOP_NETLOAD_HWADDRESS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_IF_FLAGS")]
    public const int GLIBTOP_NETLOAD_IF_FLAGS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_MTU")]
    public const int GLIBTOP_NETLOAD_MTU;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_PACKETS_IN")]
    public const int GLIBTOP_NETLOAD_PACKETS_IN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_PACKETS_OUT")]
    public const int GLIBTOP_NETLOAD_PACKETS_OUT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_PACKETS_TOTAL")]
    public const int GLIBTOP_NETLOAD_PACKETS_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_PREFIX6")]
    public const int GLIBTOP_NETLOAD_PREFIX6;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_SCOPE6")]
    public const int GLIBTOP_NETLOAD_SCOPE6;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_NETLOAD_SUBNET")]
    public const int GLIBTOP_NETLOAD_SUBNET;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_OPEN_DEST_HOST_LEN")]
    public const int GLIBTOP_OPEN_DEST_HOST_LEN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_OPEN_FILENAME_LEN")]
    public const int GLIBTOP_OPEN_FILENAME_LEN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PARAM_COMMAND")]
    public const int GLIBTOP_PARAM_COMMAND;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PARAM_ERROR_METHOD")]
    public const int GLIBTOP_PARAM_ERROR_METHOD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PARAM_FEATURES")]
    public const int GLIBTOP_PARAM_FEATURES;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PARAM_HOST")]
    public const int GLIBTOP_PARAM_HOST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PARAM_METHOD")]
    public const int GLIBTOP_PARAM_METHOD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PARAM_PORT")]
    public const int GLIBTOP_PARAM_PORT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PARAM_REQUIRED")]
    public const int GLIBTOP_PARAM_REQUIRED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PPP_BYTES_IN")]
    public const int GLIBTOP_PPP_BYTES_IN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PPP_BYTES_OUT")]
    public const int GLIBTOP_PPP_BYTES_OUT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PPP_STATE")]
    public const int GLIBTOP_PPP_STATE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCESS_DEAD")]
    public const int GLIBTOP_PROCESS_DEAD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCESS_INTERRUPTIBLE")]
    public const int GLIBTOP_PROCESS_INTERRUPTIBLE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCESS_RUNNING")]
    public const int GLIBTOP_PROCESS_RUNNING;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCESS_STOPPED")]
    public const int GLIBTOP_PROCESS_STOPPED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCESS_SWAPPING")]
    public const int GLIBTOP_PROCESS_SWAPPING;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCESS_UNINTERRUPTIBLE")]
    public const int GLIBTOP_PROCESS_UNINTERRUPTIBLE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCESS_ZOMBIE")]
    public const int GLIBTOP_PROCESS_ZOMBIE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCLIST_NUMBER")]
    public const int GLIBTOP_PROCLIST_NUMBER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCLIST_SIZE")]
    public const int GLIBTOP_PROCLIST_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROCLIST_TOTAL")]
    public const int GLIBTOP_PROCLIST_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_AFFINITY_ALL")]
    public const int GLIBTOP_PROC_AFFINITY_ALL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_AFFINITY_NUMBER")]
    public const int GLIBTOP_PROC_AFFINITY_NUMBER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_ARGS_SIZE")]
    public const int GLIBTOP_PROC_ARGS_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_CMAJ_FLT")]
    public const int GLIBTOP_PROC_KERNEL_CMAJ_FLT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_CMIN_FLT")]
    public const int GLIBTOP_PROC_KERNEL_CMIN_FLT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_KSTK_EIP")]
    public const int GLIBTOP_PROC_KERNEL_KSTK_EIP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_KSTK_ESP")]
    public const int GLIBTOP_PROC_KERNEL_KSTK_ESP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_K_FLAGS")]
    public const int GLIBTOP_PROC_KERNEL_K_FLAGS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_MAJ_FLT")]
    public const int GLIBTOP_PROC_KERNEL_MAJ_FLT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_MIN_FLT")]
    public const int GLIBTOP_PROC_KERNEL_MIN_FLT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_NWCHAN")]
    public const int GLIBTOP_PROC_KERNEL_NWCHAN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_KERNEL_WCHAN")]
    public const int GLIBTOP_PROC_KERNEL_WCHAN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MAP_NUMBER")]
    public const int GLIBTOP_PROC_MAP_NUMBER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MAP_SIZE")]
    public const int GLIBTOP_PROC_MAP_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MAP_TOTAL")]
    public const int GLIBTOP_PROC_MAP_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MEM_RESIDENT")]
    public const int GLIBTOP_PROC_MEM_RESIDENT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MEM_RSS")]
    public const int GLIBTOP_PROC_MEM_RSS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MEM_RSS_RLIM")]
    public const int GLIBTOP_PROC_MEM_RSS_RLIM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MEM_SHARE")]
    public const int GLIBTOP_PROC_MEM_SHARE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MEM_SIZE")]
    public const int GLIBTOP_PROC_MEM_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_MEM_VSIZE")]
    public const int GLIBTOP_PROC_MEM_VSIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_OPEN_FILES_NUMBER")]
    public const int GLIBTOP_PROC_OPEN_FILES_NUMBER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_OPEN_FILES_SIZE")]
    public const int GLIBTOP_PROC_OPEN_FILES_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_OPEN_FILES_TOTAL")]
    public const int GLIBTOP_PROC_OPEN_FILES_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SEGMENT_DATA_RSS")]
    public const int GLIBTOP_PROC_SEGMENT_DATA_RSS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SEGMENT_DIRTY_SIZE")]
    public const int GLIBTOP_PROC_SEGMENT_DIRTY_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SEGMENT_END_CODE")]
    public const int GLIBTOP_PROC_SEGMENT_END_CODE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SEGMENT_SHLIB_RSS")]
    public const int GLIBTOP_PROC_SEGMENT_SHLIB_RSS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SEGMENT_STACK_RSS")]
    public const int GLIBTOP_PROC_SEGMENT_STACK_RSS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SEGMENT_START_CODE")]
    public const int GLIBTOP_PROC_SEGMENT_START_CODE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SEGMENT_START_STACK")]
    public const int GLIBTOP_PROC_SEGMENT_START_STACK;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SEGMENT_TEXT_RSS")]
    public const int GLIBTOP_PROC_SEGMENT_TEXT_RSS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SIGNAL_BLOCKED")]
    public const int GLIBTOP_PROC_SIGNAL_BLOCKED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SIGNAL_SIGCATCH")]
    public const int GLIBTOP_PROC_SIGNAL_SIGCATCH;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SIGNAL_SIGIGNORE")]
    public const int GLIBTOP_PROC_SIGNAL_SIGIGNORE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_SIGNAL_SIGNAL")]
    public const int GLIBTOP_PROC_SIGNAL_SIGNAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_CMD")]
    public const int GLIBTOP_PROC_STATE_CMD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_GID")]
    public const int GLIBTOP_PROC_STATE_GID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_HAS_CPU")]
    public const int GLIBTOP_PROC_STATE_HAS_CPU;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_LAST_PROCESSOR")]
    public const int GLIBTOP_PROC_STATE_LAST_PROCESSOR;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_PROCESSOR")]
    public const int GLIBTOP_PROC_STATE_PROCESSOR;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_RGID")]
    public const int GLIBTOP_PROC_STATE_RGID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_RUID")]
    public const int GLIBTOP_PROC_STATE_RUID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_STATE")]
    public const int GLIBTOP_PROC_STATE_STATE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_STATE_UID")]
    public const int GLIBTOP_PROC_STATE_UID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_CSTIME")]
    public const int GLIBTOP_PROC_TIME_CSTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_CUTIME")]
    public const int GLIBTOP_PROC_TIME_CUTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_FREQUENCY")]
    public const int GLIBTOP_PROC_TIME_FREQUENCY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_IT_REAL_VALUE")]
    public const int GLIBTOP_PROC_TIME_IT_REAL_VALUE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_RTIME")]
    public const int GLIBTOP_PROC_TIME_RTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_START_TIME")]
    public const int GLIBTOP_PROC_TIME_START_TIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_STIME")]
    public const int GLIBTOP_PROC_TIME_STIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_TIMEOUT")]
    public const int GLIBTOP_PROC_TIME_TIMEOUT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_UTIME")]
    public const int GLIBTOP_PROC_TIME_UTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_XCPU_STIME")]
    public const int GLIBTOP_PROC_TIME_XCPU_STIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_TIME_XCPU_UTIME")]
    public const int GLIBTOP_PROC_TIME_XCPU_UTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_EGID")]
    public const int GLIBTOP_PROC_UID_EGID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_EUID")]
    public const int GLIBTOP_PROC_UID_EUID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_FSGID")]
    public const int GLIBTOP_PROC_UID_FSGID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_FSUID")]
    public const int GLIBTOP_PROC_UID_FSUID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_GID")]
    public const int GLIBTOP_PROC_UID_GID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_GROUPS")]
    public const int GLIBTOP_PROC_UID_GROUPS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_NGROUPS")]
    public const int GLIBTOP_PROC_UID_NGROUPS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_NICE")]
    public const int GLIBTOP_PROC_UID_NICE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_PGRP")]
    public const int GLIBTOP_PROC_UID_PGRP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_PID")]
    public const int GLIBTOP_PROC_UID_PID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_PPID")]
    public const int GLIBTOP_PROC_UID_PPID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_PRIORITY")]
    public const int GLIBTOP_PROC_UID_PRIORITY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_SESSION")]
    public const int GLIBTOP_PROC_UID_SESSION;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_SGID")]
    public const int GLIBTOP_PROC_UID_SGID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_SUID")]
    public const int GLIBTOP_PROC_UID_SUID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_TPGID")]
    public const int GLIBTOP_PROC_UID_TPGID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_TTY")]
    public const int GLIBTOP_PROC_UID_TTY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_UID_UID")]
    public const int GLIBTOP_PROC_UID_UID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_WD_EXE")]
    public const int GLIBTOP_PROC_WD_EXE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_WD_EXE_LEN")]
    public const int GLIBTOP_PROC_WD_EXE_LEN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_WD_MAX")]
    public const int GLIBTOP_PROC_WD_MAX;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_WD_NUMBER")]
    public const int GLIBTOP_PROC_WD_NUMBER;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_WD_ROOT")]
    public const int GLIBTOP_PROC_WD_ROOT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_PROC_WD_ROOT_LEN")]
    public const int GLIBTOP_PROC_WD_ROOT_LEN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SWAP_FREE")]
    public const int GLIBTOP_SWAP_FREE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SWAP_PAGEIN")]
    public const int GLIBTOP_SWAP_PAGEIN;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SWAP_PAGEOUT")]
    public const int GLIBTOP_SWAP_PAGEOUT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SWAP_TOTAL")]
    public const int GLIBTOP_SWAP_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SWAP_USED")]
    public const int GLIBTOP_SWAP_USED;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_ALL")]
    public const int GLIBTOP_SYSDEPS_ALL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_CPU")]
    public const int GLIBTOP_SYSDEPS_CPU;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_FEATURES")]
    public const int GLIBTOP_SYSDEPS_FEATURES;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_FSUSAGE")]
    public const int GLIBTOP_SYSDEPS_FSUSAGE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_LOADAVG")]
    public const int GLIBTOP_SYSDEPS_LOADAVG;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_MEM")]
    public const int GLIBTOP_SYSDEPS_MEM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_MOUNTLIST")]
    public const int GLIBTOP_SYSDEPS_MOUNTLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_MSG_LIMITS")]
    public const int GLIBTOP_SYSDEPS_MSG_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_NETLIST")]
    public const int GLIBTOP_SYSDEPS_NETLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_NETLOAD")]
    public const int GLIBTOP_SYSDEPS_NETLOAD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PPP")]
    public const int GLIBTOP_SYSDEPS_PPP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROCLIST")]
    public const int GLIBTOP_SYSDEPS_PROCLIST;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_AFFINITY")]
    public const int GLIBTOP_SYSDEPS_PROC_AFFINITY;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_ARGS")]
    public const int GLIBTOP_SYSDEPS_PROC_ARGS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_KERNEL")]
    public const int GLIBTOP_SYSDEPS_PROC_KERNEL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_MAP")]
    public const int GLIBTOP_SYSDEPS_PROC_MAP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_MEM")]
    public const int GLIBTOP_SYSDEPS_PROC_MEM;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_OPEN_FILES")]
    public const int GLIBTOP_SYSDEPS_PROC_OPEN_FILES;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_SEGMENT")]
    public const int GLIBTOP_SYSDEPS_PROC_SEGMENT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_SIGNAL")]
    public const int GLIBTOP_SYSDEPS_PROC_SIGNAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_STATE")]
    public const int GLIBTOP_SYSDEPS_PROC_STATE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_TIME")]
    public const int GLIBTOP_SYSDEPS_PROC_TIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_UID")]
    public const int GLIBTOP_SYSDEPS_PROC_UID;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_PROC_WD")]
    public const int GLIBTOP_SYSDEPS_PROC_WD;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_SEM_LIMITS")]
    public const int GLIBTOP_SYSDEPS_SEM_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_SHM_LIMITS")]
    public const int GLIBTOP_SYSDEPS_SHM_LIMITS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_SWAP")]
    public const int GLIBTOP_SYSDEPS_SWAP;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSDEPS_UPTIME")]
    public const int GLIBTOP_SYSDEPS_UPTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSINFO_CPUINFO")]
    public const int GLIBTOP_SYSINFO_CPUINFO;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_SYSINFO_NCPU")]
    public const int GLIBTOP_SYSINFO_NCPU;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_UPTIME_BOOT_TIME")]
    public const int GLIBTOP_UPTIME_BOOT_TIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_UPTIME_IDLETIME")]
    public const int GLIBTOP_UPTIME_IDLETIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_UPTIME_UPTIME")]
    public const int GLIBTOP_UPTIME_UPTIME;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_FLAGS")]
    public const int GLIBTOP_XCPU_FLAGS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_IDLE")]
    public const int GLIBTOP_XCPU_IDLE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_IOWAIT")]
    public const int GLIBTOP_XCPU_IOWAIT;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_IRQ")]
    public const int GLIBTOP_XCPU_IRQ;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_NICE")]
    public const int GLIBTOP_XCPU_NICE;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_SOFTIRQ")]
    public const int GLIBTOP_XCPU_SOFTIRQ;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_SYS")]
    public const int GLIBTOP_XCPU_SYS;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_TOTAL")]
    public const int GLIBTOP_XCPU_TOTAL;
    [CCode (cheader_filename = "glibtop.h", cname = "GLIBTOP_XCPU_USER")]
    public const int GLIBTOP_XCPU_USER;
    [CCode (cheader_filename = "glibtop.h", cname = "HOSTNAMSZ")]
    public const int HOSTNAMSZ;
    [CCode (cheader_filename = "glibtop.h", cname = "LIBGTOP_VERSION_STRING")]
    public const string LIBGTOP_VERSION_STRING;
    [CCode (cheader_filename = "glibtop.h", cname = "MCOOKIE_NAME")]
    public const string MCOOKIE_NAME;
    [CCode (cheader_filename = "glibtop.h", cname = "MCOOKIE_SCREEN")]
    public const string MCOOKIE_SCREEN;
    [CCode (cheader_filename = "glibtop.h", cname = "MCOOKIE_X_NAME")]
    public const string MCOOKIE_X_NAME;
    [CCode (cheader_filename = "glibtop.h", cname = "PATCHLEVEL")]
    public const int PATCHLEVEL;
    [CCode (cheader_filename = "glibtop.h", cname = "REPLYSIZ")]
    public const int REPLYSIZ;
    [CCode (cheader_filename = "glibtop.h", cname = "TABLE_SIZE")]
    public const int TABLE_SIZE;
    [CCode (cheader_filename = "glibtop.h", cname = "TRUE")]
    public const int TRUE;

    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_close")]
    public static void close ();
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_cpu")]
    public static void get_cpu (out GTop.Cpu buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_fsusage")]
    public static void get_fsusage (out GTop.FsUsage buf, string mount_dir);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_loadavg")]
    public static void get_loadavg (out GTop.LoadAvg buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_mem")]
    public static void get_mem (out GTop.Memory buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_msg_limits")]
    public static void get_msg_limits (out GTop.MsgLimits buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_netload")]
    public static void get_netload (out GTop.NetLoad buf, string @interface);
    [CCode (cheader_filename = "glibtop/netlist.h", cname = "glibtop_get_netlist", array_length = false, array_null_terminated = true)]
    public static string[] get_netlist (out GTop.NetList buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_ppp")]
    public static void get_ppp (out GTop.Ppp buf, ushort device);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_affinity")]
    public static uint16 get_proc_affinity (out GTop.ProcAffinity buf, int pid);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_args")]
    public static string get_proc_args (out GTop.ProcArgs buf, int pid, uint max_len);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_argv")]
    public static string get_proc_argv (out GTop.ProcArgs buf, int pid, uint max_len);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_kernel")]
    public static void get_proc_kernel (out GTop.ProcKernel buf, int pid);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_mem")]
    public static void get_proc_mem (out GTop.ProcMem buf, int pid);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_segment")]
    public static void get_proc_segment (out GTop.ProcSegment buf, int pid);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_signal")]
    public static void get_proc_signal (out GTop.ProcSignal buf, int pid);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_state")]
    public static void get_proc_state (out GTop.ProcState buf, int pid);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_time")]
    public static void get_proc_time (out GTop.ProcTime buf, int pid);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proc_uid")]
    public static void get_proc_uid (out GTop.ProcUid buf, int pid);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_proclist", array_length = false, array_null_terminated = false)]
    public static int[] get_proclist (out GTop.ProcList buf, int64 which, int64 arg);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_sem_limits")]
    public static void get_sem_limits (out GTop.SemLimits buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_shm_limits")]
    public static void get_shm_limits (out GTop.ShmLimits buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_swap")]
    public static void get_swap (out GTop.Swap buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_sysdeps")]
    public static void get_sysdeps (out GTop.SysDeps buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_sysinfo")]
    public static unowned GTop.SysInfo? glibtop_get_sysinfo ();
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_get_uptime")]
    public static void get_uptime (out GTop.Uptime buf);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_internet_addr")]
    public static long internet_addr (string host);
    [CCode (cheader_filename = "glibtop.h", cname = "glibtop_make_connection")]
    public static int make_connection (string hostarg, int portarg, int s);
}