// Copyright (c) 2021 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//
// $hash=a93d5c00c274d3bcaa5eebe371e105b2f3f8dd62$
//

#ifndef CEF_INCLUDE_CAPI_CEF_MEDIA_ACCESS_HANDLER_CAPI_H_
#define CEF_INCLUDE_CAPI_CEF_MEDIA_ACCESS_HANDLER_CAPI_H_
#pragma once

#include "include/capi/cef_base_capi.h"
#include "include/capi/cef_browser_capi.h"

#ifdef __cplusplus
extern "C" {
#endif

///
// Callback structure used for asynchronous continuation of media access
// permission requests.
///
typedef struct _cef_media_access_callback_t {
  ///
  // Base structure.
  ///
  cef_base_ref_counted_t base;

  ///
  // Call to allow or deny media access. If this callback was initiated in
  // response to a getUserMedia (indicated by
  // CEF_MEDIA_PERMISSION_DEVICE_AUDIO_CAPTURE and/or
  // CEF_MEDIA_PERMISSION_DEVICE_VIDEO_CAPTURE being set) the
  // |allowed_permissions| are required to match those given in
  // |required_permissions| in the OnRequestMediaAccessPermission.
  ///
  void(CEF_CALLBACK* cont)(struct _cef_media_access_callback_t* self,
                           int allowed_permissions);

  ///
  // Cancel the media access request.
  ///
  void(CEF_CALLBACK* cancel)(struct _cef_media_access_callback_t* self);
} cef_media_access_callback_t;

///
// Implement this structure to handle events related to media access permission
// requests. The functions of this structure will be called on the browser
// process UI thread.
///
typedef struct _cef_media_access_handler_t {
  ///
  // Base structure.
  ///
  cef_base_ref_counted_t base;

  ///
  // Called when a page requests permission to access media. |requesting_url| is
  // the URL requesting permission. Return true (1) and call
  // cef_media_access_callback_t::cont() either in this function or at a later
  // time to continue or cancel the request. Return false (0) to cancel the
  // request immediately.
  ///
  int(CEF_CALLBACK* on_request_media_access_permission)(
      struct _cef_media_access_handler_t* self,
      struct _cef_browser_t* browser,
      struct _cef_frame_t* frame,
      const cef_string_t* requesting_url,
      int32_t requested_permissions,
      struct _cef_media_access_callback_t* callback);
} cef_media_access_handler_t;

#ifdef __cplusplus
}
#endif

#endif  // CEF_INCLUDE_CAPI_CEF_MEDIA_ACCESS_HANDLER_CAPI_H_
