/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RequeryDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.io.AbstractChannelInterestRead;
import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UpdateSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.DualIterator;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntWrapper;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.util.URLDecoder;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.version.UpdateInformation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadManager
implements BandwidthTracker {
    private static final Log LOG = LogFactory.getLog(DownloadManager.class);
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private DownloadCallback callback;
    private DownloadCallback innetworkCallback;
    private MessageRouter router;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
    private List active = new LinkedList();
    private List waiting = new LinkedList();
    private volatile boolean guiInit = false;
    private int innetworkCount = 0;
    private final Map UDP_FAILOVER = new TreeMap(new GUID.GUIDByteComparator());
    private final ProcessingQueue FAILOVERS = new ProcessingQueue("udp failovers");
    private static long UDP_PUSH_FAILTIME = 5000L;
    public static long TIME_BETWEEN_REQUERIES = 2700000L;
    private long lastRequeryTime = 0L;
    private List querySentMDs = new ArrayList();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile float lastMeasuredBandwidth;
    private Runnable _waitingPump;

    public void initialize() {
        this.initialize(RouterService.getCallback(), RouterService.getMessageRouter(), RouterService.getFileManager());
    }

    protected void initialize(DownloadCallback guiCallback, MessageRouter router, FileManager fileManager) {
        this.callback = guiCallback;
        this.innetworkCallback = new InNetworkCallback();
        this.router = router;
        this.fileManager = fileManager;
        this.scheduleWaitingPump();
    }

    public void postGuiInit() {
        File real = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File backup = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        if (!this.readSnapshot(real)) {
            LOG.debug("Reading real downloads.dat failed");
            if (this.readSnapshot(backup)) {
                LOG.debug("Reading backup downloads.bak succeeded.");
                this.copyBackupToReal();
            } else if (backup.exists() || real.exists()) {
                LOG.debug("Reading both downloads files failed.");
                MessageService.showError("DOWNLOAD_COULD_NOT_READ_SNAPSHOT");
            }
        } else {
            LOG.debug("Reading downloads.dat worked!");
        }
        Runnable checkpointer = new Runnable(){

            public void run() {
                if (DownloadManager.this.downloadsInProgress() > 0 && !DownloadManager.this.writeSnapshot()) {
                    DownloadManager.this.copyBackupToReal();
                }
            }
        };
        RouterService.schedule(checkpointer, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME);
        this.guiInit = true;
    }

    public boolean isGUIInitd() {
        return this.guiInit;
    }

    public synchronized boolean hasInNetworkDownload() {
        if (this.innetworkCount > 0) {
            return true;
        }
        Iterator i = this.waiting.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof InNetworkDownloader)) continue;
            return true;
        }
        return false;
    }

    public synchronized void killDownloadersNotListed(Collection updates) {
        if (updates == null) {
            return;
        }
        HashSet<String> urns = new HashSet<String>(updates.size());
        DualIterator iter = updates.iterator();
        while (iter.hasNext()) {
            UpdateInformation ui = (UpdateInformation)iter.next();
            urns.add(ui.getUpdateURN().httpStringValue());
        }
        iter = new DualIterator(this.waiting.iterator(), this.active.iterator());
        while (iter.hasNext()) {
            Downloader d = (Downloader)iter.next();
            if (!(d instanceof InNetworkDownloader) || urns.contains(d.getSHA1Urn().httpStringValue())) continue;
            d.stop();
        }
        Set hopeless = UpdateSettings.FAILED_UPDATES.getValue();
        hopeless.retainAll(urns);
        UpdateSettings.FAILED_UPDATES.setValue(hopeless);
    }

    public void scheduleWaitingPump() {
        if (this._waitingPump != null) {
            return;
        }
        this._waitingPump = new Runnable(){

            public void run() {
                DownloadManager.this.pumpDownloads();
            }
        };
        RouterService.schedule(this._waitingPump, 1000L, 1000L);
    }

    private synchronized void pumpDownloads() {
        int index = 1;
        Iterator i = this.waiting.iterator();
        while (i.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)i.next();
            if (md.isAlive()) continue;
            if (md.isCancelled() || md.isCompleted()) {
                i.remove();
                this.cleanupCompletedDownload(md, false);
                continue;
            }
            if (this.hasFreeSlot() && (md.hasNewSources() || md.getRemainingStateTime() <= 0)) {
                i.remove();
                if (md instanceof InNetworkDownloader) {
                    ++this.innetworkCount;
                }
                this.active.add(md);
                md.startDownload();
                continue;
            }
            if (!md.isPaused()) {
                md.setInactivePriority(index++);
            }
            md.handleInactivity();
        }
    }

    private synchronized void copyBackupToReal() {
        File real = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File backup = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        real.delete();
        CommonUtils.copy(backup, real);
    }

    public boolean isIncomplete(URN urn) {
        return this.incompleteFileManager.getFileForUrn(urn) != null;
    }

    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    public synchronized int getNumIndividualDownloaders() {
        int ret = 0;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)iter.next();
            ret += md.getNumDownloaders();
        }
        return ret;
    }

    public synchronized int getNumActiveDownloads() {
        return this.active.size() - this.innetworkCount;
    }

    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedDownloader getDownloaderForURN(URN sha1) {
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            ManagedDownloader current;
            Iterator iter = this.active.iterator();
            while (iter.hasNext()) {
                current = (ManagedDownloader)iter.next();
                if (current.getSHA1Urn() == null || !sha1.equals(current.getSHA1Urn())) continue;
                return current;
            }
            iter = this.waiting.iterator();
            while (iter.hasNext()) {
                current = (ManagedDownloader)iter.next();
                if (current.getSHA1Urn() == null || !sha1.equals(current.getSHA1Urn())) continue;
                return current;
            }
        }
        return null;
    }

    public synchronized boolean isGuidForQueryDownloading(GUID guid) {
        GUID dGUID;
        Iterator iter = this.active.iterator();
        while (iter.hasNext()) {
            dGUID = ((ManagedDownloader)iter.next()).getQueryGUID();
            if (dGUID == null || !dGUID.equals(guid)) continue;
            return true;
        }
        iter = this.waiting.iterator();
        while (iter.hasNext()) {
            dGUID = ((ManagedDownloader)iter.next()).getQueryGUID();
            if (dGUID == null || !dGUID.equals(guid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllDownloads() {
        ArrayList buf;
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            buf = new ArrayList(this.active.size() + this.waiting.size());
            buf.addAll(this.active);
            buf.addAll(this.waiting);
            this.active.clear();
            this.waiting.clear();
        }
        Iterator i = buf.iterator();
        while (i.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)i.next();
            md.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeSnapshot() {
        boolean incompleteFileManager;
        ArrayList buf;
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            buf = new ArrayList(this.active.size() + this.waiting.size());
            buf.addAll(this.active);
            buf.addAll(this.waiting);
        }
        File outFile = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue().delete();
        outFile.renameTo(SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue());
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue())));
                out.writeObject(buf);
                IncompleteFileManager incompleteFileManager2 = this.incompleteFileManager;
                synchronized (incompleteFileManager2) {
                    out.writeObject(this.incompleteFileManager);
                }
                out.flush();
                incompleteFileManager = true;
                Object var7_7 = null;
                if (out == null) return incompleteFileManager;
            }
            catch (IOException e) {
                boolean bl = false;
                Object var7_8 = null;
                if (out == null) return bl;
                try {
                    out.close();
                    return bl;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (out == null) throw throwable;
            try {}
            catch (IOException ignored) {
                throw throwable;
            }
            out.close();
            throw throwable;
        }
        try {}
        catch (IOException ignored) {
            // empty catch block
            return incompleteFileManager;
        }
        out.close();
        return incompleteFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean readSnapshot(File file) {
        boolean iter22;
        LinkedList buf = null;
        try {
            ConverterObjectInputStream in = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            buf = (LinkedList)in.readObject();
            this.incompleteFileManager = (IncompleteFileManager)in.readObject();
        }
        catch (Throwable t) {
            LOG.error("Unable to read download file", t);
            return false;
        }
        buf = new LinkedList(new HashSet(buf));
        try {
            Iterator iter22 = buf.iterator();
            while (iter22.hasNext()) {
                ManagedDownloader downloader = (ManagedDownloader)iter22.next();
                DownloadCallback dc = this.callback;
                if (downloader instanceof RequeryDownloader) continue;
                this.waiting.add(downloader);
                downloader.initialize(this, this.fileManager, this.callback(downloader));
                this.callback(downloader).addDownload(downloader);
            }
            iter22 = true;
            Object var7_10 = null;
        }
        catch (ClassCastException e) {
            boolean bl;
            block8: {
                try {
                    bl = false;
                    Object var7_11 = null;
                    if (!this.incompleteFileManager.initialPurge(DownloadManager.getActiveDownloadFiles(buf))) break block8;
                    this.writeSnapshot();
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var7_12 = null;
                        if (!this.incompleteFileManager.initialPurge(DownloadManager.getActiveDownloadFiles(buf))) break block9;
                        this.writeSnapshot();
                    }
                    throw throwable;
                }
            }
            return bl;
        }
        if (this.incompleteFileManager.initialPurge(DownloadManager.getActiveDownloadFiles(buf))) {
            this.writeSnapshot();
        }
        return iter22;
    }

    private static Collection getActiveDownloadFiles(List downloaders) {
        ArrayList<File> ret = new ArrayList<File>(downloaders.size());
        Iterator iter = downloaders.iterator();
        while (iter.hasNext()) {
            Downloader d = (Downloader)iter.next();
            File f = d.getFile();
            if (f == null) continue;
            try {
                ret.add(FileUtils.getCanonicalFile(f));
            }
            catch (IOException iox) {
                ret.add(f.getAbsoluteFile());
            }
        }
        return ret;
    }

    public synchronized Downloader download(RemoteFileDesc[] files, List alts, GUID queryGUID, boolean overwrite, File saveDir, String fileName) throws SaveLocationException {
        String fName = this.getFileName(files, fileName);
        if (this.conflicts(files, fName)) {
            throw new SaveLocationException(10, new File(fName != null ? fName : ""));
        }
        this.incompleteFileManager.purge();
        ManagedDownloader downloader = new ManagedDownloader(files, this.incompleteFileManager, queryGUID, saveDir, fileName, overwrite);
        this.initializeDownload(downloader);
        downloader.addDownload(alts, false);
        return downloader;
    }

    public synchronized Downloader download(MagnetOptions magnet, boolean overwrite, File saveDir, String fileName) throws IllegalArgumentException, SaveLocationException {
        if (!magnet.isDownloadable()) {
            throw new IllegalArgumentException("magnet not downloadable");
        }
        this.incompleteFileManager.purge();
        if (fileName == null) {
            fileName = magnet.getFileNameForSaving();
        }
        if (this.conflicts(magnet.getSHA1Urn(), fileName, 0)) {
            throw new SaveLocationException(10, new File(fileName));
        }
        MagnetDownloader downloader = new MagnetDownloader(this.incompleteFileManager, magnet, overwrite, saveDir, fileName);
        this.initializeDownload(downloader);
        return downloader;
    }

    public synchronized Downloader download(File incompleteFile) throws CantResumeException, SaveLocationException {
        if (this.conflictsWithIncompleteFile(incompleteFile)) {
            throw new SaveLocationException(10, incompleteFile);
        }
        this.incompleteFileManager.purge();
        ResumeDownloader downloader = null;
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
            String name = IncompleteFileManager.getCompletedName(incompleteFile);
            int size = ByteOrder.long2int(IncompleteFileManager.getCompletedSize(incompleteFile));
            downloader = new ResumeDownloader(this.incompleteFileManager, incompleteFile, name, size);
        }
        catch (IllegalArgumentException e) {
            throw new CantResumeException(incompleteFile.getName());
        }
        catch (IOException ioe) {
            throw new CantResumeException(incompleteFile.getName());
        }
        this.initializeDownload(downloader);
        return downloader;
    }

    public synchronized Downloader download(DownloadInformation info, long now) throws SaveLocationException {
        File dir = FileManager.PREFERENCE_SHARE;
        dir.mkdirs();
        File f = new File(dir, info.getUpdateFileName());
        if (this.conflicts(info.getUpdateURN(), info.getUpdateFileName(), (int)info.getSize())) {
            throw new SaveLocationException(10, f);
        }
        this.incompleteFileManager.purge();
        InNetworkDownloader d = new InNetworkDownloader(this.incompleteFileManager, info, dir, now);
        this.initializeDownload(d);
        return d;
    }

    private void initializeDownload(ManagedDownloader md) {
        md.initialize(this, this.fileManager, this.callback(md));
        this.waiting.add(md);
        this.callback(md).addDownload(md);
        RouterService.schedule(new Runnable(){

            public void run() {
                DownloadManager.this.writeSnapshot();
            }
        }, 0L, 0L);
    }

    private DownloadCallback callback(ManagedDownloader md) {
        return md instanceof InNetworkDownloader ? this.innetworkCallback : this.callback;
    }

    private boolean conflicts(RemoteFileDesc[] rfds, String fileName) {
        URN urn = null;
        for (int i = 0; i < rfds.length && urn == null; ++i) {
            urn = rfds[0].getSHA1Urn();
        }
        return this.conflicts(urn, fileName, rfds[0].getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conflicts(URN urn, String fileName, int fileSize) {
        if (urn == null && fileSize == 0) {
            return false;
        }
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            return this.conflicts(this.active.iterator(), urn, fileName, fileSize) || this.conflicts(this.waiting.iterator(), urn, fileName, fileSize);
        }
    }

    private boolean conflicts(Iterator i, URN urn, String fileName, int fileSize) {
        while (i.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)i.next();
            if (!md.conflicts(urn, fileName, fileSize)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isSaveLocationTaken(File candidateFile) {
        return this.isSaveLocationTaken(this.active.iterator(), candidateFile) || this.isSaveLocationTaken(this.waiting.iterator(), candidateFile);
    }

    private boolean isSaveLocationTaken(Iterator i, File candidateFile) {
        while (i.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)i.next();
            if (!candidateFile.equals(md.getSaveFile())) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean conflictsWithIncompleteFile(File incompleteFile) {
        return this.conflictsWithIncompleteFile(this.active.iterator(), incompleteFile) || this.conflictsWithIncompleteFile(this.waiting.iterator(), incompleteFile);
    }

    private boolean conflictsWithIncompleteFile(Iterator i, File incompleteFile) {
        while (i.hasNext()) {
            ManagedDownloader md = (ManagedDownloader)i.next();
            if (!md.conflictsWithIncompleteFile(incompleteFile)) continue;
            return true;
        }
        return false;
    }

    public void handleQueryReply(QueryReply qr) {
        HostData data;
        List responses;
        if (qr.calculateQualityOfService(!RouterService.acceptedIncomingConnection()) < 1) {
            return;
        }
        try {
            responses = qr.getResultsAsList();
            data = qr.getHostData();
        }
        catch (BadPacketException bpe) {
            return;
        }
        this.addDownloadWithResponses(responses, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloadWithResponses(List responses, HostData data) {
        if (responses == null) {
            throw new NullPointerException("null responses");
        }
        if (data == null) {
            throw new NullPointerException("null hostdata");
        }
        ArrayList downloaders = new ArrayList(this.active.size() + this.waiting.size());
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            downloaders.addAll(this.active);
            downloaders.addAll(this.waiting);
        }
        if (downloaders.isEmpty()) {
            return;
        }
        Iterator i = responses.iterator();
        block3: while (i.hasNext()) {
            Response r = (Response)i.next();
            RemoteFileDesc rfd = r.toRemoteFileDesc(data);
            Iterator j = downloaders.iterator();
            while (j.hasNext()) {
                ManagedDownloader currD = (ManagedDownloader)j.next();
                if (!currD.addDownload(rfd, true)) continue;
                Set alts = r.getLocations();
                Iterator k = alts.iterator();
                while (k.hasNext()) {
                    Endpoint ep = (Endpoint)k.next();
                    currD.addDownload(new RemoteFileDesc(rfd, ep), false);
                }
                continue block3;
            }
        }
    }

    public void acceptDownload(Socket socket) {
        ((NIOMultiplexor)((Object)socket)).setReadObserver(new GivParser(socket));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGIV(Socket socket, GIVLine line) {
        String file = line.file;
        int index = 0;
        byte[] clientGUID = line.clientGUID;
        this.cancelUDPFailover(clientGUID);
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            ManagedDownloader md;
            if (BrowseHostHandler.handlePush(index, new GUID(clientGUID), socket)) {
                return;
            }
            Iterator iter = this.active.iterator();
            while (iter.hasNext()) {
                md = (ManagedDownloader)iter.next();
                if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                return;
            }
            iter = this.waiting.iterator();
            while (iter.hasNext()) {
                md = (ManagedDownloader)iter.next();
                if (!md.acceptDownload(file, socket, index, clientGUID)) continue;
                return;
            }
        }
        IOUtils.close(socket);
    }

    private boolean hasFreeSlot() {
        return this.active.size() - this.innetworkCount < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    public synchronized void remove(ManagedDownloader downloader, boolean completed) {
        this.active.remove(downloader);
        if (downloader instanceof InNetworkDownloader) {
            --this.innetworkCount;
        }
        this.waiting.remove(downloader);
        if (completed) {
            this.cleanupCompletedDownload(downloader, true);
        } else {
            this.waiting.add(downloader);
        }
    }

    public synchronized void bumpPriority(Downloader downloader, boolean up, int amt) {
        int idx = this.waiting.indexOf(downloader);
        if (idx == -1) {
            return;
        }
        if (up && idx != 0) {
            this.waiting.remove(idx);
            if (amt > idx) {
                amt = idx;
            }
            if (amt != 0) {
                this.waiting.add(idx - amt, downloader);
            } else {
                this.waiting.add(0, downloader);
            }
        } else if (!up && idx != this.waiting.size() - 1) {
            this.waiting.remove(idx);
            if (amt != 0) {
                if ((amt += idx) > this.waiting.size()) {
                    amt = this.waiting.size();
                }
                this.waiting.add(amt, downloader);
            } else {
                this.waiting.add(downloader);
            }
        }
    }

    private void cleanupCompletedDownload(ManagedDownloader dl, boolean ser) {
        this.querySentMDs.remove(dl);
        dl.finish();
        if (dl.getQueryGUID() != null) {
            this.router.downloadFinished(dl.getQueryGUID());
        }
        this.callback(dl).removeDownload(dl);
        if (ser) {
            this.writeSnapshot();
        }
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback(dl).downloadsComplete();
        }
    }

    public synchronized boolean sendQuery(ManagedDownloader requerier, QueryRequest query) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("DM.sendQuery():" + query.getQuery());
        }
        Assert.that(this.waiting.contains(requerier), "Unknown or non-waiting MD trying to send requery.");
        boolean isRequery = GUID.isLimeRequeryGUID(query.getGUID());
        long elapsed = System.currentTimeMillis() - this.lastRequeryTime;
        if (isRequery && elapsed <= TIME_BETWEEN_REQUERIES) {
            return false;
        }
        if (this.querySentMDs.size() >= this.waiting.size()) {
            LOG.trace("DM.sendQuery(): reseting query sent queue");
            this.querySentMDs.clear();
        }
        if (this.querySentMDs.contains(requerier)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("DM.sendQuery(): out of turn:" + query.getQuery());
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("DM.sendQuery(): requery allowed:" + query.getQuery());
        }
        this.querySentMDs.add(requerier);
        this.lastRequeryTime = System.currentTimeMillis();
        this.router.sendDynamicQuery(query);
        return true;
    }

    private boolean sendPushMulticast(RemoteFileDesc file, byte[] guid) {
        if (file.isReplyToMulticast()) {
            byte[] addr = RouterService.getNonForcedAddress();
            int port = RouterService.getNonForcedPort();
            if (NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port)) {
                PushRequest pr = new PushRequest(guid, 1, file.getClientGUID(), file.getIndex(), addr, port, 3);
                this.router.sendMulticastPushRequest(pr);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Sending push request through multicast " + pr);
                }
                return true;
            }
        }
        return false;
    }

    private boolean sendPushUDP(RemoteFileDesc file, byte[] guid) {
        PushRequest pr = new PushRequest(guid, 2, file.getClientGUID(), file.getIndex(), RouterService.getAddress(), RouterService.getPort(), 2);
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through udp " + pr);
        }
        UDPService udpService = UDPService.instance();
        try {
            InetAddress address = InetAddress.getByName(file.getHost());
            if (NetworkUtils.isValidAddress(address) && NetworkUtils.isValidPort(file.getPort())) {
                udpService.send(pr, address, file.getPort());
            }
        }
        catch (UnknownHostException notCritical) {
            // empty catch block
        }
        IPFilter filter = IPFilter.instance();
        Set proxies = file.getPushProxies();
        Iterator iter = proxies.iterator();
        while (iter.hasNext()) {
            IpPort ppi = (IpPort)iter.next();
            if (!filter.allow(ppi.getAddress())) continue;
            udpService.send(pr, ppi.getInetAddress(), ppi.getPort());
        }
        return true;
    }

    private boolean sendPushTCP(RemoteFileDesc file, byte[] guid) {
        int port;
        boolean shouldDoFWTransfer;
        boolean bl = shouldDoFWTransfer = file.supportsFWTransfer() && UDPService.instance().canDoFWT() && !RouterService.acceptedIncomingConnection();
        if (this.sendPushThroughProxies(file, guid, shouldDoFWTransfer)) {
            return true;
        }
        if (shouldDoFWTransfer && !RouterService.acceptedIncomingConnection()) {
            return false;
        }
        byte[] addr = RouterService.getAddress();
        if (!NetworkUtils.isValidAddressAndPort(addr, port = RouterService.getPort())) {
            return false;
        }
        PushRequest pr = new PushRequest(guid, ConnectionSettings.TTL.getValue(), file.getClientGUID(), file.getIndex(), addr, port);
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through Gnutella: " + pr);
        }
        try {
            this.router.sendPushRequest(pr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPushThroughProxies(RemoteFileDesc file, byte[] guid, boolean shouldDoFWTransfer) {
        Set proxies = file.getPushProxies();
        if (proxies.isEmpty()) {
            return false;
        }
        byte[] externalAddr = RouterService.getExternalAddress();
        if (shouldDoFWTransfer && !NetworkUtils.isValidAddress(externalAddr)) {
            return false;
        }
        byte[] addr = RouterService.getAddress();
        int port = RouterService.getPort();
        String request = "/gnutella/push-proxy?ServerID=" + Base32.encode(file.getClientGUID()) + (shouldDoFWTransfer ? "&file=2147483645" : "");
        String nodeString = "X-Node";
        String nodeValue = NetworkUtils.ip2string(shouldDoFWTransfer ? externalAddr : addr) + ":" + port;
        IPFilter filter = IPFilter.instance();
        Iterator iter = proxies.iterator();
        while (iter.hasNext()) {
            IpPort ppi = (IpPort)iter.next();
            if (!filter.allow(ppi.getAddress())) continue;
            String ppIp = ppi.getAddress();
            int ppPort = ppi.getPort();
            String connectTo = "http://" + ppIp + ":" + ppPort + request;
            HttpClient client = HttpClientManager.getNewClient();
            HeadMethod head = new HeadMethod(connectTo);
            head.addRequestHeader("X-Node", nodeValue);
            head.addRequestHeader("Cache-Control", "no-cache");
            if (LOG.isTraceEnabled()) {
                LOG.trace("Push Proxy Requesting with: " + connectTo);
            }
            try {
                client.executeMethod(head);
                if (head.getStatusCode() == 202) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Succesful push proxy: " + connectTo);
                    }
                    if (shouldDoFWTransfer) {
                        UDPConnection socket = new UDPConnection();
                        socket.connect(file.getSocketAddress(), 20000, new FWTConnectObserver());
                    }
                    boolean socket = true;
                    return socket;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Invalid push proxy: " + connectTo + ", response: " + head.getStatusCode());
            }
            catch (IOException ioe) {
                LOG.warn("PushProxy request exception", ioe);
            }
            finally {
                if (head == null) continue;
                head.releaseConnection();
            }
        }
        return false;
    }

    public void sendPush(RemoteFileDesc file) {
        this.sendPush(file, null);
    }

    public void sendPush(final RemoteFileDesc file, final Shutdownable observer) {
        byte[] addr = RouterService.getAddress();
        int port = RouterService.getPort();
        if (!NetworkUtils.isValidAddress(addr) || !NetworkUtils.isValidPort(port)) {
            if (observer != null) {
                observer.shutdown();
            }
            return;
        }
        final byte[] guid = GUID.makeGuid();
        if (this.sendPushMulticast(file, guid)) {
            return;
        }
        if (!RouterService.acceptedIncomingConnection()) {
            if (UDPService.instance().canDoFWT()) {
                ThreadFactory.startThread(new PushRequestor(file, guid, observer), "FWT PushRequestor");
            } else if (observer != null) {
                observer.shutdown();
            }
            return;
        }
        if (!file.isFromAlternateLocation()) {
            this.addUDPFailover(file);
            RouterService.schedule(new Runnable(){

                public void run() {
                    DownloadManager.this.FAILOVERS.add(new PushFailoverRequestor(file, guid, observer));
                }
            }, UDP_PUSH_FAILTIME, 0L);
        }
        this.sendPushUDP(file, guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUDPFailover(RemoteFileDesc file) {
        Map map = this.UDP_FAILOVER;
        synchronized (map) {
            byte[] key = file.getClientGUID();
            IntWrapper requests = (IntWrapper)this.UDP_FAILOVER.get(key);
            if (requests == null) {
                requests = new IntWrapper(0);
                this.UDP_FAILOVER.put(key, requests);
            }
            requests.addInt(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUDPFailover(byte[] clientGUID) {
        Map map = this.UDP_FAILOVER;
        synchronized (map) {
            byte[] key = clientGUID;
            IntWrapper requests = (IntWrapper)this.UDP_FAILOVER.get(key);
            if (requests != null) {
                requests.addInt(-1);
                if (requests.getInt() <= 0) {
                    this.UDP_FAILOVER.remove(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        ArrayList activeCopy;
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            activeCopy = new ArrayList(this.active);
        }
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = activeCopy.iterator();
        while (iter.hasNext()) {
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            if (bt instanceof InNetworkDownloader) continue;
            c = true;
            bt.measureBandwidth();
            currentTotal += bt.getAverageBandwidth();
        }
        if (c) {
            DownloadManager downloadManager2 = this;
            synchronized (downloadManager2) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMeasuredBandwidth() {
        ArrayList activeCopy;
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            activeCopy = new ArrayList(this.active);
        }
        float sum = 0.0f;
        Iterator iter = activeCopy.iterator();
        while (iter.hasNext()) {
            BandwidthTracker bt = (BandwidthTracker)iter.next();
            if (bt instanceof InNetworkDownloader) continue;
            float curr = 0.0f;
            try {
                curr = bt.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            sum += curr;
        }
        this.lastMeasuredBandwidth = sum;
        return sum;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    public float getLastMeasuredBandwidth() {
        return this.lastMeasuredBandwidth;
    }

    private String getFileName(RemoteFileDesc[] rfds, String fileName) {
        for (int i = 0; i < rfds.length && fileName == null; ++i) {
            fileName = rfds[i].getFileName();
        }
        return fileName;
    }

    private static class FWTConnectObserver
    implements ConnectObserver {
        private FWTConnectObserver() {
        }

        public void handleIOException(IOException iox) {
        }

        public void handleConnect(Socket socket) throws IOException {
            DownloadStat.FW_FW_SUCCESS.incrementStat();
            RouterService.getAcceptor().accept(socket, "GIV");
        }

        public void shutdown() {
            DownloadStat.FW_FW_FAILURE.incrementStat();
        }
    }

    private static class InNetworkCallback
    implements DownloadCallback {
        private InNetworkCallback() {
        }

        public void addDownload(Downloader d) {
        }

        public void removeDownload(Downloader d) {
            InNetworkDownloader downloader = (InNetworkDownloader)d;
            UpdateHandler.instance().inNetworkDownloadFinished(downloader.getSHA1Urn(), downloader.getState() == 4);
        }

        public void downloadsComplete() {
        }

        public void showDownloads() {
        }

        public void promptAboutCorruptDownload(Downloader dloader) {
            dloader.discardCorruptDownload(true);
        }

        public String getHostValue(String key) {
            return null;
        }
    }

    private class PushFailoverRequestor
    extends PushRequestor {
        public PushFailoverRequestor(RemoteFileDesc file, byte[] guid, Shutdownable observer) {
            super(file, guid, observer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean shouldProceed() {
            byte[] key = this._file.getClientGUID();
            Map map = DownloadManager.this.UDP_FAILOVER;
            synchronized (map) {
                IntWrapper requests = (IntWrapper)DownloadManager.this.UDP_FAILOVER.get(key);
                if (requests != null && requests.getInt() > 0) {
                    requests.addInt(-1);
                    if (requests.getInt() == 0) {
                        DownloadManager.this.UDP_FAILOVER.remove(key);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class PushRequestor
    implements Runnable {
        final RemoteFileDesc _file;
        final byte[] _guid;
        final Shutdownable _observer;

        public PushRequestor(RemoteFileDesc file, byte[] guid, Shutdownable observer) {
            this._file = file;
            this._guid = guid;
            this._observer = observer;
        }

        public void run() {
            if (this.shouldProceed() && !DownloadManager.this.sendPushTCP(this._file, this._guid) && this._observer != null) {
                this._observer.shutdown();
            }
        }

        protected boolean shouldProceed() {
            return true;
        }
    }

    private class GivParser
    extends AbstractChannelInterestRead {
        private final Socket socket;
        private final StringBuffer givSB = new StringBuffer();
        private final StringBuffer blankSB = new StringBuffer();
        private boolean readBlank;
        private GIVLine giv;

        GivParser(Socket socket) {
            this.socket = socket;
        }

        protected int getBufferSize() {
            return 1024;
        }

        public void handleRead() throws IOException {
            block6: {
                do {
                    int read = 0;
                    while (this.buffer.hasRemaining() && (read = this.source.read(this.buffer)) > 0) {
                    }
                    if (this.buffer.position() == 0) {
                        if (read != -1) break block6;
                        this.close();
                        break block6;
                    }
                    this.buffer.flip();
                    if (this.giv == null && BufferUtils.readLine(this.buffer, this.givSB)) {
                        this.giv = this.parseLine(this.givSB.toString());
                    }
                    if (this.giv != null && !this.readBlank) {
                        this.readBlank = BufferUtils.readLine(this.buffer, this.blankSB);
                        if (this.blankSB.length() > 0) {
                            throw new IOException("didn't read blank line");
                        }
                    }
                    this.buffer.compact();
                } while (!this.readBlank);
                DownloadManager.this.handleGIV(this.socket, this.giv);
            }
        }

        private GIVLine parseLine(String command) throws IOException {
            try {
                int i = command.indexOf(":");
                int index = Integer.parseInt(command.substring(0, i));
                int j = command.indexOf("/", i);
                byte[] guid = GUID.fromHexString(command.substring(i + 1, j));
                String filename = URLDecoder.decode(command.substring(j + 1));
                return new GIVLine(filename, index, guid);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException();
            }
            catch (NumberFormatException e) {
                throw new IOException();
            }
            catch (IllegalArgumentException e) {
                throw new IOException();
            }
        }
    }

    private static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String file, int index, byte[] clientGUID) {
            this.file = file;
            this.index = index;
            this.clientGUID = clientGUID;
        }
    }
}

