/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.library.LibraryData;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IntSet;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileManager {
    private static final Log LOG = LogFactory.getLog(FileManager.class);
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    public static final File PROGRAM_SHARE;
    public static final File PREFERENCE_SHARE;
    private static final ProcessingQueue LOADER;
    private volatile List eventListeners = Collections.EMPTY_LIST;
    private final Object listenerLock = new Object();
    private final LibraryData _data = new LibraryData();
    private List _files;
    private long _filesSize;
    private int _numFiles;
    private int _numPendingFiles;
    private int _numIncompleteFiles;
    private int _numForcedFiles;
    private Map _fileToFileDescMap;
    private Trie _keywordTrie;
    private Map _urnMap;
    private static Set _extensions;
    private Map _sharedDirectories;
    private Set _completelySharedDirectories;
    private IntSet _incompletesShared;
    private Set _requestingValidation = Collections.synchronizedSet(new HashSet());
    protected volatile int _revision = 0;
    private volatile int _pendingFinished = -1;
    private volatile int _updatingFinished = -1;
    private volatile boolean _isUpdating = false;
    private volatile int _loadingFinished = -1;
    protected volatile boolean shutdown;
    private final FileFilter SHAREABLE_FILE_FILTER = new FileFilter(){

        public boolean accept(File f) {
            return FileManager.this.isFileShareable(f);
        }
    };
    private static final FileFilter DIRECTORY_FILTER;
    private static final FileEventListener EMPTY_CALLBACK;
    protected static QueryRouteTable _queryRouteTable;
    protected static volatile boolean _needRebuild;
    public static final String DELIMITERS = " -._+/*()\\,";
    private static final Response[] EMPTY_RESPONSES;

    private static final boolean isDelimiter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public FileManager() {
        this.resetVariables();
    }

    private void resetVariables() {
        this._filesSize = 0L;
        this._numFiles = 0;
        this._numIncompleteFiles = 0;
        this._numPendingFiles = 0;
        this._numForcedFiles = 0;
        this._files = new ArrayList();
        this._keywordTrie = new Trie(true);
        this._urnMap = new HashMap();
        _extensions = new HashSet();
        this._sharedDirectories = new HashMap();
        this._completelySharedDirectories = new HashSet();
        this._incompletesShared = new IntSet();
        this._fileToFileDescMap = new HashMap();
    }

    public void start() {
        this._data.clean();
        this.cleanIndividualFiles();
        this.loadSettings();
    }

    public void stop() {
        this.save();
        this.shutdown = true;
    }

    protected void save() {
        this._data.save();
        UrnCache.instance().persistCache();
        CreationTimeCache.instance().persistCache();
    }

    public int getSize() {
        return ByteOrder.long2int(this._filesSize);
    }

    public int getNumFiles() {
        return this._numFiles - this._numForcedFiles;
    }

    public int getNumIncompleteFiles() {
        return this._numIncompleteFiles;
    }

    public int getNumPendingFiles() {
        return this._numPendingFiles;
    }

    public int getNumForcedFiles() {
        return this._numForcedFiles;
    }

    public synchronized FileDesc get(int i) {
        return (FileDesc)this._files.get(i);
    }

    public synchronized boolean isValidIndex(int i) {
        return i >= 0 && i < this._files.size();
    }

    public synchronized URN getURNForFile(File f) {
        FileDesc fd = this.getFileDescForFile(f);
        if (fd != null) {
            return fd.getSHA1Urn();
        }
        return null;
    }

    public synchronized FileDesc getFileDescForFile(File f) {
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException ioe) {
            return null;
        }
        return (FileDesc)this._fileToFileDescMap.get(f);
    }

    public synchronized boolean isUrnShared(URN urn) {
        FileDesc fd = this.getFileDescForUrn(urn);
        return fd != null && !(fd instanceof IncompleteFileDesc);
    }

    public synchronized FileDesc getFileDescForUrn(URN urn) {
        IntSet indices = (IntSet)this._urnMap.get(urn);
        if (indices == null) {
            return null;
        }
        IntSet.IntSetIterator iter = indices.iterator();
        FileDesc ret = null;
        while (iter.hasNext() && (ret == null || ret instanceof IncompleteFileDesc)) {
            int index = iter.next();
            ret = (FileDesc)this._files.get(index);
        }
        return ret;
    }

    public synchronized FileDesc[] getIncompleteFileDescriptors() {
        if (this._incompletesShared == null) {
            return null;
        }
        FileDesc[] ret = new FileDesc[this._incompletesShared.size()];
        IntSet.IntSetIterator iter = this._incompletesShared.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileDesc fd = (FileDesc)this._files.get(iter.next());
            Assert.that(fd != null, "Directory has null entry");
            ret[i] = fd;
            ++i;
        }
        return ret;
    }

    public synchronized FileDesc[] getAllSharedFileDescriptors() {
        FileDesc[] fds = new FileDesc[this._fileToFileDescMap.size()];
        fds = this._fileToFileDescMap.values().toArray(fds);
        return fds;
    }

    public synchronized FileDesc[] getSharedFileDescriptors(File directory) {
        if (directory == null) {
            throw new NullPointerException("null directory");
        }
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return new FileDesc[0];
        }
        IntSet indices = (IntSet)this._sharedDirectories.get(directory);
        if (indices == null) {
            return new FileDesc[0];
        }
        FileDesc[] fds = new FileDesc[indices.size()];
        IntSet.IntSetIterator iter = indices.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileDesc fd = (FileDesc)this._files.get(iter.next());
            Assert.that(fd != null, "Directory has null entry");
            fds[i] = fd;
            ++i;
        }
        return fds;
    }

    public void loadSettings() {
        final int currentRevision = ++this._revision;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting new library revision: " + currentRevision);
        }
        LOADER.add(new Runnable(){

            public void run() {
                FileManager.this.loadStarted(currentRevision);
                FileManager.this.loadSettingsInternal(currentRevision);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWithNewDirectories(Set shared) {
        SharingSettings.DIRECTORIES_TO_SHARE.setValue(shared);
        Set set = this._data.DIRECTORIES_NOT_TO_SHARE;
        synchronized (set) {
            Iterator i = shared.iterator();
            while (i.hasNext()) {
                this._data.DIRECTORIES_NOT_TO_SHARE.remove((File)i.next());
            }
        }
        RouterService.getFileManager().loadSettings();
    }

    protected void loadStarted(int revision) {
        UrnCache.instance().clearPendingHashes(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToFinish() {
        int revision;
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._pendingFinished != this._updatingFinished || this._pendingFinished != this._revision || this._loadingFinished >= this._revision) {
                return;
            }
            revision = this._loadingFinished = this._revision;
        }
        this.loadFinished(revision);
    }

    protected void loadFinished(int revision) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished loading revision: " + revision);
        }
        this.trim();
        CreationTimeCache.instance().pruneTimes();
        RouterService.getDownloadManager().getIncompleteFileManager().registerAllIncompleteFiles();
        this.save();
        SavedFileManager.instance().run();
        UpdateHandler.instance().tryToDownloadUpdates();
        RouterService.getCallback().fileManagerLoaded();
    }

    public boolean isLoadFinished() {
        return this._loadingFinished == this._revision;
    }

    public boolean isUpdating() {
        return this._isUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsInternal(int revision) {
        ArrayList list;
        File[] directories;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading Library Revision: " + revision);
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            this.resetVariables();
            String[] extensions = StringUtils.split(SharingSettings.EXTENSIONS_TO_SHARE.getValue(), ";");
            for (int i = 0; i < extensions.length; ++i) {
                _extensions.add(extensions[i].toLowerCase());
            }
            directories = SharingSettings.DIRECTORIES_TO_SHARE.getValueAsArray();
            Arrays.sort(directories, new Comparator(){

                public int compare(Object a, Object b) {
                    return a.toString().length() - b.toString().length();
                }
            });
        }
        RouterService.getCallback().fileManagerLoading();
        this.updateSharedDirectories(PROGRAM_SHARE, null, revision);
        this.updateSharedDirectories(PREFERENCE_SHARE, null, revision);
        this._isUpdating = true;
        for (int i = 0; i < directories.length && this._revision == revision; ++i) {
            this.updateSharedDirectories(directories[i], null, revision);
        }
        Set specialFiles = this._data.SPECIAL_FILES_TO_SHARE;
        Object i = specialFiles;
        synchronized (i) {
            list = new ArrayList(specialFiles);
        }
        i = list.iterator();
        while (i.hasNext() && this._revision == revision) {
            this.addFileIfShared((File)i.next(), Collections.EMPTY_LIST, true, revision, null);
        }
        this._isUpdating = false;
        this.trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished queueing shared files for revision: " + revision);
        }
        this._updatingFinished = revision;
        if (this._numPendingFiles == 0) {
            this._pendingFinished = revision;
        }
        this.tryToFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSharedDirectories(File directory, File parent, int revision) {
        try {
            directory = FileUtils.getCanonicalFile(directory);
        }
        catch (IOException e) {
            return;
        }
        if (directory.equals(SharingSettings.INCOMPLETE_DIRECTORY.getValue())) {
            return;
        }
        if (this._data.DIRECTORIES_NOT_TO_SHARE.contains(directory)) {
            return;
        }
        if (FileManager.isSensitiveDirectory(directory)) {
            if (this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.contains(directory)) {
                return;
            }
            if (this._data.SENSITIVE_DIRECTORIES_VALIDATED.contains(directory) && !RouterService.getCallback().warnAboutSharingSensitiveDirectory(directory)) {
                return;
            }
        }
        if (this._revision != revision) {
            return;
        }
        boolean isForcedShare = FileManager.isForcedShareDirectory(directory);
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._completelySharedDirectories.contains(directory)) {
                return;
            }
            this._completelySharedDirectories.add(directory);
            if (!isForcedShare) {
                this.dispatchFileEvent(new FileManagerEvent(this, 7, directory, parent));
            }
        }
        File[] file_list = directory.listFiles(this.SHAREABLE_FILE_FILTER);
        if (file_list == null) {
            return;
        }
        for (int i = 0; i < file_list.length && this._revision == revision; ++i) {
            this.addFileIfShared(file_list[i], Collections.EMPTY_LIST, true, revision, null);
        }
        if (this._revision != revision) {
            return;
        }
        if (isForcedShare) {
            return;
        }
        File[] dir_list = directory.listFiles(DIRECTORY_FILTER);
        for (int i = 0; i < dir_list.length && this._revision == revision; ++i) {
            this.updateSharedDirectories(dir_list[i], directory, revision);
        }
    }

    public void removeFolderIfShared(File folder) {
        this._isUpdating = true;
        this.removeFolderIfShared(folder, null);
        this._isUpdating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFolderIfShared(File folder, File parent) {
        boolean contained;
        if (!folder.isDirectory() && folder.exists()) {
            throw new IllegalArgumentException("Expected a directory, but given: " + folder);
        }
        try {
            folder = FileUtils.getCanonicalFile(folder);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            contained = this._completelySharedDirectories.contains(folder);
        }
        if (contained) {
            if (parent != null && SharingSettings.DIRECTORIES_TO_SHARE.contains(folder)) {
                return;
            }
            if (parent == null && !SharingSettings.DIRECTORIES_TO_SHARE.remove(folder)) {
                this._data.DIRECTORIES_NOT_TO_SHARE.add(folder);
            }
            fileManager = this;
            synchronized (fileManager) {
                this._completelySharedDirectories.remove(folder);
            }
            File[] subs = folder.listFiles();
            if (subs != null) {
                for (int i = 0; i < subs.length; ++i) {
                    File f = subs[i];
                    if (f.isDirectory()) {
                        this.removeFolderIfShared(f, folder);
                        continue;
                    }
                    if (!f.isFile() || this._data.SPECIAL_FILES_TO_SHARE.contains(f) || this.removeFileIfShared(f) != null) continue;
                    UrnCache.instance().clearPendingHashesFor(f, this);
                }
            }
            this.dispatchFileEvent(new FileManagerEvent(this, 8, folder));
        }
    }

    public void addSharedFolder(File folder) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Expected a directory, but given: " + folder);
        }
        try {
            folder = FileUtils.getCanonicalFile(folder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._data.DIRECTORIES_NOT_TO_SHARE.remove(folder);
        if (!this.isCompletelySharedDirectory(folder.getParentFile())) {
            SharingSettings.DIRECTORIES_TO_SHARE.add(folder);
        }
        this._isUpdating = true;
        this.updateSharedDirectories(folder, null, this._revision);
        this._isUpdating = false;
    }

    public void addFileAlways(File file) {
        this.addFileAlways(file, Collections.EMPTY_LIST, null);
    }

    public void addFileAlways(File file, FileEventListener callback) {
        this.addFileAlways(file, Collections.EMPTY_LIST, callback);
    }

    public void addFileAlways(File file, List list) {
        this.addFileAlways(file, list, null);
    }

    public void addFileAlways(File file, List list, FileEventListener callback) {
        this._data.FILES_NOT_TO_SHARE.remove(file);
        if (!this.isFileShareable(file)) {
            this._data.SPECIAL_FILES_TO_SHARE.add(file);
        }
        this.addFileIfShared(file, list, true, this._revision, callback);
    }

    public void addFileIfShared(File file) {
        this.addFileIfShared(file, Collections.EMPTY_LIST, true, this._revision, null);
    }

    public void addFileIfShared(File file, FileEventListener callback) {
        this.addFileIfShared(file, Collections.EMPTY_LIST, true, this._revision, callback);
    }

    public void addFileIfShared(File file, List list) {
        this.addFileIfShared(file, list, true, this._revision, null);
    }

    public void addFileIfShared(File file, List list, FileEventListener callback) {
        this.addFileIfShared(file, list, true, this._revision, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileIfShared(File file, List metadata, boolean notify, int revision, FileEventListener callback) {
        if (callback == null) {
            callback = EMPTY_CALLBACK;
        }
        if (revision != this._revision) {
            callback.handleFileEvent(new FileManagerEvent(this, 5, file));
            return;
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException e) {
            callback.handleFileEvent(new FileManagerEvent(this, 5, file));
            return;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (revision != this._revision) {
                callback.handleFileEvent(new FileManagerEvent(this, 5, file));
                return;
            }
            if (!this.isFileShareable(file)) {
                this._data.SPECIAL_FILES_TO_SHARE.remove(file);
                callback.handleFileEvent(new FileManagerEvent(this, 5, file));
                return;
            }
            if (this.isFileShared(file)) {
                callback.handleFileEvent(new FileManagerEvent(this, 6, file));
                return;
            }
            ++this._numPendingFiles;
            this._pendingFinished = -1;
        }
        UrnCache.instance().calculateAndCacheUrns(file, this.getNewUrnCallback(file, metadata, notify, revision, callback));
    }

    protected UrnCallback getNewUrnCallback(final File file, final List metadata, final boolean notify, final int revision, final FileEventListener callback) {
        return new UrnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void urnsCalculated(File f, Set urns) {
                FileDesc fd = null;
                FileManager fileManager = FileManager.this;
                synchronized (fileManager) {
                    if (revision != FileManager.this._revision) {
                        LOG.warn("Revisions changed, dropping share.");
                        callback.handleFileEvent(new FileManagerEvent(FileManager.this, 5, file));
                        return;
                    }
                    FileManager.this._numPendingFiles--;
                    if (!urns.isEmpty() && FileManager.this.isFileShareable(file)) {
                        fd = FileManager.this.addFile(file, urns);
                    }
                }
                if (fd != null) {
                    FileManager.this.loadFile(fd, file, metadata, urns);
                    FileManagerEvent evt = new FileManagerEvent(FileManager.this, 1, fd);
                    if (notify) {
                        FileManager.this.dispatchFileEvent(evt);
                    }
                    callback.handleFileEvent(evt);
                } else {
                    callback.handleFileEvent(new FileManagerEvent(FileManager.this, 5, file));
                }
                if (FileManager.this._numPendingFiles == 0) {
                    FileManager.this._pendingFinished = revision;
                    FileManager.this.tryToFinish();
                }
            }

            public boolean isOwner(Object o) {
                return o == FileManager.this;
            }
        };
    }

    protected void loadFile(FileDesc fd, File file, List metadata, Set urns) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FileDesc addFile(File file, Set urns) {
        int fileIndex = this._files.size();
        FileDesc fileDesc = new FileDesc(file, urns, fileIndex);
        ContentResponseData r = RouterService.getContentManager().getResponse(fileDesc.getSHA1Urn());
        if (r != null && !r.isOK()) {
            return null;
        }
        long fileLength = file.length();
        this._filesSize += fileLength;
        this._files.add(fileDesc);
        this._fileToFileDescMap.put(file, fileDesc);
        ++this._numFiles;
        File parent = file.getParentFile();
        Assert.that(parent != null, "Null parent to \"" + file + "\"");
        IntSet siblings = (IntSet)this._sharedDirectories.get(parent);
        if (siblings == null) {
            siblings = new IntSet();
            this._sharedDirectories.put(parent, siblings);
        }
        boolean added = siblings.add(fileIndex);
        Assert.that(added, "File " + fileIndex + " already found in " + siblings);
        if (FileManager.isForcedShareDirectory(parent)) {
            ++this._numForcedFiles;
        }
        String[] keywords = FileManager.extractKeywords(fileDesc);
        for (int i = 0; i < keywords.length; ++i) {
            String keyword = keywords[i];
            IntSet indices = (IntSet)this._keywordTrie.get(keyword);
            if (indices == null) {
                indices = new IntSet();
                this._keywordTrie.add(keyword, indices);
            }
            indices.add(fileIndex);
        }
        if (!FileManager.isForcedShare(file)) {
            CreationTimeCache ctCache;
            URN mainURN = fileDesc.getSHA1Urn();
            CreationTimeCache creationTimeCache = ctCache = CreationTimeCache.instance();
            synchronized (creationTimeCache) {
                Long cTime = ctCache.getCreationTime(mainURN);
                if (cTime == null) {
                    cTime = new Long(file.lastModified());
                }
                if (cTime > 0L) {
                    ctCache.addTime(mainURN, cTime);
                    ctCache.commitTime(mainURN);
                }
            }
        }
        this.updateUrnIndex(fileDesc);
        _needRebuild = true;
        return fileDesc;
    }

    public synchronized void stopSharingFile(File file) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException e) {
            return;
        }
        boolean removed = this._data.SPECIAL_FILES_TO_SHARE.remove(file);
        FileDesc fd = this.removeFileIfShared(file);
        if (fd == null) {
            UrnCache.instance().clearPendingHashesFor(file, this);
        } else {
            file = fd.getFile();
            if (!removed) {
                this._data.FILES_NOT_TO_SHARE.add(file);
            }
        }
    }

    public synchronized FileDesc removeFileIfShared(File f) {
        return this.removeFileIfShared(f, true);
    }

    protected synchronized FileDesc removeFileIfShared(File f, boolean notify) {
        try {
            f = FileUtils.getCanonicalFile(f);
        }
        catch (IOException e) {
            return null;
        }
        FileDesc fd = (FileDesc)this._fileToFileDescMap.get(f);
        if (fd == null) {
            return null;
        }
        int i = fd.getIndex();
        Assert.that(((FileDesc)this._files.get(i)).getFile().equals(f), "invariant broken!");
        this._files.set(i, null);
        this._fileToFileDescMap.remove(f);
        _needRebuild = true;
        if (fd instanceof IncompleteFileDesc) {
            this.removeUrnIndex(fd);
            --this._numIncompleteFiles;
            boolean removed = this._incompletesShared.remove(i);
            Assert.that(removed, "File " + i + " not found in " + this._incompletesShared);
            if (notify) {
                FileManagerEvent evt = new FileManagerEvent(this, 2, fd);
                this.dispatchFileEvent(evt);
            }
            return fd;
        }
        --this._numFiles;
        this._filesSize -= fd.getFileSize();
        File parent = f.getParentFile();
        IntSet siblings = (IntSet)this._sharedDirectories.get(parent);
        Assert.that(siblings != null, "Removed file's directory \"" + parent + "\" not in " + this._sharedDirectories);
        boolean removed = siblings.remove(i);
        Assert.that(removed, "File " + i + " not found in " + siblings);
        if (FileManager.isForcedShareDirectory(parent)) {
            notify = false;
            --this._numForcedFiles;
        }
        String[] keywords = FileManager.extractKeywords(fd);
        for (int j = 0; j < keywords.length; ++j) {
            String keyword = keywords[j];
            IntSet indices = (IntSet)this._keywordTrie.get(keyword);
            if (indices == null) continue;
            indices.remove(i);
            if (indices.size() != 0) continue;
            this._keywordTrie.remove(keyword);
        }
        this.removeUrnIndex(fd);
        if (this._urnMap.get(fd.getSHA1Urn()) == null) {
            CreationTimeCache.instance().removeTime(fd.getSHA1Urn());
        }
        if (notify) {
            FileManagerEvent evt = new FileManagerEvent(this, 2, fd);
            this.dispatchFileEvent(evt);
        }
        return fd;
    }

    public synchronized void addIncompleteFile(File incompleteFile, Set urns, String name, int size, VerifyingFile vf) {
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
        }
        catch (IOException ioe) {
            return;
        }
        Iterator iter = urns.iterator();
        while (iter.hasNext()) {
            IntSet shared = (IntSet)this._urnMap.get(iter.next());
            if (shared == null) continue;
            IntSet.IntSetIterator isIter = shared.iterator();
            while (isIter.hasNext()) {
                String path;
                String incPath;
                int i = isIter.next();
                FileDesc desc = (FileDesc)this._files.get(i);
                if (desc == null || !(incPath = incompleteFile.getAbsolutePath()).equals(path = desc.getFile().getAbsolutePath())) continue;
                return;
            }
        }
        int fileIndex = this._files.size();
        this._incompletesShared.add(fileIndex);
        IncompleteFileDesc ifd = new IncompleteFileDesc(incompleteFile, urns, fileIndex, name, size, vf);
        this._files.add(ifd);
        this._fileToFileDescMap.put(incompleteFile, ifd);
        this.updateUrnIndex(ifd);
        ++this._numIncompleteFiles;
        _needRebuild = true;
        this.dispatchFileEvent(new FileManagerEvent(this, 1, ifd));
    }

    public abstract void fileChanged(File var1);

    public void validate(final FileDesc fd) {
        ContentManager cm = RouterService.getContentManager();
        if (this._requestingValidation.add(fd.getSHA1Urn())) {
            cm.request(fd.getSHA1Urn(), new ContentResponseObserver(){

                public void handleResponse(URN urn, ContentResponseData r) {
                    FileManager.this._requestingValidation.remove(fd.getSHA1Urn());
                    if (r != null && !r.isOK()) {
                        FileManager.this.removeFileIfShared(fd.getFile());
                    }
                }
            }, 5000L);
        }
    }

    private synchronized void updateUrnIndex(FileDesc fileDesc) {
        Iterator iter = fileDesc.getUrns().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            IntSet indices = (IntSet)this._urnMap.get(urn);
            if (indices == null) {
                indices = new IntSet();
                this._urnMap.put(urn, indices);
            }
            indices.add(fileDesc.getIndex());
        }
    }

    private static String[] extractKeywords(FileDesc fd) {
        return StringUtils.split(I18NConvert.instance().getNorm(fd.getPath()), DELIMITERS);
    }

    private synchronized void removeUrnIndex(FileDesc fileDesc) {
        Iterator iter = fileDesc.getUrns().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            IntSet indices = (IntSet)this._urnMap.get(urn);
            Assert.that(indices != null, "Invariant broken");
            indices.remove(fileDesc.getIndex());
            if (indices.size() != 0) continue;
            RouterService.getAltlocManager().purge(urn);
            this._urnMap.remove(urn);
        }
    }

    public void renameFileIfShared(File oldName, File newName) {
        this.renameFileIfShared(oldName, newName, null);
    }

    public synchronized void renameFileIfShared(File oldName, File newName, final FileEventListener callback) {
        FileDesc toRemove = this.getFileDescForFile(oldName);
        if (toRemove == null) {
            FileManagerEvent evt = new FileManagerEvent(this, 5, oldName);
            this.dispatchFileEvent(evt);
            if (callback != null) {
                callback.handleFileEvent(evt);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to rename: " + oldName + " to: " + newName);
        }
        LinkedList xmlDocs = new LinkedList(toRemove.getLimeXMLDocuments());
        final FileDesc removed = this.removeFileIfShared(oldName, false);
        Assert.that(removed == toRemove, "invariant broken.");
        if (this._data.SPECIAL_FILES_TO_SHARE.remove(oldName) && !this.isFileInCompletelySharedDirectory(newName)) {
            this._data.SPECIAL_FILES_TO_SHARE.add(newName);
        }
        UrnCache.instance().addUrns(newName, removed.getUrns());
        this.addFileIfShared(newName, xmlDocs, false, this._revision, new FileEventListener(){

            public void handleFileEvent(FileManagerEvent evt) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Add of newFile returned callback: " + evt);
                }
                FileManagerEvent newEvt = null;
                if (evt.isAddEvent()) {
                    FileDesc fd = evt.getFileDescs()[0];
                    newEvt = new FileManagerEvent(FileManager.this, 3, new FileDesc[]{removed, fd});
                } else {
                    newEvt = new FileManagerEvent(FileManager.this, 2, removed);
                }
                FileManager.this.dispatchFileEvent(newEvt);
                if (callback != null) {
                    callback.handleFileEvent(newEvt);
                }
            }
        });
    }

    private synchronized void trim() {
        this._keywordTrie.trim(new Function(){

            public Object apply(Object intSet) {
                ((IntSet)intSet).trim();
                return intSet;
            }
        });
    }

    public void validateSensitiveFile(File dir) {
        this._data.SENSITIVE_DIRECTORIES_VALIDATED.add(dir);
        this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.remove(dir);
    }

    public void invalidateSensitiveFile(File dir) {
        this._data.SENSITIVE_DIRECTORIES_VALIDATED.remove(dir);
        this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.add(dir);
        SharingSettings.DIRECTORIES_TO_SHARE.remove(dir);
    }

    public boolean hasIndividualFiles() {
        return !this._data.SPECIAL_FILES_TO_SHARE.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getIndividualFiles() {
        Set candidates;
        Set set = candidates = this._data.SPECIAL_FILES_TO_SHARE;
        synchronized (set) {
            ArrayList<File> files = new ArrayList<File>(candidates.size());
            Iterator i = candidates.iterator();
            while (i.hasNext()) {
                File f = (File)i.next();
                if (!f.exists()) continue;
                files.add(f);
            }
            if (files.isEmpty()) {
                return new File[0];
            }
            return files.toArray(new File[files.size()]);
        }
    }

    public boolean isIndividualShare(File f) {
        return this._data.SPECIAL_FILES_TO_SHARE.contains(f) && FileManager.isFilePhysicallyShareable(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanIndividualFiles() {
        Set files;
        Set set = files = this._data.SPECIAL_FILES_TO_SHARE;
        synchronized (set) {
            Iterator i = files.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof File && FileManager.isFilePhysicallyShareable((File)o)) continue;
                i.remove();
            }
        }
    }

    public boolean isFileShared(File file) {
        if (file == null) {
            return false;
        }
        return this._fileToFileDescMap.get(file) != null;
    }

    private static boolean hasShareableExtension(File file) {
        if (file == null) {
            return false;
        }
        String filename = file.getName();
        int begin = filename.lastIndexOf(".");
        if (begin == -1) {
            return false;
        }
        String ext = filename.substring(begin + 1).toLowerCase();
        return _extensions.contains(ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileInCompletelySharedDirectory(File f) {
        File dir = f.getParentFile();
        if (dir == null) {
            return false;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            return this._completelySharedDirectories.contains(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompletelySharedDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            return this._completelySharedDirectories.contains(dir);
        }
    }

    private boolean isFileShareable(File file) {
        if (!FileManager.isFilePhysicallyShareable(file)) {
            return false;
        }
        if (this._data.SPECIAL_FILES_TO_SHARE.contains(file)) {
            return true;
        }
        if (this._data.FILES_NOT_TO_SHARE.contains(file)) {
            return false;
        }
        if (this.isFileInCompletelySharedDirectory(file)) {
            if (file.getName().toUpperCase().startsWith("LIMEWIRE")) {
                return true;
            }
            return FileManager.hasShareableExtension(file);
        }
        return false;
    }

    public static boolean isFilePhysicallyShareable(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canRead() || file.isHidden()) {
            return false;
        }
        long fileLength = file.length();
        return fileLength <= Integer.MAX_VALUE && fileLength > 0L;
    }

    public static boolean isSensitiveDirectory(File file) {
        String userHome;
        if (file == null) {
            return false;
        }
        File[] faRoots = File.listRoots();
        if (faRoots != null && faRoots.length > 0) {
            for (int i = 0; i < faRoots.length; ++i) {
                if (!file.equals(faRoots[i])) continue;
                return true;
            }
        }
        if (file.equals(new File(userHome = System.getProperty("user.home")))) {
            return true;
        }
        if (CommonUtils.isWindows()) {
            if (file.getName().equals("Documents and Settings")) {
                return true;
            }
            if (file.getName().equals("My Documents")) {
                return true;
            }
            if (file.getName().equals("Desktop")) {
                return true;
            }
            if (file.getName().equals("Program Files")) {
                return true;
            }
            if (file.getName().equals("Windows")) {
                return true;
            }
            if (file.getName().equals("WINNT")) {
                return true;
            }
        }
        if (CommonUtils.isMacOSX()) {
            if (file.getName().equals("Users")) {
                return true;
            }
            if (file.getName().equals("System")) {
                return true;
            }
            if (file.getName().equals("System Folder")) {
                return true;
            }
            if (file.getName().equals("Previous Systems")) {
                return true;
            }
            if (file.getName().equals("private")) {
                return true;
            }
            if (file.getName().equals("Volumes")) {
                return true;
            }
            if (file.getName().equals("Desktop")) {
                return true;
            }
            if (file.getName().equals("Applications")) {
                return true;
            }
            if (file.getName().equals("Applications (Mac OS 9)")) {
                return true;
            }
            if (file.getName().equals("Network")) {
                return true;
            }
        }
        if (CommonUtils.isPOSIX()) {
            if (file.getName().equals("bin")) {
                return true;
            }
            if (file.getName().equals("boot")) {
                return true;
            }
            if (file.getName().equals("dev")) {
                return true;
            }
            if (file.getName().equals("etc")) {
                return true;
            }
            if (file.getName().equals("home")) {
                return true;
            }
            if (file.getName().equals("mnt")) {
                return true;
            }
            if (file.getName().equals("opt")) {
                return true;
            }
            if (file.getName().equals("proc")) {
                return true;
            }
            if (file.getName().equals("root")) {
                return true;
            }
            if (file.getName().equals("sbin")) {
                return true;
            }
            if (file.getName().equals("usr")) {
                return true;
            }
            if (file.getName().equals("var")) {
                return true;
            }
        }
        return false;
    }

    public synchronized QueryRouteTable getQRT() {
        if (_needRebuild) {
            this.buildQRT();
            _needRebuild = false;
        }
        QueryRouteTable qrt = new QueryRouteTable(_queryRouteTable.getSize());
        qrt.addAll(_queryRouteTable);
        return qrt;
    }

    protected synchronized void buildQRT() {
        _queryRouteTable = new QueryRouteTable();
        FileDesc[] fds = this.getAllSharedFileDescriptors();
        for (int i = 0; i < fds.length; ++i) {
            if (fds[i] instanceof IncompleteFileDesc) continue;
            _queryRouteTable.add(fds[i].getPath());
        }
    }

    public synchronized Response[] query(QueryRequest request) {
        String str = request.getQuery();
        boolean includeXML = this.shouldIncludeXMLInResponse(request);
        if (request.isWhatIsNewRequest()) {
            return this.respondToWhatIsNewRequest(request, includeXML);
        }
        if (str.equals(INDEXING_QUERY) || str.equals(BROWSE_QUERY)) {
            return this.respondToIndexingQuery(includeXML);
        }
        str = this._keywordTrie.canonicalCase(str);
        IntSet matches = this.search(str, null);
        if (request.getQueryUrns().size() > 0) {
            matches = this.urnSearch(request.getQueryUrns().iterator(), matches);
        }
        if (matches == null) {
            return EMPTY_RESPONSES;
        }
        LinkedList<Response> responses = new LinkedList<Response>();
        MediaType.Aggregator filter = MediaType.getAggregator(request);
        LimeXMLDocument doc = request.getRichQuery();
        IntSet.IntSetIterator iter = matches.iterator();
        while (iter.hasNext()) {
            int i = iter.next();
            FileDesc desc = (FileDesc)this._files.get(i);
            if (desc == null) {
                Assert.that(false, "unexpected null in FileManager for query:\n" + request);
            }
            if (filter != null && !filter.allow(desc.getFileName())) continue;
            desc.incrementHitCount();
            RouterService.getCallback().handleSharedFileUpdate(desc.getFile());
            Response resp = new Response(desc);
            if (includeXML) {
                this.addXMLToResponse(resp, desc);
                if (doc != null && resp.getDocument() != null && !this.isValidXMLMatch(resp, doc)) continue;
            }
            responses.add(resp);
        }
        if (responses.size() == 0) {
            return EMPTY_RESPONSES;
        }
        return responses.toArray(new Response[responses.size()]);
    }

    private Response[] respondToWhatIsNewRequest(QueryRequest request, boolean includeXML) {
        List urnList = CreationTimeCache.instance().getFiles(request, 3);
        if (urnList.size() == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] resps = new Response[urnList.size()];
        for (int i = 0; i < urnList.size(); ++i) {
            URN currURN = (URN)urnList.get(i);
            FileDesc desc = this.getFileDescForUrn(currURN);
            if (desc == null || desc instanceof IncompleteFileDesc) {
                throw new RuntimeException("Bad Rep - No IFDs allowed!");
            }
            Response r = new Response(desc);
            if (includeXML) {
                this.addXMLToResponse(r, desc);
            }
            resps[i] = r;
        }
        return resps;
    }

    private Response[] respondToIndexingQuery(boolean includeXML) {
        if (this._numFiles == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] ret = new Response[this._numFiles - this._numForcedFiles];
        int j = 0;
        for (int i = 0; i < this._files.size(); ++i) {
            FileDesc desc = (FileDesc)this._files.get(i);
            if (desc == null || desc instanceof IncompleteFileDesc || FileManager.isForcedShare(desc)) continue;
            Assert.that(j < ret.length, "_numFiles is too small");
            ret[j] = new Response(desc);
            if (includeXML) {
                this.addXMLToResponse(ret[j], desc);
            }
            ++j;
        }
        Assert.that(j == ret.length, "_numFiles is too large");
        return ret;
    }

    protected abstract boolean shouldIncludeXMLInResponse(QueryRequest var1);

    protected abstract void addXMLToResponse(Response var1, FileDesc var2);

    protected abstract boolean isValidXMLMatch(Response var1, LimeXMLDocument var2);

    protected IntSet search(String query, IntSet priors) {
        IntSet ret = priors;
        int i = 0;
        while (i < query.length()) {
            int j;
            if (FileManager.isDelimiter(query.charAt(i))) {
                ++i;
                continue;
            }
            for (j = i + 1; j < query.length() && !FileManager.isDelimiter(query.charAt(j)); ++j) {
            }
            Iterator iter = this._keywordTrie.getPrefixedBy(query, i, j);
            if (iter.hasNext()) {
                IntSet matches = null;
                while (iter.hasNext()) {
                    IntSet s = (IntSet)iter.next();
                    if (matches == null) {
                        if (i == 0 && j == query.length() && !iter.hasNext()) {
                            return s;
                        }
                        matches = new IntSet();
                    }
                    matches.addAll(s);
                }
                if (ret == null) {
                    ret = matches;
                } else {
                    ret.retainAll(matches);
                }
            } else {
                return null;
            }
            if (ret.size() == 0) {
                return null;
            }
            i = j;
        }
        if (ret == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    private synchronized IntSet urnSearch(Iterator urnsIter, IntSet priors) {
        IntSet ret = priors;
        while (urnsIter.hasNext()) {
            URN urn = (URN)urnsIter.next();
            IntSet hits = (IntSet)this._urnMap.get(urn);
            if (hits == null) continue;
            IntSet.IntSetIterator iter = hits.iterator();
            while (iter.hasNext()) {
                FileDesc fd = (FileDesc)this._files.get(iter.next());
                if (fd == null || fd instanceof IncompleteFileDesc || !fd.containsUrn(urn)) continue;
                if (ret == null) {
                    ret = new IntSet();
                }
                ret.add(fd.getIndex());
            }
        }
        return ret;
    }

    public static boolean isForcedShare(FileDesc desc) {
        return FileManager.isForcedShare(desc.getFile());
    }

    public static boolean isForcedShare(File file) {
        File parent = file.getParentFile();
        return parent != null && FileManager.isForcedShareDirectory(parent);
    }

    public static boolean isForcedShareDirectory(File f) {
        return f.equals(PROGRAM_SHARE) || f.equals(PREFERENCE_SHARE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFileManagerEventListener(FileEventListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.eventListeners.contains(listener)) {
                return;
            }
            ArrayList<FileEventListener> copy = new ArrayList<FileEventListener>(this.eventListeners);
            copy.add(listener);
            this.eventListeners = Collections.unmodifiableList(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFileManagerEventListener(FileEventListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList copy = new ArrayList(this.eventListeners);
            copy.remove(listener);
            this.eventListeners = Collections.unmodifiableList(copy);
        }
    }

    public void dispatchFileEvent(FileManagerEvent evt) {
        Iterator iter = this.eventListeners.iterator();
        while (iter.hasNext()) {
            FileEventListener listener = (FileEventListener)iter.next();
            listener.handleFileEvent(evt);
        }
    }

    static {
        File forceShare = new File(".", ".NetworkShare").getAbsoluteFile();
        try {
            forceShare = FileUtils.getCanonicalFile(forceShare);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        PROGRAM_SHARE = forceShare;
        forceShare = new File(CommonUtils.getUserSettingsDir(), ".NetworkShare").getAbsoluteFile();
        try {
            forceShare = FileUtils.getCanonicalFile(forceShare);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PREFERENCE_SHARE = forceShare;
        LOADER = new ProcessingQueue("FileManagerLoader");
        DIRECTORY_FILTER = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        EMPTY_CALLBACK = new FileEventListener(){

            public void handleFileEvent(FileManagerEvent evt) {
            }
        };
        _needRebuild = true;
        EMPTY_RESPONSES = new Response[0];
    }
}

