/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import java.io.File;
import java.util.EventObject;

public class FileManagerEvent
extends EventObject {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int RENAME = 3;
    public static final int CHANGE = 4;
    public static final int FAILED = 5;
    public static final int ALREADY_SHARED = 6;
    public static final int ADD_FOLDER = 7;
    public static final int REMOVE_FOLDER = 8;
    private final int kind;
    private final FileDesc[] fds;
    private final File[] files;

    public FileManagerEvent(FileManager manager, int kind, FileDesc fd) {
        this(manager, kind, new FileDesc[]{fd});
    }

    public FileManagerEvent(FileManager manager, int kind, FileDesc[] fds) {
        super(manager);
        this.kind = kind;
        this.fds = fds;
        this.files = null;
    }

    public FileManagerEvent(FileManager manager, int kind, File file) {
        this(manager, kind, new File[]{file});
    }

    public FileManagerEvent(FileManager manager, int kind, File folder, File parent) {
        this(manager, kind, new File[]{folder, parent});
    }

    public FileManagerEvent(FileManager manager, int kind, File[] files) {
        super(manager);
        this.kind = kind;
        this.files = files;
        this.fds = null;
    }

    public int getKind() {
        return this.kind;
    }

    public FileDesc[] getFileDescs() {
        return this.fds;
    }

    public File[] getFiles() {
        return this.files;
    }

    public boolean isAddEvent() {
        return this.kind == 1;
    }

    public boolean isRemoveEvent() {
        return this.kind == 2;
    }

    public boolean isRenameEvent() {
        return this.kind == 3;
    }

    public boolean isChangeEvent() {
        return this.kind == 4;
    }

    public boolean isFailedEvent() {
        return this.kind == 5;
    }

    public boolean isAlreadySharedEvent() {
        return this.kind == 6;
    }

    public boolean isAddFolderEvent() {
        return this.kind == 7;
    }

    public boolean isRemoveFolderEvent() {
        return this.kind == 8;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer("FileManagerEvent: [event=");
        switch (this.kind) {
            case 1: {
                buffer.append("ADD");
                break;
            }
            case 2: {
                buffer.append("REMOVE");
                break;
            }
            case 3: {
                buffer.append("RENAME");
                break;
            }
            case 4: {
                buffer.append("CHANGE");
                break;
            }
            case 5: {
                buffer.append("FAILED");
                break;
            }
            case 6: {
                buffer.append("ALREADY_SHARED");
                break;
            }
            case 7: {
                buffer.append("ADD_FOLDER");
                break;
            }
            case 8: {
                buffer.append("REMOVE_FOLDER");
                break;
            }
            default: {
                buffer.append("UNKNOWN");
            }
        }
        if (this.fds != null) {
            buffer.append(", fds=").append(this.fds.length).append("\n");
            for (i = 0; i < this.fds.length; ++i) {
                buffer.append(this.fds[i]);
                if (i == this.fds.length - 1) continue;
                buffer.append(", ");
            }
        } else {
            buffer.append(", fds=null");
        }
        if (this.files != null) {
            buffer.append(", files=").append(this.files.length).append("\n");
            for (i = 0; i < this.files.length; ++i) {
                buffer.append(this.files[i]);
                if (i == this.files.length - 1) continue;
                buffer.append(", ");
            }
        } else {
            buffer.append(", files=null");
        }
        return buffer.append("]").toString();
    }
}

