/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.GuidMapFactory;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.connection.CompositeQueue;
import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.DeflaterWriter;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.connection.InflaterReader;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.MessageReader;
import com.limegroup.gnutella.connection.MessageReceiver;
import com.limegroup.gnutella.connection.MessageWriter;
import com.limegroup.gnutella.connection.OutputRunner;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.handshaking.AsyncIncomingHandshaker;
import com.limegroup.gnutella.handshaking.AsyncOutgoingHandshaker;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.DefaultHeaders;
import com.limegroup.gnutella.handshaking.HandshakeObserver;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.LeafHandshakeResponder;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.handshaking.UltrapeerHandshakeResponder;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.DelayedBufferWriter;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.NBThrottle;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleWriter;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import com.limegroup.gnutella.version.UpdateHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedConnection
extends Connection
implements ReplyHandler,
MessageReceiver,
SentMessageHandler {
    private static final Log LOG = LogFactory.getLog(ManagedConnection.class);
    private long LEAF_QUERY_ROUTE_UPDATE_TIME = 300000L;
    private long ULTRAPEER_QUERY_ROUTE_UPDATE_TIME = 60000L;
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int TOTAL_OUTGOING_MESSAGING_BANDWIDTH = 8000;
    private static final int MAX_UDP_CONNECT_BACK_ATTEMPTS = 15;
    private static final int MAX_TCP_CONNECT_BACK_ATTEMPTS = 10;
    private ConnectionManager _manager;
    private volatile SpamFilter _routeFilter = SpamFilter.newRouteFilter();
    private volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();
    private final Object QRP_LOCK = new Object();
    private static final Throttle _nbThrottle = new NBThrottle(true, 8000.0f, ConnectionSettings.NUM_CONNECTIONS.getValue(), 5000);
    private static final BandwidthThrottle _throttle = new BandwidthThrottle(8000.0f);
    private OutputRunner _outputRunner;
    private final ConnectionStats _connectionStats = new ConnectionStats();
    private static long MIN_BUSY_LEAF_TIME = 20000L;
    private long _nextQRPForwardTime;
    private BandwidthTrackerImpl _upBandwidthTracker = new BandwidthTrackerImpl();
    private BandwidthTrackerImpl _downBandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isKillable = true;
    private volatile int hopsFlowMax = -1;
    private volatile long _busyTime = -1L;
    private volatile boolean _pushProxy;
    private static int _numUDPConnectBackRequests = 0;
    private static int _numTCPConnectBackRequests = 0;
    private QueryRouteTable _lastQRPTableReceived;
    private QueryRouteTable _lastQRPTableSent;
    private GuidMap _guidMap = GuidMapFactory.getMap();
    private boolean supernodeClientAtLooping = false;
    private byte[] clientGUID = DataUtils.EMPTY_GUID;
    private boolean _useLocalPreference;
    private volatile long queryReplies;
    private Buffer b;

    public ManagedConnection(String host, int port) {
        super(host, port);
        this._manager = RouterService.getConnectionManager();
    }

    ManagedConnection(Socket socket) {
        super(socket);
        this._manager = RouterService.getConnectionManager();
    }

    public void initialize() throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(null);
    }

    public void initialize(GnetConnectObserver observer) throws IOException, NoGnutellaOkException, BadHandshakeException {
        DefaultHandshakeResponder responder;
        DefaultHeaders requestHeaders;
        if (this.isOutgoing()) {
            String host = this.getAddress();
            if (RouterService.isSupernode()) {
                requestHeaders = new UltrapeerHeaders(host);
                responder = new UltrapeerHandshakeResponder(host);
            } else {
                requestHeaders = new LeafHeaders(host);
                responder = new LeafHandshakeResponder(host);
            }
        } else {
            String host = this.getSocket().getInetAddress().getHostAddress();
            requestHeaders = null;
            responder = RouterService.isSupernode() ? new UltrapeerHandshakeResponder(host) : new LeafHandshakeResponder(host);
        }
        super.initialize(requestHeaders, responder, 6000, observer);
    }

    protected ConnectObserver createAsyncConnectObserver(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) {
        return new AsyncHandshakeConnecter(requestHeaders, responder, observer);
    }

    protected void preHandshakeInitialize(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) throws IOException, NoGnutellaOkException, BadHandshakeException {
        responder.setLocalePreferencing(this._useLocalPreference);
        super.preHandshakeInitialize(requestHeaders, responder, observer);
    }

    protected void performHandshake(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) throws IOException, BadHandshakeException, NoGnutellaOkException {
        if (observer == null || !this.isAsynchronous()) {
            if (!this.isOutgoing() && observer != null) {
                throw new IllegalStateException("cannot support incoming blocking w/ observer");
            }
            super.performHandshake(requestHeaders, responder, observer);
        } else {
            Handshaker shaker = this.createAsyncHandshaker(requestHeaders, responder, observer);
            try {
                shaker.shake();
            }
            catch (IOException iox) {
                ErrorService.error(iox);
            }
        }
    }

    protected Handshaker createAsyncHandshaker(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) {
        HandshakeWatcher shakeObserver = new HandshakeWatcher(observer);
        IOStateObserver shaker = this.isOutgoing() ? new AsyncOutgoingHandshaker(requestHeaders, responder, this._socket, shakeObserver) : new AsyncIncomingHandshaker(responder, this._socket, shakeObserver);
        shakeObserver.setHandshaker((Handshaker)((Object)shaker));
        return shaker;
    }

    protected void postHandshakeInitialize(Handshaker shaker) {
        super.postHandshakeInitialize(shaker);
        this.startOutput();
        UpdateManager.instance().checkAndUpdate(this);
    }

    public void resetQueryRouteTable(ResetTableMessage rtm) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable(rtm.getTableSize(), rtm.getInfinity());
        } else {
            this._lastQRPTableReceived.reset(rtm);
        }
    }

    public void patchQueryRouteTable(PatchTableMessage ptm) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable();
        }
        try {
            this._lastQRPTableReceived.patch(ptm);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
    }

    public void setBusy(boolean bSet) {
        if (bSet) {
            if (this._busyTime == -1L) {
                this._busyTime = System.currentTimeMillis();
            }
        } else {
            this._busyTime = -1L;
        }
    }

    public byte getHopsFlowMax() {
        return (byte)this.hopsFlowMax;
    }

    public boolean isBusyLeaf() {
        boolean busy = this.isSupernodeClientConnection() && this.getHopsFlowMax() == 0;
        return busy;
    }

    public boolean isBusyEnoughToTriggerQRTRemoval() {
        if (this._busyTime == -1L) {
            return false;
        }
        return System.currentTimeMillis() > this._busyTime + MIN_BUSY_LEAF_TIME;
    }

    public boolean shouldForwardQuery(QueryRequest query) {
        if (query.isFeatureQuery()) {
            if (this.isSupernodeClientConnection()) {
                return this.getRemoteHostFeatureQuerySelector() >= query.getFeatureSelector();
            }
            if (this.isSupernodeSupernodeConnection()) {
                return this.getRemoteHostSupportsFeatureQueries();
            }
            return false;
        }
        return this.hitsQueryRouteTable(query);
    }

    protected boolean hitsQueryRouteTable(QueryRequest query) {
        if (this._lastQRPTableReceived == null) {
            return false;
        }
        return this._lastQRPTableReceived.contains(query);
    }

    public QueryRouteTable getQueryRouteTableReceived() {
        return this._lastQRPTableReceived;
    }

    public double getQueryRouteTablePercentFull() {
        return this._lastQRPTableReceived == null ? 0.0 : this._lastQRPTableReceived.getPercentFull();
    }

    public int getQueryRouteTableSize() {
        return this._lastQRPTableReceived == null ? 0 : this._lastQRPTableReceived.getSize();
    }

    public int getQueryRouteTableEmptyUnits() {
        return this._lastQRPTableReceived == null ? -1 : this._lastQRPTableReceived.getEmptyUnits();
    }

    public int getQueryRouteTableUnitsInUse() {
        return this._lastQRPTableReceived == null ? -1 : this._lastQRPTableReceived.getUnitsInUse();
    }

    protected OutputStream createDeflatedOutputStream(OutputStream out) {
        if (this.isAsynchronous()) {
            return out;
        }
        return super.createDeflatedOutputStream(out);
    }

    protected InputStream createInflatedInputStream(InputStream in) {
        if (this.isAsynchronous()) {
            return in;
        }
        return super.createInflatedInputStream(in);
    }

    protected OutputStream getOutputStream() throws IOException {
        return new ThrottledOutputStream(super.getOutputStream(), _throttle);
    }

    public Message receive() throws IOException, BadPacketException {
        Message m = null;
        try {
            m = super.receive();
        }
        catch (IOException e) {
            if (this._manager != null) {
                this._manager.remove(this);
            }
            throw e;
        }
        this._connectionStats.addReceived();
        return m;
    }

    public Message receive(int timeout) throws IOException, BadPacketException, InterruptedIOException {
        Message m = null;
        try {
            m = super.receive(timeout);
        }
        catch (InterruptedIOException ioe) {
            throw ioe;
        }
        catch (IOException e) {
            if (this._manager != null) {
                this._manager.remove(this);
            }
            throw e;
        }
        this._connectionStats.addReceived();
        return m;
    }

    private void startOutput() {
        CompositeQueue queue = new CompositeQueue();
        if (this.isAsynchronous()) {
            MessageWriter messager = new MessageWriter(this._connectionStats, queue, this);
            this._outputRunner = messager;
            ChannelWriter writer = messager;
            if (this.isWriteDeflated()) {
                DeflaterWriter deflater = new DeflaterWriter(this._deflater);
                messager.setWriteChannel(deflater);
                writer = deflater;
            }
            DelayedBufferWriter delayer = new DelayedBufferWriter(1400);
            writer.setWriteChannel(delayer);
            writer = delayer;
            writer.setWriteChannel(new ThrottleWriter(_nbThrottle));
            ((NIOMultiplexor)((Object)this._socket)).setWriteObserver(messager);
        } else {
            this._outputRunner = new BlockingRunner(queue);
        }
    }

    public void send(Message m) {
        int smh;
        if (!this.supportsGGEP()) {
            m = m.stripExtendedPayload();
        }
        if ((smh = this.hopsFlowMax) > -1 && m instanceof QueryRequest && m.getHops() >= smh) {
            return;
        }
        this._outputRunner.send(m);
    }

    public void originateQuery(QueryRequest query) {
        query.originate();
        this.send(query);
    }

    public void flush() throws IOException {
    }

    public void close() {
        if (this._outputRunner != null) {
            this._outputRunner.shutdown();
        }
        super.close();
        GuidMapFactory.removeMap(this._guidMap);
    }

    void loopForMessages() throws IOException {
        this.supernodeClientAtLooping = this.isSupernodeClientConnection();
        if (!this.isAsynchronous()) {
            Thread.currentThread().setName("MessageLoopingThread");
            while (true) {
                Message m = null;
                try {
                    m = this.receive();
                    if (m == null) continue;
                    this.handleMessageInternal(m);
                }
                catch (BadPacketException badPacketException) {}
            }
        }
        this._socket.setSoTimeout(0);
        MessageReader reader = new MessageReader(this);
        if (this.isReadDeflated()) {
            reader.setReadChannel(new InflaterReader(this._inflater));
        }
        ((NIOMultiplexor)((Object)this._socket)).setReadObserver(reader);
    }

    public void messagingClosed() {
        if (this._manager != null) {
            this._manager.remove(this);
        }
    }

    public void processReadMessage(Message m) throws IOException {
        this.updateReadStatistics(m);
        this._connectionStats.addReceived();
        this.handleMessageInternal(m);
    }

    public void processSentMessage(Message m) {
        this.updateWriteStatistics(m);
    }

    private void handleMessageInternal(Message m) {
        if (this.isSpam(m)) {
            ReceivedMessageStatHandler.TCP_FILTERED_MESSAGES.addMessage(m);
            this._connectionStats.addReceivedDropped();
        } else {
            if (m instanceof QueryReply) {
                ++this.queryReplies;
                if (m.getHops() == 0) {
                    this.clientGUID = ((QueryReply)m).getClientGUID();
                }
                if (!this.isClientSupernodeConnection()) {
                    long sinceLast;
                    int history = (int)ConnectionSettings.FLUSH_DELAY_TIME.getValue();
                    history = Math.max(15, Math.min(40, history));
                    if (this.b == null || this.b.getCapacity() != history) {
                        this.b = new Buffer(history);
                    }
                    long now = System.currentTimeMillis();
                    this.b.add(new Long(now));
                    if (this.b.size() == this.b.getCapacity() && (sinceLast = now - (Long)this.b.last()) < 60000L && Math.random() > (double)((float)sinceLast / 60000.0f)) {
                        return;
                    }
                }
            }
            if (this.supernodeClientAtLooping) {
                if (m instanceof QueryRequest) {
                    m = this.tryToProxy((QueryRequest)m);
                } else if (m instanceof QueryStatusResponse) {
                    m = this.morphToStopQuery((QueryStatusResponse)m);
                }
            }
            MessageDispatcher.instance().dispatchTCP(m, this);
        }
    }

    public long getNumQueryReplies() {
        return this.queryReplies;
    }

    public int getNetwork() {
        return 1;
    }

    private QueryRequest tryToProxy(QueryRequest query) {
        if (this.remoteHostSupportsLeafGuidance() < 1) {
            return query;
        }
        if (query.desiresOutOfBandReplies()) {
            return query;
        }
        if (query.doNotProxy()) {
            return query;
        }
        if (!(RouterService.isOOBCapable() && OutOfBandThroughputStat.isSuccessRateGreat() && OutOfBandThroughputStat.isOOBEffectiveForProxy())) {
            return query;
        }
        byte[] origGUID = query.getGUID();
        byte[] oobGUID = new byte[origGUID.length];
        System.arraycopy(origGUID, 0, oobGUID, 0, origGUID.length);
        GUID.addressEncodeGuid(oobGUID, RouterService.getAddress(), RouterService.getPort());
        query = QueryRequest.createProxyQuery(query, oobGUID);
        this._guidMap.addMapping(origGUID, oobGUID);
        OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
        return query;
    }

    private QueryStatusResponse morphToStopQuery(QueryStatusResponse resp) {
        GUID oobGUID = this._guidMap.getNewGUID(resp.getQueryGUID());
        if (oobGUID != null) {
            return new QueryStatusResponse(oobGUID, resp.getNumResults());
        }
        return resp;
    }

    public boolean isSpam(Message m) {
        return !this._routeFilter.allow(m);
    }

    public void countDroppedMessage() {
        this._connectionStats.addReceivedDropped();
    }

    public boolean isPersonalSpam(Message m) {
        return !this._personalFilter.allow(m);
    }

    public void setRouteFilter(SpamFilter filter) {
        this._routeFilter = filter;
    }

    public void setPersonalFilter(SpamFilter filter) {
        this._personalFilter = filter;
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler receivingConnection) {
        this.send(pingReply);
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler receivingConnection) {
        byte[] origGUID;
        boolean checkOOB = true;
        if (this._guidMap != null && (origGUID = this._guidMap.getOriginalGUID(queryReply.getGUID())) != null) {
            checkOOB = false;
            byte prevHops = queryReply.getHops();
            queryReply = new QueryReply(origGUID, queryReply);
            queryReply.setTTL((byte)2);
            queryReply.setHops(prevHops);
        }
        if (checkOOB && queryReply.isUDP() && !queryReply.isReplyToMulticastQuery()) {
            return;
        }
        this.send(queryReply);
    }

    public byte[] getClientGUID() {
        return this.clientGUID;
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler receivingConnection) {
        this.send(pushRequest);
    }

    protected void handleVendorMessage(VendorMessage vm) {
        super.handleVendorMessage(vm);
        if (vm instanceof HopsFlowVendorMessage) {
            HopsFlowVendorMessage hops = (HopsFlowVendorMessage)vm;
            if (this.isSupernodeClientConnection()) {
                this.setBusy(hops.getHopValue() == 0);
            }
            this.hopsFlowMax = hops.getHopValue();
        } else if (vm instanceof PushProxyAcknowledgement) {
            PushProxyAcknowledgement ack = (PushProxyAcknowledgement)vm;
            if (Arrays.equals(ack.getGUID(), RouterService.getMessageRouter()._clientGUID)) {
                this._pushProxy = true;
            }
        } else if (vm instanceof CapabilitiesVM) {
            CapabilitiesVM capVM = (CapabilitiesVM)vm;
            if (capVM.supportsSIMPP() > SimppManager.instance().getVersion()) {
                SimppRequestVM simppReq = new SimppRequestVM();
                this.send(simppReq);
            }
            int latestId = UpdateHandler.instance().getLatestId();
            int currentId = capVM.supportsUpdate();
            if (currentId > latestId) {
                this.send(new UpdateRequest());
            } else if (currentId == latestId) {
                UpdateHandler.instance().handleUpdateAvailable(this, currentId);
            }
        } else if (vm instanceof MessagesSupportedVendorMessage) {
            if (this.isClientSupernodeConnection() && this.remoteHostSupportsLeafGuidance() >= 0) {
                SearchResultHandler srh = RouterService.getSearchResultHandler();
                List queries = srh.getQueriesToReSend();
                Iterator i = queries.iterator();
                while (i.hasNext()) {
                    this.send((Message)i.next());
                }
            }
            if (this.remoteHostSupportsPushProxy() > -1) {
                GUID clientGUID = new GUID(RouterService.getMessageRouter()._clientGUID);
                PushProxyRequest req = new PushProxyRequest(clientGUID);
                this.send(req);
            }
            if (!UDPService.instance().canReceiveUnsolicited() && _numUDPConnectBackRequests < 15 && this.remoteHostSupportsUDPRedirect() > -1) {
                GUID connectBackGUID = RouterService.getUDPConnectBackGUID();
                UDPConnectBackVendorMessage udp = new UDPConnectBackVendorMessage(RouterService.getPort(), connectBackGUID);
                this.send(udp);
                ++_numUDPConnectBackRequests;
            }
            if (!RouterService.acceptedIncomingConnection() && _numTCPConnectBackRequests < 10 && this.remoteHostSupportsTCPRedirect() > -1) {
                TCPConnectBackVendorMessage tcp = new TCPConnectBackVendorMessage(RouterService.getPort());
                this.send(tcp);
                ++_numTCPConnectBackRequests;
            }
        }
    }

    public int getNumMessagesSent() {
        return this._connectionStats.getSent();
    }

    public int getNumMessagesReceived() {
        return this._connectionStats.getReceived();
    }

    public int getNumSentMessagesDropped() {
        return this._connectionStats.getSentDropped();
    }

    public long getNumReceivedMessagesDropped() {
        return this._connectionStats.getReceivedDropped();
    }

    public float getPercentReceivedDropped() {
        return this._connectionStats.getPercentReceivedDropped();
    }

    public float getPercentSentDropped() {
        return this._connectionStats.getPercentSentDropped();
    }

    public void measureBandwidth() {
        this._upBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getBytesSent()));
        this._downBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getBytesReceived()));
    }

    public float getMeasuredUpstreamBandwidth() {
        float retValue = 0.0f;
        try {
            retValue = this._upBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            return 0.0f;
        }
        return retValue;
    }

    public float getMeasuredDownstreamBandwidth() {
        float retValue = 0.0f;
        try {
            retValue = this._downBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            return 0.0f;
        }
        return retValue;
    }

    public long getNextQRPForwardTime() {
        return this._nextQRPForwardTime;
    }

    public void incrementNextQRPForwardTime(long curTime) {
        this._nextQRPForwardTime = this.isLeafConnection() ? curTime + this.LEAF_QUERY_ROUTE_UPDATE_TIME : curTime + this.ULTRAPEER_QUERY_ROUTE_UPDATE_TIME;
    }

    public boolean isKillable() {
        return this._isKillable;
    }

    public QueryRouteTable getQueryRouteTableSent() {
        return this._lastQRPTableSent;
    }

    public void setQueryRouteTableSent(QueryRouteTable qrt) {
        this._lastQRPTableSent = qrt;
    }

    public boolean isPushProxy() {
        return this._pushProxy;
    }

    public Object getQRPLock() {
        return this.QRP_LOCK;
    }

    public void setLocalePreferencing(boolean b) {
        this._useLocalPreference = b;
    }

    public void reply(Message m) {
        this.send(m);
    }

    private class HandshakeWatcher
    implements HandshakeObserver {
        private Handshaker shaker;
        private GnetConnectObserver observer;

        HandshakeWatcher(GnetConnectObserver observer) {
            this.observer = observer;
        }

        void setHandshaker(Handshaker shaker) {
            this.shaker = shaker;
        }

        public void shutdown() {
            ManagedConnection.this.setHeaders(this.shaker);
            ManagedConnection.this.close();
            this.observer.shutdown();
        }

        public void handleHandshakeFinished(Handshaker shaker) {
            ManagedConnection.this.postHandshakeInitialize(shaker);
            this.observer.handleConnect();
        }

        public void handleBadHandshake() {
            ManagedConnection.this.setHeaders(this.shaker);
            ManagedConnection.this.close();
            this.observer.handleBadHandshake();
        }

        public void handleNoGnutellaOk(int code, String msg) {
            ManagedConnection.this.setHeaders(this.shaker);
            ManagedConnection.this.close();
            this.observer.handleNoGnutellaOk(code, msg);
        }
    }

    private class AsyncHandshakeConnecter
    implements ConnectObserver {
        private Properties requestHeaders;
        private HandshakeResponder responder;
        private GnetConnectObserver observer;

        AsyncHandshakeConnecter(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) {
            this.requestHeaders = requestHeaders;
            this.responder = responder;
            this.observer = observer;
        }

        public void handleConnect(Socket socket) throws IOException {
            ManagedConnection.this._socket = socket;
            ManagedConnection.this.preHandshakeInitialize(this.requestHeaders, this.responder, this.observer);
        }

        public void shutdown() {
            this.observer.shutdown();
        }

        public void handleIOException(IOException iox) {
        }
    }

    private class BlockingRunner
    implements Runnable,
    OutputRunner {
        private final Object LOCK = new Object();
        private final MessageQueue queue;
        private boolean shutdown = false;

        public BlockingRunner(MessageQueue queue) {
            this.queue = queue;
            ThreadFactory.startThread(this, "OutputRunner");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(Message m) {
            Object object = this.LOCK;
            synchronized (object) {
                ManagedConnection.this._connectionStats.addSent();
                this.queue.add(m);
                int dropped = this.queue.resetDropped();
                ManagedConnection.this._connectionStats.addSentDropped(dropped);
                this.LOCK.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.LOCK;
            synchronized (object) {
                this.shutdown = true;
                this.LOCK.notify();
            }
        }

        public void run() {
            try {
                while (true) {
                    this.waitForQueued();
                    this.sendQueued();
                }
            }
            catch (IOException e) {
                if (ManagedConnection.this._manager != null) {
                    ManagedConnection.this._manager.remove(ManagedConnection.this);
                }
            }
            catch (Throwable t) {
                if (ManagedConnection.this._manager != null) {
                    ManagedConnection.this._manager.remove(ManagedConnection.this);
                }
                ErrorService.error(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void waitForQueued() throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                while (!this.shutdown && ManagedConnection.this.isOpen() && this.queue.isEmpty()) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (!ManagedConnection.this.isOpen() || this.shutdown) {
                throw Connection.CONNECTION_CLOSED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendQueued() throws IOException {
            while (true) {
                Message m = null;
                Object object = this.LOCK;
                synchronized (object) {
                    m = this.queue.removeNext();
                    int dropped = this.queue.resetDropped();
                    ManagedConnection.this._connectionStats.addSentDropped(dropped);
                }
                if (m == null) break;
                ManagedConnection.super.send(m);
            }
            ManagedConnection.super.flush();
        }
    }
}

