/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.net.InetSocketAddress;

class MessageDispatcher {
    private static final MessageDispatcher INSTANCE = new MessageDispatcher();
    private final ProcessingQueue DISPATCH = new ProcessingQueue("MessageDispatch");

    private MessageDispatcher() {
    }

    public static MessageDispatcher instance() {
        return INSTANCE;
    }

    public void dispatchUDP(Message m, InetSocketAddress addr) {
        this.DISPATCH.add(new UDPDispatch(m, addr));
    }

    public void dispatchMulticast(Message m, InetSocketAddress addr) {
        this.DISPATCH.add(new MulticastDispatch(m, addr));
    }

    public void dispatchTCP(Message m, ManagedConnection conn) {
        this.DISPATCH.add(new TCPDispatch(m, conn));
    }

    private static class TCPDispatch
    implements Runnable {
        private static final MessageRouter ROUTER = RouterService.getMessageRouter();
        private final Message m;
        private final ManagedConnection conn;

        TCPDispatch(Message m, ManagedConnection conn) {
            this.m = m;
            this.conn = conn;
        }

        public void run() {
            ROUTER.handleMessage(this.m, this.conn);
        }
    }

    private static class MulticastDispatch
    implements Runnable {
        private static final MessageRouter ROUTER = RouterService.getMessageRouter();
        private final Message m;
        private final InetSocketAddress addr;

        MulticastDispatch(Message m, InetSocketAddress addr) {
            this.m = m;
            this.addr = addr;
        }

        public void run() {
            ROUTER.handleMulticastMessage(this.m, this.addr);
        }
    }

    private static class UDPDispatch
    implements Runnable {
        private static final MessageRouter ROUTER = RouterService.getMessageRouter();
        private final Message m;
        private final InetSocketAddress addr;

        UDPDispatch(Message m, InetSocketAddress addr) {
            this.m = m;
            this.addr = addr;
        }

        public void run() {
            ROUTER.handleUDPMessage(this.m, this.addr);
        }
    }
}

