/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.util.DualIterator;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ResponseVerifier {
    private ForgetfulHashMap mapper = new ForgetfulHashMap(15);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;

    public synchronized void record(QueryRequest qr) {
        this.record(qr, null);
    }

    public synchronized void record(QueryRequest qr, MediaType type) {
        byte[] guid = qr.getGUID();
        this.mapper.put(new GUID(guid), new RequestData(qr.getQuery(), qr.getRichQuery(), type, qr.isWhatIsNewRequest()));
    }

    public synchronized boolean matchesQuery(byte[] guid, Response response) {
        RequestData data = (RequestData)this.mapper.get(new GUID(guid));
        if (data == null || data.queryWords == null) {
            return false;
        }
        if (data.whatIsNew) {
            return true;
        }
        int minGood = FilterSettings.MIN_MATCHING_WORDS.getValue();
        if (ResponseVerifier.score(data.queryWords, response.getName()) > minGood) {
            return true;
        }
        LimeXMLDocument doc = response.getDocument();
        if (doc != null) {
            DualIterator iter = new DualIterator(doc.getKeyWords().iterator(), doc.getKeyWordsIndivisible().iterator());
            while (iter.hasNext()) {
                String xmlWord = (String)iter.next();
                if (ResponseVerifier.score(data.queryWords, xmlWord) <= minGood) continue;
                return true;
            }
        }
        return false;
    }

    public static int score(String query, LimeXMLDocument richQuery, RemoteFileDesc response) {
        return ResponseVerifier.score(ResponseVerifier.getSearchTerms(query, richQuery), response.getFileName());
    }

    private static int score(List queryWords, String filename) {
        int numMatchingWords = 0;
        int numQueryWords = queryWords.size();
        if (numQueryWords == 0) {
            return 100;
        }
        for (int i = 0; i < numQueryWords; ++i) {
            String pattern = (String)queryWords.get(i);
            if (!StringUtils.contains(filename, pattern, true)) continue;
            ++numMatchingWords;
        }
        return (int)(100.0f * ((float)numMatchingWords / (float)numQueryWords));
    }

    public boolean matchesType(byte[] guid, Response response) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null || request.type == null) {
            return true;
        }
        String reply = response.getName();
        return request.type.matches(reply);
    }

    public boolean isMandragoreWorm(byte[] guid, Response response) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(request.query + ".exe");
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static List getSearchTerms(String query, LimeXMLDocument richQuery) {
        String[] terms = null;
        HashSet<String> qWords = new HashSet<String>();
        terms = StringUtils.split(query.toLowerCase(), DELIMITERS);
        for (int i = 0; i < terms.length; ++i) {
            qWords.add(terms[i]);
        }
        List xmlWords = null;
        if (richQuery != null) {
            xmlWords = richQuery.getKeyWords();
            int size = xmlWords.size();
            for (int i = 0; i < size; ++i) {
                String currWord = (String)xmlWords.remove(0);
                qWords.add(currWord.toLowerCase());
            }
        }
        return Collections.unmodifiableList(new ArrayList(qWords));
    }

    private static class RequestData {
        final String query;
        final LimeXMLDocument richQuery;
        final List queryWords;
        final MediaType type;
        final boolean whatIsNew;

        RequestData(String query, MediaType type) {
            this(query, null, type, false);
        }

        RequestData(String query, LimeXMLDocument richQuery, MediaType type, boolean whatIsNew) {
            this.query = query;
            this.richQuery = richQuery;
            this.queryWords = ResponseVerifier.getSearchTerms(query, richQuery);
            this.type = type;
            this.whatIsNew = whatIsNew;
        }

        public boolean xmlQuery() {
            return this.richQuery != null;
        }
    }
}

