/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.FixedSizeSortedSet;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;

public class AlternateLocationCollection
implements HTTPHeaderValue {
    private static final int MAX_SIZE = 100;
    public static final AlternateLocationCollection EMPTY;
    private final FixedSizeSortedSet LOCATIONS = new FixedSizeSortedSet(100);
    private final URN SHA1;

    public static AlternateLocationCollection create(URN sha1) {
        return new AlternateLocationCollection(sha1);
    }

    public static AlternateLocationCollection createCollectionFromHttpValue(String value) {
        if (value == null) {
            throw new NullPointerException("cannot create an AlternateLocationCollection from a null value");
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        AlternateLocationCollection alc = null;
        while (st.hasMoreTokens()) {
            String curTok = st.nextToken();
            try {
                AlternateLocation al = AlternateLocation.create(curTok);
                if (alc == null) {
                    alc = new AlternateLocationCollection(al.getSHA1Urn());
                }
                if (!al.getSHA1Urn().equals(alc.getSHA1Urn())) continue;
                alc.add(al);
            }
            catch (IOException e) {}
        }
        return alc;
    }

    private AlternateLocationCollection(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null URN");
        }
        if (sha1 != null && !sha1.isSHA1()) {
            throw new IllegalArgumentException("URN must be a SHA1");
        }
        this.SHA1 = sha1;
    }

    public URN getSHA1Urn() {
        return this.SHA1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AlternateLocation al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alt = (AlternateLocation)this.LOCATIONS.get(al);
            boolean ret = false;
            if (alt == null) {
                ret = true;
                this.LOCATIONS.add(al);
            } else {
                this.LOCATIONS.remove(alt);
                alt.increment();
                alt.promote();
                alt.resetSent();
                ret = false;
                this.LOCATIONS.add(alt);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AlternateLocation al) {
        URN sha1 = al.getSHA1Urn();
        if (!sha1.equals(this.SHA1)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation loc = (AlternateLocation)this.LOCATIONS.get(al);
            if (loc == null) {
                return false;
            }
            if (loc.isDemoted()) {
                this.LOCATIONS.remove(loc);
                return true;
            }
            this.LOCATIONS.remove(loc);
            loc.demote();
            this.LOCATIONS.add(loc);
            return false;
        }
    }

    public synchronized void clear() {
        this.LOCATIONS.clear();
    }

    public synchronized boolean hasAlternateLocations() {
        return !this.LOCATIONS.isEmpty();
    }

    public synchronized boolean contains(AlternateLocation loc) {
        return this.LOCATIONS.contains(loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpStringValue() {
        String commaSpace = ", ";
        StringBuffer writeBuffer = new StringBuffer();
        boolean wrote = false;
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            Iterator iter = this.LOCATIONS.iterator();
            while (iter.hasNext()) {
                AlternateLocation current = (AlternateLocation)iter.next();
                writeBuffer.append(current.httpStringValue());
                writeBuffer.append(", ");
                wrote = true;
            }
        }
        if (wrote) {
            writeBuffer.setLength(writeBuffer.length() - 2);
        }
        return writeBuffer.toString();
    }

    public synchronized int getAltLocsSize() {
        return this.LOCATIONS.size();
    }

    public Iterator iterator() {
        return this.LOCATIONS.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Alternate Locations: ");
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            Iterator iter = this.LOCATIONS.iterator();
            while (iter.hasNext()) {
                AlternateLocation curLoc = (AlternateLocation)iter.next();
                sb.append(curLoc.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlternateLocationCollection)) {
            return false;
        }
        AlternateLocationCollection alc = (AlternateLocationCollection)o;
        boolean ret = this.SHA1.equals(alc.SHA1);
        if (!ret) {
            return false;
        }
        Class clazz = AlternateLocationCollection.class;
        synchronized (clazz) {
            AlternateLocationCollection alternateLocationCollection = this;
            synchronized (alternateLocationCollection) {
                AlternateLocationCollection alternateLocationCollection2 = alc;
                synchronized (alternateLocationCollection2) {
                    ret = this.LOCATIONS.equals(alc.LOCATIONS);
                }
            }
        }
        return ret;
    }

    static {
        EmptyCollection col = null;
        try {
            col = new EmptyCollection();
        }
        catch (IOException bad) {
            ErrorService.error(bad);
        }
        EMPTY = col;
    }

    private static class EmptyCollection
    extends AlternateLocationCollection {
        EmptyCollection() throws IOException {
            super(URN.createSHA1Urn("urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"));
        }

        public boolean add(AlternateLocation loc) {
            throw new UnsupportedOperationException();
        }
    }
}

