/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.archive;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.archive.Archives;
import com.limegroup.gnutella.archive.Contribution;
import com.limegroup.gnutella.archive.DescriptionTooShortException;
import com.limegroup.gnutella.archive.File;
import com.limegroup.gnutella.archive.IdentifierUnavailableException;
import com.limegroup.gnutella.archive.UploadListener;
import com.limegroup.gnutella.util.CoWList;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class AbstractContribution
implements Contribution {
    private String _title;
    private String _description;
    private int _media;
    private int _collection;
    private int _type;
    private String _username;
    private String _password;
    private final LinkedHashMap _files = new LinkedHashMap();
    private HashMap _fields = new HashMap();
    private volatile boolean _cancelled;
    private String _curFileName;
    private int _filesSent = 0;
    private long _totalBytesSent;
    protected long _totalUploadSize;
    protected final Map _fileNames2Progress = new HashMap();
    private int _id = 0;
    private final List _uploadListeners = new CoWList(CoWList.ARRAY_LIST);

    AbstractContribution() {
    }

    public abstract String getVerificationUrl();

    public abstract String requestIdentifier(String var1) throws IdentifierUnavailableException, IOException;

    public abstract String getIdentifier();

    public abstract void upload() throws IOException;

    public void addFileDesc(FileDesc fd) {
        this._files.put(fd, new File(fd));
    }

    public void removeFileDesc(FileDesc fd) {
        this._files.remove(fd);
    }

    public boolean containsFileDesc(FileDesc fd) {
        return this._files.containsKey(fd);
    }

    public void cancel() {
        this._cancelled = true;
    }

    boolean isCancelled() {
        return this._cancelled;
    }

    public Set getFileDescs() {
        return Collections.unmodifiableSet(this._files.keySet());
    }

    protected Collection getFiles() {
        return Collections.unmodifiableCollection(this._files.values());
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public void setDescription(String description) throws DescriptionTooShortException {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setMedia(int media) {
        if (Archives.getMediaString(media) == null) {
            throw new IllegalArgumentException("Invalid media type: " + media);
        }
        this._media = media;
    }

    public int getMedia() {
        return this._media;
    }

    public void setCollection(int collection) {
        if (Archives.getCollectionString(collection) == null) {
            throw new IllegalArgumentException("Invalid collection type: " + collection);
        }
        this._collection = collection;
    }

    public int getCollection() {
        return this._collection;
    }

    public void setType(int type) {
        if (Archives.getTypeString(type) == null) {
            throw new IllegalArgumentException("Invalid dublin-core type: " + type);
        }
        this._type = type;
    }

    public int getType() {
        return this._type;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public void setField(String field, String value) {
        this._fields.put(field, value);
    }

    public String getField(String field) {
        return (String)this._fields.get(field);
    }

    public void removeField(String field) {
        this._fields.remove(field);
    }

    protected Map getFields() {
        return Collections.unmodifiableMap(this._fields);
    }

    public void addListener(UploadListener l) {
        this._uploadListeners.add(l);
    }

    public void removeListener(UploadListener l) {
        this._uploadListeners.remove(l);
    }

    private void notifyStateChange() {
        Iterator i = this._uploadListeners.iterator();
        while (i.hasNext()) {
            UploadListener l = (UploadListener)i.next();
            switch (this._id) {
                case 2: {
                    l.fileStarted();
                    break;
                }
                case 3: {
                    l.fileProgressed();
                    break;
                }
                case 4: {
                    l.fileCompleted();
                    break;
                }
                case 1: {
                    l.connected();
                    break;
                }
                case 5: {
                    l.checkinStarted();
                    break;
                }
                case 6: {
                    l.checkinCompleted();
                    break;
                }
            }
        }
    }

    public synchronized int getFilesSent() {
        return this._filesSent;
    }

    public synchronized int getTotalFiles() {
        return this._fileNames2Progress.size();
    }

    public synchronized long getFileBytesSent() {
        return ((UploadFileProgress)this._fileNames2Progress.get(this._curFileName)).getBytesSent();
    }

    public synchronized long getFileSize() {
        return ((UploadFileProgress)this._fileNames2Progress.get(this._curFileName)).getFileSize();
    }

    public synchronized long getTotalBytesSent() {
        return this._totalBytesSent;
    }

    public synchronized long getTotalSize() {
        return this._totalUploadSize;
    }

    public synchronized String getFileName() {
        return this._curFileName;
    }

    public int getID() {
        return this._id;
    }

    void connected() {
        this._id = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileStarted(String fileName, long bytesSent) {
        this._id = 2;
        AbstractContribution abstractContribution = this;
        synchronized (abstractContribution) {
            this._curFileName = fileName;
            ((UploadFileProgress)this._fileNames2Progress.get(fileName)).setBytesSent(bytesSent);
        }
        this.notifyStateChange();
    }

    void fileStarted(String fileName) {
        this.fileStarted(fileName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileProgressed(long bytesSent) {
        this._id = 3;
        AbstractContribution abstractContribution = this;
        synchronized (abstractContribution) {
            UploadFileProgress progress = (UploadFileProgress)this._fileNames2Progress.get(this._curFileName);
            long delta = bytesSent - progress.getBytesSent();
            this._totalBytesSent += delta;
            progress.setBytesSent(bytesSent);
        }
        this.notifyStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileProgressedDelta(long bytesSentDelta) {
        this._id = 3;
        AbstractContribution abstractContribution = this;
        synchronized (abstractContribution) {
            this._totalBytesSent += bytesSentDelta;
            ((UploadFileProgress)this._fileNames2Progress.get(this._curFileName)).incrBytesSent(bytesSentDelta);
        }
        this.notifyStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileCompleted() {
        this._id = 4;
        AbstractContribution abstractContribution = this;
        synchronized (abstractContribution) {
            UploadFileProgress progress = (UploadFileProgress)this._fileNames2Progress.get(this._curFileName);
            progress.setBytesSent(progress.getFileSize());
            ++this._filesSent;
        }
        this.notifyStateChange();
    }

    void checkinStarted() {
        this._id = 5;
        this.notifyStateChange();
    }

    void checkinCompleted() {
        this._id = 6;
        this.notifyStateChange();
    }

    protected class UploadFileProgress {
        private final long _fileSize;
        private long _bytesSent = 0L;

        public UploadFileProgress(long fileSize) {
            this._fileSize = fileSize;
        }

        public long getFileSize() {
            return this._fileSize;
        }

        public long getBytesSent() {
            return this._bytesSent;
        }

        public void setBytesSent(long bytesSent) {
            this._bytesSent = bytesSent;
        }

        public void incrBytesSent(long bytesSentDelta) {
            this._bytesSent += bytesSentDelta;
        }
    }
}

