/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.archive;

import com.limegroup.gnutella.archive.AbstractContribution;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class UploadMonitorInputStream
extends FilterInputStream {
    private final AbstractContribution _uploadState;
    private long _markedPosition = 0L;

    UploadMonitorInputStream(InputStream in, AbstractContribution uploadEvent) {
        super(in);
        this._uploadState = uploadEvent;
    }

    public int read() throws InterruptedIOException, IOException {
        int result = super.read();
        if (result != -1) {
            this._uploadState.fileProgressedDelta(1L);
        }
        return result;
    }

    public int read(byte[] b) throws InterruptedIOException, IOException {
        int result = super.read(b);
        if (result != -1) {
            this._uploadState.fileProgressedDelta(result);
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws InterruptedIOException, IOException {
        int result = super.read(b, off, len);
        if (result != -1) {
            this._uploadState.fileProgressedDelta(off + result);
        }
        return result;
    }

    public long skip(long n) throws IOException {
        long result = super.skip(n);
        this._uploadState.fileProgressedDelta(result);
        return result;
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this._markedPosition = this._uploadState.getFileBytesSent();
    }

    public void reset() throws IOException {
        super.reset();
        this._uploadState.fileProgressed(this._markedPosition);
    }
}

