/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.DefaultBootstrapServers;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BootstrapServerManager {
    private static final Log LOG = LogFactory.getLog(BootstrapServerManager.class);
    private static final BootstrapServerManager INSTANCE = new BootstrapServerManager();
    public static final int CACHE_OFF = 0;
    public static final int FETCH_SCHEDULED = 1;
    public static final int FETCH_IN_PROGRESS = 2;
    public static final int FETCHED_TOO_MANY = 3;
    public static final int NO_CACHES_LEFT = 4;
    private static final int MAX_RESPONSES = 50;
    private static final int MAX_CACHES = 5;
    private static final int ENDPOINTS_TO_ADD = 10;
    private static final int MAX_BOOTSTRAP_SERVERS = 1000;
    public static int MAX_HOSTS_PER_REQUEST = 20;
    public static int UPDATE_DELAY_MSEC = 3600000;
    private final List SERVERS = new ArrayList();
    private BootstrapServer _lastConnectable;
    private Random _rand = new Random();
    private volatile boolean _hostFetchInProgress = false;
    private volatile int _lastIndex = 0;
    private volatile int _responsesAdded = 0;
    private boolean dirty = false;

    public static BootstrapServerManager instance() {
        return INSTANCE;
    }

    protected BootstrapServerManager() {
    }

    public synchronized void addBootstrapServer(BootstrapServer server) {
        if (server == null) {
            throw new NullPointerException("null bootstrap server not allowed");
        }
        if (!this.SERVERS.contains(server)) {
            this.dirty = true;
            this.SERVERS.add(server);
        }
        if (this.SERVERS.size() > 1000) {
            this.removeServer((BootstrapServer)this.SERVERS.get(0));
        }
    }

    public synchronized void bootstrapServersAdded() {
        this.addDefaultsIfNeeded();
        Collections.shuffle(this.SERVERS);
    }

    public synchronized void resetData() {
        this._lastIndex = 0;
        this._responsesAdded = 0;
        Collections.shuffle(this.SERVERS);
    }

    public boolean isEndpointFetchInProgress() {
        return this._hostFetchInProgress;
    }

    public synchronized void write(FileWriter out) throws IOException {
        Iterator iter = this.getBootstrapServers();
        while (iter.hasNext()) {
            BootstrapServer e = (BootstrapServer)iter.next();
            out.write(e.toString());
            out.write("\n");
        }
        this.dirty = false;
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }

    public synchronized Iterator getBootstrapServers() {
        return this.SERVERS.iterator();
    }

    public synchronized void fetchBootstrapServersAsync() {
        if (!ConnectionSettings.USE_GWEBCACHE.getValue()) {
            return;
        }
        this.addDefaultsIfNeeded();
        this.requestAsync(new UrlfileRequest(), "GWebCache urlfile");
    }

    public synchronized int fetchEndpointsAsync() {
        if (!ConnectionSettings.USE_GWEBCACHE.getValue()) {
            return 0;
        }
        this.addDefaultsIfNeeded();
        if (!this._hostFetchInProgress) {
            if (this._responsesAdded >= 50 && this._lastIndex >= 5) {
                return 3;
            }
            if (this._lastIndex >= this.size()) {
                return 4;
            }
            this._hostFetchInProgress = true;
            this.requestAsync(new HostfileRequest(), "GWebCache hostfile");
            return 1;
        }
        return 2;
    }

    public synchronized void sendUpdatesAsync(Endpoint myIP) {
        if (myIP == null) {
            throw new NullPointerException("cannot accept null update IP");
        }
        this.addDefaultsIfNeeded();
        try {
            if (!NetworkUtils.isPrivateAddress(myIP.getHostBytes())) {
                this.requestAsync(new UpdateRequest(myIP), "GWebCache update");
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private void addDefaultsIfNeeded() {
        if (this.SERVERS.size() > 0) {
            return;
        }
        DefaultBootstrapServers.addDefaults(this);
        Collections.shuffle(this.SERVERS);
    }

    private void requestAsync(final GWebCacheRequest request, String threadName) {
        if (request == null) {
            throw new NullPointerException("asynchronous request to null cache");
        }
        ThreadFactory.startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BootstrapServerManager.this.requestBlocking(request);
                }
                finally {
                    request.done();
                }
            }
        }, threadName);
    }

    private void requestBlocking(GWebCacheRequest request) {
        BootstrapServer e;
        if (request == null) {
            throw new NullPointerException("blocking request to null cache");
        }
        for (int i = 0; request.needsMoreData() && i < MAX_HOSTS_PER_REQUEST && (e = request.nextServer()) != null; ++i) {
            this.requestFromOneHost(request, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void requestFromOneHost(GWebCacheRequest request, BootstrapServer server) {
        GetMethod get;
        block20: {
            if (request == null) {
                throw new NullPointerException("null cache in request to one host");
            }
            if (server == null) {
                throw new NullPointerException("null server in request to one host");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("requesting: " + request + " from " + server);
            }
            BufferedReader in = null;
            String urlString = server.getURLString();
            String connectTo = urlString + "?client=" + "LIME" + "&version=" + URLEncoder.encode(CommonUtils.getLimeWireVersion()) + "&" + request.parameters();
            if (urlString.indexOf(".limewire.com/") > -1) {
                connectTo = connectTo + "&clientGUID=" + ApplicationSettings.CLIENT_ID.getValue();
            }
            HttpClient client = HttpClientManager.getNewClient(30000, 10000);
            try {
                get = new GetMethod(connectTo);
            }
            catch (IllegalArgumentException iae) {
                LOG.warn("Invalid server", iae);
                request.handleError(server);
                return;
            }
            get.addRequestHeader("Cache-Control", "no-cache");
            get.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
            get.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
            get.setFollowRedirects(false);
            try {
                try {
                    HttpClientManager.executeMethodRedirecting(client, get);
                    InputStream is = get.getResponseBodyAsStream();
                    if (is == null) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Invalid server: " + server);
                        }
                        request.handleError(server);
                        Object var14_11 = null;
                        if (get == null) return;
                        get.releaseConnection();
                        get.abort();
                        return;
                    }
                    in = new BufferedReader(new InputStreamReader(is));
                    if (get.getStatusCode() < 200 || get.getStatusCode() >= 300) {
                        if (!LOG.isWarnEnabled()) throw new IOException("no 2XX ok.");
                        LOG.warn("Invalid status code: " + get.getStatusCode());
                        throw new IOException("no 2XX ok.");
                    }
                    boolean firstLine = true;
                    boolean errors = false;
                    while (true) {
                        String line;
                        if ((line = in.readLine()) == null) {
                            if (!errors) {
                                break;
                            }
                            break block20;
                        }
                        if (firstLine && StringUtils.startsWithIgnoreCase(line, "ERROR")) {
                            request.handleError(server);
                            errors = true;
                        } else {
                            boolean retVal = request.handleResponseData(server, line);
                            if (!errors) {
                                errors = !retVal;
                            }
                        }
                        firstLine = false;
                    }
                    this._lastConnectable = server;
                }
                catch (IOException ioe) {
                    LOG.warn("Exception while handling server", ioe);
                    request.handleError(server);
                    Object var14_13 = null;
                    if (get == null) return;
                    get.releaseConnection();
                    get.abort();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (get == null) throw throwable;
                get.releaseConnection();
                get.abort();
                throw throwable;
            }
        }
        Object var14_12 = null;
        if (get == null) return;
        get.releaseConnection();
        get.abort();
    }

    protected synchronized int size() {
        return this.SERVERS.size();
    }

    protected int randomServer() {
        return this._rand.nextInt(this.SERVERS.size());
    }

    protected synchronized void removeServer(BootstrapServer server) {
        this.dirty = true;
        this.SERVERS.remove(server);
        this._lastIndex = Math.max(0, this._lastIndex - 1);
    }

    private final class UpdateRequest
    extends GWebCacheRequest {
        private boolean gotResponse;
        private Endpoint myIP;

        protected UpdateRequest(Endpoint myIP) {
            this.gotResponse = false;
            this.myIP = myIP;
        }

        protected String parameters() {
            String urlPart = null;
            if (BootstrapServerManager.this._lastConnectable != null) {
                urlPart = "url=" + URLEncoder.encode(BootstrapServerManager.this._lastConnectable.getURLString());
            }
            String ipPart = null;
            if (this.myIP != null) {
                ipPart = "ip=" + this.myIP.getAddress() + ":" + this.myIP.getPort();
            }
            if (urlPart == null && ipPart == null) {
                return "";
            }
            if (urlPart != null && ipPart == null) {
                return urlPart;
            }
            if (urlPart == null && ipPart != null) {
                return ipPart;
            }
            Assert.that(urlPart != null && ipPart != null);
            return ipPart + "&" + urlPart;
        }

        protected boolean handleResponseData(BootstrapServer server, String line) {
            if (StringUtils.startsWithIgnoreCase(line, "OK")) {
                this.gotResponse = true;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return !this.gotResponse;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "update request";
        }
    }

    private final class UrlfileRequest
    extends GWebCacheRequest {
        private int responses;

        private UrlfileRequest() {
            this.responses = 0;
        }

        protected String parameters() {
            return "urlfile=1";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean handleResponseData(BootstrapServer server, String line) {
            try {
                BootstrapServer e = new BootstrapServer(line);
                BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
                synchronized (bootstrapServerManager) {
                    BootstrapServerManager.this.addBootstrapServer(e);
                }
                ++this.responses;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Added bootstrap host: " + e);
                }
                ConnectionSettings.LAST_GWEBCACHE_FETCH_TIME.setValue(System.currentTimeMillis());
            }
            catch (ParseException error) {
                this.handleError(server);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "urlfile request";
        }
    }

    private final class HostfileRequest
    extends GWebCacheRequest {
        private int responses;

        private HostfileRequest() {
            this.responses = 0;
        }

        protected String parameters() {
            return "hostfile=1";
        }

        protected boolean handleResponseData(BootstrapServer server, String line) {
            try {
                Endpoint host = new Endpoint(line, true);
                RouterService.getHostCatcher().add(host, 2);
                ++this.responses;
                BootstrapServerManager.this._responsesAdded++;
            }
            catch (IllegalArgumentException bad) {
                this.handleError(server);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }

        protected void done() {
            BootstrapServerManager.this._hostFetchInProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BootstrapServer nextServer() {
            BootstrapServer e = null;
            HostfileRequest hostfileRequest = this;
            synchronized (hostfileRequest) {
                if (BootstrapServerManager.this._lastIndex >= BootstrapServerManager.this.SERVERS.size()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Used up all servers, last: " + BootstrapServerManager.this._lastIndex);
                    }
                } else {
                    e = (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this._lastIndex);
                    BootstrapServerManager.this._lastIndex++;
                }
            }
            return e;
        }

        public String toString() {
            return "hostfile request";
        }
    }

    private abstract class GWebCacheRequest {
        private GWebCacheRequest() {
        }

        protected abstract String parameters();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleError(BootstrapServer server) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error on server: " + server);
            }
            BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
            synchronized (bootstrapServerManager) {
                BootstrapServerManager.this.removeServer(server);
                if (BootstrapServerManager.this._lastConnectable == server) {
                    BootstrapServerManager.this._lastConnectable = null;
                }
            }
        }

        protected abstract boolean handleResponseData(BootstrapServer var1, String var2);

        protected abstract boolean needsMoreData();

        protected abstract BootstrapServer nextServer();

        protected void done() {
        }
    }
}

