/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.bugs.LocalAbstractInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.settings.SettingsFactory;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.NameValuePair;

public final class LocalClientInfo
extends LocalAbstractInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalClientInfo(Throwable bug, String threadName, String detail, boolean fatal) {
        SettingsFactory sf;
        this._limewireVersion = CommonUtils.getLimeWireVersion();
        this._javaVersion = CommonUtils.getJavaVersion();
        this._javaVendor = this.prop("java.vendor");
        this._os = CommonUtils.getOS();
        this._osVersion = this.prop("os.version");
        this._architecture = this.prop("os.arch");
        this._freeMemory = "" + Runtime.getRuntime().freeMemory();
        this._totalMemory = "" + Runtime.getRuntime().totalMemory();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        bug.printStackTrace(pw);
        pw.flush();
        this._bug = sw.toString();
        this._currentThread = threadName;
        this._bugName = bug.getClass().getName();
        this._fatalError = "" + fatal;
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        File propsFile = new File(CommonUtils.getUserSettingsDir(), "limewire.props");
        Properties props = new Properties();
        SettingsFactory settingsFactory = sf = LimeProps.instance().getFactory();
        synchronized (settingsFactory) {
            Iterator it = sf.iterator();
            while (it.hasNext()) {
                Setting set = (Setting)it.next();
                if (set.isPrivate() || set.isDefault()) continue;
                props.put(set.getKey(), set.getValueAsString());
            }
        }
        props.list(pw);
        pw.flush();
        this._props = sw.toString();
        if (GUIMediator.isConstructed() && RouterService.isStarted()) {
            this._upTime = CommonUtils.seconds2time((int)(RouterService.getCurrentUptime() / 1000L));
            this._connected = "" + RouterService.isConnected();
            this._upToUp = "" + RouterService.getNumUltrapeerToUltrapeerConnections();
            this._upToLeaf = "" + RouterService.getNumUltrapeerToLeafConnections();
            this._leafToUp = "" + RouterService.getNumLeafToUltrapeerConnections();
            this._oldConnections = "" + RouterService.getNumOldConnections();
            this._ultrapeer = "" + RouterService.isSupernode();
            this._leaf = "" + RouterService.isShieldedLeaf();
            this._activeUploads = "" + RouterService.getNumUploads();
            this._queuedUploads = "" + RouterService.getNumQueuedUploads();
            this._activeDownloads = "" + RouterService.getNumActiveDownloads();
            this._httpDownloaders = "" + RouterService.getNumIndividualDownloaders();
            this._waitingDownloaders = "" + RouterService.getNumWaitingDownloads();
            this._acceptedIncoming = "" + RouterService.acceptedIncomingConnection();
            this._sharedFiles = "" + RouterService.getNumSharedFiles();
            this._guessCapable = "" + RouterService.isGUESSCapable();
            this._solicitedCapable = "" + RouterService.canReceiveSolicited();
            this._latestSIMPP = "" + SimppManager.instance().getVersion();
            this._portStable = "" + UDPService.instance().portStable();
            this._canDoFWT = "" + UDPService.instance().canDoFWT();
            this._lastReportedPort = "" + UDPService.instance().lastReportedPort();
            this._externalPort = "" + RouterService.getPort();
            this._receivedIpPong = "" + UDPService.instance().receivedIpPong();
            this._responseSize = "" + RouterService.getContentResponsesSize();
            this._creationCacheSize = "" + RouterService.getCreationCacheSize();
            this._vfByteSize = "" + RouterService.getVerifyingFileByteCacheSize();
            this._vfVerifyingSize = "" + RouterService.getVerifyingFileVerifyingCacheSize();
            this._bbSize = "" + RouterService.getByteBufferCacheSize();
            this._vfQueueSize = "" + RouterService.getVerifyingFileQueueSize();
            this._waitingSockets = "" + RouterService.getNumberOfWaitingSockets();
            this._pendingTimeouts = "" + RouterService.getNumberOfPendingTimeouts();
        }
        this._detail = detail;
        Thread[] allThreads = new Thread[Thread.activeCount()];
        int copied = Thread.enumerate(allThreads);
        this._threadCount = "" + copied;
        HashMap<String, Integer> threads = new HashMap<String, Integer>();
        for (int i = 0; i < copied; ++i) {
            String name = allThreads[i].getName();
            Object val = threads.get(name);
            if (val == null) {
                threads.put(name, new Integer(1));
                continue;
            }
            int num = (Integer)val + 1;
            threads.put(name, new Integer(num));
        }
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        Iterator i = threads.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry info = i.next();
            pw.println(info.getKey() + ": " + info.getValue());
        }
        pw.flush();
        this._otherThreads = sw.toString();
    }

    private final String prop(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            return "?";
        }
        return value;
    }

    public final NameValuePair[] getPostRequestParams() {
        LinkedList params = new LinkedList();
        this.append(params, "1", this._limewireVersion);
        this.append(params, "2", this._javaVersion);
        this.append(params, "3", this._os);
        this.append(params, "4", this._osVersion);
        this.append(params, "5", this._architecture);
        this.append(params, "6", this._freeMemory);
        this.append(params, "7", this._totalMemory);
        this.append(params, "8", this._bug);
        this.append(params, "9", this._currentThread);
        this.append(params, "10", this._props);
        this.append(params, "11", this._upTime);
        this.append(params, "12", this._connected);
        this.append(params, "13", this._upToUp);
        this.append(params, "14", this._upToLeaf);
        this.append(params, "15", this._leafToUp);
        this.append(params, "16", this._oldConnections);
        this.append(params, "17", this._ultrapeer);
        this.append(params, "18", this._leaf);
        this.append(params, "19", this._activeUploads);
        this.append(params, "20", this._queuedUploads);
        this.append(params, "21", this._activeDownloads);
        this.append(params, "22", this._httpDownloaders);
        this.append(params, "23", this._waitingDownloaders);
        this.append(params, "24", this._acceptedIncoming);
        this.append(params, "25", this._sharedFiles);
        this.append(params, "26", this._otherThreads);
        this.append(params, "27", this._detail);
        this.append(params, "28", this._otherBug);
        this.append(params, "29", this._javaVendor);
        this.append(params, "30", this._threadCount);
        this.append(params, "31", this._bugName);
        this.append(params, "32", this._guessCapable);
        this.append(params, "33", this._solicitedCapable);
        this.append(params, "34", this._latestSIMPP);
        this.append(params, "36", this._portStable);
        this.append(params, "37", this._canDoFWT);
        this.append(params, "38", this._lastReportedPort);
        this.append(params, "39", this._externalPort);
        this.append(params, "40", this._receivedIpPong);
        this.append(params, "41", this._fatalError);
        this.append(params, "42", this._responseSize);
        this.append(params, "43", this._creationCacheSize);
        this.append(params, "45", this._vfByteSize);
        this.append(params, "44", this._vfVerifyingSize);
        this.append(params, "46", this._bbSize);
        this.append(params, "47", this._vfQueueSize);
        this.append(params, "48", this._waitingSockets);
        this.append(params, "49", this._pendingTimeouts);
        return params.toArray(new NameValuePair[params.size()]);
    }

    private final void append(List l, String k, String v) {
        if (v != null) {
            l.add(new NameValuePair(k, v));
        }
    }
}

