/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.bugs.RemoteClientInfo;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ServletAccessor {
    private static final Log LOG = LogFactory.getLog(ServletAccessor.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String SERVLET_URL = "http://bugreports.limewire.com/bugs/servlet/BugHandler";
    private volatile RemoteClientInfo _remoteInfo = null;

    ServletAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized RemoteClientInfo getRemoteBugInfo(LocalClientInfo localInfo) {
        NameValuePair[] params = localInfo.getPostRequestParams();
        Object remoteInfo = null;
        PostMethod post = new PostMethod(SERVLET_URL);
        post.addRequestHeader("Cache-Control", "no-cache");
        post.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        post.setFollowRedirects(false);
        post.addParameters(params);
        HttpClient client = HttpClientManager.getNewClient();
        client.setConnectionTimeout(10000);
        this._remoteInfo = new RemoteClientInfo();
        try {
            client.executeMethod(post);
            String response = post.getResponseBodyAsString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got response: " + response);
            }
            if (post.getStatusCode() == 200) {
                this._remoteInfo.addRemoteInfo(response);
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Servlet connect failed, code: " + post.getStatusCode());
                }
                this._remoteInfo.connectFailed();
            }
        }
        catch (IOException ioe) {
            LOG.error("Error connecting to bug servlet", ioe);
            this._remoteInfo.connectFailed();
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return this._remoteInfo;
    }
}

