/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.AsyncDimeRecordReader;
import com.limegroup.gnutella.dime.DIMEException;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.io.ReadState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncDimeParser
extends ReadState {
    private static final Log LOG = LogFactory.getLog(AsyncDimeParser.class);
    private boolean lastRead = false;
    private List records = new LinkedList();
    private long amountRead = 0L;
    private AsyncDimeRecordReader reader;

    protected boolean processRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        do {
            DIMERecord next;
            if (this.lastRead) {
                throw new IOException("already read last message.");
            }
            if (this.reader == null) {
                this.reader = new AsyncDimeRecordReader();
            }
            try {
                if (this.reader.process(channel, buffer)) {
                    return true;
                }
            }
            catch (DIMEException de) {
                LOG.warn("Error processing DIME", de);
                this.amountRead += this.reader.getAmountProcessed();
                return false;
            }
            this.amountRead += this.reader.getAmountProcessed();
            try {
                next = this.reader.getRecord();
            }
            catch (DIMEException de) {
                LOG.warn("Error constructing DIME record", de);
                return false;
            }
            if (next.isLastRecord()) {
                this.lastRead = true;
            }
            if (this.records.isEmpty() && !next.isFirstRecord()) {
                throw new IOException("middle of stream.");
            }
            if (!this.records.isEmpty() && next.isFirstRecord()) {
                throw new IOException("two first records.");
            }
            this.records.add(next);
            this.reader = null;
        } while (!this.lastRead);
        return false;
    }

    public List getRecords() {
        return this.records;
    }

    public long getAmountProcessed() {
        return this.amountRead;
    }
}

