/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.RandomDownloadStrategy;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.SystemUtils;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BiasedRandomDownloadStrategy
extends RandomDownloadStrategy {
    private static final Log LOG = LogFactory.getLog(BiasedRandomDownloadStrategy.class);
    private static final int MIN_PREVIEW_BYTES = 0x100000;
    private static final float MIN_PREVIEW_FRACTION = 0.1f;
    private static final float MAX_PREVIEW_FRACTION = 0.5f;
    static final int MIN_IDLE_MILLISECONDS = 300000;

    public BiasedRandomDownloadStrategy(long fileSize) {
        super(fileSize);
    }

    public synchronized Interval pickAssignment(IntervalSet candidateBytes, IntervalSet neededBytes, long blockSize) throws NoSuchElementException {
        long lowerBound = neededBytes.getFirst().low;
        long upperBound = neededBytes.getLast().high;
        if (blockSize < 1L) {
            throw new IllegalArgumentException("Block size cannot be " + blockSize);
        }
        if (lowerBound < 0L) {
            throw new IllegalArgumentException("First needed byte must be >= 0, " + lowerBound + "<0");
        }
        if (upperBound >= this.completedSize) {
            throw new IllegalArgumentException("neededBytes contains bytes beyond the end of the file." + upperBound + " >= " + this.completedSize);
        }
        if (candidateBytes.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.getIdleTime() >= 300000L || pseudoRandom.nextFloat() >= this.getBiasProbability(lowerBound, this.completedSize)) {
            return super.pickAssignment(candidateBytes, neededBytes, blockSize);
        }
        Interval candidate = candidateBytes.getFirst();
        long alignedHigh = this.alignHigh(candidate.low, blockSize);
        if (alignedHigh > (long)candidate.high) {
            alignedHigh = candidate.high;
        }
        Interval ret = candidate;
        if ((long)ret.high != alignedHigh) {
            ret = new Interval(candidate.low, alignedHigh);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Non-random download, probability=" + this.getBiasProbability(lowerBound, this.completedSize) + ", range=" + ret + " out of choices " + candidateBytes);
        }
        return ret;
    }

    private float getBiasProbability(long previewBytesDownloaded, long fileSize) {
        long goal = Math.max(0x100000L, (long)(0.1f * (float)fileSize));
        if (previewBytesDownloaded < goal) {
            return 1.0f;
        }
        if ((float)previewBytesDownloaded < 0.5f * (float)fileSize) {
            return 0.5f;
        }
        return 0.0f;
    }

    protected long getIdleTime() {
        return SystemUtils.getIdleTime();
    }
}

