/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.version.DownloadInformation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class InNetworkDownloader
extends ManagedDownloader
implements Serializable {
    static final long serialVersionUID = 5713913674943019353L;
    private final long size;
    private final URN urn;
    private final String ttRoot;
    private int downloadAttempts;
    private final long startTime;

    public InNetworkDownloader(IncompleteFileManager incompleteFileManager, DownloadInformation info, File dir, long startTime) throws SaveLocationException {
        super(new RemoteFileDesc[0], incompleteFileManager, null, dir, info.getUpdateFileName(), true);
        if (info.getSize() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size too big for now.");
        }
        this.size = info.getSize();
        this.urn = info.getUpdateURN();
        this.ttRoot = info.getTTRoot();
        this.startTime = startTime;
    }

    protected File getIncompleteFile(IncompleteFileManager ifm, String name, URN urn, int length) throws IOException {
        return ifm.getFile(name, urn, length, new File(FileManager.PREFERENCE_SHARE, "Incomplete"));
    }

    protected SourceRanker getSourceRanker(SourceRanker oldRanker) {
        if (oldRanker != null) {
            return oldRanker;
        }
        return new LegacyRanker();
    }

    public void initialize(DownloadManager manager, FileManager fileManager, DownloadCallback callback) {
        super.initialize(manager, fileManager, callback);
        if (this.downloadSHA1 == null) {
            this.downloadSHA1 = this.urn;
            RouterService.getAltlocManager().addListener(this.downloadSHA1, this);
        }
    }

    public synchronized void startDownload() {
        ++this.downloadAttempts;
        super.startDownload();
    }

    protected boolean shouldValidate(boolean deserialized) {
        return false;
    }

    protected void initializeVerifyingFile() throws IOException {
        super.initializeVerifyingFile();
        if (this.commonOutFile != null) {
            this.commonOutFile.setExpectedHashTreeRoot(this.ttRoot);
        }
    }

    public synchronized int getContentLength() {
        return (int)this.size;
    }

    protected synchronized QueryRequest newRequery(int numRequeries) throws CantResumeException {
        QueryRequest qr = super.newRequery(numRequeries);
        qr.setTTL((byte)2);
        return qr;
    }

    public synchronized int getNumAttempts() {
        return this.downloadAttempts;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

