/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskException;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedDownloader
implements Downloader,
MeshHandler,
AltLocListener,
Serializable {
    private static final Log LOG = LogFactory.getLog(ManagedDownloader.class);
    static final long serialVersionUID = 2772570805975885257L;
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.NO_FIELDS;
    private static int unknownIndex = 0;
    private DownloadManager manager;
    private FileManager fileManager;
    protected IncompleteFileManager incompleteFileManager;
    private DownloadCallback callback;
    private Set cachedRFDs;
    private SourceRanker ranker;
    static int TIME_BETWEEN_REQUERIES = 300000;
    private static final int GUESS_WAIT_TIME = 5000;
    private static final int CONNECTING_WAIT_TIME = 750;
    private static final int REQUERY_ATTEMPTS = 1;
    private static final int MATCHER_BUF_SIZE = 120;
    protected static final String UNKNOWN_FILENAME = "";
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private volatile Thread dloaderManagerThread;
    private volatile boolean stopped;
    private volatile boolean paused;
    private volatile boolean invalidated;
    private volatile List _activeWorkers;
    private List _workers;
    private volatile Map _queuedWorkers;
    private Set currentRFDs;
    protected URN downloadSHA1;
    private Set validAlts;
    private Set invalidAlts;
    private Set recentInvalidAlts;
    protected VerifyingFile commonOutFile;
    private PushList pushes;
    private int state;
    private long stateTime;
    protected File incompleteFile;
    private int queuePosition;
    private String queuedVendor;
    private volatile int corruptFileBytes;
    private volatile File corruptFile;
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private volatile int corruptState;
    private Object corruptStateLock;
    private Object altLock;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private final GUID originalQueryGUID;
    protected boolean deserializedFromDisk;
    private int numQueries;
    private boolean triedLocatingSources;
    private volatile boolean receivedNewSources;
    private long lastQuerySent;
    private volatile int inactivePriority;
    protected Map attributes = new HashMap();
    protected Map propertiesMap;
    protected static final String DEFAULT_FILENAME = "defaultFileName";
    protected static final String FILE_SIZE = "fileSize";
    protected static final String ATTRIBUTES = "attributes";
    protected static final String SAVE_FILE = "saveFile";
    protected static final String SHA1_URN = "sha1Urn";
    private static boolean initDone = false;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    static boolean NO_DELAY = false;

    public ManagedDownloader(RemoteFileDesc[] files, IncompleteFileManager ifc, GUID originalQueryGUID, File saveDirectory, String fileName, boolean overwrite) throws SaveLocationException {
        this(files, ifc, originalQueryGUID);
        Assert.that(files.length > 0 || fileName != null);
        if (files.length == 0) {
            this.propertiesMap.put(DEFAULT_FILENAME, fileName);
        }
        this.setSaveFile(saveDirectory, fileName, overwrite);
    }

    protected ManagedDownloader(RemoteFileDesc[] files, IncompleteFileManager ifc, GUID originalQueryGUID) {
        if (files == null) {
            throw new NullPointerException("null RFDS");
        }
        if (ifc == null) {
            throw new NullPointerException("null incomplete file manager");
        }
        this.cachedRFDs = new HashSet();
        this.cachedRFDs.addAll(Arrays.asList(files));
        this.propertiesMap = new HashMap();
        if (files.length > 0) {
            this.initPropertiesMap(files[0]);
        }
        this.incompleteFileManager = ifc;
        this.originalQueryGUID = originalQueryGUID;
        this.deserializedFromDisk = false;
    }

    protected synchronized void initPropertiesMap(RemoteFileDesc rfd) {
        if (this.propertiesMap.get(DEFAULT_FILENAME) == null) {
            this.propertiesMap.put(DEFAULT_FILENAME, rfd.getFileName());
        }
        if (this.propertiesMap.get(FILE_SIZE) == null) {
            this.propertiesMap.put(FILE_SIZE, new Integer(rfd.getSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        IncompleteFileManager ifm;
        HashSet cached = new HashSet();
        HashMap properties = new HashMap();
        Serializable serializable = this;
        synchronized (serializable) {
            cached.addAll(this.cachedRFDs);
            properties.putAll(this.propertiesMap);
            ifm = this.incompleteFileManager;
        }
        stream.writeObject(cached);
        serializable = ifm;
        synchronized (serializable) {
            stream.writeObject(ifm);
        }
        if (!this.propertiesMap.containsKey(ATTRIBUTES)) {
            this.propertiesMap.put(ATTRIBUTES, this.attributes);
        }
        stream.writeObject(properties);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.deserializedFromDisk = true;
        Object next = stream.readObject();
        RemoteFileDesc defaultRFD = null;
        if (next instanceof RemoteFileDesc[]) {
            RemoteFileDesc[] rfds = (RemoteFileDesc[])next;
            if (rfds != null && rfds.length > 0) {
                defaultRFD = rfds[0];
            }
            this.cachedRFDs = new HashSet<RemoteFileDesc>(Arrays.asList(rfds));
        } else {
            this.cachedRFDs = (Set)next;
            if (this.cachedRFDs.size() > 0) {
                defaultRFD = (RemoteFileDesc)this.cachedRFDs.iterator().next();
            }
        }
        this.incompleteFileManager = (IncompleteFileManager)stream.readObject();
        Object map = stream.readObject();
        if (map instanceof Map) {
            this.propertiesMap = (Map)map;
        } else if (this.propertiesMap == null) {
            this.propertiesMap = new HashMap();
        }
        if (defaultRFD != null) {
            this.initPropertiesMap(defaultRFD);
        }
        if (this.propertiesMap.get(DEFAULT_FILENAME) == null) {
            this.propertiesMap.put(DEFAULT_FILENAME, "Unknown " + ++unknownIndex);
        }
        if (this.propertiesMap.containsKey(ATTRIBUTES)) {
            this.attributes = (Map)this.propertiesMap.get(ATTRIBUTES);
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DownloadManager manager, FileManager fileManager, DownloadCallback callback) {
        this.manager = manager;
        this.fileManager = fileManager;
        this.callback = callback;
        this.currentRFDs = new HashSet();
        this._activeWorkers = new LinkedList();
        this._workers = new ArrayList();
        this._queuedWorkers = new HashMap();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stopped = false;
        this.paused = false;
        this.setState(0);
        this.pushes = new PushList();
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.altLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.queuePosition = Integer.MAX_VALUE;
        this.queuedVendor = UNKNOWN_FILENAME;
        this.triedLocatingSources = false;
        this.ranker = this.getSourceRanker(null);
        this.ranker.setMeshHandler(this);
        if (this.downloadSHA1 == null) {
            this.downloadSHA1 = (URN)this.propertiesMap.get(SHA1_URN);
        }
        Object object = this;
        synchronized (object) {
            Iterator iter = this.cachedRFDs.iterator();
            while (iter.hasNext() && this.downloadSHA1 == null) {
                RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
                this.downloadSHA1 = rfd.getSHA1Urn();
            }
        }
        if (this.downloadSHA1 != null) {
            RouterService.getAltlocManager().addListener(this.downloadSHA1, this);
            this.propertiesMap.put(SHA1_URN, this.downloadSHA1);
        }
        this.verifyAllFiles();
        object = this.altLock;
        synchronized (object) {
            this.validAlts = new HashSet();
            this.invalidAlts = new FixedSizeExpiringSet(1000, 3600000L);
            this.recentInvalidAlts = new FixedSizeExpiringSet(10, 600000L);
        }
        object = this;
        synchronized (object) {
            if (this.shouldInitAltLocs(this.deserializedFromDisk)) {
                this.initializeAlternateLocations();
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
        }
        catch (IOException bad) {
            this.setState(7);
            return;
        }
        this.setState(0);
    }

    private synchronized void verifyAllFiles() {
        if (this.downloadSHA1 == null) {
            return;
        }
        Iterator iter = this.cachedRFDs.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (rfd.getSHA1Urn() == null || this.downloadSHA1.equals(rfd.getSHA1Urn())) continue;
            iter.remove();
        }
    }

    public synchronized void startDownload() {
        Assert.that(this.dloaderManagerThread == null, "already started");
        ThreadFactory.startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ManagedDownloader.this.dloaderManagerThread = Thread.currentThread();
                    ManagedDownloader.this.validateDownload();
                    ManagedDownloader.this.receivedNewSources = false;
                    int status = ManagedDownloader.this.performDownload();
                    ManagedDownloader.this.completeDownload(status);
                }
                catch (Throwable t) {
                    ManagedDownloader.this.stop();
                    ManagedDownloader.this.setState(5);
                    ManagedDownloader.this.manager.remove(ManagedDownloader.this, true);
                    ErrorService.error(t);
                }
                finally {
                    ManagedDownloader.this.dloaderManagerThread = null;
                }
            }
        }, "ManagedDownload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeDownload(int status) {
        boolean complete;
        boolean clearingNeeded = false;
        int waitTime = 0;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            switch (status) {
                case 4: 
                case 7: 
                case 9: {
                    clearingNeeded = true;
                    this.setState(status);
                    break;
                }
                case 3: 
                case 6: {
                    if (this.invalidated) {
                        clearingNeeded = true;
                        this.setState(19);
                        break;
                    }
                    if (this.stopped) {
                        this.setState(5);
                        break;
                    }
                    if (this.paused) {
                        this.setState(18);
                        break;
                    }
                    this.setState(status);
                    break;
                }
                default: {
                    Assert.that(false, "Bad status from tad2: " + status);
                }
            }
            complete = this.isCompleted();
            waitTime = this.ranker.calculateWaitTime();
            this.ranker.stop();
            if (clearingNeeded) {
                this.ranker = null;
            }
        }
        long now = System.currentTimeMillis();
        this.manager.remove(this, complete);
        if (clearingNeeded) {
            Object object = this.altLock;
            synchronized (object) {
                this.recentInvalidAlts.clear();
                this.invalidAlts.clear();
                this.validAlts.clear();
            }
            if (complete) {
                object = this;
                synchronized (object) {
                    this.cachedRFDs.clear();
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("MD completing <" + this.getSaveFile().getName() + "> completed download, state: " + this.getState() + ", numQueries: " + this.numQueries + ", lastQuerySent: " + this.lastQuerySent);
        }
        VerifyingFile.clearCaches();
        if (!complete && this.getState() != 18 && !this.tryGUESSing()) {
            if (this.getState() == 3) {
                this.setState(3, waitTime);
            } else if (now - this.lastQuerySent < (long)TIME_BETWEEN_REQUERIES) {
                this.setState(8, (long)TIME_BETWEEN_REQUERIES - (now - this.lastQuerySent));
            } else if (this.numQueries >= 1) {
                this.setState(6);
            } else if (this.shouldSendRequeryImmediately(this.numQueries)) {
                this.sendRequery();
            } else {
                this.setState(13);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("MD completed <" + this.getSaveFile().getName() + "> completed download, state: " + this.getState() + ", numQueries: " + this.numQueries);
        }
    }

    private void sendRequery() {
        if (!this.hasStableConnections()) {
            this.lastQuerySent = -1L;
            this.setState(14, 750L);
        } else {
            try {
                QueryRequest qr = this.newRequery(this.numQueries);
                if (this.manager.sendQuery(this, qr)) {
                    this.lastQuerySent = System.currentTimeMillis();
                    ++this.numQueries;
                    this.setState(8, TIME_BETWEEN_REQUERIES);
                } else {
                    this.lastQuerySent = -1L;
                }
            }
            catch (CantResumeException cantResumeException) {
                // empty catch block
            }
        }
    }

    public synchronized void handleInactivity() {
        switch (this.getState()) {
            case 3: 
            case 14: 
            case 15: {
                if (this.getRemainingStateTime() > 0 && !this.hasNewSources()) break;
                this.setState(0);
                break;
            }
            case 8: {
                if (this.hasNewSources()) {
                    this.setState(0);
                    break;
                }
                if (this.getRemainingStateTime() > 0) break;
                this.setState(6);
                break;
            }
            case 6: 
            case 13: {
                if (this.hasNewSources()) {
                    this.setState(0);
                }
            }
            case 0: 
            case 18: {
                break;
            }
            default: {
                Assert.that(false, "invalid state: " + this.getState() + ", workers: " + this._workers.size() + ", _activeWorkers: " + this._activeWorkers.size() + ", _queuedWorkers: " + this._queuedWorkers.size());
            }
        }
    }

    private boolean tryGUESSing() {
        if (this.originalQueryGUID == null || this.triedLocatingSources || this.downloadSHA1 == null) {
            return false;
        }
        MessageRouter mr = RouterService.getMessageRouter();
        Set guessLocs = mr.getGuessLocs(this.originalQueryGUID);
        if (guessLocs == null || guessLocs.isEmpty()) {
            return false;
        }
        this.setState(15, 5000L);
        this.triedLocatingSources = true;
        Iterator i = guessLocs.iterator();
        while (i.hasNext()) {
            GUESSEndpoint ep = (GUESSEndpoint)i.next();
            OnDemandUnicaster.query(ep, this.downloadSHA1);
            if (!this.receivedNewSources) continue;
            break;
        }
        return true;
    }

    public boolean isAlive() {
        return this.dloaderManagerThread != null;
    }

    public boolean isCompleted() {
        switch (this.getState()) {
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public boolean isRelocatable() {
        if (this.isInactive()) {
            return true;
        }
        switch (this.getState()) {
            case 1: 
            case 2: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        switch (this.getState()) {
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isInactive() {
        switch (this.getState()) {
            case 0: 
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    private synchronized void initializeRanker() {
        this.ranker.setMeshHandler(this);
        this.ranker.addToPool(this.cachedRFDs);
    }

    protected void initializeVerifyingFile() throws IOException {
        if (this.incompleteFile == null) {
            return;
        }
        this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
        if (this.commonOutFile == null) {
            int completedSize = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
            this.commonOutFile = new VerifyingFile(completedSize);
            this.commonOutFile.setScanForExistingBlocks(true, this.incompleteFile.length());
            try {
                this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile);
            }
            catch (IOException ioe) {
                ErrorService.error(ioe, "file: " + this.incompleteFile);
                throw ioe;
            }
        }
    }

    protected void initializeIncompleteFile() throws IOException {
        if (this.incompleteFile != null) {
            return;
        }
        if (this.downloadSHA1 != null) {
            this.incompleteFile = this.incompleteFileManager.getFileForUrn(this.downloadSHA1);
        }
        if (this.incompleteFile == null) {
            this.incompleteFile = this.getIncompleteFile(this.incompleteFileManager, this.getSaveFile().getName(), this.downloadSHA1, this.getContentLength());
        }
        LOG.warn("Incomplete File: " + this.incompleteFile);
    }

    protected File getIncompleteFile(IncompleteFileManager ifm, String name, URN urn, int length) throws IOException {
        return ifm.getFile(name, urn, length);
    }

    private synchronized void initializeAlternateLocations() {
        URN hash;
        if (this.incompleteFile == null) {
            return;
        }
        FileDesc fd = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (fd != null && fd instanceof IncompleteFileDesc) {
            IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
            if (this.downloadSHA1 != null && !this.downloadSHA1.equals(ifd.getSHA1Urn())) {
                Assert.silent(false, "wrong IFD.\nclass: " + this.getClass().getName() + "\nours  :   " + this.incompleteFile + "\ntheirs: " + ifd.getFile() + "\nour hash    : " + this.downloadSHA1 + "\ntheir hashes: " + ifd.getUrns() + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes());
                this.fileManager.removeFileIfShared(this.incompleteFile);
            }
        }
        if ((hash = this.incompleteFileManager.getCompletedHash(this.incompleteFile)) != null) {
            long size = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            this.addLocationsToDownload(RouterService.getAltlocManager().getDirect(hash), RouterService.getAltlocManager().getPush(hash, false), RouterService.getAltlocManager().getPush(hash, true), (int)size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsToDownload(AlternateLocationCollection direct, AlternateLocationCollection push, AlternateLocationCollection fwt, int size) {
        AlternateLocation loc;
        Iterator iter;
        ArrayList<RemoteFileDesc> locs = new ArrayList<RemoteFileDesc>(direct.getAltLocsSize() + push.getAltLocsSize() + fwt.getAltLocsSize());
        AlternateLocationCollection alternateLocationCollection = direct;
        synchronized (alternateLocationCollection) {
            iter = direct.iterator();
            while (iter.hasNext()) {
                loc = (AlternateLocation)iter.next();
                locs.add(loc.createRemoteFileDesc(size));
            }
        }
        alternateLocationCollection = push;
        synchronized (alternateLocationCollection) {
            iter = push.iterator();
            while (iter.hasNext()) {
                loc = (AlternateLocation)iter.next();
                locs.add(loc.createRemoteFileDesc(size));
            }
        }
        alternateLocationCollection = fwt;
        synchronized (alternateLocationCollection) {
            iter = fwt.iterator();
            while (iter.hasNext()) {
                loc = (AlternateLocation)iter.next();
                locs.add(loc.createRemoteFileDesc(size));
            }
        }
        this.addPossibleSources(locs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conflictsWithIncompleteFile(File incFile) {
        File iFile = this.incompleteFile;
        if (iFile != null) {
            return iFile.equals(incFile);
        }
        URN urn = this.downloadSHA1;
        if (urn != null) {
            iFile = this.incompleteFileManager.getFileForUrn(urn);
        }
        if (iFile != null) {
            return iFile.equals(incFile);
        }
        RemoteFileDesc rfd = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (!this.hasRFD()) {
                return false;
            }
            rfd = (RemoteFileDesc)this.cachedRFDs.iterator().next();
        }
        if (rfd != null) {
            try {
                File thisFile = this.incompleteFileManager.getFile(rfd);
                return thisFile.equals(incFile);
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    public boolean conflicts(URN urn, String fileName, int fileSize) {
        if (urn != null && this.downloadSHA1 != null) {
            return urn.equals(this.downloadSHA1);
        }
        if (fileSize > 0) {
            try {
                File file = this.incompleteFileManager.getFile(fileName, null, fileSize);
                return this.conflictsWithIncompleteFile(file);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    protected synchronized QueryRequest newRequery(int numRequeries) throws CantResumeException {
        String queryString = StringUtils.createQueryString(this.getDefaultFileName());
        if (queryString == null || queryString.equals(UNKNOWN_FILENAME)) {
            throw new CantResumeException(this.getSaveFile().getName());
        }
        return QueryRequest.createQuery(queryString);
    }

    protected boolean shouldSendRequeryImmediately(int numRequeries) {
        return this.lastQuerySent == -1L;
    }

    protected boolean shouldInitAltLocs(boolean deserializedFromDisk) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hostIsAllowed(RemoteFileDesc other) {
        if (!IPFilter.instance().allow(other.getHost())) {
            return false;
        }
        if (RouterService.acceptedIncomingConnection() || !other.isFirewalled() || other.supportsFWTransfer() && RouterService.canDoFWT()) {
            Object object = this.altLock;
            synchronized (object) {
                if (other.isFromAlternateLocation() && this.invalidAlts.contains(other.getRemoteHostData())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc other) {
        if (!initDone) {
            ApproximateMatcher approximateMatcher = matcher;
            synchronized (approximateMatcher) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            initDone = true;
        }
        if (other.getQuality() < 1) {
            return false;
        }
        URN otherUrn = other.getSHA1Urn();
        String otherName = other.getFileName();
        long otherLength = other.getFileSize();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            int ourLength = this.getContentLength();
            if (ourLength != -1 && (long)ourLength != otherLength) {
                return false;
            }
            if (otherUrn != null && this.downloadSHA1 != null) {
                return otherUrn.equals(this.downloadSHA1);
            }
            Iterator iter = this.cachedRFDs.iterator();
            while (iter.hasNext()) {
                RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
                String thisName = rfd.getFileName();
                long thisLength = rfd.getFileSize();
                if (otherLength != thisLength || !this.namesClose(otherName, thisName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String one, String two) {
        boolean retVal = false;
        int allowedDifferences = Math.round(Math.min(0.1f * (float)StringUtils.ripExtension(one).length(), 0.1f * (float)StringUtils.ripExtension(two).length()));
        allowedDifferences = Math.min(allowedDifferences, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            retVal = matcher.matches(matcher.process(one), matcher.process(two), allowedDifferences);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD.namesClose(): one = " + one);
            LOG.debug("MD.namesClose(): two = " + two);
            LOG.debug("MD.namesClose(): retVal = " + retVal);
        }
        return retVal;
    }

    public synchronized void locationAdded(AlternateLocation loc) {
        Assert.that(loc.getSHA1Urn().equals(this.getSHA1Urn()));
        this.addDownload(loc.createRemoteFileDesc(this.getContentLength()), false);
    }

    public synchronized boolean addDownload(RemoteFileDesc rfd, boolean cache) {
        if (this.stopped || this.isCompleted()) {
            return false;
        }
        if (!this.allowAddition(rfd)) {
            return false;
        }
        rfd.setDownloading(true);
        if (!this.hostIsAllowed(rfd)) {
            return false;
        }
        return this.addDownloadForced(rfd, cache);
    }

    public synchronized boolean addDownload(Collection c, boolean cache) {
        if (this.stopped || this.isCompleted()) {
            return false;
        }
        ArrayList<RemoteFileDesc> l = new ArrayList<RemoteFileDesc>(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (!this.hostIsAllowed(rfd) || !this.allowAddition(rfd)) continue;
            l.add(rfd);
        }
        return this.addDownloadForced(l, cache);
    }

    protected synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        if (rfd.isMe()) {
            return true;
        }
        if (this.currentRFDs.contains(rfd)) {
            return true;
        }
        this.prepareRFD(rfd, cache);
        if (this.ranker.addToPool(rfd)) {
            this.receivedNewSources = true;
        }
        return true;
    }

    protected final synchronized boolean addDownloadForced(Collection c, boolean cache) {
        c.removeAll(this.currentRFDs);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (rfd.isMe()) {
                iter.remove();
                continue;
            }
            this.prepareRFD(rfd, cache);
        }
        if (this.ranker.addToPool(c)) {
            this.receivedNewSources = true;
        }
        return true;
    }

    private void prepareRFD(RemoteFileDesc rfd, boolean cache) {
        if (this.downloadSHA1 == null) {
            this.downloadSHA1 = rfd.getSHA1Urn();
            RouterService.getAltlocManager().addListener(this.downloadSHA1, this);
        }
        if (cache) {
            this.cachedRFDs.add(rfd);
        }
    }

    public boolean hasNewSources() {
        return !this.paused && this.receivedNewSources;
    }

    public boolean acceptDownload(String file, Socket socket, int index, byte[] clientGUID) {
        if (this.stopped) {
            return false;
        }
        HTTPConnectObserver observer = this.pushes.getHostFor(clientGUID, socket.getInetAddress().getHostAddress());
        if (observer != null) {
            observer.handleConnect(socket);
        }
        return observer != null;
    }

    void registerPushObserver(HTTPConnectObserver observer, PushDetails details) {
        this.pushes.addPushHost(details, observer);
    }

    void unregisterPushObserver(PushDetails details, boolean shutdown) {
        HTTPConnectObserver observer = this.pushes.getExactHostFor(details);
        if (observer != null && shutdown) {
            observer.shutdown();
        }
    }

    public boolean isCancelled() {
        return this.stopped;
    }

    public synchronized void pause() {
        if (!this.stopped && !this.isCompleted()) {
            this.stop();
            this.stopped = false;
            this.paused = true;
            if (this.isInactive()) {
                this.setState(18);
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.paused) {
            this.stopped = true;
            this.paused = false;
        }
        if (this.stopped || this.paused) {
            return;
        }
        LOG.debug("STOPPING ManagedDownloader");
        this.stopped = true;
        this.killAllWorkers();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Thread dlMan = this.dloaderManagerThread;
            if (dlMan != null) {
                dlMan.interrupt();
            } else {
                LOG.warn("MANAGER: no thread to interrupt");
            }
        }
    }

    private void killAllWorkers() {
        List workers = this.getAllWorkers();
        Iterator iter = workers.iterator();
        while (iter.hasNext()) {
            DownloadWorker doomed = (DownloadWorker)iter.next();
            doomed.interrupt();
        }
        List pushObservers = this.pushes.getAllAndClear();
        Iterator i = pushObservers.iterator();
        while (i.hasNext()) {
            HTTPConnectObserver next = (HTTPConnectObserver)i.next();
            next.shutdown();
        }
    }

    synchronized void diskProblemOccured() {
        this.setState(7);
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void informMesh(RemoteFileDesc rfd, boolean good) {
        AlternateLocation local;
        AlternateLocation loc;
        if (LOG.isDebugEnabled()) {
            LOG.debug("informing mesh that " + rfd + " is " + good);
        }
        if (good) {
            this.cachedRFDs.add(rfd);
        }
        if (!rfd.isAltLocCapable()) {
            return;
        }
        Assert.that(this.downloadSHA1 != null, "null hash.");
        Assert.that(this.downloadSHA1.equals(rfd.getSHA1Urn()), "wrong loc SHA1");
        try {
            loc = AlternateLocation.create(rfd);
        }
        catch (IOException iox) {
            return;
        }
        if (loc instanceof PushAltLoc) {
            local = loc.createClone();
            PushAltLoc ploc = (PushAltLoc)loc;
            if (ploc.getPushAddress().getProxies().isEmpty()) {
                return;
            }
            ploc.updateProxies(good);
        } else {
            local = loc;
        }
        if (good) {
            RouterService.getAltlocManager().add(loc, this);
        } else {
            RouterService.getAltlocManager().remove(loc, this);
        }
        Iterator iter = this.getActiveWorkers().iterator();
        while (iter.hasNext()) {
            HTTPDownloader httpDloader = ((DownloadWorker)iter.next()).getDownloader();
            RemoteFileDesc r = httpDloader.getRemoteFileDesc();
            if (local instanceof PushAltLoc ? r.getPushAddr() != null && r.getPushAddr().equals(rfd.getPushAddr()) : r.getHost().equals(rfd.getHost()) && r.getPort() == rfd.getPort()) continue;
            if (!(local instanceof DirectAltLoc) && !httpDloader.wantsFalts()) continue;
            if (good) {
                httpDloader.addSuccessfulAltLoc(local);
                continue;
            }
            httpDloader.addFailedAltLoc(local);
        }
        Object object = this.altLock;
        synchronized (object) {
            if (good) {
                if (!this.validAlts.contains(local)) {
                    if (rfd.isFromAlternateLocation()) {
                        if (rfd.needsPush()) {
                            DownloadStat.PUSH_ALTERNATE_WORKED.incrementStat();
                        } else {
                            DownloadStat.ALTERNATE_WORKED.incrementStat();
                        }
                    }
                    this.validAlts.add(local);
                }
            } else {
                if (rfd.isFromAlternateLocation()) {
                    if (local instanceof PushAltLoc) {
                        DownloadStat.PUSH_ALTERNATE_NOT_ADDED.incrementStat();
                    } else {
                        DownloadStat.ALTERNATE_NOT_ADDED.incrementStat();
                    }
                }
                this.validAlts.remove(local);
                this.invalidAlts.add(rfd.getRemoteHostData());
                this.recentInvalidAlts.add(local);
            }
        }
    }

    public synchronized void addPossibleSources(Collection c) {
        this.addDownload(c, false);
    }

    public synchronized boolean resume() {
        if (!this.isInactive()) {
            return false;
        }
        if (this.getState() == 13) {
            this.lastQuerySent = -1L;
        }
        Iterator i = this.cachedRFDs.iterator();
        while (i.hasNext()) {
            ((RemoteFileDesc)i.next()).setRetryAfter(0);
        }
        if (this.paused) {
            this.paused = false;
            this.stopped = false;
        }
        this.setState(0);
        return true;
    }

    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 4) {
            return this.getSaveFile();
        }
        return this.incompleteFile;
    }

    public URN getSHA1Urn() {
        return this.downloadSHA1;
    }

    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 9) {
            return this.corruptFile;
        }
        if (this.state != 4) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            int size = this.amountForPreview();
            if (size <= 0) {
                return null;
            }
            if (CommonUtils.copy(this.incompleteFile, size, file) <= 0) {
                return null;
            }
            return file;
        }
        return this.getSaveFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int amountForPreview() {
        if (this.commonOutFile == null) {
            return 0;
        }
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            Iterator iter = this.commonOutFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.low != 0) continue;
                return interval.high;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSaveFile(File saveDirectory, String fileName, boolean overwrite) throws SaveLocationException {
        if (saveDirectory == null) {
            saveDirectory = SharingSettings.getSaveDirectory();
        }
        if (fileName == null) {
            fileName = this.getDefaultFileName();
        }
        if (!saveDirectory.isDirectory()) {
            if (saveDirectory.exists()) {
                throw new SaveLocationException(8, saveDirectory);
            }
            throw new SaveLocationException(4, saveDirectory);
        }
        File candidateFile = new File(saveDirectory, fileName);
        try {
            if (!FileUtils.isReallyParent(saveDirectory, candidateFile)) {
                throw new SaveLocationException(1, candidateFile);
            }
        }
        catch (IOException e) {
            throw new SaveLocationException(9, candidateFile);
        }
        if (!FileUtils.setWriteable(saveDirectory)) {
            throw new SaveLocationException(3, saveDirectory);
        }
        if (candidateFile.exists()) {
            if (!candidateFile.isFile()) {
                throw new SaveLocationException(7, candidateFile);
            }
            if (!overwrite) {
                throw new SaveLocationException(5, candidateFile);
            }
        }
        if (RouterService.getDownloadManager().isSaveLocationTaken(candidateFile)) {
            throw new SaveLocationException(6, candidateFile);
        }
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (!this.isRelocatable()) {
                throw new SaveLocationException(2, candidateFile);
            }
            this.propertiesMap.put(SAVE_FILE, candidateFile);
        }
    }

    public synchronized File getSaveFile() {
        Object saveFile = this.propertiesMap.get(SAVE_FILE);
        if (saveFile != null) {
            return (File)saveFile;
        }
        return new File(SharingSettings.getSaveDirectory(), this.getDefaultFileName());
    }

    public synchronized void finish() {
        if (this.downloadSHA1 != null) {
            RouterService.getAltlocManager().removeListener(this.downloadSHA1, this);
        }
        if (this.cachedRFDs != null) {
            Iterator iter = this.cachedRFDs.iterator();
            while (iter.hasNext()) {
                RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
                rfd.setDownloading(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int performDownload() {
        int status;
        block14: {
            if (this.checkHosts()) {
                this.setState(6);
                return 6;
            }
            status = this.initializeDownload();
            if (status == 1) {
                try {
                    try {
                        status = this.fireDownloadWorkers();
                    }
                    finally {
                        this.commonOutFile.close();
                    }
                    if (status == 4) {
                        status = this.verifyAndSave();
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("stopping early with status: " + status);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.stopped && !this.paused) {
                        ErrorService.error(e);
                    } else {
                        status = 6;
                    }
                    if (this.corruptState != 2) break block14;
                    this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
                    status = 9;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MANAGER: TAD2 returned: " + status);
        }
        return status;
    }

    private boolean hasStableConnections() {
        if (NO_DELAY) {
            return true;
        }
        return RouterService.countConnectionsWithNMessages(6) >= 2 && RouterService.getActiveConnectionMessages() >= 45;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int initializeDownload() {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.cachedRFDs.size() == 0 && !this.ranker.hasMore()) {
                return 6;
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
            this.openVerifyingFile();
        }
        catch (IOException iox) {
            return 7;
        }
        if (this.downloadSHA1 != null) {
            this.initializeHashTree();
        }
        this.initializeRanker();
        return 1;
    }

    private int verifyAndSave() throws InterruptedException {
        URN fileHash = this.scanForCorruption();
        if (this.corruptState == 2) {
            this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
            return 9;
        }
        return this.saveFile(fileHash);
    }

    private void validateDownload() {
        if (this.shouldValidate(this.deserializedFromDisk) && this.downloadSHA1 != null) {
            RouterService.getContentManager().request(this.downloadSHA1, new ContentResponseObserver(){

                public void handleResponse(URN urn, ContentResponseData response) {
                    if (response != null && !response.isOK()) {
                        ManagedDownloader.this.invalidated = true;
                        ManagedDownloader.this.stop();
                    }
                }
            }, 5000L);
        }
    }

    protected boolean shouldValidate(boolean deserialized) {
        return !deserialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCorruptResponse() {
        if (this.corruptState != 0) {
            Object object = this.corruptStateLock;
            synchronized (object) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private URN scanForCorruption() throws InterruptedException {
        if (this.corruptState == 2) {
            return null;
        }
        URN fileHash = null;
        try {
            this.setState(11);
            fileHash = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.downloadSHA1 == null) {
            return fileHash;
        }
        if (this.downloadSHA1.equals(fileHash)) {
            return fileHash;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("hash verification problem, fileHash=" + fileHash + ", ourHash=" + this.downloadSHA1);
        }
        if (this.commonOutFile.getHashTree() == null) {
            this.fileManager.removeFileIfShared(this.incompleteFile);
        }
        TigerTreeCache.instance().purgeTree(this.downloadSHA1);
        this.commonOutFile.setHashTree(null);
        this.promptAboutCorruptDownload();
        this.waitForCorruptResponse();
        return fileHash;
    }

    private void initializeHashTree() {
        HashTree tree = TigerTreeCache.instance().getHashTree(this.downloadSHA1);
        if (tree != null && tree.isDepthGoodEnough()) {
            this.commonOutFile.setHashTree(tree);
        }
    }

    private int saveFile(URN fileHash) {
        this.setState(12);
        if (!FileUtils.setWriteable(this.getSaveFile().getParentFile())) {
            return 7;
        }
        File saveFile = this.getSaveFile();
        saveFile.delete();
        boolean success = FileUtils.forceRename(this.incompleteFile, saveFile);
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (!success) {
            return 7;
        }
        if (saveFile.exists()) {
            this.fileManager.removeFileIfShared(saveFile);
        }
        if (fileHash != null) {
            HashSet<URN> urns = new HashSet<URN>(1);
            urns.add(fileHash);
            File file = saveFile;
            try {
                file = FileUtils.getCanonicalFile(saveFile);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            UrnCache.instance().addUrns(file, urns);
            SavedFileManager.instance().addSavedFile(file, urns);
            if (this.downloadSHA1 != null && this.downloadSHA1.equals(fileHash) && this.commonOutFile.getHashTree() != null) {
                TigerTreeCache.instance();
                TigerTreeCache.addHashTree(this.downloadSHA1, this.commonOutFile.getHashTree());
            }
        }
        if (SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue()) {
            this.fileManager.addFileAlways(this.getSaveFile(), this.getXMLDocuments());
        } else {
            this.fileManager.addFileIfShared(this.getSaveFile(), this.getXMLDocuments());
        }
        return 4;
    }

    private void cleanupCorrupt(File incFile, String name) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(incFile);
        boolean renamed = false;
        for (int i = 0; i < 10 && !renamed; ++i) {
            this.corruptFile = new File(incFile.getParent(), "CORRUPT-" + i + "-" + name);
            if (this.corruptFile.exists()) continue;
            renamed = incFile.renameTo(this.corruptFile);
        }
        if (!renamed) {
            incFile.delete();
            this.corruptFile = null;
        }
    }

    private void openVerifyingFile() throws IOException {
        try {
            this.commonOutFile.open(this.incompleteFile);
        }
        catch (IOException e) {
            if (!IOUtils.handleException(e, "DOWNLOAD")) {
                ErrorService.error(e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker(RemoteFileDesc rfd) {
        DownloadWorker worker = new DownloadWorker(this, rfd, this.commonOutFile);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this._workers.add(worker);
            this.currentRFDs.add(rfd);
        }
        worker.start();
    }

    synchronized void workerFinished(DownloadWorker finished) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("worker " + finished + " finished.");
        }
        this.removeWorker(finished);
        this.notify();
    }

    synchronized void workerStarted(DownloadWorker worker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("worker " + worker + " started.");
        }
        if (!this._workers.contains(worker)) {
            throw new IllegalStateException("attempting to start invalid worker: " + worker);
        }
        this.setState(2);
        this.addActiveWorker(worker);
        this.chatList.addHost(worker.getDownloader());
        this.browseList.addHost(worker.getDownloader());
    }

    void workerFailed(DownloadWorker failed) {
        HTTPDownloader downloader = failed.getDownloader();
        if (downloader != null) {
            this.chatList.removeHost(downloader);
            this.browseList.removeHost(downloader);
        }
    }

    synchronized void removeWorker(DownloadWorker worker) {
        boolean rA = this.removeActiveWorker(worker);
        this.workerFailed(worker);
        boolean rW = this._workers.remove(worker);
        if (rA && !rW) {
            throw new IllegalStateException("active removed but not in workers");
        }
    }

    synchronized boolean removeActiveWorker(DownloadWorker worker) {
        this.currentRFDs.remove(worker.getRFD());
        ArrayList l = new ArrayList(this.getActiveWorkers());
        boolean removed = l.remove(worker);
        this._activeWorkers = Collections.unmodifiableList(l);
        return removed;
    }

    synchronized void addActiveWorker(DownloadWorker worker) {
        if (!this.getActiveWorkers().contains(worker)) {
            ArrayList<DownloadWorker> l = new ArrayList<DownloadWorker>(this.getActiveWorkers());
            l.add(worker);
            this._activeWorkers = Collections.unmodifiableList(l);
        }
    }

    synchronized String getWorkersInfo() {
        String workerState = UNKNOWN_FILENAME;
        Iterator iter = this._workers.iterator();
        while (iter.hasNext()) {
            DownloadWorker worker = (DownloadWorker)iter.next();
            workerState = workerState + worker.getInfo();
        }
        return workerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getValidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            HashSet ret;
            if (this.validAlts != null) {
                ret = new HashSet();
                Iterator iter = this.validAlts.iterator();
                while (iter.hasNext()) {
                    ret.add(iter.next());
                }
            } else {
                ret = Collections.EMPTY_SET;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getInvalidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            HashSet ret;
            if (this.invalidAlts != null) {
                ret = new HashSet();
                Iterator iter = this.recentInvalidAlts.iterator();
                while (iter.hasNext()) {
                    ret.add(iter.next());
                }
            } else {
                ret = Collections.EMPTY_SET;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fireDownloadWorkers() throws InterruptedException {
        LOG.trace("MANAGER: entered fireDownloadWorkers");
        while (true) {
            if (this.stopped || this.paused) {
                LOG.warn("MANAGER: terminating because of stop|pause");
                throw new InterruptedException();
            }
            try {
                this.commonOutFile.waitForPendingIfNeeded();
            }
            catch (DiskException dio) {
                if (this.stopped || this.paused) {
                    LOG.warn("MANAGER: terminating because of stop|pause");
                    throw new InterruptedException();
                }
                this.stop();
                return 7;
            }
            if (this.commonOutFile.isComplete()) {
                this.killAllWorkers();
                LOG.trace("MANAGER: terminating because of completion");
                return 4;
            }
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                if (this._workers.size() == 0 && !this.ranker.hasNonBusy()) {
                    this.receivedNewSources = false;
                    if (this.ranker.calculateWaitTime() > 0) {
                        LOG.trace("MANAGER: terminating with busy");
                        return 3;
                    }
                    LOG.trace("MANAGER: terminating w/o hope");
                    return 6;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("MANAGER: kicking off workers.  state: " + this.getState() + ", allWorkers: " + this._workers.size() + ", activeWorkers: " + this._activeWorkers.size() + ", queuedWorkers: " + this._queuedWorkers.size() + ", swarm cap: " + this.getSwarmCapacity());
                }
                if (this.shouldStartWorker()) {
                    this.ranker = this.getSourceRanker(this.ranker);
                    RemoteFileDesc rfd = this.ranker.getBest();
                    if (rfd != null) {
                        if (rfd.isBusy()) {
                            this.addRFD(rfd);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Staring worker for RFD: " + rfd);
                            }
                            this.startWorker(rfd);
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("no blocks but can't steal - sleeping.");
                }
                try {
                    this.wait(DownloadSettings.WORKER_INTERVAL.getValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected SourceRanker getSourceRanker(SourceRanker ranker) {
        return SourceRanker.getAppropriateRanker(ranker);
    }

    private boolean shouldStartWorker() {
        return (this.commonOutFile.hasFreeBlocksToAssign() > 0 || this.victimsExist()) && this._workers.size() - this._queuedWorkers.size() < this.getSwarmCapacity() && this.ranker.hasMore();
    }

    private boolean victimsExist() {
        if (this._workers.isEmpty()) {
            return false;
        }
        Iterator iter = this._workers.iterator();
        while (iter.hasNext()) {
            DownloadWorker victim = (DownloadWorker)iter.next();
            if (victim.isStealing() || !victim.isSlow()) continue;
            return true;
        }
        return false;
    }

    synchronized void addRFD(RemoteFileDesc rfd) {
        if (this.ranker != null) {
            this.ranker.addToPool(rfd);
        }
    }

    synchronized void forgetRFD(RemoteFileDesc rfd) {
        if (this.cachedRFDs.remove(rfd) && this.cachedRFDs.isEmpty()) {
            rfd.setSerializeProxies();
            this.cachedRFDs.add(rfd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            if (this.validAlts == null) {
                return 0;
            }
            return this.validAlts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfInvalidAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            if (this.invalidAlts == null) {
                return 0;
            }
            return this.invalidAlts.size();
        }
    }

    public synchronized int getPossibleHostCount() {
        return this.ranker == null ? 0 : this.ranker.getNumKnownHosts();
    }

    public synchronized int getBusyHostCount() {
        return this.ranker == null ? 0 : this.ranker.getNumBusyHosts();
    }

    public synchronized int getQueuedHostCount() {
        return this._queuedWorkers.size();
    }

    int getSwarmCapacity() {
        int capacity = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (capacity <= 56) {
            return 2;
        }
        if (capacity <= 1000) {
            return 8;
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            if (this.corruptState == 0) {
                this.corruptState = 1;
                this.sendCorruptCallback();
            }
        }
    }

    protected void sendCorruptCallback() {
        this.callback.promptAboutCorruptDownload(this);
    }

    public void discardCorruptDownload(final boolean delete) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("User chose to delete corrupt " + delete);
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ManagedDownloader.this.corruptStateLock;
                synchronized (object) {
                    if (delete) {
                        ManagedDownloader.this.corruptState = 2;
                    } else {
                        ManagedDownloader.this.corruptState = 3;
                    }
                }
                if (delete) {
                    ManagedDownloader.this.stop();
                } else {
                    ManagedDownloader.this.commonOutFile.setDiscardUnverified(false);
                }
                object = ManagedDownloader.this.corruptStateLock;
                synchronized (object) {
                    ManagedDownloader.this.corruptStateLock.notify();
                }
            }
        };
        RouterService.schedule(r, 0L, 0L);
    }

    private synchronized List getXMLDocuments() {
        ArrayList<LimeXMLDocument> allDocs = new ArrayList<LimeXMLDocument>();
        Iterator iter = this.cachedRFDs.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            LimeXMLDocument doc = rfd.getXMLDocument();
            if (doc == null) continue;
            allDocs.add(doc);
        }
        return allDocs;
    }

    synchronized void setState(int newState) {
        this.state = newState;
        this.stateTime = Long.MAX_VALUE;
    }

    synchronized void setState(int newState, long time) {
        this.state = newState;
        this.stateTime = System.currentTimeMillis() + time;
    }

    public void setInactivePriority(int priority) {
        this.inactivePriority = priority;
    }

    public int getInactivePriority() {
        return this.inactivePriority;
    }

    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: 
            case 8: 
            case 14: 
            case 15: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.ceil((float)Math.max(remaining, 0L) / 1000.0f);
            }
            case 0: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected synchronized String getDefaultFileName() {
        String fileName = (String)this.propertiesMap.get(DEFAULT_FILENAME);
        if (fileName == null) {
            Assert.that(false, "defaultFileName is null, subclass may have not overridden getDefaultFileName");
        }
        return CommonUtils.convertFileName(fileName);
    }

    protected synchronized boolean hasRFD() {
        return this.cachedRFDs != null && !this.cachedRFDs.isEmpty();
    }

    public synchronized int getContentLength() {
        Integer i = (Integer)this.propertiesMap.get(FILE_SIZE);
        return i != null ? i : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAmountRead() {
        VerifyingFile ourFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.state == 9) {
                return this.corruptFileBytes;
            }
            if (this.state == 11) {
                if (this.incompleteFile == null) {
                    return 0;
                }
                return URN.getHashingProgress(this.incompleteFile);
            }
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0 : ourFile.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAmountPending() {
        VerifyingFile ourFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0 : ourFile.getPendingSize();
    }

    public int getNumHosts() {
        return this._activeWorkers.size();
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    public synchronized int getQueuePosition() {
        return this.queuePosition;
    }

    public int getNumDownloaders() {
        return this.getActiveWorkers().size() + this.getQueuedWorkers().size();
    }

    List getActiveWorkers() {
        return this._activeWorkers;
    }

    synchronized List getAllWorkers() {
        return new ArrayList(this._workers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeQueuedWorker(DownloadWorker unQueued) {
        if (this.getQueuedWorkers().containsKey(unQueued)) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                HashMap m = new HashMap(this.getQueuedWorkers());
                m.remove(unQueued);
                this._queuedWorkers = Collections.unmodifiableMap(m);
            }
        }
    }

    private synchronized void addQueuedWorker(DownloadWorker queued, int position) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding queued worker " + queued + " at position " + position + " current queued workers:\n" + this._queuedWorkers);
        }
        if (!this._workers.contains(queued)) {
            throw new IllegalStateException("attempting to queue invalid worker: " + queued);
        }
        if (position < this.queuePosition) {
            this.queuePosition = position;
            this.queuedVendor = queued.getDownloader().getVendor();
        }
        HashMap<DownloadWorker, Integer> m = new HashMap<DownloadWorker, Integer>(this.getQueuedWorkers());
        m.put(queued, new Integer(position));
        this._queuedWorkers = Collections.unmodifiableMap(m);
    }

    Map getQueuedWorkers() {
        return this._queuedWorkers;
    }

    int getWorkerQueuePosition(DownloadWorker worker) {
        Integer i = (Integer)this.getQueuedWorkers().get(worker);
        return i == null ? -1 : i;
    }

    synchronized boolean killQueuedIfNecessary(DownloadWorker worker, int queuePos) {
        int swarmCapacity;
        if (LOG.isDebugEnabled()) {
            LOG.debug("deciding whether to kill a queued host for (" + queuePos + ") worker " + worker);
        }
        DownloadWorker doomed = null;
        int numDownloaders = this.getNumDownloaders();
        if (numDownloaders <= (swarmCapacity = this.getSwarmCapacity()) && queuePos == -1) {
            return true;
        }
        if (this._queuedWorkers.containsKey(worker) && queuePos > -1) {
            this.addQueuedWorker(worker, queuePos);
            return true;
        }
        if (numDownloaders >= swarmCapacity) {
            int highest = queuePos;
            Iterator i = this._queuedWorkers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry current = i.next();
                int currQueue = (Integer)current.getValue();
                if (currQueue <= highest) continue;
                doomed = (DownloadWorker)current.getKey();
                highest = currQueue;
            }
            if (doomed == null) {
                LOG.debug("not queueing myself");
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("will replace " + doomed);
            }
            doomed.interrupt();
        }
        if (queuePos > -1) {
            this.addQueuedWorker(worker, queuePos);
        }
        return true;
    }

    public synchronized String getVendor() {
        List active = this.getActiveWorkers();
        if (active.size() > 0) {
            HTTPDownloader dl = ((DownloadWorker)active.get(0)).getDownloader();
            return dl.getVendor();
        }
        if (this.getState() == 10) {
            return this.queuedVendor;
        }
        return UNKNOWN_FILENAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this.getActiveWorkers().iterator();
        while (iter.hasNext()) {
            c = true;
            HTTPDownloader dloader = ((DownloadWorker)iter.next()).getDownloader();
            dloader.measureBandwidth();
            currentTotal += dloader.getAverageBandwidth();
        }
        if (c) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
            }
        }
    }

    public float getMeasuredBandwidth() {
        float retVal = 0.0f;
        Iterator iter = this.getActiveWorkers().iterator();
        while (iter.hasNext()) {
            HTTPDownloader dloader = ((DownloadWorker)iter.next()).getDownloader();
            float curr = 0.0f;
            try {
                curr = dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            retVal += curr;
        }
        return retVal;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAmountVerified() {
        VerifyingFile ourFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0 : ourFile.getVerifiedBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAmountLost() {
        VerifyingFile ourFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0 : ourFile.getAmountLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChunkSize() {
        VerifyingFile ourFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            ourFile = this.commonOutFile;
        }
        return ourFile != null ? ourFile.getChunkSize() : 131072;
    }

    private boolean checkHosts() {
        byte[] b = new byte[]{65, 80, 80, 95, 84, 73, 84, 76, 69};
        String s = this.callback.getHostValue(new String(b));
        if (s == null) {
            return false;
        }
        return (s = s.substring(0, 8)).hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    public Object setAttribute(String key, Object value) {
        return this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }
}

