/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.ScrollingTextPane;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;

final class AboutWindow {
    private final JDialog DIALOG;
    private final ScrollingTextPane SCROLLING_PANE;
    private final JCheckBox SCROLL_CHECK_BOX = new JCheckBox(GUIMediator.getStringResource("ABOUT_SCROLL_CHECK_BOX_LABEL"));

    AboutWindow() {
        this.DIALOG = new JDialog(GUIMediator.getAppFrame());
        if (!CommonUtils.isMacOSX()) {
            this.DIALOG.setModal(true);
        }
        this.DIALOG.setSize(new Dimension(450, 400));
        this.DIALOG.setResizable(false);
        this.DIALOG.setTitle(GUIMediator.getStringResource("ABOUT_TITLE"));
        this.DIALOG.setDefaultCloseOperation(2);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }

            public void windowClosing(WindowEvent we) {
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }
        });
        this.SCROLLING_PANE = this.createScrollingPane();
        this.SCROLLING_PANE.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        JLabel client = new JLabel(GUIMediator.getStringResource("ABOUT_LABEL_START") + " " + CommonUtils.getLimeWireVersion());
        client.setHorizontalAlignment(0);
        JLabel java = new JLabel("Java " + CommonUtils.getJavaVersion());
        java.setHorizontalAlignment(0);
        URLLabel url = new URLLabel("http://www.limewire.com");
        url.setHorizontalAlignment(0);
        this.SCROLL_CHECK_BOX.setSelected(true);
        this.SCROLL_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                    AboutWindow.this.SCROLLING_PANE.startScroll();
                } else {
                    AboutWindow.this.SCROLLING_PANE.stopScroll();
                }
            }
        });
        JButton button = new JButton(GUIMediator.getStringResource("GENERAL_CLOSE_BUTTON_LABEL"));
        this.DIALOG.getRootPane().setDefaultButton(button);
        button.setToolTipText(GUIMediator.getStringResource("ABOUT_BUTTON_TIP"));
        button.addActionListener(GUIUtils.getDisposeAction());
        JComponent pane = (JComponent)this.DIALOG.getContentPane();
        GUIUtils.addHideAction(pane);
        pane.setLayout(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        LogoPanel logo = new LogoPanel();
        logo.setSearching(true);
        pane.add((Component)logo, gbc);
        gbc.gridy = 1;
        pane.add(Box.createVerticalStrut(6), gbc);
        gbc.fill = 2;
        gbc.gridy = 2;
        pane.add((Component)client, gbc);
        gbc.gridy = 3;
        pane.add((Component)java, gbc);
        gbc.gridy = 4;
        pane.add((Component)url, gbc);
        gbc.gridy = 5;
        pane.add(Box.createVerticalStrut(6), gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridy = 6;
        pane.add((Component)this.SCROLLING_PANE, gbc);
        gbc.gridy = 7;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        pane.add(Box.createVerticalStrut(6), gbc);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridy = 8;
        pane.add((Component)this.SCROLL_CHECK_BOX, gbc);
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        pane.add((Component)button, gbc);
    }

    private ScrollingTextPane createScrollingPane() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        Color color = new JLabel().getForeground();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        String hex = this.toHex(r) + this.toHex(g) + this.toHex(b);
        sb.append("<body text='#" + hex + "'>");
        sb.append(GUIMediator.getStringResource("ABOUT_INTRODUCTION"));
        sb.append("<br><br>");
        sb.append(GUIMediator.getStringResource("ABOUT_DEV_BLURB"));
        sb.append("<ul>\n  <li>Greg Bildson</li>\n  <li>Sam Berlin</li>\n  <li>Zlatin Balevsky</li>\n  <li>Roger Kapsi</li>\n  <li>Mark Kornfilt</li>\n  <li>Akshay Kumar</li>\n  <li>Kevin Faaborg</li>\n  <li>Justin Schmidt</li>\n  <li>Tim Olsen</li>\n  <li>Felix Berger</li>\n</ul>");
        sb.append(GUIMediator.getStringResource("ABOUT_BIZDEV_BLURB"));
        sb.append("<ul>\n  <li>Katie Catillaz</li>\n  <li>Rachel Sterne</li>\n  <li>Jesse Rubenfeld</li>\n</ul>");
        sb.append(GUIMediator.getStringResource("ABOUT_WEBDEV_BLURB"));
        sb.append("<ul>\n  <li>Andrew Fischler Jr.</li>\n  <li>Dave Yeu</li>\n</ul>");
        sb.append(GUIMediator.getStringResource("ABOUT_SUPPORT_BLURB"));
        sb.append("<ul>\n  <li>Zenzele Bell</li>\n  <li>Kirk Kahn</li>\n  <li>Christine Cioffari</li>\n</ul>");
        sb.append(GUIMediator.getStringResource("ABOUT_PREVIOUS_DEV_BLURB"));
        sb.append("<ul>\n  <li>Aubrey Arago</li>\n  <li>Susheel Daswani</li>\n  <li>Adam Fisk</li>\n  <li>Meghan Formel</li>\n  <li>Tarun Kapoor</li>\n  <li>Angel Leon</li>\n  <li>Karl Magdsick</li>\n  <li>Yusuke Naito</li>\n  <li>Dave Nicponski</li\n  <li>Christine Nicponski</li>\n  <li>Christopher Rohrs</li>\n  <li>Anurag Singla</li>\n  <li>Robert Soule</li>\n  <li>Sumeet Thadani</li>\n  <li>Ron Vogl</li>\n</ul>");
        sb.append(GUIMediator.getStringResource("ABOUT_CONTRIBUTORS_BLURB"));
        sb.append("<ul>\n  <li>Richie Bielak</li>\n  <li>Jerry Charumilind</li>\n  <li>Marvin Chase</li>\n  <li>Robert Collins</li>\n  <li>Kenneth Corbin</li>\n  <li>David Graff</li>\n  <li>Andy Hedges</li>\n  <li>Michael Hirsch</li>\n  <li>Jens-Uwe Mager</li>\n  <li>Gordon Mohr</li>\n  <li>Chance Moore</li>\n  <li>Rick T. Piazza</li>\n  <li>Eugene Romanenko</li>\n  <li>Gregorio Roper</li>\n  <li>William Rucklidge</li>\n  <li>Phil Schalm</li>\n  <li>Eric Seidel</li>\n  <li>Philippe Verdy</li>\n  <li>Stephan Weber</li>\n  <li>Jason Winzenried</li>\n</ul>");
        sb.append(GUIMediator.getStringResource("ABOUT_I18N_BLURB"));
        sb.append("<br><br>");
        sb.append(GUIMediator.getStringResource("ABOUT_COMMUNITY_BLURB"));
        sb.append("<ul>\n  <li>Vincent Falco -- Free Peers, Inc.</li>\n  <li>Gordon Mohr -- Bitzi, Inc.</li>\n  <li>John Marshall -- Gnucleus</li>\n  <li>Jason Thomas -- Swapper</li>\n  <li>Brander Lien -- ToadNode</li>\n  <li>Angelo Sotira -- www.gnutella.com</li>\n  <li>Marc Molinaro -- www.gnutelliums.com</li>\n  <li>Simon Bellwood -- www.gnutella.co.uk</li>\n  <li>Serguei Osokine</li>\n  <li>Justin Chapweske</li>\n  <li>Mike Green</li>\n  <li>Raphael Manfredi</li>\n  <li>Tor Klingberg</li>\n  <li>Mickael Prinkey</li>\n  <li>Sean Ediger</li>\n  <li>Kath Whittle</li>\n</ul>");
        sb.append(GUIMediator.getStringResource("ABOUT_CONCLUSION"));
        sb.append("</body></html>");
        return new ScrollingTextPane(sb.toString());
    }

    private String toHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase();
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    void showDialog() {
        if (GUIMediator.isAppVisible()) {
            this.DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            this.DIALOG.setLocation(GUIMediator.getScreenCenterPoint(this.DIALOG));
        }
        if (this.SCROLL_CHECK_BOX.isSelected()) {
            ActionListener startTimerListener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                        AboutWindow.this.SCROLLING_PANE.startScroll();
                    }
                }
            };
            Timer startTimer = new Timer(10000, startTimerListener);
            startTimer.setRepeats(false);
            startTimer.start();
        }
        this.DIALOG.setVisible(true);
    }
}

