/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class CheckBoxList
extends BoxPanel
implements Scrollable {
    private TextProvider provider;
    private DataCheckBox[] checkBoxes;
    private int visibleRowCount = -1;
    public static final String TEXT_PROVIDER_PROPERTY = "textProvider";

    public CheckBoxList(Object[] objects, TextProvider provider, boolean selected) {
        this.provider = provider;
        if (provider == null) {
            throw new NullPointerException("provider must not be null");
        }
        this.setBackground(UIManager.getColor("List.background"));
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setObjects(objects, selected);
    }

    public CheckBoxList(Object[] objects, TextProvider provider) {
        this(objects, provider, true);
    }

    public CheckBoxList(Object[] objects) {
        this(objects, new DefaultTextProvider());
    }

    public CheckBoxList() {
        this(new Object[0]);
    }

    public void setObjects(Object[] objects, boolean selected) {
        this.removeAll();
        this.checkBoxes = new DataCheckBox[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            this.checkBoxes[i] = new DataCheckBox(objects[i], selected);
            this.add(this.checkBoxes[i]);
        }
        this.revalidate();
    }

    public void setObjects(Object[] objects) {
        this.setObjects(objects, true);
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("List.background"));
    }

    public void setTextProvider(TextProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider must not be null");
        }
        TextProvider oldProvider = this.provider;
        this.provider = provider;
        this.firePropertyChange(TEXT_PROVIDER_PROPERTY, oldProvider, this.provider);
    }

    public void setVisibleRowCount(int rows) {
        this.visibleRowCount = rows;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.visibleRowCount > 0 && this.checkBoxes.length > 0 ? new Dimension(this.getPreferredSize().width, this.visibleRowCount * this.checkBoxes[0].getPreferredSize().height) : this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width / 10;
            }
            case 1: {
                return visibleRect.height / 10;
            }
        }
        throw new IllegalArgumentException("Unknown orientation " + orientation);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width;
            }
            case 1: {
                return visibleRect.height;
            }
        }
        throw new IllegalArgumentException("Unknown orientation " + orientation);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Object[] getSelectedObjects(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            if (!this.checkBoxes[i].isSelected()) continue;
            list.add(this.checkBoxes[i].getData());
        }
        return list.toArray(array);
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedObjects(new Object[0]);
    }

    public Action[] getActions() {
        return new Action[]{new SelectAllAction(), new DeselectAllAction()};
    }

    private class DeselectAllAction
    extends AbstractAction {
        public DeselectAllAction() {
            this.putValue("Name", GUIMediator.getStringResource("CHECK_BOX_LIST_DESELECT_ALL_ACTION_NAME"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("CHECK_BOX_LIST_DESELECT_ALL_ACTION_TOOLTIP"));
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < CheckBoxList.this.checkBoxes.length; ++i) {
                CheckBoxList.this.checkBoxes[i].setSelected(false);
            }
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            this.putValue("Name", GUIMediator.getStringResource("CHECK_BOX_LIST_SELECT_ALL_ACTION_NAME"));
            this.putValue("ShortDescription", GUIMediator.getStringResource("CHECK_BOX_LIST_SELECT_ALL_ACTION_TOOLTIP"));
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < CheckBoxList.this.checkBoxes.length; ++i) {
                CheckBoxList.this.checkBoxes[i].setSelected(true);
            }
        }
    }

    public static class DefaultTextProvider
    implements TextProvider {
        public String getText(Object obj) {
            return obj.toString();
        }

        public String getToolTipText(Object obj) {
            return null;
        }
    }

    private class DataCheckBox
    extends JCheckBox {
        private Object obj;

        public DataCheckBox(Object obj, boolean selected) {
            super(CheckBoxList.this.provider.getText(obj), selected);
            this.obj = obj;
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setFont(UIManager.getFont("List.font"));
            this.setOpaque(false);
            this.setSelected(selected);
            this.setToolTipText(CheckBoxList.this.provider.getToolTipText(obj));
        }

        public Object getData() {
            return this.obj;
        }

        public void updateUI() {
            super.updateUI();
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setFont(UIManager.getFont("List.font"));
            this.setOpaque(false);
        }
    }

    public static interface TextProvider {
        public String getText(Object var1);

        public String getToolTipText(Object var1);
    }
}

