/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BasicFileIconController;
import com.limegroup.gnutella.gui.ButtonIconController;
import com.limegroup.gnutella.gui.FileIconController;
import com.limegroup.gnutella.gui.NativeFileIconController;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.File;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class IconManager {
    private static volatile IconManager INSTANCE;
    private FileIconController fileController;
    private ButtonIconController buttonController = new ButtonIconController();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IconManager instance() {
        if (INSTANCE == null) {
            Class clazz = IconManager.class;
            synchronized (clazz) {
                if (INSTANCE == null) {
                    INSTANCE = new IconManager();
                }
            }
        }
        return INSTANCE;
    }

    private IconManager() {
        this.fileController = new BasicFileIconController();
        if (CommonUtils.isMacOSX() || CommonUtils.isWindows()) {
            ThreadFactory.startThread(new Runnable(){

                public void run() {
                    NativeFileIconController newController = new NativeFileIconController();
                    if (newController.isIconAvailable()) {
                        SwingUtilities.invokeLater(new Runnable(this, newController){
                            private final /* synthetic */ NativeFileIconController val$newController;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$newController = val$newController;
                            }

                            public void run() {
                                IconManager.access$102(1.access$000(this.this$1), this.val$newController);
                            }
                        });
                    }
                }

                static /* synthetic */ IconManager access$000(1 x0) {
                    return x0.IconManager.this;
                }
            }, "NativeFileIconLoader");
        }
    }

    public Icon getIconForFile(File f) {
        return this.fileController.getIconForFile(f);
    }

    public Icon getIconForExtension(String ext) {
        return this.fileController.getIconForExtension(ext);
    }

    public void wipeButtonIconCache() {
        this.buttonController.wipeButtonIconCache();
    }

    public Icon getIconForButton(String buttonName) {
        return this.buttonController.getIconForButton(buttonName);
    }

    public Icon getRolloverIconForButton(String buttonName) {
        return this.buttonController.getRolloverIconForButton(buttonName);
    }

    static /* synthetic */ FileIconController access$102(IconManager x0, FileIconController x1) {
        x0.fileController = x1;
        return x0.fileController;
    }
}

