/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.version.Version;
import com.limegroup.gnutella.version.VersionFormatException;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class Java14Notice
extends JDialog {
    private static final String REQUIRED = "1.4.1";
    private static final String CURRENT = System.getProperty("java.version");
    private static final String URL = "http://www.limewire.com/whyupgradejava";

    public static void showIfNecessary() {
        try {
            Version rq = new Version(REQUIRED);
            Version cr = new Version(CURRENT);
            if (cr.compareTo(rq) < 0) {
                new Java14Notice().show();
            }
        }
        catch (VersionFormatException versionFormatException) {
            // empty catch block
        }
    }

    private Java14Notice() {
        this.construct();
    }

    private void construct() {
        this.setTitle("Upgrade Java");
        this.setSize(new Dimension(100, 300));
        this.setModal(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        MultiLineLabel label = new MultiLineLabel("LimeWire requires Java 1.4.1 or higher in order to run. You are currently running an out-of-date version of Java.  Please visit http://www.limewire.com/whyupgradejava in order to upgrade your version of Java.\n\nCurrent Java Version : " + CURRENT + "\n" + "Required Java Version: " + REQUIRED + "\n\n", 400);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(label);
        JPanel buttonPanel = new JPanel();
        JButton now = new JButton("Upgrade Java");
        now.setToolTipText("Visit http://www.limewire.com/whyupgradejava");
        now.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Java14Notice.this.loadWindowsLibrary();
                    Launcher.openURL(Java14Notice.URL);
                }
                catch (UnsatisfiedLinkError ule) {
                    Java14Notice.this.openURLFailed();
                }
                catch (IOException iox) {
                    Java14Notice.this.openURLFailed();
                }
                System.exit(1);
            }
        });
        JButton later = new JButton("Upgrade Later");
        later.setToolTipText("Visit http://www.limewire.com/whyupgradejava Later");
        later.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(1);
            }
        });
        buttonPanel.add(now);
        buttonPanel.add(later);
        mainPanel.add(labelPanel);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void loadWindowsLibrary() throws UnsatisfiedLinkError {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") != -1) {
            System.loadLibrary("LimeWire20");
        }
    }

    private void openURLFailed() {
        JOptionPane.showMessageDialog(this, "To update, please direct your web-browser to http://www.limewire.com/whyupgradejava.", "Unable to open browser", 0);
    }
}

