/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.IntSetting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class MessageService {
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;
    public static final int CANCEL_OPTION = 103;
    public static final int REMEMBER_ANSWER = 1;
    public static final int FORGET_ANSWER = 0;
    private final Map _disposableMessageMap = new HashMap();
    private static final MessageService INSTANCE = new MessageService();

    public static MessageService instance() {
        return INSTANCE;
    }

    MessageService() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_MESSAGE_SERVICE"));
    }

    final void showError(String message) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_ERROR_CAPTION"), 0);
    }

    final void showError(String message, BooleanSetting ignore) {
        if (!ignore.getValue()) {
            JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), GUIMediator.getStringResource("MESSAGE_ERROR_CAPTION"), 0);
        }
    }

    final void showWarning(String message, BooleanSetting ignore) {
        if (!ignore.getValue()) {
            JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), GUIMediator.getStringResource("MESSAGE_WARNING_CAPTION"), 2);
        }
    }

    final void showWarning(String message) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_WARNING_CAPTION"), 2);
    }

    public final void showMessage(Component toDisplay) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), toDisplay, GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
    }

    final void showMessage(String message) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
    }

    final void showMessage(String message, BooleanSetting ignore) {
        if (!ignore.getValue()) {
            JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
        }
    }

    final void showDisposableMessage(String dialogKey, String message, int msgType) {
        this.showDisposableMessage(dialogKey, message, null, msgType);
    }

    /*
     * WARNING - void declaration
     */
    final void showDisposableMessage(String dialogKey, String message, BooleanSetting ignore, int msgType) {
        switch (msgType) {
            case 0: {
                String title = GUIMediator.getStringResource("MESSAGE_ERROR_CAPTION");
                break;
            }
            case 2: {
                String title = GUIMediator.getStringResource("MESSAGE_WARNING_CAPTION");
                break;
            }
            case -1: 
            case 1: {
                String title = GUIMediator.getStringResource("MESSAGE_CAPTION");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Message Type: " + msgType);
            }
        }
        if (ignore == null || !ignore.getValue()) {
            if (this._disposableMessageMap.containsKey(dialogKey)) {
                JDialog dialog = (JDialog)this._disposableMessageMap.get(dialogKey);
                dialog.toFront();
                dialog.setVisible(true);
            } else {
                void var5_5;
                Object component = message;
                if (ignore != null) {
                    component = this.doNotDisplayAgainLabel(message, ignore);
                }
                JOptionPane pane = new JOptionPane(component, msgType);
                JDialog dialog = pane.createDialog(MessageService.getParentComponent(), (String)var5_5);
                dialog.setModal(true);
                this._disposableMessageMap.put(dialogKey, dialog);
                dialog.setVisible(true);
                this._disposableMessageMap.remove(dialogKey);
            }
        }
    }

    final void hideDisposableMessage(String dialogKey) {
        JDialog dialog = (JDialog)this._disposableMessageMap.get(dialogKey);
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
        }
    }

    final void showConfirmMessage(String message) {
        JOptionPane.showConfirmDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
    }

    final void showConfirmMessage(String message, BooleanSetting ignore) {
        if (!ignore.getValue()) {
            JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
        }
    }

    final int showYesNoMessage(String message) {
        return this.showYesNoMessage(message, GUIMediator.getStringResource("MESSAGE_CAPTION"));
    }

    final int showYesNoMessage(String message, String title) {
        int option;
        try {
            option = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), new MultiLineLabel(message), title, 0);
        }
        catch (InternalError ie) {
            option = 1;
        }
        if (option == 0) {
            return 101;
        }
        return 102;
    }

    final int showYesNoMessage(String message, IntSetting defValue) {
        int option;
        if (defValue.getValue() == 101 || defValue.getValue() == 102) {
            return defValue.getValue();
        }
        try {
            option = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), GUIMediator.getStringResource("MESSAGE_CAPTION"), 0);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            option = 1;
        }
        catch (InternalError ie) {
            option = 1;
        }
        int ret = option == 0 ? 101 : 102;
        if (defValue.getValue() == 1) {
            defValue.setValue(ret);
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    final int showYesNoCancelMessage(String message) {
        int option;
        try {
            option = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
        }
        catch (InternalError ie) {
            option = 1;
        }
        if (option == 0) {
            return 101;
        }
        if (option == 1) {
            return 102;
        }
        return 103;
    }

    final int showYesNoCancelMessage(String message, IntSetting defValue) {
        int option;
        if (defValue.getValue() == 101 || defValue.getValue() == 102 || defValue.getValue() == 103) {
            return defValue.getValue();
        }
        try {
            option = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            option = 2;
        }
        catch (InternalError ie) {
            option = 2;
        }
        int ret = option == 0 ? 101 : (option == 1 ? 102 : 103);
        if (defValue.getValue() == 1 && ret != 103) {
            defValue.setValue(ret);
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    final String showInputMessage(String message, String initialValue) {
        if (initialValue == null) {
            return JOptionPane.showInputDialog(MessageService.getParentComponent(), (Object)message);
        }
        return JOptionPane.showInputDialog(MessageService.getParentComponent(), message, initialValue);
    }

    public static Component getParentComponent() {
        if (GUIMediator.isOptionsVisible()) {
            return GUIMediator.getMainOptionsComponent();
        }
        return GUIMediator.getAppFrame();
    }

    private final JComponent doNotDisplayAgainLabel(String message, final BooleanSetting setting) {
        JPanel thePanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox option = new JCheckBox(GUIMediator.getStringResource("OPTIONS_DO_NOT_ASK_AGAIN"));
        MultiLineLabel lbl = new MultiLineLabel(message);
        thePanel.add((Component)lbl, "North");
        thePanel.add((Component)option, "West");
        option.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                setting.setValue(e.getStateChange() == 1);
            }
        });
        return thePanel;
    }

    private final JComponent alwaysUseThisAnswerLabel(String message, final IntSetting setting) {
        JPanel thePanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox option = new JCheckBox(GUIMediator.getStringResource("OPTIONS_ALWAYS_USE_ANSWER"));
        MultiLineLabel lbl = new MultiLineLabel(message);
        thePanel.add((Component)lbl, "North");
        thePanel.add((Component)option, "West");
        option.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    setting.setValue(1);
                } else {
                    setting.setValue(0);
                }
            }
        });
        return thePanel;
    }
}

