/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;

public final class SaveDirectoryHandler {
    private SaveDirectoryHandler() {
    }

    private static void showSaveDirectoryWindow() {
        File dir = null;
        while (!SaveDirectoryHandler.isSaveDirectoryValid(dir)) {
            GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY_WINDOW");
            dir = SaveDirectoryHandler.showChooser();
            if (dir == null) continue;
            FileUtils.setWriteable(dir);
        }
    }

    private static File showChooser() {
        File dir = FileChooserHandler.getInputDirectory(null);
        if (dir != null) {
            try {
                SharingSettings.setSaveDirectory(dir);
                SharingSettings.DIRECTORIES_TO_SHARE.add(dir);
                return dir;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isSaveDirectoryValid(File saveDir) {
        block19: {
            if (saveDir == null || !saveDir.exists() || !saveDir.isDirectory()) {
                return false;
            }
            FileUtils.setWriteable(saveDir);
            Random generator = new Random();
            File testFile = null;
            for (int i = 0; i < 10 && testFile == null; ++i) {
                StringBuffer name = new StringBuffer();
                for (int j = 0; j < 8; ++j) {
                    name.append((char)(97 + generator.nextInt(25)));
                }
                name.append(".tmp");
                testFile = new File(saveDir, name.toString());
                if (!testFile.exists()) continue;
                testFile = null;
            }
            if (testFile == null) {
                return false;
            }
            RandomAccessFile testRAFile = null;
            testRAFile = new RandomAccessFile(testFile, "rw");
            testRAFile.write(7);
            testRAFile.close();
            Object var7_9 = null;
            testFile.delete();
            try {
                if (testRAFile != null) {
                    testRAFile.close();
                }
                break block19;
            }
            catch (IOException ignored) {}
            break block19;
            {
                boolean bl;
                catch (FileNotFoundException e) {
                    bl = false;
                    Object var7_10 = null;
                    testFile.delete();
                    try {
                        if (testRAFile != null) {
                            testRAFile.close();
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (IOException e) {
                    try {
                        bl = false;
                        Object var7_11 = null;
                        testFile.delete();
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        testFile.delete();
                        try {
                            if (testRAFile != null) {
                                testRAFile.close();
                            }
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (testRAFile != null) {
                            testRAFile.close();
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return bl;
                }
            }
        }
        return saveDir.canWrite();
    }

    public static void handleSaveDirectory() {
        File saveDir = SharingSettings.getSaveDirectory();
        if (!SaveDirectoryHandler.isSaveDirectoryValid(saveDir)) {
            SaveDirectoryHandler.showSaveDirectoryWindow();
        }
    }
}

