/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.iTunesSettings;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Switch;
import com.limegroup.gnutella.version.UpdateInformation;
import java.io.File;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;

public final class VisualConnectionCallback
implements ActivityCallback {
    private final HandleQueryString HANDLE_QUERY_STRING = new HandleQueryString();

    VisualConnectionCallback() {
    }

    public void connectionInitializing(Connection c) {
        ConnectionInitializing doWorkRunnable = new ConnectionInitializing(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void connectionInitialized(Connection c) {
        ConnectionInitialized doWorkRunnable = new ConnectionInitialized(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void connectionClosed(Connection c) {
        ConnectionClosed doWorkRunnable = new ConnectionClosed(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void handleQueryString(String query) {
        this.HANDLE_QUERY_STRING.addQueryString(query);
    }

    public void handleQueryResult(final RemoteFileDesc rfd, final HostData data, final Set locs) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.handleQueryResult(rfd, data, locs);
            }
        });
    }

    public boolean isQueryAlive(GUID guid) {
        return SearchMediator.queryIsAlive(guid);
    }

    public void fileManagerLoaded() {
        if (DaapSettings.DAAP_ENABLED.getValue()) {
            Runnable r = new Runnable(){

                public void run() {
                    DaapManager.instance().fileManagerLoaded();
                }
            };
            GUIMediator.instance().schedule(r);
        }
    }

    public void handleSharedFileUpdate(File file) {
        this.mf().getLibraryMediator().updateSharedFile(file);
    }

    public void handleFileEvent(final FileManagerEvent evt) {
        if (DaapSettings.DAAP_ENABLED.getValue() && DaapManager.instance().isEnabled()) {
            Runnable r = new Runnable(){

                public void run() {
                    DaapManager.instance().handleFileManagerEvent(evt);
                }
            };
            GUIMediator.instance().schedule(r);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().handleFileManagerEvent(evt);
            }
        });
    }

    public void fileManagerLoading() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().clearLibrary();
            }
        });
        if (DaapSettings.DAAP_ENABLED.getValue()) {
            Runnable r = new Runnable(){

                public void run() {
                    DaapManager.instance().fileManagerLoading();
                }
            };
            GUIMediator.instance().schedule(r);
        }
    }

    public void addDownload(Downloader mgr) {
        AddDownload doWorkRunnable = new AddDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void removeDownload(Downloader mgr) {
        RemoveDownload doWorkRunnable = new RemoveDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
        if (iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() && mgr.getState() == 4) {
            iTunesMediator.instance().addSong(mgr.getSaveFile());
        }
    }

    public void downloadsComplete() {
        Finalizer.setDownloadsComplete();
    }

    public void showDownloads() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().setWindow(0);
            }
        });
    }

    public void addUpload(Uploader mgr) {
        AddUpload doWorkRunnable = new AddUpload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void removeUpload(Uploader mgr) {
        RemoveUpload doWorkRunnable = new RemoveUpload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void uploadsComplete() {
        Finalizer.setUploadsComplete();
    }

    public void acceptChat(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().acceptChat(chatter);
            }
        });
    }

    public void receiveMessage(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().receiveMessage(chatter);
            }
        });
    }

    public void chatUnavailable(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().chatUnavailable(chatter);
            }
        });
    }

    public void chatErrorMessage(final Chatter chatter, final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatUIManager.instance().chatErrorMessage(chatter, str);
            }
        });
    }

    public void addressStateChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GUIMediator.isConstructed()) {
                    SearchMediator.addressChanged();
                }
            }
        });
    }

    public void disconnected() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GUIMediator.isConstructed()) {
                    GUIMediator.disconnected();
                }
            }
        });
    }

    public boolean warnAboutSharingSensitiveDirectory(final File dir) {
        final Switch share = new Switch();
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                String dirName = GUIUtils.convertToNonBreakingSpaces(4, dir.getAbsolutePath());
                int retval = GUIMediator.showYesNoMessage("MESSAGE_SENSITIVE_SHARE_TOP", (Object)("\n\n" + dirName + "\n\n"), "MESSAGE_SENSITIVE_SHARE_BOTTOM");
                if (retval == 101) {
                    share.turnOn();
                    RouterService.getFileManager().validateSensitiveFile(dir);
                } else {
                    share.turnOff();
                    RouterService.getFileManager().invalidateSensitiveFile(dir);
                }
            }
        });
        return share.isOn();
    }

    public void setAnnotateEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.mf().getLibraryMediator().setAnnotateEnabled(enabled);
            }
        });
    }

    public void updateAvailable(UpdateInformation update) {
        GUIMediator.instance().showUpdateNotification(update);
    }

    public void browseHostFailed(final GUID guid) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.browseHostFailed(guid);
            }
        });
    }

    public void promptAboutCorruptDownload(Downloader downloader) {
        final Downloader dloader = downloader;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int resp = GUIMediator.showYesNoMessage("MESSAGE_FILE_CORRUPT", dloader.getSaveFile().getName(), "MESSAGE_CONTINUE_DOWNLOAD", QuestionsHandler.CORRUPT_DOWNLOAD);
                dloader.discardCorruptDownload(resp == 102);
            }
        });
    }

    public void restoreApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.restoreView();
            }
        });
    }

    public void componentLoading(final String component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_COMPONENT_LOADING_" + component));
            }
        });
    }

    public void acceptedIncomingChanged(final boolean status) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().getStatusLine().updateFirewallLabel(status);
            }
        });
    }

    public String getHostValue(String key) {
        return GUIMediator.getStringResource(key);
    }

    private MainFrame mf() {
        return GUIMediator.instance().getMainFrame();
    }

    public boolean handleMagnets(final MagnetOptions[] magnets) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean oneSearchStarted = false;
                for (int i = 0; i < magnets.length; ++i) {
                    if (magnets[i].isKeywordTopicOnly() && !oneSearchStarted) {
                        String query = StringUtils.createQueryString(magnets[i].getKeywordTopic());
                        SearchInformation info = SearchInformation.createKeywordSearch(query, null, MediaType.getAnyTypeMediaType());
                        if (SearchMediator.validateInfo(info) != 0) continue;
                        oneSearchStarted = true;
                        SearchMediator.triggerSearch(info);
                        continue;
                    }
                    DownloaderUtils.createDownloader(magnets[i]);
                }
                if (magnets.length > 0) {
                    GUIMediator.instance().setWindow(0);
                }
            }
        });
        return true;
    }

    private class RemoveUpload
    implements Runnable {
        private Uploader mgr;

        public RemoveUpload(Uploader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getUploadMediator().remove(this.mgr);
        }
    }

    private class AddUpload
    implements Runnable {
        private Uploader up;

        public AddUpload(Uploader up) {
            this.up = up;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getUploadMediator().add(this.up);
        }
    }

    private class RemoveDownload
    implements Runnable {
        private Downloader mgr;

        public RemoveDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getDownloadMediator().remove(this.mgr);
            VisualConnectionCallback.this.mf().getLibraryMediator().quickRefresh();
            SearchMediator.updateResults();
        }
    }

    private class AddDownload
    implements Runnable {
        private Downloader mgr;

        public AddDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getDownloadMediator().add(this.mgr);
        }
    }

    private class HandleQueryString
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addQueryString(String query) {
            this.list.add(query);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            while (this.list.size() > 0) {
                String query = (String)this.list.elementAt(0);
                this.list.remove(0);
                VisualConnectionCallback.this.mf().getMonitorView().handleQueryString(query);
            }
            this.active = false;
        }
    }

    private class ConnectionClosed
    implements Runnable {
        private Connection c;

        public ConnectionClosed(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().remove(this.c);
        }
    }

    private class ConnectionInitialized
    implements Runnable {
        private Connection c;

        public ConnectionInitialized(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().update(this.c);
        }
    }

    private class ConnectionInitializing
    implements Runnable {
        private Connection c;

        public ConnectionInitializing(Connection c) {
            this.c = c;
        }

        public void run() {
            VisualConnectionCallback.this.mf().getConnectionMediator().add(this.c);
        }
    }
}

