/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ChatFrame
extends JFrame
implements ThemeObserver {
    private final String BLOCK_BUTTON_LABEL = "CHAT_BLOCK_BUTTON_LABEL";
    private final String SEND_BUTTON_LABEL = "CHAT_SEND_BUTTON_LABEL";
    private final String BLOCK_BUTTON_TIP = "CHAT_BLOCK_BUTTON_TIP";
    private final String SEND_BUTTON_TIP = "CHAT_SEND_BUTTON_TIP";
    private final String WITH_LABEL = "CHAT_WITH_LABEL";
    private final String UNAVAILABLE_LABEL = "CHAT_HOST_UNAVAILABLE";
    private final String YOU_LABEL = "CHAT_YOU";
    private final int WINDOW_WIDTH = 500;
    private final int WINDOW_HEIGHT = 300;
    private final int WINDOW_MIN_WIDTH = 250;
    private final int WINDOW_MIN_HEIGHT = 200;
    private final int TEXT_FIELD_LIMIT = 500;
    private boolean _connected = true;
    JTextArea _area;
    JTextField _field;
    JTextField _connectField;
    Chatter _chat;
    ButtonRow _buttons;

    public ChatFrame(Chatter chat) {
        this.setTitle(GUIMediator.getStringResource("CHAT_WITH_LABEL") + " " + chat.getHost());
        this.setSize(500, 300);
        this._chat = chat;
        JFrame parentFrame = GUIMediator.getAppFrame();
        int mwidth = parentFrame.getSize().width / 2;
        int mheight = parentFrame.getSize().height / 2;
        int fwidth = this.getSize().width / 2;
        int fheight = this.getSize().height / 2;
        int xlocation = mwidth - fwidth;
        int ylocation = mheight - fheight;
        int xstart = parentFrame.getLocation().x;
        int ystart = parentFrame.getLocation().y;
        this.setLocation(xstart + xlocation, ystart + ylocation);
        BlockListener blockListener = new BlockListener();
        SendListener sendListener = new SendListener();
        String[] buttonLabels = new String[]{"CHAT_BLOCK_BUTTON_LABEL", "CHAT_SEND_BUTTON_LABEL"};
        String[] buttonTips = new String[]{"CHAT_BLOCK_BUTTON_TIP", "CHAT_SEND_BUTTON_TIP"};
        ActionListener[] buttonListeners = new ActionListener[]{blockListener, sendListener};
        this._buttons = new ButtonRow(buttonLabels, buttonTips, buttonListeners, 0, 14);
        this._buttons.setButtonEnabled(1, false);
        TextPanel tp = new TextPanel();
        BoxPanel mainPanel = new BoxPanel(1);
        PaddedPanel myPanel = new PaddedPanel();
        myPanel.setPreferredSize(new Dimension(1000, 1000));
        myPanel.add(tp);
        mainPanel.add(myPanel);
        mainPanel.add(Box.createVerticalStrut(6));
        mainPanel.add(this._buttons);
        mainPanel.add(Box.createVerticalStrut(6));
        this.getContentPane().add(mainPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ChatFrame.this._chat.stop();
                ChatUIManager.instance().removeChat(ChatFrame.this._chat);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JFrame src = (JFrame)e.getSource();
                int width = src.getWidth();
                int height = src.getHeight();
                int newWidth = Math.max(width, 250);
                int newHeight = Math.max(height, 200);
                if (newWidth != width || newHeight != height) {
                    src.setSize(newWidth, newHeight);
                }
            }
        });
        this.updateTheme();
    }

    public void updateTheme() {
        ImageIcon plugIcon = GUIMediator.getThemeImage("limeicon");
        this.setIconImage(plugIcon.getImage());
    }

    public void addResponse(String str) {
        String host = this._chat.getHost();
        this._area.setText(this._area.getText() + host + ": " + str + "\n");
    }

    public void setChat(Chatter chat) {
        this._chat = chat;
    }

    public void chatUnavailable() {
        this._area.setForeground(Color.red);
        this._area.setText(this._area.getText() + GUIMediator.getStringResource("CHAT_HOST_UNAVAILABLE") + "\n");
        this._connected = false;
        this._buttons.setButtonEnabled(1, false);
    }

    public void displayErrorMessage(String str) {
        this._area.setForeground(Color.red);
        this._area.setText(str);
    }

    private void send() {
        if (!this._connected) {
            return;
        }
        String str = this._field.getText();
        if (str.length() == 0) {
            return;
        }
        this._field.setText("");
        this._buttons.setButtonEnabled(1, false);
        this._area.setText(this._area.getText() + GUIMediator.getStringResource("CHAT_YOU") + ": " + str + "\n");
        try {
            this._chat.send(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class JTextFieldKeyListener
    implements KeyListener {
        private JTextFieldKeyListener() {
        }

        public void keyTyped(KeyEvent k) {
            if (k.getKeyChar() == '\n') {
                ChatFrame.this.send();
            }
        }

        public void keyPressed(KeyEvent k) {
        }

        public void keyReleased(KeyEvent k) {
            String text = ChatFrame.this._field.getText();
            if (text.length() == 0) {
                ChatFrame.this._buttons.setButtonEnabled(1, false);
            } else if (ChatFrame.this._connected) {
                ChatFrame.this._buttons.setButtonEnabled(1, true);
            }
        }
    }

    private class BlockListener
    implements ActionListener {
        private BlockListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String host = ChatFrame.this._chat.getHost();
            ChatFrame.this._chat.blockHost(host);
            ChatFrame.this._chat.stop();
        }
    }

    private class SendListener
    implements ActionListener {
        private SendListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ChatFrame.this.send();
        }
    }

    private class EndListener
    implements ActionListener {
        private EndListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ChatFrame.this._chat.stop();
            ChatUIManager.instance().removeChat(ChatFrame.this._chat);
        }
    }

    private class TextPanel
    extends JPanel {
        public TextPanel() {
            this.setLayout(new BoxLayout(this, 1));
            BoxPanel fieldPanel = new BoxPanel(0);
            ChatFrame.this._area = new JTextArea();
            ChatFrame.this._area.setLineWrap(true);
            ChatFrame.this._field = new JTextField();
            ChatFrame.this._field.setDocument(new JTextFieldLimit(500));
            JScrollPane areaScrollPane = new JScrollPane(ChatFrame.this._area);
            ChatFrame.this._area.setEditable(false);
            ChatFrame.this._field.addKeyListener(new JTextFieldKeyListener());
            fieldPanel.add(Box.createHorizontalStrut(6));
            fieldPanel.add(ChatFrame.this._field);
            fieldPanel.add(Box.createHorizontalStrut(6));
            fieldPanel.setPreferredSize(new Dimension(1000, 20));
            fieldPanel.setMaximumSize(new Dimension(1000, 20));
            this.add(areaScrollPane);
            this.add(Box.createVerticalStrut(6));
            this.add(fieldPanel);
        }
    }

    private class JTextFieldLimit
    extends PlainDocument {
        private int limit;

        public JTextFieldLimit(int limit) {
            this.limit = limit;
        }

        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

