/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.connection.BandwidthHolder;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.connection.DroppedHolder;
import com.limegroup.gnutella.gui.connection.MessagesHolder;
import com.limegroup.gnutella.gui.connection.ProtocolHolder;
import com.limegroup.gnutella.gui.connection.QRPHolder;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public final class ConnectionDataLine
extends AbstractDataLine {
    static final int HOST_IDX = 0;
    private static final LimeTableColumn HOST_COLUMN = new LimeTableColumn(0, "CV_COLUMN_HOST", 218, true, String.class);
    static final int STATUS_IDX = 1;
    private static final LimeTableColumn STATUS_COLUMN = new LimeTableColumn(1, "CV_COLUMN_STATUS", 70, true, String.class);
    static final int MESSAGES_IDX = 2;
    private static final LimeTableColumn MESSAGES_COLUMN = new LimeTableColumn(2, "CV_COLUMN_MESSAGE", 97, true, MessagesHolder.class);
    static final int BANDWIDTH_IDX = 3;
    private static final LimeTableColumn BANDWIDTH_COLUMN = new LimeTableColumn(3, "CV_COLUMN_BANDWIDTH", 115, true, BandwidthHolder.class);
    static final int DROPPED_IDX = 4;
    private static final LimeTableColumn DROPPED_COLUMN = new LimeTableColumn(4, "CV_COLUMN_DROPPED", 92, true, DroppedHolder.class);
    static final int PROTOCOL_IDX = 5;
    private static final LimeTableColumn PROTOCOL_COLUMN = new LimeTableColumn(5, "CV_COLUMN_PROTOCOL", 60, true, ProtocolHolder.class);
    static final int VENDOR_IDX = 6;
    private static final LimeTableColumn VENDOR_COLUMN = new LimeTableColumn(6, "CV_COLUMN_VENDOR", 116, true, String.class);
    static final int TIME_IDX = 7;
    private static final LimeTableColumn TIME_COLUMN = new LimeTableColumn(7, "CV_COLUMN_TIME", 44, true, TimeRemainingHolder.class);
    static final int COMPRESSION_IDX = 8;
    private static final LimeTableColumn COMPRESS_COLUMN = new LimeTableColumn(8, "CV_COLUMN_COMPRESSION", 114, false, DroppedHolder.class);
    static final int QRP_FULL_IDX = 9;
    private static final LimeTableColumn QRP_FULL_COLUMN = new LimeTableColumn(9, "CV_COLUMN_QRP_FULL", 70, false, QRPHolder.class);
    static final int QRP_USED_IDX = 10;
    private static final LimeTableColumn QRP_USED_COLUMN = new LimeTableColumn(10, "CV_COLUMN_QRP_USED", 70, false, String.class);
    static final int NUMBER_OF_COLUMNS = 11;
    private ManagedConnection MCONNECTION;
    private static final String CONNECTING_STRING = GUIMediator.getStringResource("CV_TABLE_STRING_CONNECTING");
    private static final String OUTGOING_STRING = GUIMediator.getStringResource("CV_TABLE_STRING_OUTGOING");
    private static final String INCOMING_STRING = GUIMediator.getStringResource("CV_TABLE_STRING_INCOMING");
    private static final String CONNECTED_ON = GUIMediator.getStringResource("CV_TABLE_STRING_CONNECTED_ON");
    private volatile String _host;
    private String _status;
    private long _time;
    private boolean _isConnecting = true;
    private boolean _hasResolvedAddress = false;
    private static volatile boolean _hostChanged = false;
    private static boolean _updated = false;

    public int getColumnCount() {
        return 11;
    }

    public void initialize(Object conn) {
        super.initialize(conn);
        this.MCONNECTION = (ManagedConnection)conn;
        this._host = this.MCONNECTION.getAddress();
        this._status = CONNECTING_STRING;
        this._time = System.currentTimeMillis();
    }

    public Object getValueAt(int idx) {
        switch (idx) {
            case 0: {
                if (!this._hasResolvedAddress && !this._isConnecting && System.currentTimeMillis() - this._time > 10000L) {
                    this.assignHostName();
                }
                return this._host;
            }
            case 1: {
                return this._status;
            }
            case 2: {
                if (this._isConnecting) {
                    return null;
                }
                return new MessagesHolder(this.MCONNECTION.getNumMessagesReceived(), this.MCONNECTION.getNumMessagesSent());
            }
            case 3: {
                if (this._isConnecting) {
                    return null;
                }
                return new BandwidthHolder(this.MCONNECTION.getMeasuredDownstreamBandwidth(), this.MCONNECTION.getMeasuredUpstreamBandwidth());
            }
            case 4: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder((float)this.MCONNECTION.getNumReceivedMessagesDropped() / ((float)this.MCONNECTION.getNumMessagesReceived() + 1.0f), (float)this.MCONNECTION.getNumSentMessagesDropped() / ((float)this.MCONNECTION.getNumMessagesSent() + 1.0f));
            }
            case 5: {
                return new ProtocolHolder(this.MCONNECTION);
            }
            case 6: {
                if (this._isConnecting) {
                    return null;
                }
                String vendor = this.MCONNECTION.getUserAgent();
                return vendor == null ? "" : vendor;
            }
            case 7: {
                return new TimeRemainingHolder((int)((System.currentTimeMillis() - this._time) / 1000L));
            }
            case 8: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder(this.MCONNECTION.getReadSavedFromCompression(), this.MCONNECTION.getSentSavedFromCompression());
            }
            case 9: {
                if (this._isConnecting) {
                    return null;
                }
                return new QRPHolder(this.MCONNECTION.getQueryRouteTablePercentFull(), this.MCONNECTION.getQueryRouteTableSize());
            }
            case 10: {
                if (this._isConnecting) {
                    return null;
                }
                int empty = this.MCONNECTION.getQueryRouteTableEmptyUnits();
                int inuse = this.MCONNECTION.getQueryRouteTableUnitsInUse();
                if (empty == -1 || inuse == -1) {
                    return null;
                }
                return empty + " / " + inuse;
            }
        }
        return null;
    }

    private void assignHostName() {
        this._hasResolvedAddress = true;
        GUIMediator.instance().schedule(new HostAssigner(this));
    }

    public LimeTableColumn getColumn(int idx) {
        switch (idx) {
            case 0: {
                return HOST_COLUMN;
            }
            case 1: {
                return STATUS_COLUMN;
            }
            case 2: {
                return MESSAGES_COLUMN;
            }
            case 3: {
                return BANDWIDTH_COLUMN;
            }
            case 4: {
                return DROPPED_COLUMN;
            }
            case 5: {
                return PROTOCOL_COLUMN;
            }
            case 6: {
                return VENDOR_COLUMN;
            }
            case 7: {
                return TIME_COLUMN;
            }
            case 8: {
                return COMPRESS_COLUMN;
            }
            case 9: {
                return QRP_FULL_COLUMN;
            }
            case 10: {
                return QRP_USED_COLUMN;
            }
        }
        return null;
    }

    public boolean isClippable(int idx) {
        return true;
    }

    public int getTypeAheadColumn() {
        return 0;
    }

    public boolean isDynamic(int idx) {
        switch (idx) {
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 0: {
                if (_hostChanged) {
                    _hostChanged = false;
                    return true;
                }
                return false;
            }
            case 1: 
            case 5: 
            case 6: {
                if (_updated) {
                    _updated = false;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    boolean isPeer() {
        return this.MCONNECTION.isSupernodeSupernodeConnection();
    }

    boolean isUltrapeer() {
        return this.MCONNECTION.isClientSupernodeConnection();
    }

    boolean isLeaf() {
        return this.MCONNECTION.isSupernodeClientConnection();
    }

    boolean isConnecting() {
        return this._isConnecting;
    }

    public void update() {
        this._isConnecting = false;
        boolean isOutgoing = this.MCONNECTION.isOutgoing();
        this._status = isOutgoing ? OUTGOING_STRING : INCOMING_STRING;
        this._host = this.MCONNECTION.getInetAddress().getHostAddress();
        if (isOutgoing) {
            ConnectionMediator.instance().addKnownHost(this._host, this.MCONNECTION.getPort());
        }
        _updated = true;
        this._time = this.MCONNECTION.getConnectionTime();
    }

    public boolean isConnected() {
        return !this._isConnecting;
    }

    public String[] getToolTipArray(int col) {
        Properties p = this.MCONNECTION.headers().props();
        ArrayList<String> tips = new ArrayList<String>();
        if (p == null) {
            tips.add(CONNECTED_ON + " " + GUIUtils.msec2DateTime(this._time));
        } else {
            tips.add(CONNECTED_ON + " " + GUIUtils.msec2DateTime(this._time));
            tips.add("");
            Enumeration<?> ps = p.propertyNames();
            while (ps.hasMoreElements()) {
                String k = (String)ps.nextElement();
                tips.add(k + ": " + p.getProperty(k));
            }
        }
        return tips.toArray(new String[0]);
    }

    private static class HostAssigner
    implements Runnable {
        private final WeakReference line;

        HostAssigner(ConnectionDataLine cdl) {
            this.line = new WeakReference<ConnectionDataLine>(cdl);
        }

        public void run() {
            ConnectionDataLine cdl = (ConnectionDataLine)this.line.get();
            if (cdl != null) {
                try {
                    cdl._host = InetAddress.getByName(cdl._host).getHostName();
                    _hostChanged = true;
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
    }
}

