/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.download.DownloaderFactory;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.List;

public class SearchResultDownloaderFactory
implements DownloaderFactory {
    private RemoteFileDesc[] rfds;
    private List alts;
    private GUID queryGUID;
    private File saveDir;
    private String fileName;

    public SearchResultDownloaderFactory(RemoteFileDesc[] rfds, List alts, GUID queryGUID, File saveDir, String fileName) {
        this.rfds = rfds;
        this.alts = alts;
        this.queryGUID = queryGUID;
        this.saveDir = saveDir;
        this.fileName = fileName != null ? fileName : rfds[0].getFileName();
    }

    public URN getURN() {
        return this.rfds[0].getSHA1Urn();
    }

    public Downloader createDownloader(boolean overwrite) throws SaveLocationException {
        return RouterService.download(this.rfds, this.alts, this.queryGUID, overwrite, this.saveDir, this.fileName);
    }

    public File getSaveFile() {
        return new File(this.saveDir != null ? this.saveDir : SharingSettings.getSaveDirectory(), this.fileName);
    }

    public void setSaveFile(File saveFile) {
        File parentDir = saveFile.getParentFile();
        if (parentDir != null && !parentDir.equals(SharingSettings.getSaveDirectory())) {
            this.saveDir = parentDir;
        }
        this.fileName = saveFile.getName();
    }

    public int getFileSize() {
        return this.rfds[0].getSize();
    }
}

