/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

final class SpeedWindow
extends SetupWindow {
    private ButtonGroup _speedGroup;
    private JRadioButton _modem;
    private JRadioButton _cable;
    private JRadioButton _t1;
    private JRadioButton _t3;

    SpeedWindow(SetupManager manager) {
        super(manager, "SETUP_SPEED_TITLE", "SETUP_SPEED_LABEL");
    }

    protected void createWindow() {
        super.createWindow();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel buttonPanel = new JPanel(new GridLayout(2, 2));
        buttonPanel.setBorder(new TitledBorder(GUIMediator.getStringResource("SETUP_SPEED_TITLED_BORDER")));
        this._speedGroup = new ButtonGroup();
        this._modem = new JRadioButton(GUIConstants.MODEM_SPEED);
        this._cable = new JRadioButton(GUIConstants.CABLE_SPEED);
        this._t1 = new JRadioButton(GUIConstants.T1_SPEED);
        this._t3 = new JRadioButton(GUIConstants.T3_SPEED);
        this._cable.setSelected(true);
        this._speedGroup.add(this._modem);
        this._speedGroup.add(this._cable);
        this._speedGroup.add(this._t1);
        this._speedGroup.add(this._t3);
        buttonPanel.add(this._modem);
        buttonPanel.add(this._cable);
        buttonPanel.add(this._t1);
        buttonPanel.add(this._t3);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        mainPanel.add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        mainPanel.add((Component)new JPanel(), gbc);
        this.setSetupComponent(mainPanel);
    }

    public void applySettings() throws ApplySettingsException {
        int speed = this.getSpeed();
        this.setDownloadSlots(speed);
        if (speed < 0 || 20000 < speed) {
            throw new IllegalArgumentException();
        }
        ConnectionSettings.CONNECTION_SPEED.setValue(speed);
    }

    private int getSpeed() {
        if (this._cable.isSelected()) {
            return 350;
        }
        if (this._t1.isSelected()) {
            return 1000;
        }
        if (this._t3.isSelected()) {
            return 3000;
        }
        return 56;
    }

    private void setDownloadSlots(int speed) {
        if (speed == 56) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(3);
        } else if (speed == 350) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(8);
        } else if (speed == 1000) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(12);
        } else if (speed == 3000) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(14);
        } else {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(3);
        }
    }
}

