/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.actions.ShareFileSpeciallyAction;
import com.limegroup.gnutella.gui.actions.ShareNewFolderAction;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.IncompleteDirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SharedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.library.SpeciallySharedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.DragManager;
import com.limegroup.gnutella.gui.tables.FileTransfer;
import com.limegroup.gnutella.gui.tables.MouseObserver;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class LibraryTree
extends JTree
implements MouseObserver {
    private static final Log LOG = LogFactory.getLog(LibraryTree.class);
    private final LibraryTreeNode ROOT_NODE = new LibraryTreeNode(new RootNodeDirectoryHolder(""));
    private RootSharedFilesDirectoryHolder rsfdh = new RootSharedFilesDirectoryHolder();
    private final DefaultTreeModel TREE_MODEL = new DefaultTreeModel(this.ROOT_NODE);
    private LibraryTreeNode savedFilesNode;
    private final SavedFilesDirectoryHolder sfdh = new SavedFilesDirectoryHolder(SharingSettings.DIRECTORY_FOR_SAVING_FILES, GUIMediator.getStringResource("LIBRARY_TREE_SAVED_DIRECTORY"));
    private LibraryTreeNode sharedFilesNode;
    private LibraryTreeNode incompleteFilesNode;
    private final IncompleteDirectoryHolder idh = new IncompleteDirectoryHolder();
    private LibraryTreeNode speciallySharedFilesNode;
    private final SpeciallySharedFilesDirectoryHolder ssfdh = new SpeciallySharedFilesDirectoryHolder();
    private static final LibraryTree INSTANCE = new LibraryTree();
    private final JPopupMenu DIRECTORY_POPUP = new JPopupMenu();
    private Action shareAction = new ShareAction();
    private Action unshareAction = new UnshareAction();
    private Action addDirToPlaylistAction = new AddDirectoryToPlaylistAction();

    public static LibraryTree instance() {
        return INSTANCE;
    }

    private LibraryTree() {
        this.setModel(this.TREE_MODEL);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setEditable(false);
        this.setInvokesStopCellEditing(true);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setCellRenderer(new LibraryTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.makePopupMenu();
        this.addMouseListener(new DefaultMouseListener(this));
        this.sharedFilesNode = new LibraryTreeNode(this.rsfdh);
        this.addNode(this.ROOT_NODE, this.sharedFilesNode);
        this.speciallySharedFilesNode = new LibraryTreeNode(this.ssfdh);
        this.savedFilesNode = new LibraryTreeNode(this.sfdh);
        this.addNode(this.ROOT_NODE, this.savedFilesNode);
        this.addPerMediaTypeDirectories();
        this.incompleteFilesNode = new LibraryTreeNode(this.idh);
        this.addNode(this.ROOT_NODE, this.incompleteFilesNode);
        this.updateTheme();
        DragManager.install(this);
        this.addTreeSelectionListener(new LibraryTreeSelectionListener());
    }

    private void addNode(LibraryTreeNode parent, LibraryTreeNode child, boolean expand) {
        int insert;
        if (parent.getIndex(child) != -1) {
            if (expand) {
                this.expandPath(new TreePath(parent.getPath()));
            }
            return;
        }
        int children = parent.getChildCount();
        if (!(child.getDirectoryHolder() instanceof SharedFilesDirectoryHolder)) {
            insert = children;
        } else {
            File f;
            for (insert = 0; insert < children && (f = ((LibraryTreeNode)parent.getChildAt(insert)).getFile()) != null && StringUtils.compareFullPrimary(f.getName(), child.getFile().getName()) < 0; ++insert) {
            }
        }
        this.TREE_MODEL.insertNodeInto(child, parent, insert);
        if (expand || parent == this.sharedFilesNode && !this.isExpanded(new TreePath(this.sharedFilesNode.getPath()))) {
            this.expandPath(new TreePath(parent.getPath()));
        }
    }

    private void addNode(LibraryTreeNode parent, LibraryTreeNode child) {
        this.addNode(parent, child, false);
    }

    private void removeNode(LibraryTreeNode parent, LibraryTreeNode child) {
        if (parent == null || child == null) {
            return;
        }
        if (parent.getIndex(child) == -1) {
            return;
        }
        this.TREE_MODEL.removeNodeFromParent(child);
    }

    private void addPerMediaTypeDirectories() {
        Iterator i = NamedMediaType.getAllNamedMediaTypes().iterator();
        while (i.hasNext()) {
            NamedMediaType nm = (NamedMediaType)i.next();
            if (nm.getMediaType().getMimeType().equals("*")) continue;
            FileSetting fs = SharingSettings.getFileSettingForMediaType(nm.getMediaType());
            MediaTypeSavedFilesDirectoryHolder dh = new MediaTypeSavedFilesDirectoryHolder(fs, nm.getName(), nm.getMediaType());
            LibraryTreeNode node = new LibraryTreeNode(dh);
            this.addNode(this.savedFilesNode, node, true);
        }
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.setBackground(tableColor);
        this.setCellRenderer(new LibraryTreeCellRenderer());
    }

    public void setInitialSelection() {
        TreePath tp = new TreePath(this.savedFilesNode.getPath());
        this.setSelectionPath(tp);
    }

    private void addSharedDirectory(File dir) {
        SharedFilesDirectoryHolder dh = new SharedFilesDirectoryHolder(dir);
        LibraryTreeNode current = new LibraryTreeNode(dh);
        int children = this.sharedFilesNode.getChildCount();
        for (int i = children - 1; i >= 0; --i) {
            LibraryTreeNode child = (LibraryTreeNode)this.sharedFilesNode.getChildAt(i);
            File f = child.getFile();
            if (f == null || !dir.equals(f.getParentFile())) continue;
            this.TREE_MODEL.removeNodeFromParent(child);
            this.addNode(current, child);
        }
        File parent = dir.getParentFile();
        LibraryTreeNode parentNode = null;
        if (parent != null) {
            parentNode = this.getNodeForFolder(parent, this.sharedFilesNode);
        }
        if (parentNode == null) {
            parentNode = this.sharedFilesNode;
        }
        this.addNode(parentNode, current);
    }

    public void handleFileManagerEvent(FileManagerEvent evt) {
        switch (evt.getKind()) {
            case 1: {
                if (!this.ssfdh.accept(evt.getFileDescs()[0].getFile())) break;
                this.addNode(this.sharedFilesNode, this.speciallySharedFilesNode, true);
                break;
            }
            case 2: {
                if (!this.ssfdh.isEmpty()) break;
                if (this.ssfdh == this.getSelectedDirectoryHolder()) {
                    this.setSelectionPath(new TreePath(this.savedFilesNode.getPath()));
                }
                this.removeNode(this.sharedFilesNode, this.speciallySharedFilesNode);
                break;
            }
            case 7: {
                File[] files = evt.getFiles();
                this.addSharedDirectory(files[0]);
                break;
            }
            case 8: {
                File removed = evt.getFiles()[0];
                this.removeFolder(removed);
            }
        }
    }

    void removeFolder(File folder) {
        LibraryTreeNode node = this.getNodeForFolder(folder, this.sharedFilesNode);
        if (node == null) {
            return;
        }
        if (this.getSelectedNode() == node) {
            this.setSelectionPath(new TreePath(this.sharedFilesNode.getPath()));
        }
        int childCount = node.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            LibraryTreeNode child = (LibraryTreeNode)node.getChildAt(i);
            this.TREE_MODEL.removeNodeFromParent(child);
            this.addNode(this.sharedFilesNode, child);
        }
        this.TREE_MODEL.removeNodeFromParent(node);
    }

    LibraryTreeNode getNodeForFolder(File folder, LibraryTreeNode parent) {
        int children = parent.getChildCount();
        for (int i = children - 1; i >= 0; --i) {
            LibraryTreeNode child = (LibraryTreeNode)parent.getChildAt(i);
            File childFile = child.getFile();
            if (childFile == null) continue;
            if (childFile.equals(folder)) {
                return child;
            }
            if (!child.isAncestorOf(folder)) continue;
            return this.getNodeForFolder(folder, child);
        }
        return null;
    }

    void addPlayListEntries() {
        if (this.incompleteDirectoryIsSelected() || !GUIMediator.isPlaylistVisible()) {
            return;
        }
        final DirectoryHolder dh = this.getSelectedDirectoryHolder();
        if (dh == null) {
            return;
        }
        if (PlaylistMediator.instance() == null) {
            return;
        }
        GUIMediator.instance().schedule(new Runnable(){

            public void run() {
                PlaylistMediator pm = GUIMediator.getPlayList();
                if (pm == null) {
                    return;
                }
                ArrayList<File> list = new ArrayList<File>();
                File[] files = dh.getFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().endsWith("mp3") && !files[i].getName().endsWith("ogg")) continue;
                    list.add(files[i]);
                }
                if (!list.isEmpty()) {
                    pm.addFilesToPlaylist(list.toArray(new File[0]));
                }
            }
        });
    }

    private boolean canBeUnshared(LibraryTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node == this.speciallySharedFilesNode) {
            return false;
        }
        if (node == this.incompleteFilesNode) {
            return false;
        }
        if (node == this.sharedFilesNode) {
            return false;
        }
        if (node.getParent() == null) {
            return false;
        }
        if (node.getParent() == this.sharedFilesNode) {
            return true;
        }
        return this.canBeUnshared((LibraryTreeNode)node.getParent());
    }

    private boolean canBeShared(LibraryTreeNode node) {
        if (node == null || node == this.incompleteFilesNode) {
            return false;
        }
        File dir = node.getDirectoryHolder().getDirectory();
        return dir != null && !RouterService.getFileManager().isCompletelySharedDirectory(dir);
    }

    public DirectoryHolder getSelectedDirectoryHolder() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            return ((LibraryTreeNode)path.getLastPathComponent()).getDirectoryHolder();
        }
        return null;
    }

    boolean droppingToIncompleteFolder(Point mousePoint) {
        TreePath path = this.getPathForLocation(mousePoint.x, mousePoint.y);
        LibraryTreeNode node = (LibraryTreeNode)path.getLastPathComponent();
        return node == this.incompleteFilesNode;
    }

    File getSelectedDirectory() {
        LibraryTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getDirectoryHolder().getDirectory();
    }

    LibraryTreeNode getSelectedNode() {
        return (LibraryTreeNode)this.getLastSelectedPathComponent();
    }

    File[] getSharedDirectories() {
        int length = this.sharedFilesNode.getChildCount();
        ArrayList<File> newFiles = new ArrayList<File>(length);
        for (int i = 0; i < length - 1; ++i) {
            LibraryTreeNode node = (LibraryTreeNode)this.sharedFilesNode.getChildAt(i);
            if (node == this.speciallySharedFilesNode) continue;
            newFiles.add(node.getDirectoryHolder().getDirectory());
        }
        return newFiles.toArray(new File[0]);
    }

    void clear() {
        boolean selected = false;
        int count = this.sharedFilesNode.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            TreeNode node = this.sharedFilesNode.getChildAt(i);
            if (node == this.getSelectedNode()) {
                selected = true;
            }
            this.sharedFilesNode.remove(i);
        }
        this.TREE_MODEL.reload(this.sharedFilesNode);
        if (selected) {
            this.setSelectionPath(new TreePath(this.sharedFilesNode));
        }
    }

    void unshareLibraryFolder() {
        LibraryTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage("delete");
        } else if (!this.canBeUnshared(node)) {
            GUIMediator.showMessage("MESSAGE_CANNOT_UNSHARE_DIRECTORY");
        } else {
            String msgKey = "MESSAGE_CONFIRM_UNSHARE_DIRECTORY";
            int response = GUIMediator.showYesNoMessage(msgKey, QuestionsHandler.UNSHARE_DIRECTORY);
            if (response != 101) {
                return;
            }
            final File file = node.getFile();
            GUIMediator.instance().schedule(new Runnable(){

                public void run() {
                    RouterService.getFileManager().removeFolderIfShared(file);
                }
            });
        }
    }

    boolean incompleteDirectoryIsSelected() {
        return this.incompleteFilesNode == this.getSelectedNode();
    }

    boolean savedDirectoryIsSelected() {
        return this.isSavedDirectory(this.getSelectedNode());
    }

    boolean sharedFoldersNodeIsSelected() {
        return this.getSelectedNode() == this.sharedFilesNode;
    }

    private boolean isSavedDirectory(LibraryTreeNode node) {
        return node == this.savedFilesNode || node != null && node.getParent() == this.savedFilesNode;
    }

    private void showIncompleteFolderMessage(String action) {
        String key1 = "MESSAGE_INCOMPLETE_DIRECTORY_START";
        String key2 = "MESSAGE_INCOMPLETE_DIRECTORY_END";
        GUIMediator.showError(key1, (Object)action, key2);
    }

    private boolean isEnqueueable() {
        File[] files;
        LibraryTreeNode node = this.getSelectedNode();
        boolean enqueueable = false;
        if (node != null && node != this.incompleteFilesNode && node != this.sharedFilesNode && (files = node.getDirectoryHolder().getFiles()) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (!GUIMediator.isPlaylistVisible() || !PlaylistMediator.isPlayableFile(files[i])) continue;
                enqueueable = true;
            }
        }
        return enqueueable;
    }

    public void setPlayerEnabled(boolean value) {
        this.addDirToPlaylistAction.setEnabled(this.isEnqueueable());
    }

    private void makePopupMenu() {
        this.DIRECTORY_POPUP.add(new JMenuItem(this.shareAction));
        this.DIRECTORY_POPUP.add(new JMenuItem(this.unshareAction));
        this.DIRECTORY_POPUP.add(new JMenuItem(this.addDirToPlaylistAction));
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(new ShareFileSpeciallyAction()));
        this.DIRECTORY_POPUP.add(new JMenuItem(new ShareNewFolderAction()));
        this.DIRECTORY_POPUP.addSeparator();
        this.DIRECTORY_POPUP.add(new JMenuItem(new ConfigureOptionsAction("OPTIONS_SHARED_MAIN_TITLE", "LIBRARY_SHARED_FILES_CONFIGURE_MENU", "LIBRARY_SHARED_FILES_CONFIGURE_EXPLAIN")));
    }

    public void handleMouseDoubleClick(MouseEvent e) {
    }

    public void handleRightMouseClick(MouseEvent e) {
    }

    public void handlePopupMenu(MouseEvent e) {
        int row = this.getRowForLocation(e.getX(), e.getY());
        if (row == -1) {
            return;
        }
        this.setSelectionRow(row);
        this.DIRECTORY_POPUP.show(this, e.getX(), e.getY());
    }

    public boolean setSelectedDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        LibraryTreeNode ltn = this.getNodeForFolder(dir, this.sharedFilesNode);
        if (ltn == null) {
            return false;
        }
        this.setSelectionPath(new TreePath(ltn.getPath()));
        return true;
    }

    private class ShareAction
    extends AbstractAction {
        public ShareAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_TREE_SHARE_FOLDER_LABEL"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryMediator.instance().addSharedLibraryFolder(LibraryTree.this.getSelectedDirectory());
        }
    }

    private class LibraryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public LibraryTreeCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focused) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focused);
            LibraryTreeNode node = (LibraryTreeNode)value;
            DirectoryHolder dh = node.getDirectoryHolder();
            this.setText(dh.getName());
            this.setToolTipText(dh.getDescription());
            Icon icon = dh.getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    private class AddDirectoryToPlaylistAction
    extends AbstractAction {
        public AddDirectoryToPlaylistAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_TREE_TO_PLAYLIST_FOLDER_LABEL"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTree.this.addPlayListEntries();
        }
    }

    private class UnshareAction
    extends AbstractAction {
        public UnshareAction() {
            this.putValue("Name", GUIMediator.getStringResource("LIBRARY_TREE_UNSHARE_FOLDER_LABEL"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTree.this.unshareLibraryFolder();
        }
    }

    private class RootSharedFilesDirectoryHolder
    extends RootNodeDirectoryHolder {
        public RootSharedFilesDirectoryHolder() {
            super(GUIMediator.getStringResource("LIBRARY_TREE_SHARED_FILES_DIRECTORY"));
        }

        public boolean accept(File file) {
            return RouterService.getFileManager().isFileInCompletelySharedDirectory(file);
        }

        public Icon getIcon() {
            return GUIMediator.getThemeImage("shared_folder");
        }
    }

    private class RootNodeDirectoryHolder
    implements DirectoryHolder {
        private String name;

        public RootNodeDirectoryHolder(String s) {
            this.name = s;
        }

        public File getDirectory() {
            return null;
        }

        public String getDescription() {
            return "";
        }

        public File[] getFiles() {
            return new File[0];
        }

        public FileDesc[] getFileDescs() {
            return new FileDesc[0];
        }

        public String getName() {
            return this.name;
        }

        public boolean accept(File pathname) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isEmpty() {
            return true;
        }
    }

    private final class LibraryTreeNode
    extends DefaultMutableTreeNode
    implements FileTransfer {
        private DirectoryHolder _holder;

        private LibraryTreeNode(DirectoryHolder holder) {
            super(holder);
            this._holder = holder;
        }

        public DirectoryHolder getDirectoryHolder() {
            return this._holder;
        }

        public File getFile() {
            return this._holder.getDirectory();
        }

        public boolean isAncestorOf(File folder) {
            File f = this.getFile();
            return f != null && folder.getPath().startsWith(f.getPath());
        }

        public boolean isParentOf(File folder) {
            return folder.getParentFile().equals(this.getFile());
        }

        public String toString() {
            return this.getClass().getName() + ", file: " + this.getFile();
        }
    }

    private class LibraryTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            LibraryTreeNode node = LibraryTree.this.getSelectedNode();
            LibraryTree.this.unshareAction.setEnabled(LibraryTree.this.canBeUnshared(node));
            LibraryTree.this.shareAction.setEnabled(LibraryTree.this.canBeShared(node));
            LibraryTree.this.addDirToPlaylistAction.setEnabled(LibraryTree.this.isEnqueueable());
            if (node == null) {
                return;
            }
            if (node == LibraryTree.this.sharedFilesNode) {
                LibraryMediator.showSharedFiles();
            } else {
                LibraryMediator.updateTableFiles(node.getDirectoryHolder());
            }
        }
    }
}

