/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;

public class LinuxNotifyUser
implements NotifyUser {
    private final SystemTray _tray = SystemTray.getDefaultSystemTray();
    private TrayIcon _icon;
    private final JPopupMenu _menu = this.buildPopupMenu();

    public LinuxNotifyUser() {
        this.buildTrayIcon(GUIMediator.getStringResource("TRAY_TOOLTIP"), "limeicon");
    }

    private void buildTrayIcon(String desc, String imageFileName) {
        this._icon = new TrayIcon(GUIMediator.getThemeImage(imageFileName), desc, this._menu);
        this._icon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.restoreView();
            }
        });
        this._icon.setIconAutoSize(true);
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(GUIMediator.getStringResource("TRAY_RESTORE_LABEL"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.restoreView();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(GUIMediator.getStringResource("TRAY_ABOUT_LABEL"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.showAboutWindow();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(GUIMediator.getStringResource("TRAY_EXIT_LATER_LABEL"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.shutdownAfterTransfers();
            }
        });
        menu.add(item);
        item = new JMenuItem(GUIMediator.getStringResource("TRAY_EXIT_LABEL"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.shutdown();
            }
        });
        menu.add(item);
        return menu;
    }

    public void addNotify() {
        this._tray.addTrayIcon(this._icon);
    }

    public void removeNotify() {
        this._tray.removeTrayIcon(this._icon);
    }

    public void updateNotify(String imageFileName, String desc) {
        this.removeNotify();
        this.buildTrayIcon(desc, imageFileName);
        this._tray.addTrayIcon(this._icon);
    }

    public void updateDesc(String desc) {
        this.removeNotify();
        this._icon.setCaption(desc);
        this.addNotify();
    }

    public void updateImage(String imageFileName) {
        this.removeNotify();
        ImageIcon i = new ImageIcon(LinuxNotifyUser.class.getResource(imageFileName));
        this._icon.setIcon(i);
        this.addNotify();
    }

    public void hideNotify() {
        this.removeNotify();
    }
}

