/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.gui.ListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.FilterSettings;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class AllowMessagesPaneItem
extends AbstractPaneItem {
    private final ListEditor MESSAGES_LIST = new ListEditor();

    public AllowMessagesPaneItem(String key) {
        super(key);
        this.add(this.MESSAGES_LIST);
        this.MESSAGES_LIST.addListDataListener(new IPEnforcer());
    }

    public void initOptions() {
        String[] allowedIps = FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue();
        this.MESSAGES_LIST.setModel(new Vector<String>(Arrays.asList(allowedIps)));
    }

    public boolean applyOptions() throws IOException {
        Vector model = this.MESSAGES_LIST.getModel();
        Object[] allowedIps = new String[model.size()];
        model.copyInto(allowedIps);
        FilterSettings.WHITE_LISTED_IP_ADDRESSES.setValue((String[])allowedIps);
        RouterService.adjustSpamFilters();
        return false;
    }

    public boolean isDirty() {
        List<String> model = Arrays.asList(FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue());
        return !((Object)model).equals(this.MESSAGES_LIST.getModel());
    }

    private class IPEnforcer
    implements ListDataListener {
        private IPEnforcer() {
        }

        public void intervalAdded(ListDataEvent lde) {
            Vector model = (Vector)lde.getSource();
            String ipString = (String)model.get(lde.getIndex0());
            try {
                new IP(ipString);
            }
            catch (IllegalArgumentException e) {
                AllowMessagesPaneItem.this.MESSAGES_LIST.removeItem(lde.getIndex0());
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void intervalRemoved(ListDataEvent lde) {
        }

        public void contentsChanged(ListDataEvent lde) {
            Vector model = (Vector)lde.getSource();
            String ipString = (String)model.get(lde.getIndex0());
            try {
                new IP(ipString);
            }
            catch (IllegalArgumentException e) {
                String[] allowedIps = FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue();
                AllowMessagesPaneItem.this.MESSAGES_LIST.setModel(new Vector<String>(Arrays.asList(allowedIps)));
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

