/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedPasswordField;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.DaapSettings;
import de.kapsi.net.daap.DaapUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public final class DaapPasswordPaneItem
extends AbstractPaneItem {
    private final String USERNAME_CHECK_BOX_LABEL = "OPTIONS_ITUNES_DAAP_PASSWORD_USERNAME_CHECKBOX_LABEL";
    private final String PASSWORD_CHECK_BOX_LABEL = "OPTIONS_ITUNES_DAAP_PASSWORD_CHECKBOX_LABEL";
    private final String USERNAME_BOX_LABEL = "OPTIONS_ITUNES_DAAP_PASSWORD_USERNAME_LABEL";
    private final String PASSWORD_BOX_LABEL = "OPTIONS_ITUNES_DAAP_PASSWORD_TEXTFIELD_LABEL";
    private final JCheckBox REQUIRE_USERNAME_CHECK_BOX = new JCheckBox();
    private final JCheckBox REQUIRE_PASSWORD_CHECK_BOX = new JCheckBox();
    private final JTextField USERNAME = new SizedTextField(16, new Dimension(32, 20));
    private final JTextField PASSWORD = new SizedPasswordField(16, new Dimension(32, 20));

    public DaapPasswordPaneItem(String key) {
        super(key);
        LabeledComponent usernameCheckBox = new LabeledComponent("OPTIONS_ITUNES_DAAP_PASSWORD_USERNAME_CHECKBOX_LABEL", this.REQUIRE_USERNAME_CHECK_BOX, 120);
        LabeledComponent passwordCheckBox = new LabeledComponent("OPTIONS_ITUNES_DAAP_PASSWORD_CHECKBOX_LABEL", this.REQUIRE_PASSWORD_CHECK_BOX, 120);
        LabeledComponent username = new LabeledComponent("OPTIONS_ITUNES_DAAP_PASSWORD_USERNAME_LABEL", this.USERNAME, 120);
        LabeledComponent password = new LabeledComponent("OPTIONS_ITUNES_DAAP_PASSWORD_TEXTFIELD_LABEL", this.PASSWORD, 120);
        this.add(passwordCheckBox.getComponent());
        this.add(password.getComponent());
        this.REQUIRE_USERNAME_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DaapPasswordPaneItem.this.enable();
            }
        });
        this.REQUIRE_PASSWORD_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DaapPasswordPaneItem.this.enable();
            }
        });
    }

    private void enable() {
        this.PASSWORD.setEnabled(this.REQUIRE_PASSWORD_CHECK_BOX.isSelected());
        this.REQUIRE_USERNAME_CHECK_BOX.setEnabled(this.REQUIRE_PASSWORD_CHECK_BOX.isSelected());
        if (!this.REQUIRE_PASSWORD_CHECK_BOX.isSelected()) {
            this.REQUIRE_USERNAME_CHECK_BOX.setSelected(false);
        }
        this.USERNAME.setEnabled(this.REQUIRE_USERNAME_CHECK_BOX.isSelected() && this.REQUIRE_PASSWORD_CHECK_BOX.isSelected());
    }

    public void initOptions() {
        this.REQUIRE_USERNAME_CHECK_BOX.setSelected(DaapSettings.DAAP_REQUIRES_USERNAME.getValue());
        this.REQUIRE_PASSWORD_CHECK_BOX.setSelected(DaapSettings.DAAP_REQUIRES_PASSWORD.getValue());
        if (this.REQUIRE_USERNAME_CHECK_BOX.isSelected()) {
            this.USERNAME.setText(DaapSettings.DAAP_USERNAME.getValue());
        }
        if (this.REQUIRE_PASSWORD_CHECK_BOX.isSelected()) {
            this.PASSWORD.setText(DaapSettings.DAAP_PASSWORD.getValue());
        }
        this.enable();
    }

    public boolean applyOptions() throws IOException {
        boolean prevRequiresUsername = DaapSettings.DAAP_REQUIRES_USERNAME.getValue();
        String prevUsername = DaapSettings.DAAP_USERNAME.getValue();
        boolean prevRequiresPassword = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
        String prevPassword = DaapSettings.DAAP_PASSWORD.getValue();
        boolean requiresUsername = this.REQUIRE_USERNAME_CHECK_BOX.isSelected();
        String username = this.USERNAME.getText().trim();
        boolean requiresPassword = this.REQUIRE_PASSWORD_CHECK_BOX.isSelected();
        String password = this.PASSWORD.getText().trim();
        if (username.equals("") && requiresUsername) {
            throw new IOException();
        }
        if (password.equals("") && requiresPassword) {
            throw new IOException();
        }
        if (!DaapSettings.DAAP_USERNAME.getValue().equals(username)) {
            DaapSettings.DAAP_USERNAME.setValue(username);
        }
        if (!DaapSettings.DAAP_PASSWORD.equals(password)) {
            DaapSettings.DAAP_PASSWORD.setValue(password);
        }
        if (requiresUsername) {
            password = DaapUtil.calculateHA1(username, password);
        }
        if (requiresPassword != prevRequiresPassword || requiresPassword && !password.equals(prevPassword)) {
            DaapSettings.DAAP_REQUIRES_USERNAME.setValue(requiresUsername);
            DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(requiresPassword);
            try {
                if (requiresPassword) {
                    DaapManager.instance().disconnectAll();
                }
                DaapManager.instance().updateService();
            }
            catch (IOException err) {
                DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(prevRequiresUsername);
                DaapSettings.DAAP_USERNAME.setValue(prevUsername);
                DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(prevRequiresPassword);
                DaapSettings.DAAP_PASSWORD.setValue(prevPassword);
                DaapManager.instance().stop();
                this.initOptions();
                throw err;
            }
        }
        return false;
    }

    public boolean isDirty() {
        return DaapSettings.DAAP_REQUIRES_PASSWORD.getValue() != this.REQUIRE_PASSWORD_CHECK_BOX.isSelected() || DaapSettings.DAAP_REQUIRES_USERNAME.getValue() != this.REQUIRE_USERNAME_CHECK_BOX.isSelected() || !DaapSettings.DAAP_PASSWORD.getValue().equals(this.PASSWORD.getText().trim()) || !DaapSettings.DAAP_USERNAME.getValue().equals(this.USERNAME.getText().trim());
    }
}

