/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.OverlayLayout;

class OverlayAd
extends JPanel
implements ThemeObserver {
    private static final String PRO_URL = "http://www.limewire.com/clientpro?";
    private final Icon CLOSER;
    private Icon _image;
    private boolean _searchDone;

    OverlayAd() {
        this.setLayout(new OverlayLayout(this));
        this.CLOSER = GUIMediator.getThemeImage("kill_on");
        this._image = GUIMediator.getThemeImage("intro");
        Dimension preferredSize = new Dimension(this._image.getIconWidth(), this._image.getIconHeight());
        this.setMaximumSize(preferredSize);
        this.setPreferredSize(preferredSize);
        try {
            this.add(this.createTextPanel(false));
            this.add(this.createImagePanel());
            GUIUtils.setOpaque(false, this);
        }
        catch (NullPointerException npe) {
            this.setVisible(false);
            this._searchDone = true;
        }
    }

    public void updateTheme() {
        GUIUtils.setOpaque(false, this);
    }

    void searchPerformed() {
        if (!this._searchDone) {
            this._searchDone = true;
            if (CommonUtils.isPro()) {
                this.setVisible(false);
            } else {
                this._image = GUIMediator.getThemeImage("gopro");
                Dimension preferredSize = new Dimension(this._image.getIconWidth(), this._image.getIconHeight());
                this.setMaximumSize(preferredSize);
                this.setPreferredSize(preferredSize);
                this.removeAll();
                this.add(this.createTextPanel(true));
                this.add(this.createImagePanel());
                GUIUtils.setOpaque(false, this);
            }
        }
    }

    private JPanel createImagePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(this._image), "Center");
        panel.setMaximumSize(this.getMaximumSize());
        panel.setPreferredSize(this.getPreferredSize());
        return panel;
    }

    private JPanel createTextPanel(boolean goPro) {
        JPanel panel = new JPanel(new BorderLayout());
        if (CommonUtils.isPro() || goPro) {
            panel.add((Component)this.createNorthPanel(), "North");
        }
        panel.add(Box.createHorizontalStrut(18), "West");
        JPanel center = goPro ? this.createGoProCenter() : this.createGettingStartedCenter();
        panel.add((Component)center, "Center");
        panel.add(Box.createHorizontalStrut(18), "East");
        panel.setMaximumSize(this.getMaximumSize());
        panel.setPreferredSize(this.getPreferredSize());
        return panel;
    }

    private JPanel createNorthPanel() {
        BoxPanel box = new BoxPanel(0);
        box.add(Box.createHorizontalGlue());
        if (CommonUtils.isPro()) {
            JLabel closer = new JLabel(this.CLOSER);
            closer.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    OverlayAd.this.setVisible(false);
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }
            });
            box.add(closer);
        } else {
            box.add(Box.createVerticalStrut(this.CLOSER.getIconHeight()));
        }
        return box;
    }

    private JPanel createGettingStartedCenter() {
        JLabel title = new JLabel(GUIMediator.getStringResource("GETTING_STARTED_TITLE"));
        title.setFont(new Font("Dialog", 0, 24));
        title.setForeground(new Color(90, 118, 148));
        JTextArea text = new JTextArea(GUIMediator.getStringResource("GETTING_STARTED_CONTENTS"));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setOpaque(false);
        text.setForeground(new Color(0, 0, 0));
        text.setFont(new Font("Dialog", 0, 14));
        JScrollPane pane = new JScrollPane(text);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        JPanel box = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(40, 0, 5, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.anchor = 18;
        box.add((Component)title, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        box.add((Component)pane, c);
        return box;
    }

    private JPanel createGoProCenter() {
        JLabel title = new JLabel(GUIMediator.getStringResource("GOING_PRO_TITLE"));
        title.setFont(new Font("Dialog", 1, 16));
        title.setForeground(new Color(67, 67, 67));
        JTextArea text = new JTextArea(GUIMediator.getStringResource("GOING_PRO_DESCRIPTION"));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setOpaque(false);
        text.setForeground(new Color(67, 67, 67));
        text.setFont(new Font("Dialog", 0, 14));
        BoxPanel textPanel = new BoxPanel(0);
        textPanel.add(Box.createHorizontalStrut(185));
        textPanel.add(text);
        BoxPanel box = new BoxPanel(1);
        box.add(GUIUtils.center(title));
        box.add(Box.createVerticalStrut(80));
        box.add(textPanel);
        MouseListener launcher = new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (!e.isConsumed()) {
                    e.consume();
                    GUIMediator.openURL(OverlayAd.PRO_URL + ApplicationSettings.LANGUAGE.getValue());
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        };
        box.addMouseListener(launcher);
        text.addMouseListener(launcher);
        title.addMouseListener(launcher);
        textPanel.addMouseListener(launcher);
        return box;
    }
}

