/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.ResultNameHolder;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.search.XMLSearchColumn;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.gui.xml.XMLValue;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public final class TableLine
extends AbstractDataLine {
    private final SearchTableColumns COLUMNS;
    private SearchResult RESULT;
    private List _otherResults;
    private URN _sha1;
    private NamedMediaType _mediaType;
    private Set _alts;
    private boolean _savedFile;
    private boolean _incompleteFile;
    private boolean _downloading;
    private boolean _secure;
    private ResultSpeed _speed = null;
    private int _quality;
    private RemoteFileDesc _chatHost;
    private RemoteFileDesc _browseHost;
    private RemoteFileDesc _nonFirewalledHost;
    private LimeXMLDocument _doc;
    private EndpointHolder _location = null;
    private long _addedOn;
    private float _lastRating = -1.0f;
    private int _licenseState = -1;
    private String _licenseName = null;

    public TableLine(SearchTableColumns stc) {
        this.COLUMNS = stc;
    }

    public void initialize(Object init) {
        super.initialize(init);
        SearchResult sr = (SearchResult)init;
        RemoteFileDesc rfd = sr.getRemoteFileDesc();
        HostData data = sr.getHostData();
        Set alts = sr.getAlts();
        this.RESULT = sr;
        this._doc = rfd.getXMLDocument();
        this._sha1 = rfd.getSHA1Urn();
        this._mediaType = this._doc != null ? NamedMediaType.getFromDescription(this._doc.getSchemaDescription()) : NamedMediaType.getFromExtension(this.getExtension());
        this._speed = new ResultSpeed(rfd.getSpeed(), data.isMeasuredSpeed());
        this._quality = rfd.getQuality();
        boolean bl = this._secure = rfd.getSecureStatus() == 2;
        if (rfd.chatEnabled()) {
            this._chatHost = rfd;
        }
        if (rfd.browseHostEnabled()) {
            this._browseHost = rfd;
        }
        if (!rfd.isFirewalled()) {
            this._nonFirewalledHost = rfd;
        }
        this._location = new EndpointHolder(rfd.getHost(), rfd.getPort(), rfd.isReplyToMulticast());
        this._addedOn = rfd.getCreationTime();
        if (alts != null && !alts.isEmpty()) {
            if (this._alts == null) {
                this._alts = new HashSet();
            }
            this._alts.addAll(alts);
            sr.clearAlts();
            this._location.addHosts(alts);
        }
        this.updateLicense();
        this.updateFileStatus();
    }

    void addNewResult(SearchResult sr, MetadataModel mm) {
        RemoteFileDesc rfd = sr.getRemoteFileDesc();
        HostData data = sr.getHostData();
        Set alts = sr.getAlts();
        URN resultSHA1 = this.RESULT.getRemoteFileDesc().getSHA1Urn();
        URN thisSHA1 = rfd.getSHA1Urn();
        if (resultSHA1 == null) {
            Assert.that(thisSHA1 == null);
        } else {
            Assert.that(resultSHA1.equals(thisSHA1));
        }
        if (this._otherResults == null) {
            this._otherResults = new LinkedList();
        }
        this._otherResults.add(sr);
        this._lastRating = -1.0f;
        if (alts != null && !alts.isEmpty()) {
            if (this._alts == null) {
                this._alts = new HashSet();
            }
            this._alts.addAll(alts);
            sr.clearAlts();
            this._location.addHosts(alts);
        }
        this._location.addHost(rfd.getHost(), rfd.getPort());
        ResultSpeed newSpeed = new ResultSpeed(rfd.getSpeed(), data.isMeasuredSpeed());
        if (this._speed.compareTo(newSpeed) < 0) {
            if (mm != null) {
                mm.updateProperty("RESULT_PANEL_SPEED", this._speed, newSpeed, this);
            }
            this._speed = newSpeed;
        }
        this._quality = Math.max(rfd.getQuality(), this._quality);
        this._secure |= rfd.getSecureStatus() == 2;
        if (rfd.getCreationTime() > 0L) {
            this._addedOn = Math.min(this._addedOn, rfd.getCreationTime());
        }
        if (this._chatHost == null && rfd.chatEnabled()) {
            this._chatHost = rfd;
        }
        if (this._browseHost == null && rfd.browseHostEnabled()) {
            this._browseHost = rfd;
        }
        if (this._nonFirewalledHost == null && !rfd.isFirewalled()) {
            this._nonFirewalledHost = rfd;
        }
        this.updateXMLDocument(rfd.getXMLDocument(), mm);
    }

    private void updateXMLDocument(LimeXMLDocument newDoc, MetadataModel mm) {
        HashSet newKeys;
        if (newDoc == null) {
            return;
        }
        if (this._doc == null) {
            this._doc = newDoc;
            this.updateLicense();
            if (mm != null) {
                this._mediaType = NamedMediaType.getFromDescription(this._doc.getSchemaDescription());
                mm.addNewDocument(this._doc, this);
            }
            return;
        }
        if (!this._doc.getSchemaURI().equals(newDoc.getSchemaURI())) {
            return;
        }
        Set oldKeys = this._doc.getNameSet();
        if (oldKeys.containsAll(newKeys = newDoc.getNameSet())) {
            return;
        }
        newKeys = new HashSet(newKeys);
        newKeys.removeAll(oldKeys);
        HashMap newMap = new HashMap(oldKeys.size() + newKeys.size());
        Iterator i = this._doc.getNameValueSet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            newMap.put(entry.getKey(), entry.getValue());
        }
        LimeXMLSchema schema = this._doc.getSchema();
        Iterator i2 = schema.getCanonicalizedFields().iterator();
        while (i2.hasNext()) {
            SchemaFieldInfo sfi = (SchemaFieldInfo)i2.next();
            String key = sfi.getCanonicalizedFieldName();
            if (!newKeys.contains(key)) continue;
            String value = newDoc.getValue(key);
            if (mm == null) continue;
            mm.addField(sfi, key, value, this);
        }
        this._doc = new LimeXMLDocument(newMap.entrySet(), this._doc.getSchemaURI());
        this.updateLicense();
    }

    private void updateFileStatus() {
        if (this._sha1 != null) {
            this._savedFile = RouterService.getFileManager().isUrnShared(this._sha1);
            this._incompleteFile = RouterService.getDownloadManager().isIncomplete(this._sha1);
        } else {
            this._savedFile = false;
            this._incompleteFile = false;
        }
        if (!this._savedFile) {
            this._savedFile = SavedFileManager.instance().isSaved(this._sha1, this.getFilename());
        }
    }

    public void update() {
        this.updateLicense();
        this._lastRating = -1.0f;
    }

    private void updateLicense() {
        String licenseString;
        if (this._doc != null && this._sha1 != null && (licenseString = this._doc.getLicenseString()) != null) {
            this._licenseState = LicenseFactory.isVerifiedAndValid(this._sha1, licenseString) ? 2 : 0;
            this._licenseName = LicenseFactory.getLicenseName(licenseString);
        }
    }

    boolean isSecure() {
        return this._secure;
    }

    boolean isLicenseAvailable() {
        return this._licenseState != -1;
    }

    License getLicense() {
        if (this._doc != null && this._sha1 != null) {
            return this._doc.getLicense();
        }
        return null;
    }

    URN getSHA1Urn() {
        return this._sha1;
    }

    ResultSpeed getSpeed() {
        return this._speed;
    }

    Date getAddedOn() {
        if (this._addedOn > 0L) {
            return new Date(this._addedOn);
        }
        return null;
    }

    int getQuality() {
        RemoteFileDesc rfd = this.RESULT.getRemoteFileDesc();
        boolean downloading = rfd.isDownloading();
        if (downloading != this._downloading) {
            this.updateFileStatus();
        }
        this._downloading = downloading;
        if (this._savedFile) {
            return 1002;
        }
        if (downloading) {
            return 1001;
        }
        if (this._incompleteFile) {
            return 1000;
        }
        if (this._secure) {
            return 999;
        }
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && SpamFilter.isAboveSpamThreshold(this)) {
            return 1003;
        }
        return this._quality;
    }

    NamedMediaType getNamedMediaType() {
        return this._mediaType;
    }

    LimeXMLDocument getXMLDocument() {
        return this._doc;
    }

    EndpointHolder getLocation() {
        return this._location;
    }

    List getOtherResults() {
        return this._otherResults == null ? Collections.EMPTY_LIST : this._otherResults;
    }

    Set getAlts() {
        return this._alts == null ? Collections.EMPTY_SET : this._alts;
    }

    int getLocationCount() {
        return this._location.numLocations();
    }

    String getLicenseName() {
        return this._licenseName;
    }

    boolean isChatEnabled() {
        return this._chatHost != null;
    }

    boolean isBrowseHostEnabled() {
        return this._browseHost != null;
    }

    boolean hasNonFirewalledRFD() {
        return this._nonFirewalledHost != null;
    }

    boolean isLaunchable() {
        return this._doc != null && this._doc.getAction() != null && !"".equals(this._doc.getAction());
    }

    String getFilenameNoExtension() {
        return this.RESULT.getFilenameNoExtension();
    }

    IconAndNameHolder getIconAndExtension() {
        String ext = this.getExtension();
        return new IconAndNameHolderImpl(IconManager.instance().getIconForExtension(ext), ext);
    }

    Icon getIcon() {
        String ext = this.getExtension();
        return IconManager.instance().getIconForExtension(ext);
    }

    String getExtension() {
        return this.RESULT.getExtension();
    }

    String getFilename() {
        return this.RESULT.getRemoteFileDesc().getFileName();
    }

    int getSize() {
        return this.RESULT.getSize();
    }

    String getVendor() {
        return this.RESULT.getRemoteFileDesc().getVendor();
    }

    public LimeTableColumn getColumn(int idx) {
        return this.COLUMNS.getColumn(idx);
    }

    public int getColumnCount() {
        return SearchTableColumns.COLUMN_COUNT;
    }

    public boolean isDynamic(int idx) {
        return false;
    }

    public boolean isClippable(int idx) {
        switch (idx) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public int getTypeAheadColumn() {
        return 4;
    }

    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return new Integer(this.getQuality());
            }
            case 1: {
                int count = this._location.numLocations();
                if (count == 1) {
                    return null;
                }
                return new Integer(count);
            }
            case 3: {
                return this.getIcon();
            }
            case 4: {
                return new ResultNameHolder(this);
            }
            case 5: {
                return this.getExtension();
            }
            case 6: {
                return new SizeHolder(this.getSize());
            }
            case 7: {
                return this.getSpeed();
            }
            case 8: {
                return this.isChatEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return this.getLocation();
            }
            case 10: {
                return this.RESULT.getRemoteFileDesc().getVendor();
            }
            case 11: {
                return this.getAddedOn();
            }
            case 2: {
                return new NameValue.ComparableByName(this._licenseName, new Integer(this._licenseState));
            }
            case 12: {
                return new Float(this.getSpamRating());
            }
        }
        if (this._doc == null || index == -1) {
            return null;
        }
        XMLSearchColumn ltc = (XMLSearchColumn)this.getColumn(index);
        return new XMLValue(this._doc.getValue(ltc.getId()), ltc.getSchemaFieldInfo());
    }

    public String[] getToolTipArray(int col) {
        if (col == 3 && CommonUtils.isWindows()) {
            Icon icon = this.getIcon();
            if (icon != null) {
                return new String[]{icon.toString()};
            }
            return null;
        }
        if (col == 9 && this.getLocationCount() > 1) {
            StringBuffer sb = new StringBuffer(69);
            LinkedList<String> retList = new LinkedList<String>();
            Iterator iter = this._location.getHosts().iterator();
            int i = 0;
            while (iter.hasNext()) {
                if (i == 3) {
                    i = 0;
                    retList.add(sb.toString());
                    sb = new StringBuffer(69);
                }
                sb.append(iter.next());
                if (iter.hasNext()) {
                    sb.append(", ");
                } else {
                    retList.add(sb.toString());
                }
                ++i;
            }
            return retList.toArray(new String[retList.size()]);
        }
        LinkedList<String> tips = new LinkedList<String>();
        if (this.isSecure()) {
            tips.add(GUIMediator.getStringResource("SEARCH_RESULT_SECURE_TIP"));
            tips.add("");
        }
        if (this._doc != null) {
            tips.addAll(XMLUtils.getDisplayList(this._doc));
        }
        if (!tips.isEmpty()) {
            tips.add(0, this.getFilenameNoExtension());
            return tips.toArray(new String[tips.size()]);
        }
        return null;
    }

    String getHostname() {
        return this.RESULT.getRemoteFileDesc().getHost();
    }

    RemoteFileDesc[] getAllRemoteFileDescs() {
        int size = this.getOtherResults().size() + 1;
        RemoteFileDesc[] rfds = new RemoteFileDesc[size];
        rfds[0] = this.RESULT.getRemoteFileDesc();
        int j = 1;
        Iterator i = this.getOtherResults().iterator();
        while (i.hasNext()) {
            rfds[j] = ((SearchResult)i.next()).getRemoteFileDesc();
            ++j;
        }
        return rfds;
    }

    void doChat() {
        if (this._chatHost != null && this._chatHost.getHost() != null && this._chatHost.getPort() != -1) {
            RouterService.createChat(this._chatHost.getHost(), this._chatHost.getPort());
        }
    }

    RemoteFileDesc getRemoteFileDesc() {
        return this.RESULT.getRemoteFileDesc();
    }

    float getSpamRating() {
        if (this._lastRating == -1.0f) {
            this._lastRating = this.RESULT.getRemoteFileDesc().getSpamRating();
            int num = 1;
            if (this._otherResults != null) {
                Iterator iter = this._otherResults.iterator();
                while (iter.hasNext()) {
                    this._lastRating += ((SearchResult)iter.next()).getRemoteFileDesc().getSpamRating();
                    ++num;
                }
            }
            this._lastRating /= (float)num;
        }
        return this._lastRating;
    }

    RemoteFileDesc getBrowseHostEnabledRFD() {
        return this._browseHost;
    }

    RemoteFileDesc getNonFirewalledRFD() {
        return this._nonFirewalledHost;
    }

    RemoteFileDesc getChatEnabledRFD() {
        return this._chatHost;
    }
}

